/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.commands;

import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.spigot.commands.BaseCommand;
import com.pg85.otg.spigot.gen.OTGNoiseChunkGenerator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.BiomeSettingsMobs;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.EnumCreatureType;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.WeightedRandom;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class BiomeCommand
extends BaseCommand {
    private static final List<String> TYPES = new ArrayList<String>(Arrays.asList("info", "spawns"));
    private static Field weightField;

    public BiomeCommand() {
        super("biome");
        this.helpMessage = "Displays information about the biome you are in.";
        this.usage = "/otg biome";
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return (List)StringUtil.copyPartialMatches((String)args[1], TYPES, new ArrayList());
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can execute this command");
            return true;
        }
        Player player = (Player)sender;
        WorldServer world = ((CraftWorld)player.getWorld()).getHandle();
        if (!(world.getChunkProvider().getChunkGenerator() instanceof OTGNoiseChunkGenerator)) {
            sender.sendMessage("OTG is not enabled in this world");
            return true;
        }
        BiomeBase biome = world.getBiome(new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ()));
        String MCBiome = ((CraftServer)Bukkit.getServer()).getServer().getCustomRegistry().b(IRegistry.ay).getKey((Object)biome).toString();
        IBiomeConfig config = ((OTGNoiseChunkGenerator)world.getChunkProvider().getChunkGenerator()).getCachedBiomeProvider().getBiomeConfig(player.getLocation().getBlockX(), player.getLocation().getBlockZ());
        String option = "";
        if (args.length >= 1) {
            option = args[0];
        }
        sender.sendMessage("=====================================================");
        sender.spigot().sendMessage(new BaseComponent[]{this.createComponent("According to OTG, you are in the ", ChatColor.GOLD), this.createComponent(config.getName(), ChatColor.GREEN), this.createComponent(" biome.", ChatColor.GOLD)});
        sender.spigot().sendMessage(this.createComponent("Biome registry name: ", MCBiome, ChatColor.GOLD, ChatColor.GREEN).create());
        switch (option) {
            case "info": {
                this.showBiomeInfo(player, biome, config);
                break;
            }
            case "spawns": {
                this.showBiomeMobs(player, biome, config);
                break;
            }
        }
        return true;
    }

    private void showBiomeInfo(Player sender, BiomeBase biome, IBiomeConfig config) {
        sender.spigot().sendMessage(this.createComponent("Biome Category: ", biome.t().toString(), ChatColor.GOLD, ChatColor.GREEN).create());
        sender.spigot().sendMessage(this.createComponent("Inherit Mobs: ", config.getInheritMobsBiomeName(), ChatColor.GOLD, ChatColor.GREEN).create());
        sender.spigot().sendMessage(this.createComponent("Base Size: ", Integer.toString(config.getBiomeSize()), ChatColor.GOLD, ChatColor.GREEN).append(this.createComponent(" Biome Rarity: ", Integer.toString(config.getBiomeRarity()), ChatColor.GOLD, ChatColor.GREEN).create()).create());
        sender.spigot().sendMessage(this.createComponent("Biome Height: ", String.format("%.2f", Float.valueOf(config.getBiomeHeight())), ChatColor.GOLD, ChatColor.GREEN).create());
        sender.spigot().sendMessage(this.createComponent("Volatility: ", String.format("%.2f", Float.valueOf(config.getBiomeVolatility())), ChatColor.GOLD, ChatColor.GREEN).append(this.createComponent(" Volatility1: ", String.format("%.2f", config.getVolatility1()), ChatColor.GOLD, ChatColor.GREEN).create()).append(this.createComponent(" Volatility2: ", String.format("%.2f", config.getVolatility2()), ChatColor.GOLD, ChatColor.GREEN).create()).create());
        sender.spigot().sendMessage(this.createComponent("Base Temperature: ", String.format("%.2f", Float.valueOf(biome.k())), ChatColor.GOLD, ChatColor.GREEN).append(this.createComponent(" Current Temperature: ", String.format("%.2f", Float.valueOf(biome.getAdjustedTemperature(new BlockPosition(sender.getLocation().getX(), sender.getLocation().getY(), sender.getLocation().getZ())))), ChatColor.GOLD, ChatColor.GREEN).create()).create());
    }

    private void showBiomeMobs(Player sender, BiomeBase biome, IBiomeConfig config) {
        sender.spigot().sendMessage(this.createComponent("Spawns:", ChatColor.GOLD));
        sender.spigot().sendMessage(this.createComponent("  Monsters:", ChatColor.GOLD));
        this.showSpawns(sender, biome.b().a(EnumCreatureType.MONSTER));
        sender.spigot().sendMessage(this.createComponent("  Creatures:", ChatColor.GOLD));
        this.showSpawns(sender, biome.b().a(EnumCreatureType.CREATURE));
        sender.spigot().sendMessage(this.createComponent("  Water Creatures:", ChatColor.GOLD));
        this.showSpawns(sender, biome.b().a(EnumCreatureType.CREATURE));
        sender.spigot().sendMessage(this.createComponent("  Ambient Creatures:", ChatColor.GOLD));
        this.showSpawns(sender, biome.b().a(EnumCreatureType.AMBIENT));
        sender.spigot().sendMessage(this.createComponent("  Water Ambient:", ChatColor.GOLD));
        this.showSpawns(sender, biome.b().a(EnumCreatureType.WATER_AMBIENT));
        sender.spigot().sendMessage(this.createComponent("  Misc:", ChatColor.GOLD));
        this.showSpawns(sender, biome.b().a(EnumCreatureType.MISC));
    }

    public void showSpawns(Player sender, List<BiomeSettingsMobs.c> list) {
        list.forEach(spawn -> {
            try {
                sender.spigot().sendMessage(this.createComponent("   - Entity: ", IRegistry.ENTITY_TYPE.getKey((Object)spawn.c).toString(), ChatColor.GOLD, ChatColor.GREEN).append(this.createComponent(", Weight: ", Integer.toString(weightField.getInt(spawn)), ChatColor.GOLD, ChatColor.GREEN).create()).append(this.createComponent(", Min: ", Integer.toString(spawn.d), ChatColor.GOLD, ChatColor.GREEN).create()).append(this.createComponent(", Max: ", Integer.toString(spawn.e), ChatColor.GOLD, ChatColor.GREEN).create()).create());
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        });
    }

    static {
        try {
            weightField = WeightedRandom.WeightedRandomChoice.class.getDeclaredField("a");
            weightField.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }
}

