/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pg85.otg.OTG;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.util.HashMap;
import java.util.Map;

public class CommandUtil {
    public static Map<String, String> parseArgs(String[] strings, boolean stripFirst) {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        String input = String.join((CharSequence)" ", strings);
        long count = input.chars().filter(c2 -> c2 == 34).count();
        StringReader reader = new StringReader(input);
        int index = 1;
        try {
            if (stripFirst) {
                reader.readString();
            }
            while (reader.getCursor() < input.length()) {
                String str;
                if (reader.peek() == ' ') {
                    reader.skip();
                }
                if (count % 2L == 1L && reader.peek() == '\"') {
                    str = reader.getRemaining();
                    reader.setCursor(reader.getTotalLength());
                } else {
                    str = reader.readString();
                }
                if (reader.getCursor() < input.length() && !StringReader.isAllowedInUnquotedString((char)reader.peek())) {
                    char c3 = reader.peek();
                    reader.skip();
                    str = str + c3 + reader.readString();
                }
                if (str.startsWith("-")) {
                    if (str.startsWith("--")) {
                        if (!reader.canRead()) continue;
                        argsMap.put(str, reader.readString());
                        continue;
                    }
                    if (str.startsWith("-")) {
                        argsMap.put(str, "");
                        continue;
                    }
                }
                argsMap.put(index++ + "", str);
            }
        }
        catch (CommandSyntaxException e2) {
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, String.format("Command syntax error: ", e2.getStackTrace()));
        }
        return argsMap;
    }
}

