/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.commands;

import com.pg85.otg.OTG;
import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.bo2.BO2;
import com.pg85.otg.customobject.bo3.BO3;
import com.pg85.otg.customobject.bo3.bo3function.BO3RandomBlockFunction;
import com.pg85.otg.customobject.bo4.BO4;
import com.pg85.otg.customobject.bo4.BO4Config;
import com.pg85.otg.customobject.bo4.bo4function.BO4RandomBlockFunction;
import com.pg85.otg.customobject.bofunctions.BlockFunction;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.config.io.FileSettingsReaderBO4;
import com.pg85.otg.customobject.creator.ObjectCreator;
import com.pg85.otg.customobject.creator.ObjectType;
import com.pg85.otg.customobject.structures.StructuredCustomObject;
import com.pg85.otg.customobject.util.Corner;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ICustomObjectManager;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.spigot.commands.BaseCommand;
import com.pg85.otg.spigot.commands.CommandUtil;
import com.pg85.otg.spigot.commands.ExportCommand;
import com.pg85.otg.spigot.commands.ObjectUtils;
import com.pg85.otg.spigot.commands.RegionCommand;
import com.pg85.otg.spigot.gen.SpigotWorldGenRegion;
import com.pg85.otg.spigot.materials.SpigotMaterialData;
import com.pg85.otg.spigot.util.SpigotNBTHelper;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockLeaves;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.GeneratorAccess;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IBlockState;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.TagsBlock;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class EditCommand
extends BaseCommand {
    private static final HashMap<Player, EditSession> sessionsMap = new HashMap();
    private static final List<String> FLAGS = Arrays.asList("-nofix", "-update", "-wrongleaves");
    private static final HashSet<LocalMaterialData> gravityBlocksSet = Stream.of(LocalMaterials.SAND, LocalMaterials.RED_SAND, LocalMaterials.GRAVEL).collect(Collectors.toCollection(HashSet::new));
    private static final HashSet<MinecraftKey> updateMap = Stream.of("blocks/oak_fence", "blocks/birch_fence", "blocks/nether_brick_fence", "blocks/spruce_fence", "blocks/jungle_fence", "blocks/acacia_fence", "blocks/dark_oak_fence", "blocks/iron_door", "blocks/oak_door", "blocks/spruce_door", "blocks/birch_door", "blocks/jungle_door", "blocks/acacia_door", "blocks/dark_oak_door", "blocks/glass_pane", "blocks/white_stained_glass_pane", "blocks/orange_stained_glass_pane", "blocks/magenta_stained_glass_pane", "blocks/light_blue_stained_glass_pane", "blocks/yellow_stained_glass_pane", "blocks/lime_stained_glass_pane", "blocks/pink_stained_glass_pane", "blocks/gray_stained_glass_pane", "blocks/light_gray_stained_glass_pane", "blocks/cyan_stained_glass_pane", "blocks/purple_stained_glass_pane", "blocks/blue_stained_glass_pane", "blocks/brown_stained_glass_pane", "blocks/green_stained_glass_pane", "blocks/red_stained_glass_pane", "blocks/black_stained_glass_pane", "blocks/purpur_stairs", "blocks/oak_stairs", "blocks/cobblestone_stairs", "blocks/brick_stairs", "blocks/stone_brick_stairs", "blocks/nether_brick_stairs", "blocks/spruce_stairs", "blocks/sandstone_stairs", "blocks/birch_stairs", "blocks/jungle_stairs", "blocks/quartz_stairs", "blocks/acacia_stairs", "blocks/dark_oak_stairs", "blocks/prismarine_stairs", "blocks/prismarine_brick_stairs", "blocks/dark_prismarine_stairs", "blocks/red_sandstone_stairs", "blocks/polished_granite_stairs", "blocks/smooth_red_sandstone_stairs", "blocks/mossy_stone_brick_stairs", "blocks/polished_diorite_stairs", "blocks/mossy_cobblestone_stairs", "blocks/end_stone_brick_stairs", "blocks/stone_stairs", "blocks/smooth_sandstone_stairs", "blocks/smooth_quartz_stairs", "blocks/granite_stairs", "blocks/andesite_stairs", "blocks/red_nether_brick_stairs", "blocks/polished_andesite_stairs", "blocks/diorite_stairs", "blocks/cobblestone_wall", "blocks/mossy_cobblestone_wall", "blocks/brick_wall", "blocks/prismarine_wall", "blocks/red_sandstone_wall", "blocks/mossy_stone_brick_wall", "blocks/granite_wall", "blocks/stone_brick_wall", "blocks/nether_brick_wall", "blocks/andesite_wall", "blocks/red_nether_brick_wall", "blocks/sandstone_wall", "blocks/end_stone_brick_wall", "blocks/diorite_wall", "blocks/iron_bars", "blocks/trapped_chest", "blocks/chest", "blocks/redstone_wire", "blocks/oak_leaves", "blocks/spruce_leaves", "blocks/birch_leaves", "blocks/jungle_leaves", "blocks/acacia_leaves", "blocks/dark_oak_leaves", "blocks/vine").map(MinecraftKey::new).collect(Collectors.toCollection(HashSet::new));

    public EditCommand() {
        super("edit");
        this.helpMessage = "Allows you to edit existing BO3 and BO4 files.";
        this.usage = "Please see /otg help edit.";
    }

    protected static StructuredCustomObject getStructuredObject(String objectName, String presetFolderName) throws InvalidConfigException {
        CustomObject objectToSpawn = ObjectUtils.getObject(objectName, presetFolderName);
        if (objectToSpawn instanceof BO3) {
            return (StructuredCustomObject)objectToSpawn;
        }
        if (presetFolderName == null) {
            presetFolderName = OTG.getEngine().getPresetLoader().getDefaultPresetFolderName();
        }
        if (objectToSpawn instanceof BO4) {
            File file = ((BO4)objectToSpawn).getConfig().getFile();
            return new BO4(objectName, file, new BO4Config(new FileSettingsReaderBO4(objectName, file, OTG.getEngine().getLogger()), true, presetFolderName, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(presetFolderName), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker()));
        }
        if (objectToSpawn instanceof BO2) {
            try {
                return new BO3(objectToSpawn.getName(), ObjectType.BO3.getObjectFilePathFromName(objectToSpawn.getName(), ((BO2)objectToSpawn).getFile().getParentFile().toPath()).toFile(), ((BO2)objectToSpawn).getConvertedConfig(presetFolderName, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(presetFolderName), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker()));
            }
            catch (InvalidConfigException var4) {
                OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, "Failed to convert BO2 " + objectName);
                OTG.getEngine().getLogger().printStackTrace(LogLevel.ERROR, LogCategory.MAIN, var4);
            }
        }
        return null;
    }

    protected static ArrayList<BlockFunction<?>> spawnAndFixObject(int x, int y, int z, StructuredCustomObject object, SpigotWorldGenRegion worldGenRegion, boolean fixObject, String presetFolderName, Path otgRootFolder, ILogger logger, ICustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        BlockFunction<?>[] blocks = object.getConfig().getBlockFunctions(presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
        HashSet<BlockPosition> updates = new HashSet<BlockPosition>();
        HashSet<BlockPosition> gravityBlocksToCheck = new HashSet<BlockPosition>();
        Random random = new Random();
        ArrayList unspawnedBlocks = new ArrayList();
        for (BlockFunction<?> block : blocks) {
            if (block.material == null || block.nbt != null || block instanceof BO3RandomBlockFunction || block instanceof BO4RandomBlockFunction || block.material.isBlank()) {
                unspawnedBlocks.add(block);
                continue;
            }
            if (fixObject && updateMap.contains(MinecraftKey.a((String)block.material.getRegistryName()))) {
                updates.add(new BlockPosition(x + block.x, y + block.y, z + block.z));
            }
            if (gravityBlocksSet.contains(block.material)) {
                gravityBlocksToCheck.add(new BlockPosition(x + block.x, y + block.y, z + block.z));
            }
            if (block.material.isLeaves()) {
                block.material = SpigotMaterialData.ofBlockData((IBlockData)((IBlockData)((SpigotMaterialData)block.material).internalBlock().set((IBlockState)BlockLeaves.PERSISTENT, (Comparable)Boolean.valueOf(true))).set((IBlockState)BlockLeaves.DISTANCE, (Comparable)Integer.valueOf(7)));
            }
            block.spawn(worldGenRegion, random, x + block.x, y + block.y, z + block.z);
        }
        for (BlockPosition pos : gravityBlocksToCheck) {
            if (!worldGenRegion.getMaterial(pos.getX(), pos.getY() - 1, pos.getZ()).isMaterial(LocalMaterials.STRUCTURE_VOID)) continue;
            worldGenRegion.setBlock(pos.getX(), pos.getY() - 1, pos.getZ(), LocalMaterials.STRUCTURE_BLOCK);
        }
        if (fixObject) {
            for (BlockPosition pos : updates) {
                IBlockData blockstate = worldGenRegion.getBlockData(pos);
                if (blockstate.a((Tag)TagsBlock.LEAVES)) {
                    worldGenRegion.getInternal().getBlockTickList().a(pos, (Object)blockstate.getBlock(), 1);
                    continue;
                }
                IBlockData blockstate1 = Block.b((IBlockData)blockstate, (GeneratorAccess)worldGenRegion.getInternal(), (BlockPosition)pos);
                worldGenRegion.setBlockState(pos, blockstate1, 20);
            }
        }
        return unspawnedBlocks;
    }

    public static void finishSession(Player source) {
        try {
            EditSession session = sessionsMap.get(source);
            RegionCommand.Region region = RegionCommand.playerSelectionMap.get(source);
            if (session == null) {
                source.sendMessage("No active session, do '/otg edit' to start one");
                return;
            }
            if (ObjectUtils.isOutsideBounds(region, session.type)) {
                source.sendMessage("Selection is too big! Maximum size is 16x16 for BO4 and 32x32 for BO3");
                return;
            }
            source.sendMessage("Cleaning up...");
            StructuredCustomObject object = EditCommand.exportFromSession(session, region);
            if (object != null) {
                source.sendMessage("Successfully edited " + session.type.getType() + " " + object.getName());
                OTG.getEngine().getCustomObjectManager().getGlobalObjects().addObjectToPreset(session.presetFolderName, object.getName(), object.getConfig().getFile(), object);
            } else {
                source.sendMessage("Failed to edit " + session.type.getType() + " " + session.object.getName());
            }
            ObjectUtils.cleanArea(session.genRegion, region.getMin(), region.getMax(), false);
            sessionsMap.put(source, null);
        }
        catch (Exception var4) {
            source.sendMessage("Edit command encountered an error, please check logs.");
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MAIN, "Edit command encountered an error: ");
            OTG.getEngine().getLogger().printStackTrace(LogLevel.ERROR, LogCategory.MAIN, var4);
        }
    }

    public static void cancelSession(Player player) {
        EditSession session = sessionsMap.get(player);
        RegionCommand.Region region = RegionCommand.playerSelectionMap.get(player);
        if (session != null && region != null) {
            ObjectUtils.cleanArea(session.genRegion, region.getMin(), region.getMax(), false);
            sessionsMap.put(player, null);
            player.sendMessage("Edit session cancelled");
        } else {
            player.sendMessage("No active edit session to cancel");
        }
    }

    public static StructuredCustomObject exportFromSession(EditSession session, RegionCommand.Region region) {
        return ObjectCreator.createObject(session.type, region.getMin(), region.getMax(), session.extraBlocks.isEmpty() ? region.getCenter() : session.originalCenterPoint, null, session.object.getName(), false, session.leaveIllegalLeaves, session.objectPath, session.genRegion, new SpigotNBTHelper(), session.extraBlocks, session.object.getConfig(), session.presetFolderName, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(session.presetFolderName), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        Map<String, String> strings = CommandUtil.parseArgs(args, true);
        if (strings.size() >= 3) {
            return FLAGS;
        }
        Set presetFolderNames = OTG.getEngine().getPresetLoader().getAllPresetFolderNames().stream().map(ExportCommand.filterNamesWithSpaces).collect(Collectors.toSet());
        presetFolderNames.add("global");
        String presetFolderName = strings.get("1");
        String objectName = strings.get("2");
        if (presetFolderName == null) {
            return new ArrayList<String>(presetFolderNames);
        }
        return objectName != null && presetFolderNames.contains(presetFolderName) ? (List)StringUtil.copyPartialMatches((String)objectName, OTG.getEngine().getCustomObjectManager().getGlobalObjects().getAllBONamesForPreset(presetFolderName, OTG.getEngine().getLogger(), OTG.getEngine().getOTGRootFolder()), new ArrayList()) : (List)StringUtil.copyPartialMatches((String)presetFolderName, presetFolderNames, new ArrayList());
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can execute this command");
            return true;
        }
        Player source = (Player)sender;
        if (args.length == 0) {
            this.help(source);
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("Please supply an object name to export");
            return true;
        }
        String presetFolderName = args[0];
        String objectName = args[1];
        String flags = args.length >= 3 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)) : "";
        boolean immediate = flags.contains("-update");
        boolean doFixing = !flags.contains("-nofix");
        boolean leaveIllegalLeaves = flags.contains("-wrongleaves");
        presetFolderName = presetFolderName != null && presetFolderName.equalsIgnoreCase("global") ? null : presetFolderName;
        boolean isGlobal = presetFolderName == null;
        StructuredCustomObject inputObject = null;
        try {
            inputObject = EditCommand.getStructuredObject(objectName, presetFolderName);
        }
        catch (InvalidConfigException e2) {
            source.sendMessage("Failed to load object " + objectName);
            return true;
        }
        if (inputObject == null) {
            source.sendMessage("Could not find " + objectName);
            return true;
        }
        ObjectType type = inputObject.getType();
        Preset preset = ObjectUtils.getPresetOrDefault(presetFolderName);
        if (preset == null) {
            source.sendMessage("Could not find preset " + (presetFolderName == null ? "" : presetFolderName));
            return true;
        }
        SpigotWorldGenRegion worldGenRegion = ObjectUtils.getWorldGenRegion(preset, (CraftWorld)source.getWorld());
        RegionCommand.Region region = ObjectUtils.getRegionFromObject(source.getLocation(), inputObject);
        Corner center = region.getCenter();
        ObjectUtils.cleanArea(worldGenRegion, region.getMin(), region.getMax(), true);
        ArrayList<BlockFunction<?>> extraBlocks = EditCommand.spawnAndFixObject(center.x, center.y, center.z, inputObject, worldGenRegion, doFixing, presetFolderName, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(presetFolderName), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
        Path path = ObjectUtils.getObjectFolderPath(isGlobal ? null : preset.getPresetFolder()).resolve(ObjectUtils.getFoldersFromObject(inputObject));
        if (immediate) {
            new Thread(ObjectUtils.getExportRunnable(type, region, center, inputObject, path, extraBlocks, presetFolderName, true, leaveIllegalLeaves, source, worldGenRegion)).start();
            return true;
        }
        sessionsMap.put(source, new EditSession(type, worldGenRegion, inputObject, extraBlocks, path, preset.getFolderName(), center, leaveIllegalLeaves));
        source.sendMessage("You can now edit the object");
        source.sendMessage("To change the area of the object, use /otg region");
        source.sendMessage("When you are done editing, do /otg finishedit");
        source.sendMessage("To cancel, do /otg canceledit");
        if (!extraBlocks.isEmpty()) {
            source.sendMessage("This object's center cannot be moved");
        }
        RegionCommand.playerSelectionMap.put(source, region);
        return true;
    }

    public void help(Player source) {
        source.sendMessage(ChatColor.LIGHT_PURPLE + "To use the edit command:");
        source.sendMessage("/otg edit <preset> <object> [-nofix, -update]");
        source.sendMessage(" - Preset is which preset to fetch the object from, and save it back to");
        source.sendMessage(" - Object is the object you want to edit");
        source.sendMessage(" - The -nofix flag disables block state fixing");
        source.sendMessage(" - The -update flag immediately exports and cleans after fixing");
        source.sendMessage(" - Complex objects cannot have their center moved");
        source.sendMessage(" - An object is \"complex\" if it contains NBT or RandomBlock");
    }

    private static class EditSession {
        private final ObjectType type;
        private final SpigotWorldGenRegion genRegion;
        private final StructuredCustomObject object;
        private final ArrayList<BlockFunction<?>> extraBlocks;
        private final Path objectPath;
        private final String presetFolderName;
        private final Corner originalCenterPoint;
        private final boolean leaveIllegalLeaves;

        public EditSession(ObjectType type, SpigotWorldGenRegion genRegion, StructuredCustomObject object, ArrayList<BlockFunction<?>> extraBlocks, Path objectPath, String presetFolderName, Corner originalCenterPoint, boolean leaveIllegalLeaves) {
            this.type = type;
            this.genRegion = genRegion;
            this.object = object;
            this.extraBlocks = extraBlocks;
            this.objectPath = objectPath;
            this.presetFolderName = presetFolderName;
            this.originalCenterPoint = originalCenterPoint;
            this.leaveIllegalLeaves = leaveIllegalLeaves;
        }
    }
}

