/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pg85.otg.OTG;
import com.pg85.otg.customobject.creator.ObjectCreator;
import com.pg85.otg.customobject.creator.ObjectType;
import com.pg85.otg.customobject.structures.StructuredCustomObject;
import com.pg85.otg.customobject.util.Corner;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.spigot.commands.BaseCommand;
import com.pg85.otg.spigot.commands.CommandUtil;
import com.pg85.otg.spigot.commands.ObjectUtils;
import com.pg85.otg.spigot.commands.RegionCommand;
import com.pg85.otg.spigot.commands.WorldEditUtil;
import com.pg85.otg.spigot.gen.SpigotWorldGenRegion;
import com.pg85.otg.spigot.materials.SpigotMaterialData;
import com.pg85.otg.spigot.util.SpigotNBTHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.server.v1_16_R3.ArgumentTile;
import net.minecraft.server.v1_16_R3.IBlockData;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class ExportCommand
extends BaseCommand {
    protected static final Function<String, String> filterNamesWithSpaces = name -> name.contains(" ") ? "\"" + name + "\"" : name;
    protected static final Function<String, String> removeData = data -> data.matches("minecraft:[a-z]+\\[[^:]*\\]") ? data.replaceAll("\\[[^:]*\\]", "") : data;
    private static final List<String> flags = Arrays.asList("-a", "-b", "-o", "-e");
    protected static Set<String> presetNames = OTG.getEngine().getPresetLoader().getAllPresetFolderNames().stream().map(filterNamesWithSpaces).collect(Collectors.toSet());
    protected static List<String> objectTypes = Arrays.asList("BO3", "BO4");

    public ExportCommand() {
        super("export");
        this.helpMessage = "Allows you to export an area as a BO3 or BO4.";
        this.usage = "Please see /otg help export.";
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        Map<String, String> strings = CommandUtil.parseArgs(args, true);
        if (strings.size() == 6) {
            return flags;
        }
        if (strings.size() > 6 && strings.containsValue("-e")) {
            String str = strings.get(Integer.toString(strings.size()));
            List<Object> mats = new ArrayList();
            for (Material mat : Material.values()) {
                if (!mat.isBlock()) continue;
                String blockData = mat.createBlockData().getAsString(true);
                mats.add(blockData);
            }
            mats = mats.stream().map(removeData).collect(Collectors.toList());
            mats.addAll(flags);
            return (List)StringUtil.copyPartialMatches((String)(str == null ? "" : str), mats, new ArrayList());
        }
        if (strings.size() == 4) {
            String str = strings.get("4");
            return (List)StringUtil.copyPartialMatches((String)(str == null ? "" : str), objectTypes, new ArrayList());
        }
        if (strings.size() == 5) {
            List<String> list;
            String str = strings.get("5");
            if (str == null) {
                str = "";
            }
            if ((list = str.equalsIgnoreCase("global") ? OTG.getEngine().getCustomObjectManager().getGlobalObjects().getGlobalTemplates(OTG.getEngine().getLogger(), OTG.getEngine().getOTGRootFolder()) : OTG.getEngine().getCustomObjectManager().getGlobalObjects().getTemplatesForPreset(str, OTG.getEngine().getLogger(), OTG.getEngine().getOTGRootFolder())) == null) {
                list = new ArrayList();
            }
            list = list.stream().map(filterNamesWithSpaces).collect(Collectors.toList());
            list.add("default");
            return (List)StringUtil.copyPartialMatches((String)str, list, new ArrayList());
        }
        if (strings.size() == 3) {
            String str = strings.get("3");
            return (List)StringUtil.copyPartialMatches((String)(str == null ? "" : str), presetNames, new ArrayList());
        }
        return new ArrayList<String>();
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        StructuredCustomObject object;
        LocalMaterialData centerBlock;
        Preset preset;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can execute this command");
            return true;
        }
        Player source = (Player)sender;
        if (args.length == 0) {
            this.helpMessage(source);
            return true;
        }
        String objectName = args[0];
        IBlockData centerBlockState = null;
        try {
            if (args.length >= 2 && !args[1].equalsIgnoreCase("any")) {
                centerBlockState = ArgumentTile.a().parse(new StringReader(args[1])).a();
            }
        }
        catch (CommandSyntaxException var25) {
            sender.sendMessage("Could not find material " + args[1]);
            return true;
        }
        String presetName = args.length > 2 && !args[2].equalsIgnoreCase("global") ? args[2] : null;
        boolean isGlobal = presetName == null;
        ObjectType type = args.length >= 4 ? ObjectType.valueOf(args[3].toUpperCase(Locale.ROOT)) : ObjectType.BO3;
        String templateName = args.length >= 5 ? args[4] : "default";
        String flags = args.length >= 6 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 5, args.length)) : "";
        boolean overwrite = flags.contains("-o");
        boolean isStructure = flags.contains("-b");
        boolean includeAir = flags.contains("-a");
        boolean hasExcludes = flags.contains("-e");
        if (type == ObjectType.BO2) {
            source.sendMessage("Cannot export BO2 objects");
            return true;
        }
        RegionCommand.Region region = null;
        if (OTG.getEngine().getModLoadedChecker().isModLoaded("worldedit")) {
            region = WorldEditUtil.getRegionFromPlayer(source);
        }
        if (region == null) {
            region = RegionCommand.playerSelectionMap.get(source);
        }
        if (region == null || region.getMin() == null || region.getMax() == null) {
            source.sendMessage("Please define a region with /otg region mark, or worldedit");
            return true;
        }
        if (ObjectUtils.isOutsideBounds(region, type)) {
            isStructure = true;
        }
        if ((preset = ObjectUtils.getPresetOrDefault(presetName)) == null) {
            source.sendMessage("Could not find preset " + (presetName == null ? "" : presetName));
            return true;
        }
        Path objectPath = ObjectUtils.getObjectFolderPath(isGlobal ? null : preset.getPresetFolder());
        if (!overwrite && new File(objectPath.toFile(), objectName + ".bo3").exists() && new File(objectPath.toFile(), objectName + "." + type.getType()).exists()) {
            source.sendMessage("File already exists, run command with flag '-o' to overwrite");
            return true;
        }
        SpigotWorldGenRegion worldGenRegion = ObjectUtils.getWorldGenRegion(preset, (CraftWorld)source.getWorld());
        SpigotNBTHelper nbtHelper = new SpigotNBTHelper();
        Corner lowCorner = region.getMin();
        Corner highCorner = region.getMax();
        Corner center = region.getCenter() != null ? region.getCenter() : new Corner((highCorner.x - lowCorner.x) / 2 + lowCorner.x, Math.min(lowCorner.y, highCorner.y), (highCorner.z - lowCorner.z) / 2 + lowCorner.z);
        File templateFile = OTG.getEngine().getCustomObjectManager().getGlobalObjects().getTemplateFileForPreset(presetName, templateName, OTG.getEngine().getLogger(), OTG.getEngine().getOTGRootFolder());
        StructuredCustomObject template = (StructuredCustomObject)OTG.getEngine().getCustomObjectManager().getObjectLoaders().get(type.getType().toLowerCase()).loadFromFile(templateName, templateFile != null ? templateFile : new File(type.getFileNameForTemplate(templateName)), OTG.getEngine().getLogger());
        if (!template.onEnable(preset.getFolderName(), OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker())) {
            source.sendMessage("Failed to load template \"" + templateName + "\"");
            return true;
        }
        LocalMaterialData localMaterialData = centerBlock = centerBlockState == null ? null : SpigotMaterialData.ofBlockData(centerBlockState);
        if (hasExcludes) {
            String[] flagsArr = flags.split(" ");
            ArrayList<LocalMaterialData> excludes = new ArrayList<LocalMaterialData>();
            for (String flag : flagsArr) {
                if (flag.startsWith("-")) continue;
                try {
                    excludes.add(SpigotMaterialData.ofBlockData(ArgumentTile.a().parse(new StringReader(flag)).a()));
                }
                catch (CommandSyntaxException e2) {
                    sender.sendMessage("Could not find material " + flag);
                    return true;
                }
            }
            object = ObjectCreator.create(type, lowCorner, highCorner, center, centerBlock, objectName, includeAir, isStructure, false, objectPath, worldGenRegion, nbtHelper, null, template.getConfig(), preset.getFolderName(), OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker(), excludes);
        } else {
            object = ObjectCreator.create(type, lowCorner, highCorner, center, centerBlock, objectName, includeAir, isStructure, false, objectPath, worldGenRegion, nbtHelper, null, template.getConfig(), preset.getFolderName(), OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
        }
        if (object != null) {
            source.sendMessage("Successfully created " + type.getType() + " " + objectName);
            if (isGlobal) {
                OTG.getEngine().getCustomObjectManager().registerGlobalObject(object, object.getConfig().getFile());
            } else {
                OTG.getEngine().getCustomObjectManager().getGlobalObjects().addObjectToPreset(preset.getFolderName(), object.getName().toLowerCase(Locale.ROOT), object.getConfig().getFile(), object);
            }
        } else {
            source.sendMessage("Failed to create " + type.getType() + " " + objectName);
        }
        return true;
    }

    public void helpMessage(Player source) {
        source.sendMessage(ChatColor.LIGHT_PURPLE + "Usage: /otg export <object name> [center block] [preset] [type] [template] [-a -b -o]");
        source.sendMessage(" - Object name is the only required argument");
        source.sendMessage(" - Center block is optional; if set, the center will be set to the first found instance of the given block.");
        source.sendMessage(" - Preset determines where the object is saved, and where templates are searched for");
        source.sendMessage(" - Type is either BO3 or BO4");
        source.sendMessage(" - Template is a BO3 file whose settings are used for the exported object");
        source.sendMessage("    - Templates have file ending .BO3Template or .BO4Template");
        source.sendMessage("    - Templates are not loaded as objects");
        source.sendMessage(" - There are three flags; -a for Air blocks, -b for Branches, -o for Override, and -e for exclude blocks");
    }

    static {
        presetNames.add("global");
    }
}

