/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.commands;

import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.spigot.biome.OTGBiomeProvider;
import com.pg85.otg.spigot.commands.BaseCommand;
import com.pg85.otg.spigot.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.spigot.gen.OTGSpigotChunkGen;
import com.pg85.otg.spigot.gen.SpigotChunkBuffer;
import com.pg85.otg.spigot.materials.SpigotMaterialData;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.materials.LocalMaterials;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Blocks;
import net.minecraft.server.v1_16_R3.IBlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class MapCommand
extends BaseCommand {
    private static final List<String> TYPES = new ArrayList<String>(Arrays.asList("biomes", "terrain"));

    public MapCommand() {
        super("map");
        this.helpMessage = "Generates an image of the biome or terrain layout.";
        this.usage = "/otg map <biomes/terrain> [width] [height] [threads]";
        this.detailedHelp = new String[]{"<biomes/terrain>: The type of map to create.", " - biomes: Creates an image using the color specified in each biome's config file.", " - terrain: Creates an image using the colours of the blocks shaded to show the altitude of the terrain.", "[width]: Image width in pixels.", "[height]: Image height in pixels.", "[threads]: The number of threads to use while rendering the image."};
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (args.length == 0) {
            return true;
        }
        if (args[0].equalsIgnoreCase("biomes")) {
            return this.mapBiomes(sender, args);
        }
        if (args[0].equalsIgnoreCase("terrain")) {
            return this.mapTerrain(sender, args);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return (List)StringUtil.copyPartialMatches((String)args[1], TYPES, new ArrayList());
    }

    private boolean mapBiomes(CommandSender sender, String[] args) {
        CraftWorld world;
        Player player;
        int size = 2048;
        int offsetX = 0;
        int offsetZ = 0;
        String name = "";
        for (int i = 1; i < args.length - 1; ++i) {
            if (args[i].equalsIgnoreCase("-s")) {
                size = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equalsIgnoreCase("-ox")) {
                offsetX = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equalsIgnoreCase("-oz")) {
                offsetZ = Integer.parseInt(args[i + 1]);
            }
            if (!args[i].equalsIgnoreCase("-n")) continue;
            name = args[i + 1];
        }
        if (sender instanceof Player) {
            player = (Player)sender;
            world = (CraftWorld)player.getWorld();
            if (offsetX == 0 && offsetZ == 0) {
                offsetX += player.getLocation().getBlockX();
                offsetZ += player.getLocation().getBlockZ();
            }
        } else {
            sender.sendMessage("Only in-game for now");
            return true;
        }
        if (!(world.getHandle().getChunkProvider().getChunkGenerator() instanceof OTGNoiseChunkGenerator)) {
            sender.sendMessage("This is not an OTG world");
            return true;
        }
        ICachedBiomeProvider provider = ((OTGNoiseChunkGenerator)world.getHandle().getChunkProvider().getChunkGenerator()).getCachedBiomeProvider();
        BufferedImage img = new BufferedImage(size, size, 1);
        int progressUpdate = img.getHeight() / 8;
        for (int noiseX = 0; noiseX < img.getHeight(); ++noiseX) {
            for (int noiseZ = 0; noiseZ < img.getWidth(); ++noiseZ) {
                img.setRGB(noiseX, noiseZ, provider.getNoiseBiomeConfig(noiseX + offsetX, noiseZ + offsetZ, true).getBiomeColor());
            }
            if (noiseX % progressUpdate != 0) continue;
            sender.sendMessage((double)noiseX / (double)img.getHeight() * 100.0 + "% Done mapping");
        }
        String fileName = player.getWorld().getName() + " " + name + " biomes.png";
        sender.sendMessage("Finished mapping! The resulting image is located at " + fileName + ".");
        Path p = Paths.get(fileName, new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return true;
    }

    private boolean mapTerrain(CommandSender sender, String[] args) {
        CraftWorld world;
        Player player;
        int size = 2048;
        int offsetX = 0;
        int offsetZ = 0;
        String name = "";
        for (int i = 1; i < args.length - 1; ++i) {
            if (args[i].equalsIgnoreCase("-s")) {
                size = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equalsIgnoreCase("-ox")) {
                offsetX = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equalsIgnoreCase("-oz")) {
                offsetZ = Integer.parseInt(args[i + 1]);
            }
            if (!args[i].equalsIgnoreCase("-n")) continue;
            name = args[i + 1];
        }
        if (sender instanceof Player) {
            player = (Player)sender;
            world = (CraftWorld)player.getWorld();
            if (offsetX == 0 && offsetZ == 0) {
                offsetX += player.getLocation().getBlockX();
                offsetZ += player.getLocation().getBlockZ();
            }
        } else {
            sender.sendMessage("Only in-game for now");
            return true;
        }
        if (!(world.getHandle().getChunkProvider().chunkGenerator.getWorldChunkManager() instanceof OTGBiomeProvider)) {
            sender.sendMessage("This is not an OTG world");
            return true;
        }
        BufferedImage img = new BufferedImage(size, size, 1);
        int progressUpdate = img.getHeight() / 8;
        int min = 0;
        int max = 255;
        int range = max - min;
        int progress = 0;
        for (int chunkX = 0; chunkX < (int)Math.ceil((float)img.getWidth() / 16.0f); ++chunkX) {
            for (int chunkZ = 0; chunkZ < (int)Math.ceil((float)img.getHeight() / 16.0f); ++chunkZ) {
                SpigotChunkBuffer chunk = ((OTGSpigotChunkGen)world.getHandle().generator).generator.getChunkWithoutLoadingOrCaching(world.getHandle().getRandom(), ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
                for (int internalX = 0; internalX < 16; ++internalX) {
                    for (int internalZ = 0; internalZ < 16; ++internalZ) {
                        if (chunkX * 16 + internalX >= img.getWidth() || chunkZ * 16 + internalZ >= img.getHeight()) continue;
                        HighestBlockInfo highestBlockInfo = this.getHighestBlockInfoInUnloadedChunk(chunk, internalX, internalZ);
                        int distance = -min + highestBlockInfo.y;
                        float relativeDistance = (float)distance / (float)range;
                        int shadePercentage = (int)Math.floor(relativeDistance * 2.0f * 100.0f);
                        int rgbColor = MapCommand.shadeColor(highestBlockInfo.material.internalBlock().getBlock().s().rgb, shadePercentage);
                        img.setRGB(chunkX * 16 + internalX, chunkZ * 16 + internalZ, rgbColor);
                    }
                }
                if (++progress % progressUpdate != 0) continue;
                sender.sendMessage((double)chunkX / (double)((int)Math.ceil((float)img.getWidth() / 16.0f)) * 100.0 + "% Done mapping");
            }
        }
        String fileName = player.getWorld().getName() + " " + name + " terrain.png";
        sender.sendMessage("Finished mapping! The resulting image is located at " + fileName + ".");
        Path p = Paths.get(fileName, new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return true;
    }

    private static int shadeColor(int rgbColor, int percent) {
        int red = rgbColor >> 16 & 0xFF;
        int green = rgbColor >> 8 & 0xFF;
        int blue = rgbColor & 0xFF;
        red = (red = red * percent / 100) > 255 ? 255 : red;
        green = green * percent / 100;
        green = green > 255 ? 255 : green;
        blue = blue * percent / 100;
        blue = blue > 255 ? 255 : blue;
        return 65536 * red + 256 * green + blue;
    }

    private HighestBlockInfo getHighestBlockInfoInUnloadedChunk(SpigotChunkBuffer chunk, int internalX, int internalZ) {
        for (int y = chunk.getHighestBlockForColumn(internalX, internalZ); y >= 0; --y) {
            IBlockData blockInChunk = chunk.getChunk().getType(new BlockPosition(internalX, y, internalZ));
            if (blockInChunk == null || blockInChunk.getBlock() == Blocks.AIR) continue;
            return new HighestBlockInfo((SpigotMaterialData)SpigotMaterialData.ofBlockData(blockInChunk), y);
        }
        return new HighestBlockInfo((SpigotMaterialData)LocalMaterials.AIR, 63);
    }

    public class HighestBlockInfo {
        public final SpigotMaterialData material;
        public final int y;

        public HighestBlockInfo(SpigotMaterialData material, int y) {
            this.material = material;
            this.y = y;
        }
    }
}

