/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.commands;

import com.pg85.otg.presets.Preset;
import com.pg85.otg.spigot.commands.BaseCommand;
import com.pg85.otg.spigot.gen.OTGNoiseChunkGenerator;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.entity.Player;

public class PresetCommand
extends BaseCommand {
    public PresetCommand() {
        super("preset");
        this.helpMessage = "Displays information about the current world's preset.";
        this.usage = "/otg preset";
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can execute this command");
            return true;
        }
        Player player = (Player)sender;
        WorldServer world = ((CraftWorld)player.getWorld()).getHandle();
        if (!(world.getChunkProvider().getChunkGenerator() instanceof OTGNoiseChunkGenerator)) {
            sender.sendMessage("OTG is not enabled in this world");
            return true;
        }
        Preset preset = ((OTGNoiseChunkGenerator)world.getChunkProvider().getChunkGenerator()).getPreset();
        sender.sendMessage("Preset: " + preset.getFolderName() + "\nDescription: " + preset.getDescription() + "\nMajor version: " + preset.getMajorVersion());
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return Collections.emptyList();
    }
}

