/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.commands;

import com.pg85.otg.customobject.util.Corner;
import com.pg85.otg.spigot.commands.BaseCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.server.v1_16_R3.BlockPosition;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class RegionCommand
extends BaseCommand {
    protected static final HashMap<Player, Region> playerSelectionMap = new HashMap();
    private static final List<String> directions = Arrays.asList("down", "east", "north", "south", "up", "west");
    private static final List<String> regionSubCommands = Arrays.asList("clear", "expand", "mark", "shrink");
    private static final List<String> points = Arrays.asList("pos1", "pos2", "center");

    public RegionCommand() {
        super("region");
        this.helpMessage = "Allows for setting and modifying regions";
        this.usage = "Please see /otg help region.";
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] strings) {
        if (strings.length == 2) {
            return (List)StringUtil.copyPartialMatches((String)strings[1], regionSubCommands, new ArrayList());
        }
        if ((strings[1].equalsIgnoreCase("expand") || strings[1].equalsIgnoreCase("shrink")) && strings.length == 3) {
            return (List)StringUtil.copyPartialMatches((String)strings[2], directions, new ArrayList());
        }
        if (strings[1].equalsIgnoreCase("mark")) {
            return (List)StringUtil.copyPartialMatches((String)strings[2], points, new ArrayList());
        }
        return new ArrayList<String>();
    }

    @Override
    public boolean execute(CommandSender source, String[] args) {
        if (!(source instanceof Player)) {
            source.sendMessage("Only players can execute this command");
            return false;
        }
        Player player = (Player)source;
        if (!playerSelectionMap.containsKey(player)) {
            playerSelectionMap.put(player, new Region());
        }
        if (args.length == 0) {
            source.sendMessage("placeholder help message");
            return true;
        }
        Region region = playerSelectionMap.get(player);
        switch (args[0]) {
            case "mark": {
                if (args.length > 1) {
                    this.mark(player, args[1]);
                } else if (region.setPos(player.getLocation())) {
                    source.sendMessage("Point 1 marked");
                } else {
                    source.sendMessage("Point 2 marked");
                }
                return true;
            }
            case "clear": {
                region.clear();
                player.sendMessage("Position cleared");
                return true;
            }
            case "shrink": 
            case "expand": {
                if (region.getMax() == null) {
                    source.sendMessage("Please mark two positions before modifying or exporting the region");
                    return true;
                }
                if (args.length < 3) {
                    source.sendMessage("Please specify a direction and an amount to expand by");
                    return true;
                }
                String direction = args[1];
                int value = Integer.parseInt(args[2]);
                if (args[0].equalsIgnoreCase("shrink")) {
                    value = -value;
                }
                this.expand(player, direction, value);
                return true;
            }
        }
        return false;
    }

    public void mark(Player source, String input) {
        Region r = playerSelectionMap.get(source);
        switch (input) {
            case "min": 
            case "pos1": 
            case "1": {
                r.setPos1(source.getLocation());
                source.sendMessage("Point 1 marked");
                return;
            }
            case "max": 
            case "pos2": 
            case "2": {
                r.setPos2(source.getLocation());
                source.sendMessage("Point 2 marked");
                return;
            }
            case "center": {
                r.setCenter(Region.cornerFromLocation(source.getLocation()));
                source.sendMessage("Center marked");
                return;
            }
        }
        source.sendMessage(input + " is not recognized");
    }

    public void expand(Player source, String direction, Integer value) {
        Region region = playerSelectionMap.get(source);
        if (region.getMax() == null) {
            source.sendMessage("Please mark two positions before modifying or exporting the region");
            return;
        }
        switch (direction) {
            case "south": {
                if (region.pos2.getZ() >= region.pos1.getZ()) {
                    region.setPos2(region.pos2.south(value.intValue()));
                    break;
                }
                region.setPos1(region.pos1.south(value.intValue()));
                break;
            }
            case "north": {
                if (region.pos2.getZ() < region.pos1.getZ()) {
                    region.setPos2(region.pos2.north(value.intValue()));
                    break;
                }
                region.setPos1(region.pos1.north(value.intValue()));
                break;
            }
            case "east": {
                if (region.pos2.getX() >= region.pos1.getX()) {
                    region.setPos2(region.pos2.east(value.intValue()));
                    break;
                }
                region.setPos1(region.pos1.east(value.intValue()));
                break;
            }
            case "west": {
                if (region.pos2.getX() < region.pos1.getX()) {
                    region.setPos2(region.pos2.west(value.intValue()));
                    break;
                }
                region.setPos1(region.pos1.west(value.intValue()));
                break;
            }
            case "up": {
                if (region.pos2.getY() >= region.pos1.getY()) {
                    region.setPos2(region.pos2.up(value.intValue()));
                    break;
                }
                region.setPos1(region.pos1.up(value.intValue()));
                break;
            }
            case "down": {
                if (region.pos2.getY() < region.pos1.getY()) {
                    region.setPos2(region.pos2.down(value.intValue()));
                    break;
                }
                region.setPos1(region.pos1.down(value.intValue()));
                break;
            }
            default: {
                source.sendMessage("Unrecognized direction " + direction);
                return;
            }
        }
        source.sendMessage("Region modified");
    }

    public static class Region {
        private BlockPosition pos1 = null;
        private BlockPosition pos2 = null;
        private Corner center = null;
        private boolean flip = true;

        public boolean setPos(Location loc) {
            return this.setPos(new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        }

        public boolean setPos(BlockPosition BlockPosition2) {
            if (this.flip) {
                this.pos1 = BlockPosition2;
            } else {
                this.pos2 = BlockPosition2;
            }
            this.flip = !this.flip;
            return !this.flip;
        }

        public static Corner cornerFromLocation(Location loc) {
            return new Corner(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        }

        public void clear() {
            this.pos1 = null;
            this.pos2 = null;
            this.center = null;
        }

        public Corner getMin() {
            if (this.pos1 == null || this.pos2 == null) {
                return null;
            }
            return new Corner(Math.min(this.pos1.getX(), this.pos2.getX()), Math.min(this.pos1.getY(), this.pos2.getY()), Math.min(this.pos1.getZ(), this.pos2.getZ()));
        }

        public Corner getMax() {
            if (this.pos1 == null || this.pos2 == null) {
                return null;
            }
            return new Corner(Math.max(this.pos1.getX(), this.pos2.getX()), Math.max(this.pos1.getY(), this.pos2.getY()), Math.max(this.pos1.getZ(), this.pos2.getZ()));
        }

        public void setPos1(Location loc) {
            this.setPos1(new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        }

        public void setPos1(BlockPosition pos) {
            this.flip = false;
            this.pos1 = pos;
        }

        public void setPos2(Location loc) {
            this.setPos2(new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        }

        public void setPos2(BlockPosition pos) {
            this.flip = true;
            this.pos2 = pos;
        }

        public Corner getCenter() {
            return this.center;
        }

        public void setCenter(Corner center) {
            this.center = center;
        }
    }
}

