/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.commands;

import com.pg85.otg.OTG;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.bo4.BO4;
import com.pg85.otg.customobject.structures.CustomStructureCache;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.spigot.commands.BaseCommand;
import com.pg85.otg.spigot.commands.CommandUtil;
import com.pg85.otg.spigot.commands.ExportCommand;
import com.pg85.otg.spigot.commands.ObjectUtils;
import com.pg85.otg.spigot.gen.MCWorldGenRegion;
import com.pg85.otg.spigot.gen.OTGSpigotChunkGen;
import com.pg85.otg.spigot.gen.SpigotWorldGenRegion;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.StringUtil;

public class SpawnCommand
extends BaseCommand {
    public SpawnCommand() {
        super("spawn");
        this.helpMessage = "Spawns a structure from a specific preset.";
        this.usage = "/otg spawn <preset> <object> [location] [force]";
        this.detailedHelp = new String[]{"<preset>: The name of the preset to look for the object in, or global to check GlobalObjects.", "<object>: The name of the object to spawn.", "[location]: The x, y, and z location to spawn the object at, defaults to your position.", "[force]: Whether to force the object to spawn regardless of conditions."};
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        Map<String, String> strings = CommandUtil.parseArgs(args, false);
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can execute this command");
            return true;
        }
        Player player = (Player)sender;
        String presetName = strings.get("1");
        String objectName = strings.get("2");
        boolean force = false;
        if (strings.containsKey("3")) {
            force = Boolean.getBoolean(strings.get("3"));
        }
        if (presetName == null || objectName == null) {
            sender.sendMessage("Please specify a preset and an object");
            return true;
        }
        CustomObject objectToSpawn = SpawnCommand.getObject(objectName, presetName = presetName.equalsIgnoreCase("global") ? null : presetName);
        if (objectToSpawn == null) {
            sender.sendMessage("Could not find an object by the name " + objectName + " in either " + presetName + " or Global objects");
            return true;
        }
        Block block = SpawnCommand.getWatchedBlock(player, false);
        if (block == null) {
            block = player.getLocation().getBlock();
        }
        Preset preset = ObjectUtils.getPresetOrDefault(presetName);
        SpigotWorldGenRegion genRegion = ObjectUtils.getWorldGenRegion(preset, (CraftWorld)player.getWorld());
        if (objectToSpawn instanceof BO4) {
            if (!(((CraftWorld)((Player)sender).getWorld()).getGenerator() instanceof OTGSpigotChunkGen)) {
                sender.sendMessage("BO4 objects can only be spawned in OTG worlds/dimensions.");
                return true;
            }
            if (preset.getWorldConfig().getCustomStructureType() != SettingsEnums.CustomStructureType.BO4) {
                sender.sendMessage("Cannot spawn a BO4 structure in an isOTGPlus:false world, use a BO3 instead or recreate the world with IsOTGPlus:true in the worldconfig.");
                return true;
            }
            int playerX = block.getX();
            int playerZ = block.getZ();
            ChunkCoordinate playerChunk = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
            if (((BO4)objectToSpawn).getName().matches(".*C[0-9]([0-9]*)R[0-9]([0-9]*)$")) {
                int x = playerChunk.getBlockX() + ((BO4)objectToSpawn).getConfig().getminX();
                int z = playerChunk.getBlockZ() + ((BO4)objectToSpawn).getConfig().getminZ();
                ((BO4)objectToSpawn).trySpawnAt(preset.getFolderName(), OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), null, genRegion, new Random(), Rotation.NORTH, playerChunk, x, genRegion.getHighestBlockAboveYAt(x, z), z, null, null, false, null, null, null, false, genRegion.getCachedBiomeProvider().getBiomeConfig(x, z).getWaterLevelMax(), false, false, false);
                return true;
            }
            CustomStructureCache cache = ((OTGSpigotChunkGen)((CraftWorld)((Player)sender).getWorld()).getGenerator()).generator.getStructureCache(player.getWorld().getWorldFolder().toPath());
            int maxRadius = 1000;
            OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.MAIN, "Trying to plot BO4 structure within " + maxRadius + " chunks of player, with height bounds " + (force ? "disabled" : "enabled") + ". This may take a while.");
            sender.sendMessage("Trying to plot BO4 structure within " + maxRadius + " chunks of player, with height bounds " + (force ? "disabled" : "enabled") + ". This may take a while.");
            for (int cycle = 1; cycle < maxRadius; ++cycle) {
                for (int x1 = playerX - cycle; x1 <= playerX + cycle; ++x1) {
                    for (int z1 = playerZ - cycle; z1 <= playerZ + cycle; ++z1) {
                        ChunkCoordinate chunkCoordSpawned;
                        if (x1 != playerX - cycle && x1 != playerX + cycle && z1 != playerZ - cycle && z1 != playerZ + cycle) continue;
                        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(playerChunk.getChunkX() + (x1 - playerX), playerChunk.getChunkZ() + (z1 - playerZ));
                        if (player.getWorld().isChunkGenerated(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) || (chunkCoordSpawned = cache.plotBo4Structure(genRegion, (BO4)objectToSpawn, new ArrayList<String>(), chunkCoord, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName()), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker(), force)) == null) continue;
                        OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.MAIN, objectToSpawn.getName() + " was spawned at " + chunkCoordSpawned.getBlockX() + " ~ " + chunkCoordSpawned.getBlockZ());
                        sender.sendMessage(objectToSpawn.getName() + " was spawned at " + chunkCoordSpawned.getBlockX() + " ~ " + chunkCoordSpawned.getBlockZ());
                        return true;
                    }
                }
            }
            OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.MAIN, objectToSpawn.getName() + " could not be spawned. This can happen if the world is currently generating chunks, if no biomes with enough space could be found, or if there is an error in the structure's files. Enable SpawnLog:true in OTG.ini and check the logs for more information.");
            sender.sendMessage(objectToSpawn.getName() + " could not be spawned. This can happen if the world is currently generating chunks, if no biomes with enough space could be found, or if there is an error in the structure's files. Enable SpawnLog:true in OTG.ini and check the logs for more information.");
            return true;
        }
        if (objectToSpawn.spawnForced(null, genRegion, new Random(), Rotation.NORTH, block.getX(), block.getY(), block.getZ(), !(genRegion instanceof MCWorldGenRegion))) {
            Location location = block.getLocation();
            sender.sendMessage("Spawned object " + objectName + " at " + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ());
        } else {
            sender.sendMessage("Failed to spawn object " + objectName);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        Map<String, String> strings = CommandUtil.parseArgs(args, true);
        Set presetFolderNames = OTG.getEngine().getPresetLoader().getAllPresetFolderNames().stream().map(ExportCommand.filterNamesWithSpaces).collect(Collectors.toSet());
        presetFolderNames.add("global");
        String presetFolderName = strings.get("1");
        String objectName = strings.get("2");
        if (presetFolderName == null) {
            return new ArrayList<String>(presetFolderNames);
        }
        if (objectName != null && presetFolderNames.contains(presetFolderName)) {
            return (List)StringUtil.copyPartialMatches((String)objectName, OTG.getEngine().getCustomObjectManager().getGlobalObjects().getAllBONamesForPreset(presetFolderName, OTG.getEngine().getLogger(), OTG.getEngine().getOTGRootFolder()), new ArrayList());
        }
        return (List)StringUtil.copyPartialMatches((String)presetFolderName, presetFolderNames, new ArrayList());
    }

    public static Block getWatchedBlock(Player me, boolean verbose) {
        if (me == null) {
            return null;
        }
        Block previousBlock = null;
        BlockIterator itr = new BlockIterator((LivingEntity)me, 200);
        while (itr.hasNext()) {
            Block block = (Block)itr.next();
            if (block.getType() != Material.AIR && block.getType() != Material.TALL_GRASS) {
                return previousBlock;
            }
            previousBlock = block;
        }
        if (verbose) {
            me.sendMessage("No block in sight.");
        }
        return null;
    }

    public static CustomObject getObject(String objectName, String presetFolderName) {
        if (presetFolderName == null) {
            presetFolderName = OTG.getEngine().getPresetLoader().getDefaultPresetFolderName();
        }
        return OTG.getEngine().getCustomObjectManager().getGlobalObjects().getObjectByName(objectName, presetFolderName, OTG.getEngine().getOTGRootFolder(), OTG.getEngine().getLogger(), OTG.getEngine().getCustomObjectManager(), OTG.getEngine().getPresetLoader().getMaterialReader(presetFolderName), OTG.getEngine().getCustomObjectResourcesManager(), OTG.getEngine().getModLoadedChecker());
    }
}

