/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.commands;

import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.spigot.commands.BaseCommand;
import com.pg85.otg.spigot.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.util.biome.OTGBiomeResourceLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.ChatMessage;
import net.minecraft.server.v1_16_R3.HeightMap;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.ResourceKey;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class TpCommand
extends BaseCommand {
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(object -> new ChatMessage("commands.locatebiome.notFound", new Object[]{object}));

    public TpCommand() {
        super("tp");
        this.helpMessage = "Teleports you to a specific OTG biome.";
        this.usage = "/otg tp <biome> [range]";
        this.detailedHelp = new String[]{"<biome>: The name of the biome to teleport to.", "[range]: The radius in blocks to search for the target biome, defaults to 10000.", "Note: large numbers will make the command take a long time."};
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can execute this command");
            return true;
        }
        Player player = (Player)sender;
        WorldServer world = ((CraftWorld)player.getWorld()).getHandle();
        if (!(world.getChunkProvider().getChunkGenerator() instanceof OTGNoiseChunkGenerator)) {
            sender.sendMessage("OTG is not enabled in this world");
            return true;
        }
        if (args.length >= 1) {
            BlockPosition playerPos;
            BlockPosition pos;
            String biome = args[0];
            Preset preset = ((OTGNoiseChunkGenerator)world.getChunkProvider().getChunkGenerator()).getPreset();
            MinecraftKey key = new MinecraftKey(new OTGBiomeResourceLocation(preset.getPresetFolder(), preset.getShortPresetName(), preset.getMajorVersion(), biome).toResourceLocationString());
            BiomeBase biomeBase = (BiomeBase)world.r().b(IRegistry.ay).a(ResourceKey.a((ResourceKey)IRegistry.ay, (MinecraftKey)key));
            if (biomeBase == null) {
                sender.sendMessage("Invalid biome: " + biome + ".");
                return true;
            }
            int range = 10000;
            if (args.length >= 2) {
                try {
                    range = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException ex) {
                    sender.sendMessage("Invalid search radius: " + args[1] + ".");
                    return true;
                }
            }
            if ((pos = world.a(biomeBase, playerPos = new BlockPosition(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ()), range, 8)) == null) {
                sender.sendMessage(ERROR_BIOME_NOT_FOUND.create((Object)biome).getLocalizedMessage());
                return true;
            }
            int y = world.getChunkProvider().getChunkGenerator().getBaseHeight(pos.getX(), pos.getZ(), HeightMap.Type.MOTION_BLOCKING_NO_LEAVES);
            player.teleport(new Location(player.getWorld(), (double)pos.getX(), (double)y, (double)pos.getZ()));
            player.sendMessage("Teleporting you to the nearest " + biome + ".");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        WorldServer serverWorld;
        ArrayList<String> options = new ArrayList<String>();
        if (args.length == 2 && sender instanceof Player && (serverWorld = ((CraftWorld)((Player)sender).getWorld()).getHandle()).getChunkProvider().getChunkGenerator() instanceof OTGNoiseChunkGenerator) {
            ArrayList<String> biomeNames = new ArrayList<String>();
            for (String name : ((OTGNoiseChunkGenerator)serverWorld.getChunkProvider().getChunkGenerator()).getPreset().getAllBiomeNames()) {
                biomeNames.add(name.replace(' ', '_'));
            }
            StringUtil.copyPartialMatches((String)args[1], biomeNames, options);
        }
        return options;
    }
}

