/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.events;

import com.pg85.otg.OTG;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.resource.SaplingResource;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.ISaplingSpawner;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.spigot.gen.OTGSpigotChunkGen;
import com.pg85.otg.spigot.gen.SpigotWorldGenRegion;
import com.pg85.otg.spigot.materials.SpigotMaterialData;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import com.pg85.otg.util.minecraft.SaplingType;
import java.nio.file.Path;
import java.util.Random;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.GeneratorAccessSeed;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.event.world.StructureGrowEvent;

public class SaplingHandler {
    void onStructureGrow(StructureGrowEvent event) {
        if (!(event.getWorld() instanceof CraftWorld)) {
            return;
        }
        BlockPosition blockPos = new BlockPosition(event.getLocation().getBlockX(), event.getLocation().getBlockY(), event.getLocation().getBlockZ());
        if (!(((CraftWorld)event.getWorld()).getGenerator() instanceof OTGSpigotChunkGen)) {
            return;
        }
        Preset preset = ((OTGSpigotChunkGen)((CraftWorld)event.getWorld()).getGenerator()).generator.getPreset();
        SpigotWorldGenRegion worldGenRegion = new SpigotWorldGenRegion(preset.getFolderName(), preset.getWorldConfig(), (GeneratorAccessSeed)((CraftWorld)event.getWorld()).getHandle(), ((OTGSpigotChunkGen)((CraftWorld)event.getWorld()).getGenerator()).generator);
        CustomObjectManager customObjectManager = OTG.getEngine().getCustomObjectManager();
        CustomObjectResourcesManager customObjectResourcesManager = OTG.getEngine().getCustomObjectResourcesManager();
        ILogger logger = OTG.getEngine().getLogger();
        Path otgRootFolder = OTG.getEngine().getOTGRootFolder();
        IModLoadedChecker modLoadedChecker = OTG.getEngine().getModLoadedChecker();
        IMaterialReader materialReader = OTG.getEngine().getPresetLoader().getMaterialReader(preset.getFolderName());
        IBiomeConfig biomeConfig = worldGenRegion.getCachedBiomeProvider().getBiomeConfig(blockPos.getX(), blockPos.getZ());
        SpigotMaterialData material = (SpigotMaterialData)worldGenRegion.getMaterial(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        BlockPosition result = this.findFourSaplings(blockPos, material, worldGenRegion);
        boolean wideTrunk = false;
        if (result != null) {
            blockPos = result;
            wideTrunk = true;
        } else {
            wideTrunk = false;
        }
        ISaplingSpawner sapling = biomeConfig.getCustomSaplingGen(SpigotMaterialData.ofBlockData(material.internalBlock().getBlock().getBlockData()), wideTrunk);
        if (sapling != null && sapling.hasWideTrunk() && !wideTrunk) {
            return;
        }
        if (sapling == null) {
            SaplingType saplingType = null;
            if (wideTrunk) {
                saplingType = this.getBigSaplingType(SpigotMaterialData.ofBlockData(material.internalBlock().getBlock().getBlockData()));
            }
            if (saplingType == null) {
                saplingType = this.getSmallSaplingType(SpigotMaterialData.ofBlockData(material.internalBlock().getBlock().getBlockData()));
            }
            if (saplingType != null) {
                sapling = biomeConfig.getSaplingGen(saplingType);
            }
        }
        if (sapling == null) {
            return;
        }
        event.setCancelled(true);
        if (sapling.hasWideTrunk()) {
            worldGenRegion.setBlock(blockPos.getX(), blockPos.getY(), blockPos.getZ(), LocalMaterials.AIR);
            worldGenRegion.setBlock(blockPos.getX() + 1, blockPos.getY(), blockPos.getZ(), LocalMaterials.AIR);
            worldGenRegion.setBlock(blockPos.getX(), blockPos.getY(), blockPos.getZ() + 1, LocalMaterials.AIR);
            worldGenRegion.setBlock(blockPos.getX() + 1, blockPos.getY(), blockPos.getZ() + 1, LocalMaterials.AIR);
        } else {
            worldGenRegion.setBlock(blockPos.getX(), blockPos.getY(), blockPos.getZ(), LocalMaterials.AIR);
        }
        boolean saplingGrown = false;
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            if (!((SaplingResource)sapling).growSapling(worldGenRegion, random, wideTrunk, blockPos.getX(), blockPos.getY(), blockPos.getZ(), preset.getFolderName(), otgRootFolder, logger, customObjectManager, materialReader, customObjectResourcesManager, modLoadedChecker)) continue;
            saplingGrown = true;
            break;
        }
        if (!saplingGrown) {
            int saplingX = blockPos.getX();
            int saplingY = blockPos.getY();
            int saplingZ = blockPos.getZ();
            if (sapling.hasWideTrunk()) {
                worldGenRegion.setBlock(saplingX, saplingY, saplingZ, material);
                worldGenRegion.setBlock(saplingX + 1, saplingY, saplingZ, material);
                worldGenRegion.setBlock(saplingX, saplingY, saplingZ + 1, material);
                worldGenRegion.setBlock(saplingX + 1, saplingY, saplingZ + 1, material);
            } else {
                worldGenRegion.setBlock(saplingX, saplingY, saplingZ, material);
            }
        }
    }

    private SaplingType getSmallSaplingType(LocalMaterialData saplingMaterial) {
        if (saplingMaterial == LocalMaterials.OAK_SAPLING) {
            return SaplingType.Oak;
        }
        if (saplingMaterial == LocalMaterials.SPRUCE_SAPLING) {
            return SaplingType.Redwood;
        }
        if (saplingMaterial == LocalMaterials.BIRCH_SAPLING) {
            return SaplingType.Birch;
        }
        if (saplingMaterial == LocalMaterials.JUNGLE_SAPLING) {
            return SaplingType.SmallJungle;
        }
        if (saplingMaterial == LocalMaterials.ACACIA_SAPLING) {
            return SaplingType.Acacia;
        }
        if (saplingMaterial == LocalMaterials.BAMBOO_SAPLING) {
            return SaplingType.Bamboo;
        }
        return null;
    }

    private SaplingType getBigSaplingType(LocalMaterialData saplingMaterial) {
        if (saplingMaterial == LocalMaterials.DARK_OAK_SAPLING) {
            return SaplingType.DarkOak;
        }
        if (saplingMaterial == LocalMaterials.SPRUCE_SAPLING) {
            return SaplingType.HugeRedwood;
        }
        if (saplingMaterial == LocalMaterials.JUNGLE_SAPLING) {
            return SaplingType.BigJungle;
        }
        return null;
    }

    private BlockPosition findFourSaplings(BlockPosition blockPos, LocalMaterialData material, IWorldGenRegion worldGenRegion) {
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        for (int treeOffsetX = 0; treeOffsetX >= -1; --treeOffsetX) {
            for (int treeOffsetZ = 0; treeOffsetZ >= -1; --treeOffsetZ) {
                if (!material.isMaterial(worldGenRegion.getMaterial(x + treeOffsetX, y, z + treeOffsetZ)) || !material.isMaterial(worldGenRegion.getMaterial(x + treeOffsetX + 1, y, z + treeOffsetZ)) || !material.isMaterial(worldGenRegion.getMaterial(x + treeOffsetX, y, z + treeOffsetZ + 1)) || !material.isMaterial(worldGenRegion.getMaterial(x + treeOffsetX + 1, y, z + treeOffsetZ + 1))) continue;
                return blockPos.b(treeOffsetX, 0, treeOffsetZ);
            }
        }
        return null;
    }
}

