/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.gen;

import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.spigot.gen.SpigotWorldGenRegion;
import com.pg85.otg.spigot.materials.SpigotMaterialData;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.minecraft.TreeType;
import com.pg85.otg.util.nbt.NamedBinaryTag;
import java.util.Random;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.ChunkStatus;
import net.minecraft.server.v1_16_R3.GeneratorAccessSeed;
import net.minecraft.server.v1_16_R3.HeightMap;
import net.minecraft.server.v1_16_R3.IChunkAccess;
import org.apache.commons.lang.NotImplementedException;

public class MCWorldGenRegion
extends SpigotWorldGenRegion {
    public MCWorldGenRegion(String presetFolderName, IWorldConfig worldConfig, GeneratorAccessSeed worldGenRegion) {
        super(presetFolderName, worldConfig, worldGenRegion);
    }

    @Override
    public IBiome getBiomeForDecoration(int worldX, int worldZ) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public IBiomeConfig getBiomeConfigForDecoration(int worldX, int worldZ) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public double getBiomeBlocksNoiseValue(int xInWorld, int zInWorld) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public LocalMaterialData getMaterial(int x, int y, int z) {
        IChunkAccess chunk;
        if (y >= 256 || y < 0) {
            return null;
        }
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunkAccess iChunkAccess = chunk = this.worldGenRegion.isChunkLoaded(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.getChunkAt(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        if (chunk == null || !chunk.getChunkStatus().b(ChunkStatus.LIQUID_CARVERS)) {
            return null;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        return SpigotMaterialData.ofBlockData(chunk.getType(new BlockPosition(internalX, y, internalZ)));
    }

    @Override
    public int getHighestBlockYAt(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow, boolean ignoreLeaves) {
        IChunkAccess chunk;
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunkAccess iChunkAccess = chunk = this.worldGenRegion.isChunkLoaded(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.getChunkAt(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        if (chunk == null || !chunk.getChunkStatus().b(ChunkStatus.LIQUID_CARVERS)) {
            return -1;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        int heightMapY = chunk.getHighestBlock(HeightMap.Type.WORLD_SURFACE, internalX, internalZ);
        return this.getHighestBlockYAt(chunk, internalX, heightMapY, internalZ, findSolid, findLiquid, ignoreLiquid, ignoreSnow, ignoreLeaves);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag nbt, ReplaceBlockMatrix replaceBlocksMatrix) {
        if (y < 0 || y >= 256) {
            return;
        }
        if (material.isEmpty()) {
            return;
        }
        BlockPosition pos = new BlockPosition(x, y, z);
        this.worldGenRegion.setTypeAndData(pos, ((SpigotMaterialData)material).internalBlock(), 18);
        if (material.isLiquid()) {
            this.worldGenRegion.getFluidTickList().a(pos, (Object)((SpigotMaterialData)material).internalBlock().getFluid().getType(), 0);
        }
        if (nbt != null) {
            this.attachNBT(x, y, z, nbt, this.worldGenRegion.getType(pos));
        }
    }

    @Override
    public boolean placeTree(TreeType type, Random rand, int x, int y, int z) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public void placeDungeon(Random random, int x, int y, int z) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public void placeFossil(Random random, int x, int y, int z) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public LocalMaterialData getMaterialWithoutLoading(int x, int y, int z) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public int getHighestBlockYAtWithoutLoading(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow, boolean ignoreLeaves) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }

    @Override
    public boolean chunkHasDefaultStructure(Random worldRandom, ChunkCoordinate chunkCoordinate) {
        throw new NotImplementedException("This method is not available for non-OTG worlds, you're trying to use an unsupported feature.");
    }
}

