/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.gen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pg85.otg.OTG;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.customobject.structures.CustomStructureCache;
import com.pg85.otg.gen.OTGChunkDecorator;
import com.pg85.otg.gen.OTGChunkGenerator;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.interfaces.ILayerSource;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.spigot.biome.SpigotBiome;
import com.pg85.otg.spigot.gen.ShadowChunkGenerator;
import com.pg85.otg.spigot.gen.SpigotChunkBuffer;
import com.pg85.otg.spigot.gen.SpigotWorldGenRegion;
import com.pg85.otg.spigot.presets.SpigotPresetLoader;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.gen.ChunkBuffer;
import com.pg85.otg.util.gen.JigsawStructureData;
import com.pg85.otg.util.materials.LocalMaterialData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.BiomeManager;
import net.minecraft.server.v1_16_R3.BiomeSettingsMobs;
import net.minecraft.server.v1_16_R3.BiomeStorage;
import net.minecraft.server.v1_16_R3.BlockColumn;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Blocks;
import net.minecraft.server.v1_16_R3.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R3.ChunkGenerator;
import net.minecraft.server.v1_16_R3.CrashReport;
import net.minecraft.server.v1_16_R3.EnumCreatureType;
import net.minecraft.server.v1_16_R3.GeneratorAccess;
import net.minecraft.server.v1_16_R3.GeneratorSettingBase;
import net.minecraft.server.v1_16_R3.HeightMap;
import net.minecraft.server.v1_16_R3.IBlockAccess;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IChunkAccess;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.MathHelper;
import net.minecraft.server.v1_16_R3.NoiseSettings;
import net.minecraft.server.v1_16_R3.ProtoChunk;
import net.minecraft.server.v1_16_R3.RegionLimitedWorldAccess;
import net.minecraft.server.v1_16_R3.ReportedException;
import net.minecraft.server.v1_16_R3.SectionPosition;
import net.minecraft.server.v1_16_R3.SeededRandom;
import net.minecraft.server.v1_16_R3.SpawnerCreature;
import net.minecraft.server.v1_16_R3.StructureBoundingBox;
import net.minecraft.server.v1_16_R3.StructureGenerator;
import net.minecraft.server.v1_16_R3.StructureManager;
import net.minecraft.server.v1_16_R3.StructurePiece;
import net.minecraft.server.v1_16_R3.StructureSettings;
import net.minecraft.server.v1_16_R3.StructureSettingsFeature;
import net.minecraft.server.v1_16_R3.StructureSettingsStronghold;
import net.minecraft.server.v1_16_R3.StructureStart;
import net.minecraft.server.v1_16_R3.WorldAccess;
import net.minecraft.server.v1_16_R3.WorldChunkManager;
import net.minecraft.server.v1_16_R3.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.server.v1_16_R3.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.server.v1_16_R3.WorldGenFeaturePillagerOutpostPoolPiece;
import net.minecraft.server.v1_16_R3.WorldGenStage;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.generator.ChunkGenerator;

public class OTGNoiseChunkGenerator
extends ChunkGenerator {
    public static final Codec<OTGNoiseChunkGenerator> CODEC = RecordCodecBuilder.create(p_236091_0_ -> p_236091_0_.group((App)Codec.STRING.fieldOf("preset_folder_name").forGetter(p_236090_0_ -> p_236090_0_.presetFolderName), (App)WorldChunkManager.a.fieldOf("biome_source").forGetter(p_236096_0_ -> p_236096_0_.b), (App)Codec.LONG.fieldOf("seed").stable().forGetter(p_236093_0_ -> p_236093_0_.worldSeed), (App)GeneratorSettingBase.b.fieldOf("settings").forGetter(p_236090_0_ -> p_236090_0_.dimensionSettingsSupplier)).apply((Applicative)p_236091_0_, p_236091_0_.stable(OTGNoiseChunkGenerator::new)));
    private final Supplier<GeneratorSettingBase> dimensionSettingsSupplier;
    private final long worldSeed;
    private final int noiseHeight;
    protected final IBlockData defaultBlock;
    protected final IBlockData defaultFluid;
    private final ShadowChunkGenerator shadowChunkGenerator;
    private final OTGChunkGenerator internalGenerator;
    private final OTGChunkDecorator chunkDecorator;
    private final String presetFolderName;
    private final Preset preset;
    protected final SeededRandom random;
    private CustomStructureCache structureCache;
    private ChunkCoordinate fixBiomesForChunk = null;

    public OTGNoiseChunkGenerator(WorldChunkManager biomeProvider, long seed, Supplier<GeneratorSettingBase> dimensionSettingsSupplier) {
        this("default", biomeProvider, biomeProvider, seed, dimensionSettingsSupplier);
    }

    public OTGNoiseChunkGenerator(String presetName, WorldChunkManager biomeProvider, long seed, Supplier<GeneratorSettingBase> dimensionSettingsSupplier) {
        this(presetName, biomeProvider, biomeProvider, seed, dimensionSettingsSupplier);
    }

    private OTGNoiseChunkGenerator(String presetFolderName, WorldChunkManager biomeProvider1, WorldChunkManager biomeProvider2, long seed, Supplier<GeneratorSettingBase> dimensionSettingsSupplier) {
        super(biomeProvider1, biomeProvider2, OTGNoiseChunkGenerator.overrideStructureSettings(dimensionSettingsSupplier.get().a(), presetFolderName), seed);
        if (!(biomeProvider1 instanceof ILayerSource)) {
            throw new RuntimeException("OTG has detected an incompatible biome provider- try using otg:otg as the biome source name");
        }
        this.presetFolderName = presetFolderName;
        this.worldSeed = seed;
        GeneratorSettingBase dimensionsettings = dimensionSettingsSupplier.get();
        this.dimensionSettingsSupplier = dimensionSettingsSupplier;
        NoiseSettings noisesettings = dimensionsettings.b();
        this.noiseHeight = noisesettings.a();
        this.defaultBlock = dimensionsettings.c();
        this.defaultFluid = dimensionsettings.d();
        this.random = new SeededRandom(seed);
        this.preset = OTG.getEngine().getPresetLoader().getPresetByFolderName(presetFolderName);
        this.shadowChunkGenerator = new ShadowChunkGenerator();
        this.internalGenerator = new OTGChunkGenerator(this.preset, seed, (ILayerSource)biomeProvider1, ((SpigotPresetLoader)OTG.getEngine().getPresetLoader()).getGlobalIdMapping(presetFolderName), OTG.getEngine().getLogger());
        this.chunkDecorator = new OTGChunkDecorator();
    }

    private static StructureSettings overrideStructureSettings(StructureSettings oldSettings, String presetFolderName) {
        Preset preset = OTG.getEngine().getPresetLoader().getPresetByFolderName(presetFolderName);
        IWorldConfig worldConfig = preset.getWorldConfig();
        ImmutableMap.Builder structureSeparationSettings = ImmutableMap.builder();
        if (worldConfig.getVillagesEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.VILLAGE, (Object)new StructureSettingsFeature(worldConfig.getVillageSpacing(), worldConfig.getVillageSeparation(), 10387312));
        }
        if (worldConfig.getRareBuildingsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.DESERT_PYRAMID, (Object)new StructureSettingsFeature(worldConfig.getDesertPyramidSpacing(), worldConfig.getDesertPyramidSeparation(), 14357617));
        }
        if (worldConfig.getRareBuildingsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.IGLOO, (Object)new StructureSettingsFeature(worldConfig.getIglooSpacing(), worldConfig.getIglooSeparation(), 14357618));
        }
        if (worldConfig.getRareBuildingsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.JUNGLE_PYRAMID, (Object)new StructureSettingsFeature(worldConfig.getJungleTempleSpacing(), worldConfig.getJungleTempleSeparation(), 14357619));
        }
        if (worldConfig.getRareBuildingsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.SWAMP_HUT, (Object)new StructureSettingsFeature(worldConfig.getSwampHutSpacing(), worldConfig.getSwampHutSeparation(), 14357620));
        }
        if (worldConfig.getPillagerOutpostsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.PILLAGER_OUTPOST, (Object)new StructureSettingsFeature(worldConfig.getPillagerOutpostSpacing(), worldConfig.getPillagerOutpostSeparation(), 165745296));
        }
        if (worldConfig.getStrongholdsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.STRONGHOLD, (Object)new StructureSettingsFeature(worldConfig.getStrongholdSpacing(), worldConfig.getStrongholdSeparation(), 0));
        }
        if (worldConfig.getOceanMonumentsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.MONUMENT, (Object)new StructureSettingsFeature(worldConfig.getOceanMonumentSpacing(), worldConfig.getOceanMonumentSeparation(), 10387313));
        }
        if (worldConfig.getEndCitiesEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.ENDCITY, (Object)new StructureSettingsFeature(worldConfig.getEndCitySpacing(), worldConfig.getEndCitySeparation(), 10387313));
        }
        if (worldConfig.getWoodlandMansionsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.MANSION, (Object)new StructureSettingsFeature(worldConfig.getWoodlandMansionSpacing(), worldConfig.getWoodlandMansionSeparation(), 10387319));
        }
        if (worldConfig.getBuriedTreasureEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.BURIED_TREASURE, (Object)new StructureSettingsFeature(worldConfig.getBuriedTreasureSpacing(), worldConfig.getBuriedTreasureSeparation(), 0));
        }
        if (worldConfig.getMineshaftsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.MINESHAFT, (Object)new StructureSettingsFeature(worldConfig.getMineshaftSpacing(), worldConfig.getMineshaftSeparation(), 0));
        }
        if (worldConfig.getRuinedPortalsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.RUINED_PORTAL, (Object)new StructureSettingsFeature(worldConfig.getRuinedPortalSpacing(), worldConfig.getRuinedPortalSeparation(), 34222645));
        }
        if (worldConfig.getShipWrecksEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.SHIPWRECK, (Object)new StructureSettingsFeature(worldConfig.getShipwreckSpacing(), worldConfig.getShipwreckSeparation(), 165745295));
        }
        if (worldConfig.getOceanRuinsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.OCEAN_RUIN, (Object)new StructureSettingsFeature(worldConfig.getOceanRuinSpacing(), worldConfig.getOceanRuinSeparation(), 14357621));
        }
        if (worldConfig.getBastionRemnantsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.BASTION_REMNANT, (Object)new StructureSettingsFeature(worldConfig.getBastionRemnantSpacing(), worldConfig.getBastionRemnantSeparation(), 30084232));
        }
        if (worldConfig.getNetherFortressesEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.FORTRESS, (Object)new StructureSettingsFeature(worldConfig.getNetherFortressSpacing(), worldConfig.getNetherFortressSeparation(), 30084232));
        }
        if (worldConfig.getNetherFossilsEnabled()) {
            structureSeparationSettings.put((Object)StructureGenerator.NETHER_FOSSIL, (Object)new StructureSettingsFeature(worldConfig.getNetherFossilSpacing(), worldConfig.getNetherFossilSeparation(), 14357921));
        }
        structureSeparationSettings.putAll(oldSettings.a().entrySet().stream().filter(a2 -> a2.getKey() != StructureGenerator.VILLAGE && a2.getKey() != StructureGenerator.DESERT_PYRAMID && a2.getKey() != StructureGenerator.IGLOO && a2.getKey() != StructureGenerator.JUNGLE_PYRAMID && a2.getKey() != StructureGenerator.SWAMP_HUT && a2.getKey() != StructureGenerator.PILLAGER_OUTPOST && a2.getKey() != StructureGenerator.STRONGHOLD && a2.getKey() != StructureGenerator.MONUMENT && a2.getKey() != StructureGenerator.ENDCITY && a2.getKey() != StructureGenerator.MANSION && a2.getKey() != StructureGenerator.BURIED_TREASURE && a2.getKey() != StructureGenerator.MINESHAFT && a2.getKey() != StructureGenerator.RUINED_PORTAL && a2.getKey() != StructureGenerator.SHIPWRECK && a2.getKey() != StructureGenerator.OCEAN_RUIN && a2.getKey() != StructureGenerator.BASTION_REMNANT && a2.getKey() != StructureGenerator.FORTRESS && a2.getKey() != StructureGenerator.NETHER_FOSSIL).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        StructureSettings newSettings = new StructureSettings(worldConfig.getStrongholdsEnabled() ? Optional.of(new StructureSettingsStronghold(worldConfig.getStrongHoldDistance(), worldConfig.getStrongHoldSpread(), worldConfig.getStrongHoldCount())) : Optional.empty(), (Map)Maps.newHashMap((Map)structureSeparationSettings.build()));
        return newSettings;
    }

    public ICachedBiomeProvider getCachedBiomeProvider() {
        return this.internalGenerator.getCachedBiomeProvider();
    }

    public void saveStructureCache() {
        if (this.chunkDecorator.getIsSaveRequired() && this.structureCache != null) {
            this.structureCache.saveToDisk(OTG.getEngine().getLogger(), this.chunkDecorator);
        }
    }

    public void buildNoiseSpigot(WorldServer world, ChunkGenerator.ChunkData chunk, ChunkCoordinate chunkCoord, Random random) {
        SpigotChunkBuffer buffer = new SpigotChunkBuffer(chunk, chunkCoord);
        IChunkAccess cachedChunk = this.shadowChunkGenerator.getChunkFromCache(chunkCoord);
        if (cachedChunk != null) {
            this.shadowChunkGenerator.fillWorldGenChunkFromShadowChunk(chunkCoord, chunk, cachedChunk);
        } else {
            ObjectArrayList structures = new ObjectArrayList(10);
            ObjectArrayList junctions = new ObjectArrayList(32);
            ChunkCoordIntPair pos = new ChunkCoordIntPair(chunkCoord.getChunkX(), chunkCoord.getChunkZ());
            int chunkX = pos.x;
            int chunkZ = pos.z;
            int startX = chunkX << 4;
            int startZ = chunkZ << 4;
            StructureManager manager = world.getStructureManager();
            for (StructureGenerator structure : StructureGenerator.t) {
                manager.a(SectionPosition.a((ChunkCoordIntPair)pos, (int)0), structure).forEach(arg_0 -> OTGNoiseChunkGenerator.lambda$buildNoiseSpigot$6(pos, (ObjectList)structures, startX, startZ, (ObjectList)junctions, arg_0));
            }
            this.internalGenerator.populateNoise(this.preset.getWorldConfig().getWorldHeightCap(), random, buffer, ((ChunkBuffer)buffer).getChunkCoordinate(), (ObjectList<JigsawStructureData>)structures, (ObjectList<JigsawStructureData>)junctions);
            this.shadowChunkGenerator.setChunkGenerated(chunkCoord);
        }
    }

    public void buildNoise(GeneratorAccess world, StructureManager manager, IChunkAccess chunk) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunk.getPos().x, chunk.getPos().z);
        if (this.fixBiomesForChunk != null && this.fixBiomesForChunk.equals(chunkCoord)) {
            this.createStructures(world.getMinecraftWorld().r(), world.getMinecraftWorld().getStructureManager(), chunk, world.getMinecraftWorld().n(), world.getMinecraftWorld().getSeed());
            this.createBiomes((IRegistry<BiomeBase>)((CraftServer)Bukkit.getServer()).getServer().customRegistry.b(IRegistry.ay), chunk);
            this.fixBiomesForChunk = null;
        }
        SpigotChunkBuffer buffer = new SpigotChunkBuffer((ProtoChunk)chunk);
        IChunkAccess cachedChunk = this.shadowChunkGenerator.getChunkFromCache(chunkCoord);
        if (cachedChunk != null) {
            this.shadowChunkGenerator.fillWorldGenChunkFromShadowChunk(chunkCoord, chunk, cachedChunk);
        } else {
            ObjectArrayList structures = new ObjectArrayList(10);
            ObjectArrayList junctions = new ObjectArrayList(32);
            ChunkCoordIntPair pos = chunk.getPos();
            int chunkX = pos.x;
            int chunkZ = pos.z;
            int startX = chunkX << 4;
            int startZ = chunkZ << 4;
            for (StructureGenerator structure : StructureGenerator.t) {
                manager.a(SectionPosition.a((ChunkCoordIntPair)pos, (int)0), structure).forEach(arg_0 -> OTGNoiseChunkGenerator.lambda$buildNoise$7(pos, (ObjectList)structures, startX, startZ, (ObjectList)junctions, arg_0));
            }
            this.internalGenerator.populateNoise(this.preset.getWorldConfig().getWorldHeightCap(), world.getRandom(), buffer, ((ChunkBuffer)buffer).getChunkCoordinate(), (ObjectList<JigsawStructureData>)structures, (ObjectList<JigsawStructureData>)junctions);
            this.shadowChunkGenerator.setChunkGenerated(chunkCoord);
        }
    }

    public void buildBase(RegionLimitedWorldAccess worldGenRegion, IChunkAccess chunk) {
    }

    public void doCarving(long seed, BiomeManager biomeManager, IChunkAccess chunk, WorldGenStage.Features stage) {
        if (stage == WorldGenStage.Features.AIR) {
            ProtoChunk protoChunk = (ProtoChunk)chunk;
            SpigotChunkBuffer chunkBuffer = new SpigotChunkBuffer(protoChunk);
            BitSet carvingMask = protoChunk.b(stage);
            this.internalGenerator.carve(chunkBuffer, seed, protoChunk.getPos().x, protoChunk.getPos().z, carvingMask, true, true);
        }
        super.doCarving(seed, biomeManager, chunk, stage);
    }

    public void addDecorations(RegionLimitedWorldAccess worldGenRegion, StructureManager structureManager) {
        if (!OTG.getEngine().getPluginConfig().getDecorationEnabled()) {
            return;
        }
        int worldX = worldGenRegion.a() * 16;
        int worldZ = worldGenRegion.b() * 16;
        BlockPosition blockpos = new BlockPosition(worldX, 0, worldZ);
        SeededRandom sharedseedrandom = new SeededRandom();
        long decorationSeed = sharedseedrandom.a(worldGenRegion.getSeed(), worldX, worldZ);
        ChunkCoordinate chunkBeingDecorated = ChunkCoordinate.fromBlockCoords(worldX, worldZ);
        SpigotWorldGenRegion spigotWorldGenRegion = new SpigotWorldGenRegion(this.preset.getFolderName(), this.preset.getWorldConfig(), worldGenRegion, this);
        IBiome biome = this.internalGenerator.getCachedBiomeProvider().getNoiseBiome((worldGenRegion.a() << 2) + 2, (worldGenRegion.b() << 2) + 2);
        IBiome biome1 = this.internalGenerator.getCachedBiomeProvider().getNoiseBiome(worldGenRegion.a() << 2, worldGenRegion.b() << 2);
        IBiome biome2 = this.internalGenerator.getCachedBiomeProvider().getNoiseBiome(worldGenRegion.a() << 2, (worldGenRegion.b() << 2) + 4);
        IBiome biome3 = this.internalGenerator.getCachedBiomeProvider().getNoiseBiome((worldGenRegion.a() << 2) + 4, worldGenRegion.b() << 2);
        IBiome biome4 = this.internalGenerator.getCachedBiomeProvider().getNoiseBiome((worldGenRegion.a() << 2) + 4, (worldGenRegion.b() << 2) + 4);
        Path worldSaveFolder = worldGenRegion.getMinecraftWorld().getWorld().getWorldFolder().toPath();
        if (!this.getPreset().getWorldConfig().improvedBorderDecoration()) {
            ArrayList<IBiome> biomes = new ArrayList<IBiome>();
            biomes.add(biome);
            biomes.add(biome1);
            biomes.add(biome2);
            biomes.add(biome3);
            biomes.add(biome4);
            HashMap<IBiome, Integer> map = new HashMap<IBiome, Integer>();
            Iterator iterator = biomes.iterator();
            while (iterator.hasNext()) {
                IBiome b;
                Integer val = (Integer)map.get(b = (IBiome)iterator.next());
                map.put(b, val == null ? 1 : val + 1);
            }
            Map.Entry max = null;
            for (Map.Entry ent : map.entrySet()) {
                if (max != null && (Integer)ent.getValue() <= (Integer)max.getValue()) continue;
                max = ent;
            }
            biome = (IBiome)max.getKey();
        }
        IBiomeConfig biomeConfig = biome.getBiomeConfig();
        try {
            ArrayList<Integer> alreadyDecorated = new ArrayList<Integer>();
            this.chunkDecorator.decorate(this.preset.getFolderName(), chunkBeingDecorated, spigotWorldGenRegion, biomeConfig, this.getStructureCache(worldSaveFolder));
            ((SpigotBiome)biome).getBiomeBase().a(structureManager, (ChunkGenerator)this, worldGenRegion, decorationSeed, sharedseedrandom, blockpos);
            alreadyDecorated.add(biome.getBiomeConfig().getOTGBiomeId());
            if (this.getPreset().getWorldConfig().improvedBorderDecoration()) {
                if (!alreadyDecorated.contains(biome1.getBiomeConfig().getOTGBiomeId())) {
                    this.chunkDecorator.decorate(this.preset.getFolderName(), chunkBeingDecorated, spigotWorldGenRegion, biome1.getBiomeConfig(), this.getStructureCache(worldSaveFolder));
                    ((SpigotBiome)biome1).getBiomeBase().a(structureManager, (ChunkGenerator)this, worldGenRegion, decorationSeed, sharedseedrandom, blockpos);
                    alreadyDecorated.add(biome1.getBiomeConfig().getOTGBiomeId());
                }
                if (!alreadyDecorated.contains(biome2.getBiomeConfig().getOTGBiomeId())) {
                    this.chunkDecorator.decorate(this.preset.getFolderName(), chunkBeingDecorated, spigotWorldGenRegion, biome2.getBiomeConfig(), this.getStructureCache(worldSaveFolder));
                    ((SpigotBiome)biome2).getBiomeBase().a(structureManager, (ChunkGenerator)this, worldGenRegion, decorationSeed, sharedseedrandom, blockpos);
                    alreadyDecorated.add(biome2.getBiomeConfig().getOTGBiomeId());
                }
                if (!alreadyDecorated.contains(biome3.getBiomeConfig().getOTGBiomeId())) {
                    this.chunkDecorator.decorate(this.preset.getFolderName(), chunkBeingDecorated, spigotWorldGenRegion, biome3.getBiomeConfig(), this.getStructureCache(worldSaveFolder));
                    ((SpigotBiome)biome3).getBiomeBase().a(structureManager, (ChunkGenerator)this, worldGenRegion, decorationSeed, sharedseedrandom, blockpos);
                    alreadyDecorated.add(biome3.getBiomeConfig().getOTGBiomeId());
                }
                if (!alreadyDecorated.contains(biome4.getBiomeConfig().getOTGBiomeId())) {
                    this.chunkDecorator.decorate(this.preset.getFolderName(), chunkBeingDecorated, spigotWorldGenRegion, biome4.getBiomeConfig(), this.getStructureCache(worldSaveFolder));
                    ((SpigotBiome)biome4).getBiomeBase().a(structureManager, (ChunkGenerator)this, worldGenRegion, decorationSeed, sharedseedrandom, blockpos);
                }
            }
            this.chunkDecorator.doSnowAndIce(spigotWorldGenRegion, chunkBeingDecorated);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.a((Throwable)exception, (String)"Biome decoration");
            crashreport.a("Generation").a("CenterX", (Object)worldX).a("CenterZ", (Object)worldZ).a("Seed", (Object)decorationSeed);
            throw new ReportedException(crashreport);
        }
    }

    public void createBiomes(IRegistry<BiomeBase> iregistry, IChunkAccess ichunkaccess) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.getPos();
        ((ProtoChunk)ichunkaccess).a(new BiomeStorage(iregistry, chunkcoordintpair, this.c));
    }

    public void addMobs(RegionLimitedWorldAccess worldGenRegion) {
        int chunkX = worldGenRegion.a();
        int chunkZ = worldGenRegion.b();
        IBiome biome = this.internalGenerator.getCachedBiomeProvider().getBiome(chunkX * 16 + 8, chunkZ * 16 + 8);
        SeededRandom sharedseedrandom = new SeededRandom();
        sharedseedrandom.a(worldGenRegion.getSeed(), chunkX << 4, chunkZ << 4);
        SpawnerCreature.a((WorldAccess)worldGenRegion, (BiomeBase)((SpigotBiome)biome).getBiomeBase(), (int)chunkX, (int)chunkZ, (Random)sharedseedrandom);
    }

    public List<BiomeSettingsMobs.c> getMobsFor(BiomeBase biome, StructureManager structureManager, EnumCreatureType entityClassification, BlockPosition blockPos) {
        if (structureManager.a(blockPos, true, (StructureGenerator)StructureGenerator.SWAMP_HUT).e()) {
            if (entityClassification == EnumCreatureType.MONSTER) {
                return StructureGenerator.SWAMP_HUT.c();
            }
            if (entityClassification == EnumCreatureType.CREATURE) {
                return StructureGenerator.SWAMP_HUT.j();
            }
        }
        if (entityClassification == EnumCreatureType.MONSTER) {
            if (structureManager.a(blockPos, false, StructureGenerator.PILLAGER_OUTPOST).e()) {
                return StructureGenerator.PILLAGER_OUTPOST.c();
            }
            if (structureManager.a(blockPos, false, StructureGenerator.MONUMENT).e()) {
                return StructureGenerator.MONUMENT.c();
            }
            if (structureManager.a(blockPos, true, StructureGenerator.FORTRESS).e()) {
                return StructureGenerator.FORTRESS.c();
            }
        }
        return super.getMobsFor(biome, structureManager, entityClassification, blockPos);
    }

    public int getBaseHeight(int x, int z, HeightMap.Type heightmapType) {
        return this.sampleHeightmap(x, z, null, heightmapType.e());
    }

    public IBlockAccess a(int x, int z) {
        IBlockData[] ablockstate = new IBlockData[this.internalGenerator.getNoiseSizeY() * 8];
        this.sampleHeightmap(x, x, ablockstate, null);
        return new BlockColumn(ablockstate);
    }

    private int sampleHeightmap(int x, int z, @Nullable IBlockData[] blockStates, @Nullable Predicate<IBlockData> predicate) {
        int xStart = Math.floorDiv(x, 4);
        int zStart = Math.floorDiv(z, 4);
        int xProgress = Math.floorMod(x, 4);
        int zProgress = Math.floorMod(z, 4);
        double xLerp = (double)xProgress / 4.0;
        double zLerp = (double)zProgress / 4.0;
        double[][] noiseData = new double[4][this.internalGenerator.getNoiseSizeY() + 1];
        for (int i = 0; i < noiseData.length; ++i) {
            noiseData[i] = new double[this.internalGenerator.getNoiseSizeY() + 1];
        }
        this.internalGenerator.getNoiseColumn(noiseData[0], xStart, zStart);
        this.internalGenerator.getNoiseColumn(noiseData[1], xStart, zStart + 1);
        this.internalGenerator.getNoiseColumn(noiseData[2], xStart + 1, zStart);
        this.internalGenerator.getNoiseColumn(noiseData[3], xStart + 1, zStart + 1);
        for (int noiseY = this.internalGenerator.getNoiseSizeY() - 1; noiseY >= 0; --noiseY) {
            double x0z0y0 = noiseData[0][noiseY];
            double x0z1y0 = noiseData[1][noiseY];
            double x1z0y0 = noiseData[2][noiseY];
            double x1z1y0 = noiseData[3][noiseY];
            double x0z0y1 = noiseData[0][noiseY + 1];
            double x0z1y1 = noiseData[1][noiseY + 1];
            double x1z0y1 = noiseData[2][noiseY + 1];
            double x1z1y1 = noiseData[3][noiseY + 1];
            for (int pieceY = 7; pieceY >= 0; --pieceY) {
                double yLerp = (double)pieceY / 8.0;
                double density = MathHelper.a((double)yLerp, (double)xLerp, (double)zLerp, (double)x0z0y0, (double)x0z0y1, (double)x1z0y0, (double)x1z0y1, (double)x0z1y0, (double)x0z1y1, (double)x1z1y0, (double)x1z1y1);
                int y = noiseY * 8 + pieceY;
                IBlockData state = this.getBlockState(density, y);
                if (blockStates != null) {
                    blockStates[y] = state;
                }
                if (predicate == null || !predicate.test(state)) continue;
                return y + 1;
            }
        }
        return 0;
    }

    private IBlockData getBlockState(double density, int y) {
        if (density > 0.0) {
            return this.defaultBlock;
        }
        if (y < this.getSeaLevel()) {
            return this.defaultFluid;
        }
        return Blocks.AIR.getBlockData();
    }

    protected Codec<? extends ChunkGenerator> a() {
        return CODEC;
    }

    public int getGenerationDepth() {
        return this.noiseHeight;
    }

    public int getSeaLevel() {
        return this.dimensionSettingsSupplier.get().g();
    }

    public Preset getPreset() {
        return this.preset;
    }

    public CustomStructureCache getStructureCache(Path worldSaveFolder) {
        if (this.structureCache == null) {
            this.structureCache = OTG.getEngine().createCustomStructureCache(this.preset.getFolderName(), worldSaveFolder, this.worldSeed, this.preset.getWorldConfig().getCustomStructureType() == SettingsEnums.CustomStructureType.BO4);
        }
        return this.structureCache;
    }

    double getBiomeBlocksNoiseValue(int blockX, int blockZ) {
        return this.internalGenerator.getBiomeBlocksNoiseValue(blockX, blockZ);
    }

    public void fixBiomes(int chunkX, int chunkZ) {
        this.fixBiomesForChunk = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
    }

    public Boolean checkHasVanillaStructureWithoutLoading(WorldServer world, ChunkCoordinate chunkCoord) {
        return this.shadowChunkGenerator.checkHasVanillaStructureWithoutLoading(world, this, this.b, this.getSettings(), chunkCoord, this.internalGenerator.getCachedBiomeProvider());
    }

    public int getHighestBlockYInUnloadedChunk(Random worldRandom, int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow) {
        return this.shadowChunkGenerator.getHighestBlockYInUnloadedChunk(this.internalGenerator, this.preset.getWorldConfig().getWorldHeightCap(), worldRandom, x, z, findSolid, findLiquid, ignoreLiquid, ignoreSnow);
    }

    public LocalMaterialData getMaterialInUnloadedChunk(Random worldRandom, int x, int y, int z) {
        return this.shadowChunkGenerator.getMaterialInUnloadedChunk(this.internalGenerator, this.preset.getWorldConfig().getWorldHeightCap(), worldRandom, x, y, z);
    }

    public SpigotChunkBuffer getChunkWithoutLoadingOrCaching(Random random, ChunkCoordinate chunkCoord) {
        return this.shadowChunkGenerator.getChunkWithoutLoadingOrCaching(this.internalGenerator, this.preset.getWorldConfig().getWorldHeightCap(), random, chunkCoord);
    }

    private static /* synthetic */ void lambda$buildNoise$7(ChunkCoordIntPair pos, ObjectList structures, int startX, int startZ, ObjectList junctions, StructureStart start) {
        for (StructurePiece piece : start.d()) {
            if (!piece.a(pos, 12)) continue;
            StructureBoundingBox box = piece.g();
            if (piece instanceof WorldGenFeaturePillagerOutpostPoolPiece) {
                WorldGenFeaturePillagerOutpostPoolPiece villagePiece = (WorldGenFeaturePillagerOutpostPoolPiece)piece;
                if (villagePiece.b().e() == WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID) {
                    structures.add((Object)new JigsawStructureData(box.a, box.b, box.c, box.d, villagePiece.d(), box.f, true, 0, 0, 0));
                }
                for (WorldGenFeatureDefinedStructureJigsawJunction junction : villagePiece.e()) {
                    int sourceX = junction.a();
                    int sourceZ = junction.c();
                    if (sourceX <= startX - 12 || sourceZ <= startZ - 12 || sourceX >= startX + 15 + 12 || sourceZ >= startZ + 15 + 12) continue;
                    junctions.add((Object)new JigsawStructureData(0, 0, 0, 0, 0, 0, false, junction.a(), junction.b(), junction.c()));
                }
                continue;
            }
            structures.add((Object)new JigsawStructureData(box.a, box.b, box.c, box.d, 0, box.f, false, 0, 0, 0));
        }
    }

    private static /* synthetic */ void lambda$buildNoiseSpigot$6(ChunkCoordIntPair pos, ObjectList structures, int startX, int startZ, ObjectList junctions, StructureStart start) {
        for (StructurePiece piece : start.d()) {
            if (!piece.a(pos, 12)) continue;
            StructureBoundingBox box = piece.g();
            if (piece instanceof WorldGenFeaturePillagerOutpostPoolPiece) {
                WorldGenFeaturePillagerOutpostPoolPiece villagePiece = (WorldGenFeaturePillagerOutpostPoolPiece)piece;
                if (villagePiece.b().e() == WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID) {
                    structures.add((Object)new JigsawStructureData(box.a, box.b, box.c, box.d, villagePiece.d(), box.f, true, 0, 0, 0));
                }
                for (WorldGenFeatureDefinedStructureJigsawJunction junction : villagePiece.e()) {
                    int sourceX = junction.a();
                    int sourceZ = junction.c();
                    if (sourceX <= startX - 12 || sourceZ <= startZ - 12 || sourceX >= startX + 15 + 12 || sourceZ >= startZ + 15 + 12) continue;
                    junctions.add((Object)new JigsawStructureData(0, 0, 0, 0, 0, 0, false, junction.a(), junction.b(), junction.c()));
                }
                continue;
            }
            structures.add((Object)new JigsawStructureData(box.a, box.b, box.c, box.d, 0, box.f, false, 0, 0, 0));
        }
    }
}

