/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.gen;

import com.pg85.otg.presets.Preset;
import com.pg85.otg.spigot.OTGPlugin;
import com.pg85.otg.spigot.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.FifoMap;
import java.util.Random;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.generator.ChunkGenerator;

public class OTGSpigotChunkGen
extends ChunkGenerator {
    public OTGNoiseChunkGenerator generator = null;
    private final FifoMap<ChunkCoordinate, ChunkGenerator.ChunkData> chunkDataCache = new FifoMap(128);
    private final Preset preset;

    public OTGSpigotChunkGen(Preset preset) {
        this.preset = preset;
    }

    public Preset getPreset() {
        return this.preset;
    }

    public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int chunkX, int chunkZ, ChunkGenerator.BiomeGrid biome) {
        ChunkCoordinate chunkCoord;
        ChunkGenerator.ChunkData chunkData;
        if (this.generator == null) {
            OTGPlugin.injectInternalGenerator(world);
            this.generator.fixBiomes(chunkX, chunkZ);
        }
        if ((chunkData = (ChunkGenerator.ChunkData)this.chunkDataCache.get(chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ))) == null) {
            chunkData = this.createChunkData(world);
            this.generator.buildNoiseSpigot(((CraftWorld)world).getHandle(), chunkData, chunkCoord, random);
            this.chunkDataCache.put(chunkCoord, chunkData);
        }
        return chunkData;
    }

    public boolean isParallelCapable() {
        return true;
    }

    public boolean shouldGenerateCaves() {
        return true;
    }

    public boolean shouldGenerateDecorations() {
        return true;
    }

    public boolean shouldGenerateMobs() {
        return true;
    }

    public boolean shouldGenerateStructures() {
        return true;
    }
}

