/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.gen;

import com.pg85.otg.gen.OTGChunkGenerator;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.spigot.biome.SpigotBiome;
import com.pg85.otg.spigot.gen.SpigotChunkBuffer;
import com.pg85.otg.spigot.materials.SpigotMaterialData;
import com.pg85.otg.util.BlockPos2D;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.gen.JigsawStructureData;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R3.ChunkGenerator;
import net.minecraft.server.v1_16_R3.DefinedStructureManager;
import net.minecraft.server.v1_16_R3.HeightMap;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IChunkAccess;
import net.minecraft.server.v1_16_R3.IRegistryCustom;
import net.minecraft.server.v1_16_R3.ProtoChunk;
import net.minecraft.server.v1_16_R3.SeededRandom;
import net.minecraft.server.v1_16_R3.StructureFeature;
import net.minecraft.server.v1_16_R3.StructureGenerator;
import net.minecraft.server.v1_16_R3.StructureManager;
import net.minecraft.server.v1_16_R3.StructureSettings;
import net.minecraft.server.v1_16_R3.StructureSettingsFeature;
import net.minecraft.server.v1_16_R3.WorldChunkManager;
import net.minecraft.server.v1_16_R3.WorldGenStage;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.craftbukkit.v1_16_R3.generator.CraftChunkData;
import org.bukkit.generator.ChunkGenerator;

public class ShadowChunkGenerator {
    private final FifoMap<BlockPos2D, LocalMaterialData[]> unloadedBlockColumnsCache = new FifoMap(1024);
    private final FifoMap<ChunkCoordinate, IChunkAccess> unloadedChunksCache = new FifoMap(512);
    private final FifoMap<ChunkCoordinate, Integer> hasVanillaStructureChunkCache = new FifoMap(2048);
    static Field heightMaps;
    static Field light;
    static Field sections;
    private int cacheHits = 0;
    private int cacheMisses = 0;

    private SpigotChunkBuffer getUnloadedChunk(OTGChunkGenerator otgChunkGenerator, int worldHeightCap, Random random, ChunkCoordinate chunkCoordinate) {
        ProtoChunk chunk = new ProtoChunk(new ChunkCoordIntPair(chunkCoordinate.getChunkX(), chunkCoordinate.getChunkZ()), null);
        SpigotChunkBuffer buffer = new SpigotChunkBuffer(chunk);
        ObjectArrayList structures = new ObjectArrayList(10);
        ObjectArrayList junctions = new ObjectArrayList(32);
        otgChunkGenerator.populateNoise(worldHeightCap, random, buffer, buffer.getChunkCoordinate(), (ObjectList<JigsawStructureData>)structures, (ObjectList<JigsawStructureData>)junctions);
        return buffer;
    }

    public IChunkAccess getChunkFromCache(ChunkCoordinate chunkCoord) {
        IChunkAccess cachedChunk = (IChunkAccess)this.unloadedChunksCache.get(chunkCoord);
        if (cachedChunk != null) {
            return cachedChunk;
        }
        return null;
    }

    public void fillWorldGenChunkFromShadowChunk(ChunkCoordinate chunkCoord, ChunkGenerator.ChunkData chunk, IChunkAccess cachedChunk) {
        CraftChunkData data = (CraftChunkData)chunk;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int endY = cachedChunk.a(HeightMap.Type.WORLD_SURFACE_WG).a(x, z);
                for (int y = 0; y <= endY; ++y) {
                    BlockPosition pos = new BlockPosition(x, y, z);
                    data.setRegion(x, y, z, x + 1, y + 1, z + 1, cachedChunk.getType(pos));
                }
            }
        }
        ++this.cacheHits;
        this.unloadedChunksCache.remove(chunkCoord);
    }

    public void fillWorldGenChunkFromShadowChunk(ChunkCoordinate chunkCoord, IChunkAccess chunk, IChunkAccess cachedChunk) {
        try {
            sections.set((ProtoChunk)chunk, sections.get((ProtoChunk)cachedChunk));
            light.set((ProtoChunk)chunk, light.get((ProtoChunk)cachedChunk));
            heightMaps.set((ProtoChunk)chunk, heightMaps.get((ProtoChunk)cachedChunk));
        }
        catch (ReflectiveOperationException e2) {
            e2.printStackTrace();
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int endY = cachedChunk.a(HeightMap.Type.WORLD_SURFACE_WG).a(x, z);
                for (int y = 0; y <= endY; ++y) {
                    BlockPosition pos = new BlockPosition(x, y, z);
                    chunk.setType(pos, cachedChunk.getType(pos), false);
                }
            }
        }
        ++this.cacheHits;
        this.unloadedChunksCache.remove(chunkCoord);
    }

    public void setChunkGenerated(ChunkCoordinate chunkCoord) {
        ++this.cacheMisses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkHasVanillaStructureWithoutLoading(WorldServer serverWorld, ChunkGenerator chunkGenerator, WorldChunkManager biomeProvider, StructureSettings dimensionStructuresSettings, ChunkCoordinate chunkCoordinate, ICachedBiomeProvider cachedBiomeProvider) {
        int radiusInChunks = 5;
        if (serverWorld.getServer().getGenerateStructures()) {
            ArrayList<ChunkCoordinate> chunksToHandle = new ArrayList<ChunkCoordinate>();
            HashMap<ChunkCoordinate, Integer> chunksHandled = new HashMap<ChunkCoordinate, Integer>();
            FifoMap<ChunkCoordinate, Integer> fifoMap = this.hasVanillaStructureChunkCache;
            synchronized (fifoMap) {
                if (this.checkHasVanillaStructureWithoutLoadingCache(this.hasVanillaStructureChunkCache, chunkCoordinate, radiusInChunks, chunksToHandle)) {
                    return true;
                }
            }
            ArrayList[] structuresPerDistance = new ArrayList[radiusInChunks];
            structuresPerDistance[4] = new ArrayList<StructureGenerator>(Arrays.asList(StructureGenerator.VILLAGE, StructureGenerator.ENDCITY, StructureGenerator.BASTION_REMNANT, StructureGenerator.MONUMENT, StructureGenerator.MANSION));
            structuresPerDistance[3] = new ArrayList<StructureGenerator>(Arrays.asList(new StructureGenerator[0]));
            structuresPerDistance[2] = new ArrayList<StructureGenerator>(Arrays.asList(new StructureGenerator[0]));
            structuresPerDistance[1] = new ArrayList<StructureGenerator>(Arrays.asList(StructureGenerator.JUNGLE_PYRAMID, StructureGenerator.DESERT_PYRAMID, StructureGenerator.RUINED_PORTAL, StructureGenerator.SWAMP_HUT, StructureGenerator.IGLOO, StructureGenerator.SHIPWRECK, StructureGenerator.PILLAGER_OUTPOST, StructureGenerator.OCEAN_RUIN));
            structuresPerDistance[0] = new ArrayList<StructureGenerator>(Arrays.asList(new StructureGenerator[0]));
            for (ChunkCoordinate chunkToHandle : chunksToHandle) {
                ProtoChunk chunk = new ProtoChunk(new ChunkCoordIntPair(chunkToHandle.getChunkX(), chunkToHandle.getChunkZ()), null);
                ChunkCoordIntPair chunkpos = chunk.getPos();
                int distance = (int)Math.floor(Math.sqrt(Math.pow(chunkToHandle.getChunkX() - chunkCoordinate.getChunkX(), 2.0) + Math.pow(chunkToHandle.getChunkZ() - chunkCoordinate.getChunkZ(), 2.0)));
                IBiome biome = cachedBiomeProvider.getNoiseBiome((chunkpos.x << 2) + 2, (chunkpos.z << 2) + 2);
                block10: for (Supplier supplier : ((SpigotBiome)biome).getBiomeBase().e().a()) {
                    StructureFeature structure = (StructureFeature)supplier.get();
                    if (structure.d.f() != WorldGenStage.Decoration.SURFACE_STRUCTURES) continue;
                    for (int i = structuresPerDistance.length - 1; i > 0; --i) {
                        ArrayList structuresAtDistance = structuresPerDistance[i];
                        if (!structuresAtDistance.contains(structure.d)) continue;
                        if (!ShadowChunkGenerator.hasStructureStart(structure, dimensionStructuresSettings, serverWorld.r(), serverWorld.getStructureManager(), (IChunkAccess)chunk, serverWorld.n(), chunkGenerator, biomeProvider, serverWorld.getSeed(), chunkpos, ((SpigotBiome)biome).getBiomeBase())) continue block10;
                        chunksHandled.put(chunkToHandle, new Integer(i));
                        if (i < distance) continue block10;
                        FifoMap<ChunkCoordinate, Integer> fifoMap2 = this.hasVanillaStructureChunkCache;
                        synchronized (fifoMap2) {
                            this.hasVanillaStructureChunkCache.putAll(chunksHandled);
                        }
                        return true;
                    }
                }
                chunksHandled.putIfAbsent(chunkToHandle, new Integer(0));
            }
            FifoMap<ChunkCoordinate, Integer> fifoMap3 = this.hasVanillaStructureChunkCache;
            synchronized (fifoMap3) {
                this.hasVanillaStructureChunkCache.putAll(chunksHandled);
            }
        }
        return false;
    }

    private boolean checkHasVanillaStructureWithoutLoadingCache(FifoMap<ChunkCoordinate, Integer> cache, ChunkCoordinate chunkCoordinate, int radiusInChunks, List<ChunkCoordinate> chunksToHandle) {
        for (int cycle = 0; cycle < radiusInChunks; ++cycle) {
            for (int xOffset = -cycle; xOffset <= cycle; ++xOffset) {
                for (int zOffset = -cycle; zOffset <= cycle; ++zOffset) {
                    int distance = (int)Math.floor(Math.sqrt(Math.pow(xOffset, 2.0) + Math.pow(zOffset, 2.0)));
                    if (distance != cycle) continue;
                    ChunkCoordinate searchChunk = ChunkCoordinate.fromChunkCoords(chunkCoordinate.getChunkX() + xOffset, chunkCoordinate.getChunkZ() + zOffset);
                    Integer result = (Integer)cache.get(searchChunk);
                    if (result != null) {
                        if (result <= 0 || result < distance) continue;
                        return true;
                    }
                    chunksToHandle.add(searchChunk);
                }
            }
        }
        return false;
    }

    private static boolean hasStructureStart(StructureFeature<?, ?> structureFeature, StructureSettings dimensionStructuresSettings, IRegistryCustom dynamicRegistries, StructureManager structureManager, IChunkAccess chunk, DefinedStructureManager templateManager, ChunkGenerator chunkGenerator, WorldChunkManager biomeProvider, long seed, ChunkCoordIntPair chunkPos, BiomeBase biome) {
        StructureSettingsFeature structureSeparationSettings = dimensionStructuresSettings.a(structureFeature.d);
        if (structureSeparationSettings != null) {
            SeededRandom sharedSeedRandom = new SeededRandom();
            ChunkCoordIntPair chunkPosPotential = structureFeature.d.a(structureSeparationSettings, seed, sharedSeedRandom, chunkPos.x, chunkPos.z);
            return chunkPos.x == chunkPosPotential.x && chunkPos.z == chunkPosPotential.z;
        }
        return false;
    }

    public SpigotChunkBuffer getChunkWithoutLoadingOrCaching(OTGChunkGenerator otgChunkGenerator, int worldHeightCap, Random random, ChunkCoordinate chunkCoordinate) {
        return this.getUnloadedChunk(otgChunkGenerator, worldHeightCap, random, chunkCoordinate);
    }

    private LocalMaterialData[] getBlockColumnInUnloadedChunk(OTGChunkGenerator otgChunkGenerator, int worldHeightCap, Random worldRandom, int x, int z) {
        IBlockData blockInChunk;
        BlockPos2D blockPos = new BlockPos2D(x, z);
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        byte blockX = (byte)(x &= 0xF);
        byte blockZ = (byte)(z &= 0xF);
        LocalMaterialData[] cachedColumn = (LocalMaterialData[])this.unloadedBlockColumnsCache.get(blockPos);
        if (cachedColumn != null) {
            return cachedColumn;
        }
        IChunkAccess chunk = this.getChunkFromCache(chunkCoord);
        if (chunk == null) {
            chunk = this.getUnloadedChunk(otgChunkGenerator, worldHeightCap, worldRandom, chunkCoord).getChunk();
            this.unloadedChunksCache.put(chunkCoord, chunk);
        }
        cachedColumn = new LocalMaterialData[256];
        LocalMaterialData[] blocksInColumn = new LocalMaterialData[256];
        for (int y = 0; y < 256 && (blockInChunk = chunk.getType(new BlockPosition((int)blockX, y, (int)blockZ))) != null; y = (int)((short)(y + 1))) {
            blocksInColumn[y] = SpigotMaterialData.ofBlockData(blockInChunk);
        }
        this.unloadedBlockColumnsCache.put(blockPos, cachedColumn);
        return blocksInColumn;
    }

    public LocalMaterialData getMaterialInUnloadedChunk(OTGChunkGenerator otgChunkGenerator, int worldHeightCap, Random worldRandom, int x, int y, int z) {
        LocalMaterialData[] blockColumn = this.getBlockColumnInUnloadedChunk(otgChunkGenerator, worldHeightCap, worldRandom, x, z);
        return blockColumn[y];
    }

    public int getHighestBlockYInUnloadedChunk(OTGChunkGenerator otgChunkGenerator, int worldHeightCap, Random worldRandom, int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow) {
        int height = -1;
        LocalMaterialData[] blockColumn = this.getBlockColumnInUnloadedChunk(otgChunkGenerator, worldHeightCap, worldRandom, x, z);
        for (int y = 255; y >= 0; --y) {
            boolean isSolid;
            SpigotMaterialData material = (SpigotMaterialData)blockColumn[y];
            boolean isLiquid = material.isLiquid();
            boolean bl = isSolid = material.isSolid() || !ignoreSnow && material.isMaterial(LocalMaterials.SNOW);
            if (isLiquid && ignoreLiquid) continue;
            if (findSolid && isSolid || findLiquid && isLiquid) {
                return y;
            }
            if ((!findSolid || !isLiquid) && (!findLiquid || !isSolid)) continue;
            return -1;
        }
        return height;
    }

    static {
        try {
            heightMaps = ProtoChunk.class.getDeclaredField("f");
            heightMaps.setAccessible(true);
            light = ProtoChunk.class.getDeclaredField("l");
            light.setAccessible(true);
            sections = ProtoChunk.class.getDeclaredField("j");
            sections.setAccessible(true);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }
}

