/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.gen;

import com.google.gson.JsonSyntaxException;
import com.pg85.otg.OTG;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.interfaces.IEntityFunction;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.spigot.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.spigot.materials.SpigotMaterialData;
import com.pg85.otg.spigot.util.JsonToNBT;
import com.pg85.otg.spigot.util.SpigotNBTHelper;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.gen.LocalWorldGenRegion;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import com.pg85.otg.util.minecraft.TreeType;
import com.pg85.otg.util.nbt.NamedBinaryTag;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.Random;
import net.minecraft.server.v1_16_R3.BiomeDecoratorGroups;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Blocks;
import net.minecraft.server.v1_16_R3.ChatComponentText;
import net.minecraft.server.v1_16_R3.ChunkGenerator;
import net.minecraft.server.v1_16_R3.ChunkStatus;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityGuardian;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumMobSpawn;
import net.minecraft.server.v1_16_R3.EnumMonsterType;
import net.minecraft.server.v1_16_R3.GeneratorAccessSeed;
import net.minecraft.server.v1_16_R3.GroupDataEntity;
import net.minecraft.server.v1_16_R3.HeightMap;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.IChunkAccess;
import net.minecraft.server.v1_16_R3.NBTBase;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.NBTTagInt;
import net.minecraft.server.v1_16_R3.RegionLimitedWorldAccess;
import net.minecraft.server.v1_16_R3.TileEntity;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldAccess;
import net.minecraft.server.v1_16_R3.WorldGenFeatureConfiguration;
import net.minecraft.server.v1_16_R3.WorldGenFeatureConfigured;
import net.minecraft.server.v1_16_R3.WorldGenFeatureHugeFungiConfiguration;
import net.minecraft.server.v1_16_R3.WorldGenerator;

public class SpigotWorldGenRegion
extends LocalWorldGenRegion {
    protected final GeneratorAccessSeed worldGenRegion;
    private final OTGNoiseChunkGenerator chunkGenerator;
    private FifoMap<ChunkCoordinate, Boolean> cachedHasDefaultStructureChunks = new FifoMap(2048);

    public SpigotWorldGenRegion(String presetFolderName, IWorldConfig worldConfig, RegionLimitedWorldAccess worldGenRegion, OTGNoiseChunkGenerator chunkGenerator) {
        super(presetFolderName, OTG.getEngine().getPluginConfig(), worldConfig, OTG.getEngine().getLogger(), worldGenRegion.a(), worldGenRegion.b(), chunkGenerator.getCachedBiomeProvider());
        this.worldGenRegion = worldGenRegion;
        this.chunkGenerator = chunkGenerator;
    }

    public SpigotWorldGenRegion(String presetFolderName, IWorldConfig worldConfig, GeneratorAccessSeed worldGenRegion, OTGNoiseChunkGenerator chunkGenerator) {
        super(presetFolderName, OTG.getEngine().getPluginConfig(), worldConfig, OTG.getEngine().getLogger());
        this.worldGenRegion = worldGenRegion;
        this.chunkGenerator = chunkGenerator;
    }

    public SpigotWorldGenRegion(String presetFolderName, IWorldConfig worldConfig, GeneratorAccessSeed worldGenRegion) {
        super(presetFolderName, OTG.getEngine().getPluginConfig(), worldConfig, OTG.getEngine().getLogger());
        this.worldGenRegion = worldGenRegion;
        this.chunkGenerator = null;
    }

    @Override
    public ILogger getLogger() {
        return OTG.getEngine().getLogger();
    }

    @Override
    public long getSeed() {
        return this.worldGenRegion.getSeed();
    }

    @Override
    public Random getWorldRandom() {
        return this.worldGenRegion.getRandom();
    }

    @Override
    public ICachedBiomeProvider getCachedBiomeProvider() {
        return this.chunkGenerator.getCachedBiomeProvider();
    }

    @Override
    public ChunkCoordinate getSpawnChunk() {
        if (this.getWorldConfig().getSpawnPointSet()) {
            return ChunkCoordinate.fromBlockCoords(this.getWorldConfig().getSpawnPointX(), this.getWorldConfig().getSpawnPointZ());
        }
        BlockPosition spawnPos = this.worldGenRegion.getMinecraftWorld().getSpawn();
        return ChunkCoordinate.fromBlockCoords(spawnPos.getX(), spawnPos.getZ());
    }

    public GeneratorAccessSeed getInternal() {
        return this.worldGenRegion;
    }

    @Override
    public IBiome getBiomeForDecoration(int x, int z) {
        return this.decorationArea != null ? this.decorationBiomeCache.getBiome(x, z) : this.getCachedBiomeProvider().getBiome(x, z);
    }

    @Override
    public IBiomeConfig getBiomeConfigForDecoration(int x, int z) {
        return this.decorationArea != null ? this.decorationBiomeCache.getBiomeConfig(x, z) : this.getCachedBiomeProvider().getBiomeConfig(x, z);
    }

    @Override
    public double getBiomeBlocksNoiseValue(int xInWorld, int zInWorld) {
        return this.chunkGenerator.getBiomeBlocksNoiseValue(xInWorld, zInWorld);
    }

    @Override
    public LocalMaterialData getMaterialDirect(int x, int y, int z) {
        return SpigotMaterialData.ofBlockData(this.worldGenRegion.getType(new BlockPosition(x, y, z)));
    }

    @Override
    public LocalMaterialData getMaterial(int x, int y, int z) {
        if (y >= 256 || y < 0) {
            return null;
        }
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunkAccess chunk = null;
        if (this.decorationArea == null || this.decorationArea.isInAreaBeingDecorated(x, z)) {
            IChunkAccess iChunkAccess = chunk = this.worldGenRegion.isChunkLoaded(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.getChunkAt(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        }
        if (chunk == null || !chunk.getChunkStatus().b(ChunkStatus.LIQUID_CARVERS)) {
            return null;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        return SpigotMaterialData.ofBlockData(chunk.getType(new BlockPosition(internalX, y, internalZ)));
    }

    @Override
    public int getBlockAboveLiquidHeight(int x, int z) {
        int highestY = this.getHighestBlockYAt(x, z, false, true, false, false, false);
        if (highestY >= 0) {
            return highestY + 1;
        }
        return -1;
    }

    @Override
    public int getBlockAboveSolidHeight(int x, int z) {
        int highestY = this.getHighestBlockYAt(x, z, true, false, true, true, false);
        if (highestY >= 0) {
            return highestY + 1;
        }
        return -1;
    }

    @Override
    public int getHighestBlockAboveYAt(int x, int z) {
        int highestY = this.getHighestBlockYAt(x, z, true, true, false, false, false);
        if (highestY >= 0) {
            return highestY + 1;
        }
        return -1;
    }

    @Override
    public int getHighestBlockYAt(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow, boolean ignoreLeaves) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunkAccess chunk = null;
        if (this.decorationArea == null || this.decorationArea.isInAreaBeingDecorated(x, z)) {
            IChunkAccess iChunkAccess = chunk = this.worldGenRegion.isChunkLoaded(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.getChunkAt(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        }
        if (chunk == null || !chunk.getChunkStatus().b(ChunkStatus.LIQUID_CARVERS)) {
            return -1;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        int heightMapY = chunk.getHighestBlock(HeightMap.Type.WORLD_SURFACE, internalX, internalZ);
        return this.getHighestBlockYAt(chunk, internalX, heightMapY, internalZ, findSolid, findLiquid, ignoreLiquid, ignoreSnow, ignoreLeaves);
    }

    protected int getHighestBlockYAt(IChunkAccess chunk, int internalX, int heightMapY, int internalZ, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow, boolean ignoreLeaves) {
        for (int i = heightMapY; i >= 0; --i) {
            boolean isSolid;
            IBlockData blockState = chunk.getType(new BlockPosition(internalX, i, internalZ));
            Block block = blockState.getBlock();
            LocalMaterialData material = SpigotMaterialData.ofBlockData(blockState);
            boolean isLiquid = material.isLiquid();
            boolean bl = isSolid = material.isSolid() && (!ignoreLeaves || block != Blocks.ACACIA_LOG && block != Blocks.BIRCH_LOG && block != Blocks.DARK_OAK_LOG && block != Blocks.JUNGLE_LOG && block != Blocks.OAK_LOG && block != Blocks.SPRUCE_LOG && block != Blocks.STRIPPED_ACACIA_LOG && block != Blocks.STRIPPED_BIRCH_LOG && block != Blocks.STRIPPED_DARK_OAK_LOG && block != Blocks.STRIPPED_JUNGLE_LOG && block != Blocks.STRIPPED_OAK_LOG && block != Blocks.STRIPPED_SPRUCE_LOG) || !ignoreLeaves && (block == Blocks.ACACIA_LEAVES || block == Blocks.BIRCH_LEAVES || block == Blocks.DARK_OAK_LEAVES || block == Blocks.JUNGLE_LEAVES || block == Blocks.OAK_LEAVES || block == Blocks.SPRUCE_LEAVES) || !ignoreSnow && block == Blocks.SNOW;
            if (ignoreLiquid && isLiquid) continue;
            if (findSolid && isSolid || findLiquid && isLiquid) {
                return i;
            }
            if ((!findSolid || !isLiquid) && (!findLiquid || !isSolid)) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public int getHeightMapHeight(int x, int z) {
        return this.worldGenRegion.a(HeightMap.Type.WORLD_SURFACE_WG, x, z);
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        IChunkAccess chunk;
        if (y < 0 || y >= 256) {
            return -1;
        }
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunkAccess iChunkAccess = chunk = this.worldGenRegion.isChunkLoaded(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.getChunkAt(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        if (chunk != null && chunk.getChunkStatus().b(ChunkStatus.LIGHT)) {
            return this.worldGenRegion.getLightLevel(new BlockPosition(x, y, z));
        }
        return -1;
    }

    @Override
    public void setBlockDirect(int x, int y, int z, LocalMaterialData material) {
        IBiomeConfig biomeConfig = this.getCachedBiomeProvider().getBiomeConfig(x, z, true);
        if (biomeConfig.getReplaceBlocks() != null) {
            material = material.parseWithBiomeAndHeight(this.getWorldConfig().getBiomeConfigsHaveReplacement(), biomeConfig.getReplaceBlocks(), y);
        }
        this.worldGenRegion.setTypeAndData(new BlockPosition(x, y, z), ((SpigotMaterialData)material).internalBlock(), 3);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material) {
        this.setBlock(x, y, z, material, null, null);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag nbt) {
        this.setBlock(x, y, z, material, nbt, null);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, ReplaceBlockMatrix replaceBlocksMatrix) {
        this.setBlock(x, y, z, material, null, replaceBlocksMatrix);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag nbt, ReplaceBlockMatrix replaceBlocksMatrix) {
        if (y < 0 || y >= 256) {
            return;
        }
        if (material.isEmpty()) {
            return;
        }
        if (this.decorationArea == null || this.decorationArea.isInAreaBeingDecorated(x, z)) {
            if (replaceBlocksMatrix != null) {
                material = material.parseWithBiomeAndHeight(this.getWorldConfig().getBiomeConfigsHaveReplacement(), replaceBlocksMatrix, y);
            }
            BlockPosition pos = new BlockPosition(x, y, z);
            this.worldGenRegion.setTypeAndData(pos, ((SpigotMaterialData)material).internalBlock(), 18);
            if (material.isLiquid()) {
                this.worldGenRegion.getFluidTickList().a(pos, (Object)((SpigotMaterialData)material).internalBlock().getFluid().getType(), 0);
            } else if (material.isMaterial(LocalMaterials.COMMAND_BLOCK)) {
                this.worldGenRegion.getBlockTickList().a(pos, (Object)((SpigotMaterialData)material).internalBlock().getBlock(), 0);
            }
            if (nbt != null) {
                this.attachNBT(x, y, z, nbt, this.worldGenRegion.getType(pos));
            }
        }
    }

    protected void attachNBT(int x, int y, int z, NamedBinaryTag nbt, IBlockData state) {
        NBTTagCompound nms = SpigotNBTHelper.getNMSFromNBTTagCompound(nbt);
        nms.set("x", (NBTBase)NBTTagInt.a((int)x));
        nms.set("y", (NBTBase)NBTTagInt.a((int)y));
        nms.set("z", (NBTBase)NBTTagInt.a((int)z));
        TileEntity tileEntity = this.worldGenRegion.getTileEntity(new BlockPosition(x, y, z));
        if (tileEntity != null) {
            try {
                tileEntity.load(state, nms);
            }
            catch (JsonSyntaxException e2) {
                if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, MessageFormat.format("Badly formatted json for tile entity with id '{0}' at {1},{2},{3}", nms.getString("id"), x, y, z));
                }
            }
        } else if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
            this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, MessageFormat.format("Skipping tile entity with id {0}, cannot be placed at {1},{2},{3}", nms.getString("id"), x, y, z));
        }
    }

    public TileEntity getTileEntity(BlockPosition blockPos) {
        return this.worldGenRegion.getTileEntity(blockPos);
    }

    @Override
    public boolean placeTree(TreeType type, Random rand, int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return false;
        }
        BlockPosition blockPos = new BlockPosition(x, y, z);
        try {
            WorldGenFeatureConfigured tree = null;
            WorldGenFeatureConfigured other = null;
            switch (type) {
                case Acacia: {
                    tree = BiomeDecoratorGroups.ACACIA;
                    break;
                }
                case BigTree: {
                    tree = BiomeDecoratorGroups.FANCY_OAK;
                    break;
                }
                case Forest: 
                case Birch: {
                    tree = BiomeDecoratorGroups.BIRCH;
                    break;
                }
                case JungleTree: {
                    tree = BiomeDecoratorGroups.MEGA_JUNGLE_TREE;
                    break;
                }
                case CocoaTree: {
                    tree = BiomeDecoratorGroups.JUNGLE_TREE;
                    break;
                }
                case DarkOak: {
                    tree = BiomeDecoratorGroups.DARK_OAK;
                    break;
                }
                case GroundBush: {
                    other = BiomeDecoratorGroups.JUNGLE_BUSH;
                    break;
                }
                case HugeMushroom: {
                    if (rand.nextBoolean()) {
                        other = BiomeDecoratorGroups.HUGE_BROWN_MUSHROOM;
                        break;
                    }
                    other = BiomeDecoratorGroups.HUGE_RED_MUSHROOM;
                    break;
                }
                case HugeRedMushroom: {
                    other = BiomeDecoratorGroups.HUGE_RED_MUSHROOM;
                    break;
                }
                case HugeBrownMushroom: {
                    other = BiomeDecoratorGroups.HUGE_BROWN_MUSHROOM;
                    break;
                }
                case SwampTree: {
                    other = BiomeDecoratorGroups.SWAMP_TREE;
                    break;
                }
                case Taiga1: {
                    tree = BiomeDecoratorGroups.PINE;
                    break;
                }
                case Taiga2: {
                    tree = BiomeDecoratorGroups.SPRUCE;
                    break;
                }
                case HugeTaiga1: {
                    tree = BiomeDecoratorGroups.MEGA_PINE;
                    break;
                }
                case HugeTaiga2: {
                    tree = BiomeDecoratorGroups.MEGA_SPRUCE;
                    break;
                }
                case TallBirch: {
                    tree = BiomeDecoratorGroups.SUPER_BIRCH_BEES_0002;
                    break;
                }
                case Tree: {
                    tree = BiomeDecoratorGroups.OAK;
                    break;
                }
                case CrimsonFungi: {
                    WorldGenFeatureConfigured crimsonFungi = BiomeDecoratorGroups.CRIMSON_FUNGI_PLANTED;
                    crimsonFungi.e.generate(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, (WorldGenFeatureConfiguration)WorldGenFeatureHugeFungiConfiguration.c);
                    return true;
                }
                case WarpedFungi: {
                    WorldGenFeatureConfigured warpedFungi = BiomeDecoratorGroups.WARPED_FUNGI_PLANTED;
                    warpedFungi.e.generate(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, (WorldGenFeatureConfiguration)WorldGenFeatureHugeFungiConfiguration.e);
                    return true;
                }
                case ChorusPlant: {
                    WorldGenFeatureConfigured chorus_plant = BiomeDecoratorGroups.CHORUS_PLANT;
                    chorus_plant.e.generate(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, chorus_plant.f);
                    return true;
                }
                default: {
                    throw new RuntimeException("Failed to handle tree of type " + type.toString());
                }
            }
            if (tree != null) {
                tree.e.generate(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, tree.f);
            } else if (other != null) {
                other.e.generate(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, rand, blockPos, other.f);
            } else {
                throw new RuntimeException("Incorrect handling of tree of type " + type.toString());
            }
            return true;
        }
        catch (NullPointerException ex) {
            if (this.logger.getLogCategoryEnabled(LogCategory.DECORATION)) {
                this.logger.log(LogLevel.ERROR, LogCategory.DECORATION, String.format("Treegen caused an error: ", ex.getStackTrace()));
            }
            return true;
        }
    }

    @Override
    public void spawnEntity(IEntityFunction entityData) {
        if (entityData.getY() < 0 || entityData.getY() >= 256) {
            if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Failed to spawn mob for Entity() " + entityData.makeString() + ", y position out of bounds");
            }
            return;
        }
        Entity entity = null;
        Optional type1 = EntityTypes.a((String)entityData.getResourceLocation().toString());
        EntityTypes type2 = null;
        if (!type1.isPresent()) {
            if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not parse mob for Entity() " + entityData.makeString() + ", mob type could not be found.");
            }
            return;
        }
        type2 = (EntityTypes)type1.get();
        NBTTagCompound nbtTagCompound = null;
        if (entityData.getNameTagOrNBTFileName() != null && (entityData.getNameTagOrNBTFileName().toLowerCase().trim().endsWith(".txt") || entityData.getNameTagOrNBTFileName().toLowerCase().trim().endsWith(".nbt"))) {
            nbtTagCompound = new NBTTagCompound();
            if (entityData.getNameTagOrNBTFileName().toLowerCase().trim().endsWith(".txt")) {
                try {
                    nbtTagCompound = JsonToNBT.getTagFromJson(entityData.getMetaData());
                }
                catch (Exception e2) {
                    if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                        this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not parse nbt for Entity() " + entityData.makeString() + ", file: " + entityData.getNameTagOrNBTFileName());
                    }
                    return;
                }
                nbtTagCompound.setString("id", entityData.getResourceLocation());
            } else if (entityData.getNBTTag() != null) {
                nbtTagCompound = SpigotNBTHelper.getNMSFromNBTTagCompound(entityData.getNBTTag());
            }
        }
        if (nbtTagCompound == null) {
            try {
                entity = type2.a((World)this.worldGenRegion.getMinecraftWorld());
            }
            catch (Exception exception) {
                if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not create entity for Entity() " + entityData.makeString() + ", exception: " + exception.getMessage());
                }
                return;
            }
            if (entity == null) {
                if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not create entity for Entity() " + entityData.makeString() + ", MC returned null.");
                }
                return;
            }
            entity.setPositionRotation(entityData.getX(), (double)entityData.getY(), entityData.getZ(), this.getWorldRandom().nextFloat() * 360.0f, 0.0f);
            this.worldGenRegion.addAllEntities(entity);
        } else {
            entity = EntityTypes.a(nbtTagCompound, (World)this.worldGenRegion.getMinecraftWorld(), entity1 -> {
                entity1.setPositionRotation(entityData.getX(), (double)entityData.getY(), entityData.getZ(), this.getWorldRandom().nextFloat() * 360.0f, 0.0f);
                return entity1;
            });
            if (entity == null) {
                if (this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not create entity for Entity() " + entityData.makeString() + ", MC returned null.");
                }
                return;
            }
            this.worldGenRegion.addAllEntities(entity);
        }
        for (int r = 0; r < entityData.getGroupSize(); ++r) {
            if (r != 0) {
                if (nbtTagCompound == null) {
                    try {
                        entity = type2.a((World)this.worldGenRegion.getMinecraftWorld());
                    }
                    catch (Exception exception) {
                        return;
                    }
                    if (entity == null) {
                        return;
                    }
                    entity.setPositionRotation(entityData.getX(), (double)entityData.getY(), entityData.getZ(), this.getWorldRandom().nextFloat() * 360.0f, 0.0f);
                    this.worldGenRegion.addAllEntities(entity);
                } else {
                    entity = EntityTypes.a((NBTTagCompound)nbtTagCompound, (World)this.worldGenRegion.getMinecraftWorld(), entity1 -> {
                        entity1.setPositionRotation(entityData.getX(), (double)entityData.getY(), entityData.getZ(), this.getWorldRandom().nextFloat() * 360.0f, 0.0f);
                        return entity1;
                    });
                    this.worldGenRegion.addAllEntities(entity);
                }
                if (entity == null) {
                    return;
                }
            }
            if (!(entity instanceof EntityInsentient)) continue;
            LocalMaterialData block = SpigotMaterialData.ofBlockData(this.worldGenRegion.getType(new BlockPosition(entityData.getX(), (double)entityData.getY(), entityData.getZ())));
            if (block.isSolid() || (((EntityInsentient)entity).getMonsterType() == EnumMonsterType.WATER_MOB || entity instanceof EntityGuardian) && !block.isLiquid()) {
                if (!this.logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) continue;
                this.logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not spawn entity at " + entityData.getX() + " " + entityData.getY() + " " + entityData.getZ() + " for Entity() " + entityData.makeString() + ", a solid block was found or a water mob tried to spawn outside of water.");
                continue;
            }
            EntityInsentient mobEntity = (EntityInsentient)entity;
            String nameTag = entityData.getNameTagOrNBTFileName();
            if (nameTag != null && !nameTag.toLowerCase().trim().endsWith(".txt") && !nameTag.toLowerCase().trim().endsWith(".nbt")) {
                entity.setCustomName((IChatBaseComponent)new ChatComponentText(nameTag));
            }
            mobEntity.setPersistent();
            GroupDataEntity ilivingentitydata = null;
            ilivingentitydata = mobEntity.prepare((WorldAccess)this.worldGenRegion, this.worldGenRegion.getDamageScaler(new BlockPosition(entityData.getX(), (double)entityData.getY(), entityData.getZ())), EnumMobSpawn.CHUNK_GENERATION, ilivingentitydata, nbtTagCompound);
            this.worldGenRegion.addAllEntities((Entity)mobEntity);
        }
    }

    @Override
    public void placeDungeon(Random random, int x, int y, int z) {
        WorldGenerator.MONSTER_ROOM.b((WorldGenFeatureConfiguration)WorldGenFeatureConfiguration.k).a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, random, new BlockPosition(x, y, z));
    }

    @Override
    public void placeFossil(Random random, int x, int y, int z) {
        WorldGenerator.FOSSIL.b((WorldGenFeatureConfiguration)WorldGenFeatureConfiguration.k).a(this.worldGenRegion, (ChunkGenerator)this.chunkGenerator, random, new BlockPosition(x, y, z));
    }

    @Override
    public boolean isInsideWorldBorder(ChunkCoordinate chunkCoordinate) {
        return true;
    }

    public IBlockData getBlockData(BlockPosition blockpos) {
        return this.worldGenRegion.getType(blockpos);
    }

    public void setBlockState(BlockPosition blockpos, IBlockData blockstate1, int i) {
        this.worldGenRegion.setTypeAndData(blockpos, blockstate1, i);
    }

    @Override
    public LocalMaterialData getMaterialWithoutLoading(int x, int y, int z) {
        if (y >= 256 || y < 0) {
            return null;
        }
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunkAccess chunk = null;
        if (this.decorationArea != null && this.decorationArea.isInAreaBeingDecorated(x, z)) {
            IChunkAccess iChunkAccess = chunk = this.worldGenRegion.isChunkLoaded(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.getChunkAt(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        }
        if (chunk == null || !chunk.getChunkStatus().b(ChunkStatus.LIQUID_CARVERS)) {
            return this.chunkGenerator.getMaterialInUnloadedChunk(this.getWorldRandom(), x, y, z);
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        return SpigotMaterialData.ofBlockData(chunk.getType(new BlockPosition(internalX, y, internalZ)));
    }

    @Override
    public int getHighestBlockYAtWithoutLoading(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow, boolean ignoreLeaves) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        IChunkAccess chunk = null;
        if (this.decorationArea != null && this.decorationArea.isInAreaBeingDecorated(x, z)) {
            IChunkAccess iChunkAccess = chunk = this.worldGenRegion.isChunkLoaded(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) ? this.worldGenRegion.getChunkAt(chunkCoord.getChunkX(), chunkCoord.getChunkZ()) : null;
        }
        if (chunk == null || !chunk.getChunkStatus().b(ChunkStatus.LIQUID_CARVERS)) {
            return this.chunkGenerator.getHighestBlockYInUnloadedChunk(this.getWorldRandom(), x, z, findSolid, findLiquid, ignoreLiquid, ignoreSnow);
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        int heightMapY = chunk.getHighestBlock(HeightMap.Type.WORLD_SURFACE_WG, internalX, internalZ);
        return this.getHighestBlockYAt(chunk, internalX, heightMapY, internalZ, findSolid, findLiquid, ignoreLiquid, ignoreSnow, ignoreLeaves);
    }

    @Override
    public boolean chunkHasDefaultStructure(Random worldRandom, ChunkCoordinate chunkCoordinate) {
        Boolean hasDefaultStructure = (Boolean)this.cachedHasDefaultStructureChunks.get(chunkCoordinate);
        if (hasDefaultStructure != null) {
            return hasDefaultStructure;
        }
        hasDefaultStructure = this.chunkGenerator.checkHasVanillaStructureWithoutLoading(this.worldGenRegion.getMinecraftWorld(), chunkCoordinate);
        this.cachedHasDefaultStructureChunks.put(chunkCoordinate, hasDefaultStructure);
        return hasDefaultStructure;
    }
}

