/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.materials;

import com.pg85.otg.OTG;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.minecraft.BlockNames;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockAnvil;
import net.minecraft.server.v1_16_R3.BlockBanner;
import net.minecraft.server.v1_16_R3.BlockBannerWall;
import net.minecraft.server.v1_16_R3.BlockBed;
import net.minecraft.server.v1_16_R3.BlockBeetroot;
import net.minecraft.server.v1_16_R3.BlockBrewingStand;
import net.minecraft.server.v1_16_R3.BlockCactus;
import net.minecraft.server.v1_16_R3.BlockCake;
import net.minecraft.server.v1_16_R3.BlockCarrots;
import net.minecraft.server.v1_16_R3.BlockCauldron;
import net.minecraft.server.v1_16_R3.BlockChest;
import net.minecraft.server.v1_16_R3.BlockChestTrapped;
import net.minecraft.server.v1_16_R3.BlockCocoa;
import net.minecraft.server.v1_16_R3.BlockCrops;
import net.minecraft.server.v1_16_R3.BlockDaylightDetector;
import net.minecraft.server.v1_16_R3.BlockDispenser;
import net.minecraft.server.v1_16_R3.BlockDoor;
import net.minecraft.server.v1_16_R3.BlockDropper;
import net.minecraft.server.v1_16_R3.BlockEndRod;
import net.minecraft.server.v1_16_R3.BlockEnderChest;
import net.minecraft.server.v1_16_R3.BlockEnderPortalFrame;
import net.minecraft.server.v1_16_R3.BlockFenceGate;
import net.minecraft.server.v1_16_R3.BlockFire;
import net.minecraft.server.v1_16_R3.BlockFloorSign;
import net.minecraft.server.v1_16_R3.BlockFurnace;
import net.minecraft.server.v1_16_R3.BlockGlazedTerracotta;
import net.minecraft.server.v1_16_R3.BlockHay;
import net.minecraft.server.v1_16_R3.BlockHopper;
import net.minecraft.server.v1_16_R3.BlockHugeMushroom;
import net.minecraft.server.v1_16_R3.BlockJukeBox;
import net.minecraft.server.v1_16_R3.BlockLadder;
import net.minecraft.server.v1_16_R3.BlockLeaves;
import net.minecraft.server.v1_16_R3.BlockLever;
import net.minecraft.server.v1_16_R3.BlockMinecartDetector;
import net.minecraft.server.v1_16_R3.BlockMinecartTrack;
import net.minecraft.server.v1_16_R3.BlockNetherWart;
import net.minecraft.server.v1_16_R3.BlockObserver;
import net.minecraft.server.v1_16_R3.BlockPiston;
import net.minecraft.server.v1_16_R3.BlockPistonExtension;
import net.minecraft.server.v1_16_R3.BlockPortal;
import net.minecraft.server.v1_16_R3.BlockPotatoes;
import net.minecraft.server.v1_16_R3.BlockPoweredRail;
import net.minecraft.server.v1_16_R3.BlockPressurePlateBinary;
import net.minecraft.server.v1_16_R3.BlockPressurePlateWeighted;
import net.minecraft.server.v1_16_R3.BlockPropertyAttachPosition;
import net.minecraft.server.v1_16_R3.BlockPropertyBedPart;
import net.minecraft.server.v1_16_R3.BlockPropertyComparatorMode;
import net.minecraft.server.v1_16_R3.BlockPropertyDoorHinge;
import net.minecraft.server.v1_16_R3.BlockPropertyDoubleBlockHalf;
import net.minecraft.server.v1_16_R3.BlockPropertyHalf;
import net.minecraft.server.v1_16_R3.BlockPropertyPistonType;
import net.minecraft.server.v1_16_R3.BlockPropertySlabType;
import net.minecraft.server.v1_16_R3.BlockPropertyStructureMode;
import net.minecraft.server.v1_16_R3.BlockPropertyTrackPosition;
import net.minecraft.server.v1_16_R3.BlockPumpkinCarved;
import net.minecraft.server.v1_16_R3.BlockRedstoneComparator;
import net.minecraft.server.v1_16_R3.BlockRedstoneLamp;
import net.minecraft.server.v1_16_R3.BlockRedstoneTorchWall;
import net.minecraft.server.v1_16_R3.BlockRedstoneWire;
import net.minecraft.server.v1_16_R3.BlockReed;
import net.minecraft.server.v1_16_R3.BlockRepeater;
import net.minecraft.server.v1_16_R3.BlockRotatable;
import net.minecraft.server.v1_16_R3.BlockShulkerBox;
import net.minecraft.server.v1_16_R3.BlockSkull;
import net.minecraft.server.v1_16_R3.BlockSnow;
import net.minecraft.server.v1_16_R3.BlockSoil;
import net.minecraft.server.v1_16_R3.BlockStairs;
import net.minecraft.server.v1_16_R3.BlockStem;
import net.minecraft.server.v1_16_R3.BlockStepAbstract;
import net.minecraft.server.v1_16_R3.BlockStoneButton;
import net.minecraft.server.v1_16_R3.BlockStructure;
import net.minecraft.server.v1_16_R3.BlockTorchWall;
import net.minecraft.server.v1_16_R3.BlockTrapdoor;
import net.minecraft.server.v1_16_R3.BlockTripwire;
import net.minecraft.server.v1_16_R3.BlockTripwireHook;
import net.minecraft.server.v1_16_R3.BlockVine;
import net.minecraft.server.v1_16_R3.BlockWallSign;
import net.minecraft.server.v1_16_R3.BlockWoodButton;
import net.minecraft.server.v1_16_R3.Blocks;
import net.minecraft.server.v1_16_R3.DataConverterFlatten;
import net.minecraft.server.v1_16_R3.EnumDirection;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IBlockState;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.MinecraftKey;

public class SpigotLegacyMaterials {
    static IBlockData fromLegacyBlockName(String oldBlockName) {
        if (oldBlockName.matches("minecraft:[A-Za-z]+:[0-9]+")) {
            int stateId = Integer.parseInt(oldBlockName.split(":")[2]);
            return SpigotLegacyMaterials.fromLegacyBlockNameOrIdWithData(oldBlockName.split(":")[1], stateId);
        }
        switch (oldBlockName) {
            case "stationary_water": 
            case "flowing_water": {
                return Blocks.WATER.getBlockData();
            }
            case "stationary_lava": 
            case "flowing_lava": {
                return Blocks.LAVA.getBlockData();
            }
            case "stained_clay": {
                return Blocks.WHITE_TERRACOTTA.getBlockData();
            }
            case "hard_clay": {
                return Blocks.TERRACOTTA.getBlockData();
            }
            case "step": {
                return Blocks.SMOOTH_STONE_SLAB.getBlockData();
            }
            case "sugar_cane_block": {
                return Blocks.SUGAR_CANE.getBlockData();
            }
            case "melon_block": {
                return Blocks.MELON.getBlockData();
            }
            case "water_lily": {
                return Blocks.LILY_PAD.getBlockData();
            }
            case "soil": {
                return Blocks.FARMLAND.getBlockData();
            }
            case "grass": {
                return Blocks.GRASS_BLOCK.getBlockData();
            }
            case "long_grass": {
                return Blocks.TALL_GRASS.getBlockData();
            }
            case "mycel": {
                return Blocks.MYCELIUM.getBlockData();
            }
            case "snow_layer": {
                return Blocks.SNOW.getBlockData();
            }
            case "leaves": {
                return (IBlockData)Blocks.OAK_LEAVES.getBlockData().set((IBlockState)BlockLeaves.DISTANCE, (Comparable)Integer.valueOf(1));
            }
            case "leaves_2": {
                return (IBlockData)Blocks.ACACIA_LEAVES.getBlockData().set((IBlockState)BlockLeaves.DISTANCE, (Comparable)Integer.valueOf(1));
            }
            case "red_rose": {
                return Blocks.POPPY.getBlockData();
            }
            case "double_plant": {
                return Blocks.SUNFLOWER.getBlockData();
            }
            case "wood_stairs": 
            case "oak_stairs": {
                return (IBlockData)Blocks.OAK_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "birch_wood_stairs": 
            case "birch_stairs": {
                return (IBlockData)Blocks.BIRCH_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "spruce_wood_stairs": 
            case "spruce_stairs": {
                return (IBlockData)Blocks.SPRUCE_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "jungle_wood_stairs": 
            case "jungle_stairs": {
                return (IBlockData)Blocks.JUNGLE_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "cobblestone_stairs": 
            case "stone_stairs": {
                return (IBlockData)Blocks.COBBLESTONE_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "stone_brick_stairs": 
            case "smooth_stairs": {
                return (IBlockData)Blocks.STONE_BRICK_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "brick_stairs": {
                return (IBlockData)Blocks.BRICK_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "nether_brick_stairs": {
                return (IBlockData)Blocks.NETHER_BRICK_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "sandstone_stairs": {
                return (IBlockData)Blocks.SANDSTONE_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "quartz_stairs": {
                return (IBlockData)Blocks.QUARTZ_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "acacia_stairs": {
                return (IBlockData)Blocks.ACACIA_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "dark_oak_stairs": {
                return (IBlockData)Blocks.DARK_OAK_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "red_sandstone_stairs": {
                return (IBlockData)Blocks.RED_SANDSTONE_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "purpur_stairs": {
                return (IBlockData)Blocks.PURPUR_STAIRS.getBlockData().set((IBlockState)BlockStairs.FACING, (Comparable)EnumDirection.EAST);
            }
            case "wooden_button": 
            case "wood_button": {
                return (IBlockData)Blocks.OAK_BUTTON.getBlockData().set((IBlockState)BlockWoodButton.FACING, (Comparable)EnumDirection.NORTH);
            }
            case "waterlily": {
                return Blocks.LILY_PAD.getBlockData();
            }
            case "quartz_ore": {
                return Blocks.NETHER_QUARTZ_ORE.getBlockData();
            }
            case "yellow_flower": {
                return Blocks.DANDELION.getBlockData();
            }
            case "web": {
                return Blocks.COBWEB.getBlockData();
            }
            case "standing_banner": {
                return Blocks.WHITE_BANNER.getBlockData();
            }
            case "wall_banner": {
                return Blocks.WHITE_WALL_BANNER.getBlockData();
            }
            case "redstone_lamp_on": {
                return (IBlockData)Blocks.REDSTONE_LAMP.getBlockData().set((IBlockState)BlockRedstoneLamp.a, (Comparable)Boolean.valueOf(true));
            }
            case "redstone_lamp_off": {
                return (IBlockData)Blocks.REDSTONE_LAMP.getBlockData().set((IBlockState)BlockRedstoneLamp.a, (Comparable)Boolean.valueOf(false));
            }
            case "wool": {
                return Blocks.WHITE_WOOL.getBlockData();
            }
            case "log": 
            case "wood": {
                return Blocks.OAK_LOG.getBlockData();
            }
            case "log_2": {
                return Blocks.ACACIA_LOG.getBlockData();
            }
            case "magma": {
                return Blocks.MAGMA_BLOCK.getBlockData();
            }
            case "tallgrass": {
                return Blocks.GRASS.getBlockData();
            }
            case "cobble_wall": {
                return Blocks.COBBLESTONE_WALL.getBlockData();
            }
            case "iron_fence": {
                return Blocks.IRON_BARS.getBlockData();
            }
            case "workbench": {
                return Blocks.CRAFTING_TABLE.getBlockData();
            }
            case "enchantment_table": {
                return Blocks.ENCHANTING_TABLE.getBlockData();
            }
            case "mob_spawner": {
                return Blocks.INFESTED_STONE.getBlockData();
            }
            case "double_step": {
                return (IBlockData)((Block)IRegistry.BLOCK.get(new MinecraftKey("minecraft:smooth_stone_slab"))).getBlockData().set((IBlockState)BlockStepAbstract.a, (Comparable)BlockPropertySlabType.DOUBLE);
            }
            case "smooth_brick": {
                return Blocks.STONE_BRICKS.getBlockData();
            }
            case "rails": {
                return Blocks.RAIL.getBlockData();
            }
            case "fence": {
                return Blocks.OAK_FENCE.getBlockData();
            }
            case "nether_fence": {
                return Blocks.NETHER_BRICK_FENCE.getBlockData();
            }
            case "wood_step": {
                return Blocks.OAK_SLAB.getBlockData();
            }
            case "thin_glass": {
                return Blocks.GLASS_PANE.getBlockData();
            }
            case "stained_glass_pane": {
                return Blocks.WHITE_STAINED_GLASS_PANE.getBlockData();
            }
            case "stone_plate": {
                return Blocks.STONE_PRESSURE_PLATE.getBlockData();
            }
            case "wood_plate": {
                return Blocks.OAK_PRESSURE_PLATE.getBlockData();
            }
            case "wood_double_step": {
                return (IBlockData)Blocks.OAK_SLAB.getBlockData().set((IBlockState)BlockStepAbstract.a, (Comparable)BlockPropertySlabType.DOUBLE);
            }
            case "brick": {
                return Blocks.BRICKS.getBlockData();
            }
            case "iron_door_block": {
                return Blocks.IRON_DOOR.getBlockData();
            }
            case "carpet": {
                return Blocks.WHITE_CARPET.getBlockData();
            }
            case "carrot": {
                return Blocks.CARROTS.getBlockData();
            }
            case "skull": {
                return Blocks.SKELETON_SKULL.getBlockData();
            }
            case "nether_wart": {
                return Blocks.NETHER_WART.getBlockData();
            }
            case "nether_wart_block": {
                return Blocks.NETHER_WART_BLOCK.getBlockData();
            }
            case "nether_brick": {
                return Blocks.NETHER_BRICKS.getBlockData();
            }
            case "red_nether_brick": {
                return Blocks.RED_NETHER_BRICKS.getBlockData();
            }
            case "end_bricks": 
            case "ender_bricks": {
                return Blocks.END_STONE_BRICKS.getBlockData();
            }
            case "end_stone": 
            case "ender_stone": {
                return Blocks.END_STONE.getBlockData();
            }
            case "mcpitman": {
                return Blocks.CREEPER_HEAD.getBlockData();
            }
            case "pg85": {
                return Blocks.SHROOMLIGHT.getBlockData();
            }
            case "supercoder": {
                return Blocks.CAKE.getBlockData();
            }
            case "authvin": {
                return Blocks.WET_SPONGE.getBlockData();
            }
            case "josh": {
                return Blocks.BARREL.getBlockData();
            }
            case "wahrheit": {
                return Blocks.LECTERN.getBlockData();
            }
            case "lordsmellypants": {
                return Blocks.FLOWER_POT.getBlockData();
            }
            case "frank": {
                return Blocks.JUKEBOX.getBlockData();
            }
        }
        return null;
    }

    static IBlockData fromLegacyBlockNameOrIdWithData(String blockName, int data) {
        block465: {
            if (blockName == null || blockName.trim().isEmpty()) {
                return null;
            }
            try {
                int blockId = Integer.parseInt(blockName);
                blockName = BlockNames.blockNameFromLegacyBlockId(blockId);
                if (blockName == null) {
                    return null;
                }
            }
            catch (NumberFormatException blockId) {
                // empty catch block
            }
            try {
                switch (blockName) {
                    case "grass": {
                        if (data == 0) {
                            return Blocks.GRASS_BLOCK.getBlockData();
                        }
                    }
                    case "banner": 
                    case "white_banner": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:banner", data))).getBlockData();
                    }
                    case "bed": 
                    case "white_bed": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:bed", data))).getBlockData();
                    }
                    case "carpet": 
                    case "white_carpet": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:carpet", data))).getBlockData();
                    }
                    case "cobblestone_wall": 
                    case "cobble_wall": {
                        switch (data) {
                            default: {
                                return Blocks.COBBLESTONE_WALL.getBlockData();
                            }
                            case 1: 
                        }
                        return Blocks.MOSSY_COBBLESTONE_WALL.getBlockData();
                    }
                    case "concrete": 
                    case "white_concrete": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:concrete", data))).getBlockData();
                    }
                    case "concrete_powder": 
                    case "white_concrete_powder": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:concrete_powder", data))).getBlockData();
                    }
                    case "dirt": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:dirt", data))).getBlockData();
                    }
                    case "double_plant": 
                    case "sunflower": 
                    case "rose_bush": 
                    case "tall_grass": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:double_plant", data))).getBlockData();
                    }
                    case "double_stone_slab": 
                    case "smooth_stone": {
                        return (IBlockData)((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:stone_slab", data))).getBlockData().set((IBlockState)BlockStepAbstract.a, (Comparable)BlockPropertySlabType.DOUBLE);
                    }
                    case "double_wooden_slab": 
                    case "wood_double_step": {
                        return (IBlockData)((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:wooden_slab", data))).getBlockData().set((IBlockState)BlockStepAbstract.a, (Comparable)BlockPropertySlabType.DOUBLE);
                    }
                    case "leaves": 
                    case "oak_leaves": {
                        return (IBlockData)((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:leaves", data % 4))).getBlockData().set((IBlockState)BlockLeaves.DISTANCE, (Comparable)Integer.valueOf(1));
                    }
                    case "leaves2": 
                    case "leaves_2": 
                    case "acacia_leaves": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:leaves2", data % 4))).getBlockData();
                    }
                    case "monster_egg": 
                    case "monster_eggs": 
                    case "infested_stone": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:monster_egg", data))).getBlockData();
                    }
                    case "planks": 
                    case "wood": 
                    case "oak_planks": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:planks", data))).getBlockData();
                    }
                    case "prismarine": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:prismarine", data))).getBlockData();
                    }
                    case "purpur_slab": {
                        return (IBlockData)Blocks.PURPUR_SLAB.getBlockData().set((IBlockState)BlockStepAbstract.a, (Comparable)(data == 0 ? BlockPropertySlabType.BOTTOM : (data == 8 ? BlockPropertySlabType.TOP : BlockPropertySlabType.BOTTOM)));
                    }
                    case "purpur_double_slab": {
                        return (IBlockData)Blocks.PURPUR_SLAB.getBlockData().set((IBlockState)BlockStepAbstract.a, (Comparable)BlockPropertySlabType.DOUBLE);
                    }
                    case "red_flower": 
                    case "red_rose": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:red_flower", data))).getBlockData();
                    }
                    case "red_sandstone": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:red_sandstone", data))).getBlockData();
                    }
                    case "red_sandstone_slab": 
                    case "stone_slab2": {
                        switch (data) {
                            default: {
                                return (IBlockData)Blocks.RED_SANDSTONE_SLAB.getBlockData().set((IBlockState)BlockStepAbstract.a, (Comparable)BlockPropertySlabType.BOTTOM);
                            }
                            case 8: 
                        }
                        return (IBlockData)Blocks.RED_SANDSTONE_SLAB.getBlockData().set((IBlockState)BlockStepAbstract.a, (Comparable)BlockPropertySlabType.TOP);
                    }
                    case "double_red_sandstone_slab": 
                    case "double_stone_slab2": {
                        return (IBlockData)Blocks.RED_SANDSTONE_SLAB.getBlockData().set((IBlockState)BlockStepAbstract.a, (Comparable)BlockPropertySlabType.DOUBLE);
                    }
                    case "sand": {
                        switch (data) {
                            default: {
                                return Blocks.SAND.getBlockData();
                            }
                            case 1: 
                        }
                        return Blocks.RED_SAND.getBlockData();
                    }
                    case "sandstone": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:sandstone", data))).getBlockData();
                    }
                    case "sapling": 
                    case "oak_sapling": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:sapling", data))).getBlockData();
                    }
                    case "skull": 
                    case "skeleton_skull": {
                        return (IBlockData)Blocks.SKELETON_SKULL.getBlockData().set((IBlockState)BlockSkull.a, (Comparable)Integer.valueOf(data));
                    }
                    case "sponge": {
                        switch (data) {
                            default: {
                                return Blocks.SPONGE.getBlockData();
                            }
                            case 1: 
                        }
                        return Blocks.WET_SPONGE.getBlockData();
                    }
                    case "stained_glass": 
                    case "white_stained_glass": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:stained_glass", data))).getBlockData();
                    }
                    case "stained_glass_pane": 
                    case "white_stained_glass_pane": 
                    case "thin_glass": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:stained_glass_pane", data))).getBlockData();
                    }
                    case "stained_hardened_clay": 
                    case "stained_clay": 
                    case "white_terracotta": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:stained_hardened_clay", data))).getBlockData();
                    }
                    case "stone": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:stone", data))).getBlockData();
                    }
                    case "stone_slab": 
                    case "step": {
                        return (IBlockData)((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:stone_slab", data % 8))).getBlockData().set((IBlockState)BlockStepAbstract.a, (Comparable)(data >= 8 ? BlockPropertySlabType.TOP : BlockPropertySlabType.BOTTOM));
                    }
                    case "double_step": {
                        return (IBlockData)((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:stone_slab", data % 8))).getBlockData().set((IBlockState)BlockStepAbstract.a, (Comparable)BlockPropertySlabType.DOUBLE);
                    }
                    case "stonebrick": 
                    case "stone_bricks": 
                    case "smooth_brick": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:stonebrick", data))).getBlockData();
                    }
                    case "tallgrass": 
                    case "long_grass": {
                        switch (data) {
                            default: {
                                return Blocks.GRASS.getBlockData();
                            }
                            case 2: 
                        }
                        return Blocks.FERN.getBlockData();
                    }
                    case "wooden_slab": 
                    case "wood_step": 
                    case "oak_slab": {
                        return (IBlockData)((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:wooden_slab", data % 8))).getBlockData().set((IBlockState)BlockStepAbstract.a, (Comparable)(data >= 8 ? BlockPropertySlabType.TOP : BlockPropertySlabType.BOTTOM));
                    }
                    case "wool": 
                    case "white_wool": {
                        return ((Block)IRegistry.BLOCK.get(SpigotLegacyMaterials.getFlatKey("minecraft:wool", data))).getBlockData();
                    }
                    case "fire": {
                        return (IBlockData)Blocks.FIRE.getBlockData().set((IBlockState)BlockFire.AGE, (Comparable)Integer.valueOf(data));
                    }
                    case "cake": 
                    case "cake_block": {
                        return (IBlockData)Blocks.CAKE.getBlockData().set((IBlockState)BlockCake.BITES, (Comparable)Integer.valueOf(data));
                    }
                    case "stone_pressure_plate": 
                    case "stone_plate": {
                        return (IBlockData)Blocks.STONE_PRESSURE_PLATE.getBlockData().set((IBlockState)BlockPressurePlateBinary.POWERED, (Comparable)Boolean.valueOf(SpigotLegacyMaterials.getBit(data, 0) == 1));
                    }
                    case "wooden_pressure_plate": 
                    case "wood_plate": 
                    case "oak_pressure_plate": {
                        return (IBlockData)Blocks.OAK_PRESSURE_PLATE.getBlockData().set((IBlockState)BlockPressurePlateBinary.POWERED, (Comparable)Boolean.valueOf(SpigotLegacyMaterials.getBit(data, 0) == 1));
                    }
                    case "light_weighted_pressure_plate": 
                    case "gold_plate": {
                        return (IBlockData)Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE.getBlockData().set((IBlockState)BlockPressurePlateWeighted.POWER, (Comparable)Integer.valueOf(data));
                    }
                    case "heavy_weighted_pressure_plate": 
                    case "iron_plate": {
                        return (IBlockData)Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE.getBlockData().set((IBlockState)BlockPressurePlateWeighted.POWER, (Comparable)Integer.valueOf(data));
                    }
                    case "snow_layer": {
                        return (IBlockData)Blocks.SNOW.getBlockData().set((IBlockState)BlockSnow.LAYERS, (Comparable)Integer.valueOf(data));
                    }
                    case "cactus": {
                        return (IBlockData)Blocks.CACTUS.getBlockData().set((IBlockState)BlockCactus.AGE, (Comparable)Integer.valueOf(data));
                    }
                    case "reeds": {
                        return (IBlockData)Blocks.SUGAR_CANE.getBlockData().set((IBlockState)BlockReed.AGE, (Comparable)Integer.valueOf(data));
                    }
                    case "jukebox": {
                        return (IBlockData)Blocks.JUKEBOX.getBlockData().set((IBlockState)BlockJukeBox.HAS_RECORD, (Comparable)Boolean.valueOf(data == 1));
                    }
                    case "wheat": 
                    case "crops": {
                        return (IBlockData)Blocks.WHEAT.getBlockData().set((IBlockState)BlockCrops.AGE, (Comparable)Integer.valueOf(data));
                    }
                    case "carrot": 
                    case "carrots": {
                        return (IBlockData)Blocks.CARROTS.getBlockData().set((IBlockState)BlockCarrots.AGE, (Comparable)Integer.valueOf(data));
                    }
                    case "potato": 
                    case "potatoes": {
                        return (IBlockData)Blocks.POTATOES.getBlockData().set((IBlockState)BlockPotatoes.AGE, (Comparable)Integer.valueOf(data));
                    }
                    case "beetroot": 
                    case "beetroots": {
                        return (IBlockData)Blocks.BEETROOTS.getBlockData().set((IBlockState)BlockBeetroot.AGE, (Comparable)Integer.valueOf(data));
                    }
                    case "farmland": 
                    case "soil": {
                        return (IBlockData)Blocks.FARMLAND.getBlockData().set((IBlockState)BlockSoil.MOISTURE, (Comparable)Integer.valueOf(data));
                    }
                    case "anvil": {
                        return SpigotLegacyMaterials.getAnvilWithData(0, data);
                    }
                    case "log": 
                    case "oak_log": {
                        return SpigotLegacyMaterials.getLogWithData(data);
                    }
                    case "log_2": 
                    case "acacia_log": {
                        return SpigotLegacyMaterials.getLog2WithData(data);
                    }
                    case "quartz_block": {
                        return SpigotLegacyMaterials.getQuartzBlockWithData(data);
                    }
                    case "torch": {
                        return SpigotLegacyMaterials.getTorchWithData(0, data);
                    }
                    case "redstone_torch_off": 
                    case "redstone_torch": {
                        return SpigotLegacyMaterials.getTorchWithData(1, data);
                    }
                    case "redstone_torch_on": {
                        return SpigotLegacyMaterials.getTorchWithData(2, data);
                    }
                    case "rails": {
                        return (IBlockData)Blocks.RAIL.getBlockData().set((IBlockState)BlockMinecartTrack.SHAPE, (Comparable)SpigotLegacyMaterials.getRailShape(data));
                    }
                    case "powered_rail": 
                    case "golden_rail": {
                        return SpigotLegacyMaterials.getRailsWithData(0, data);
                    }
                    case "detector_rail": {
                        return SpigotLegacyMaterials.getRailsWithData(1, data);
                    }
                    case "activator_rail": {
                        return SpigotLegacyMaterials.getRailsWithData(2, data);
                    }
                    case "hay_block": {
                        return (IBlockData)Blocks.HAY_BLOCK.getBlockData().set((IBlockState)BlockHay.AXIS, (Comparable)SpigotLegacyMaterials.getPillarAxisXYZ(data));
                    }
                    case "bone_block": {
                        return (IBlockData)Blocks.BONE_BLOCK.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)SpigotLegacyMaterials.getAxisXYZ(data));
                    }
                    case "wood_stairs": 
                    case "oak_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(0, data);
                    }
                    case "birch_wood_stairs": 
                    case "birch_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(1, data);
                    }
                    case "spruce_wood_stairs": 
                    case "spruce_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(2, data);
                    }
                    case "jungle_wood_stairs": 
                    case "jungle_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(3, data);
                    }
                    case "cobblestone_stairs": 
                    case "stone_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(4, data);
                    }
                    case "brick_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(5, data);
                    }
                    case "nether_brick_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(7, data);
                    }
                    case "sandstone_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(8, data);
                    }
                    case "quartz_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(9, data);
                    }
                    case "acacia_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(10, data);
                    }
                    case "dark_oak_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(11, data);
                    }
                    case "red_sandstone_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(12, data);
                    }
                    case "purpur_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(13, data);
                    }
                    case "stone_brick_stairs": 
                    case "smooth_stairs": {
                        return SpigotLegacyMaterials.getStairsWithData(14, data);
                    }
                    case "lever": {
                        return SpigotLegacyMaterials.getLeverOrButtonWithData(0, data);
                    }
                    case "stone_button": {
                        return SpigotLegacyMaterials.getLeverOrButtonWithData(1, data);
                    }
                    case "wood_button": 
                    case "wooden_button": {
                        return SpigotLegacyMaterials.getLeverOrButtonWithData(2, data);
                    }
                    case "wooden_door": 
                    case "oak_door": {
                        return SpigotLegacyMaterials.getDoorWithData(0, data);
                    }
                    case "iron_door_block": 
                    case "iron_door": {
                        return SpigotLegacyMaterials.getDoorWithData(1, data);
                    }
                    case "spruce_door": {
                        return SpigotLegacyMaterials.getDoorWithData(2, data);
                    }
                    case "birch_door": {
                        return SpigotLegacyMaterials.getDoorWithData(3, data);
                    }
                    case "jungle_door": {
                        return SpigotLegacyMaterials.getDoorWithData(4, data);
                    }
                    case "acacia_door": {
                        return SpigotLegacyMaterials.getDoorWithData(5, data);
                    }
                    case "dark_oak_door": {
                        return SpigotLegacyMaterials.getDoorWithData(6, data);
                    }
                    case "oak_sign": 
                    case "sign_post": 
                    case "sign": {
                        return SpigotLegacyMaterials.getSignPostWithData(data);
                    }
                    case "standing_banner": {
                        return (IBlockData)Blocks.RED_BANNER.getBlockData().set((IBlockState)BlockBanner.ROTATION, (Comparable)Integer.valueOf(data));
                    }
                    case "wall_banner": {
                        return (IBlockData)Blocks.WHITE_WALL_BANNER.getBlockData().set((IBlockState)BlockBannerWall.a, (Comparable)SpigotLegacyMaterials.getFacingNorthSouthWestEast(data));
                    }
                    case "end_rod": {
                        return (IBlockData)Blocks.END_ROD.getBlockData().set((IBlockState)BlockEndRod.FACING, (Comparable)SpigotLegacyMaterials.getFacingDownUpNorthSouthWestEast(data));
                    }
                    case "daylight_detector": {
                        return (IBlockData)Blocks.DAYLIGHT_DETECTOR.getBlockData().set((IBlockState)BlockDaylightDetector.POWER, (Comparable)Integer.valueOf(data));
                    }
                    case "command": 
                    case "command_block": {
                        return SpigotLegacyMaterials.getCommandBlockWithData(0, data);
                    }
                    case "command_repeating": 
                    case "repeating_command_block": {
                        return SpigotLegacyMaterials.getCommandBlockWithData(1, data);
                    }
                    case "command_chain": 
                    case "chain_command_block": {
                        return SpigotLegacyMaterials.getCommandBlockWithData(2, data);
                    }
                    case "white_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(0, data);
                    }
                    case "orange_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(1, data);
                    }
                    case "magenta_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(2, data);
                    }
                    case "light_blue_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(3, data);
                    }
                    case "yellow_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(4, data);
                    }
                    case "lime_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(5, data);
                    }
                    case "pink_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(6, data);
                    }
                    case "gray_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(7, data);
                    }
                    case "light_gray_shulker_box": 
                    case "silver_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(8, data);
                    }
                    case "cyan_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(9, data);
                    }
                    case "purple_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(10, data);
                    }
                    case "blue_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(11, data);
                    }
                    case "brown_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(12, data);
                    }
                    case "green_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(13, data);
                    }
                    case "red_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(14, data);
                    }
                    case "black_shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(15, data);
                    }
                    case "shulker_box": {
                        return SpigotLegacyMaterials.getShulkerBoxWithData(16, data);
                    }
                    case "ladder": {
                        return SpigotLegacyMaterials.getLadderChestOrFurnaceWithData(0, data);
                    }
                    case "chest": {
                        return SpigotLegacyMaterials.getLadderChestOrFurnaceWithData(1, data);
                    }
                    case "ender_chest": {
                        return SpigotLegacyMaterials.getLadderChestOrFurnaceWithData(2, data);
                    }
                    case "trapped_chest": {
                        return SpigotLegacyMaterials.getLadderChestOrFurnaceWithData(3, data);
                    }
                    case "furnace": {
                        return SpigotLegacyMaterials.getLadderChestOrFurnaceWithData(4, data);
                    }
                    case "burning_furnace": {
                        return SpigotLegacyMaterials.getLadderChestOrFurnaceWithData(5, data);
                    }
                    case "wall_sign": 
                    case "oak_wall_sign": {
                        return SpigotLegacyMaterials.getWallSignWithData(data);
                    }
                    case "observer": {
                        return SpigotLegacyMaterials.getObserverWithData(data);
                    }
                    case "dispenser": {
                        return SpigotLegacyMaterials.getDispenserHopperDropperWithData(0, data);
                    }
                    case "dropper": {
                        return SpigotLegacyMaterials.getDispenserHopperDropperWithData(1, data);
                    }
                    case "hopper": {
                        return SpigotLegacyMaterials.getDispenserHopperDropperWithData(2, data);
                    }
                    case "pumpkin_stem": {
                        return (IBlockData)Blocks.PUMPKIN_STEM.getBlockData().set((IBlockState)BlockStem.AGE, (Comparable)Integer.valueOf(data));
                    }
                    case "melon_stem": {
                        return (IBlockData)Blocks.MELON_STEM.getBlockData().set((IBlockState)BlockStem.AGE, (Comparable)Integer.valueOf(data));
                    }
                    case "carved_pumpkin": 
                    case "pumpkin": {
                        return SpigotLegacyMaterials.getJackOLanternOrPumpkinWithData(0, data);
                    }
                    case "jack_o_lantern": 
                    case "lit_pumpkin": {
                        return SpigotLegacyMaterials.getJackOLanternOrPumpkinWithData(1, data);
                    }
                    case "diode_block_off": 
                    case "repeater": 
                    case "unpowered_repeater": {
                        return SpigotLegacyMaterials.getRepeaterWithData(0, data);
                    }
                    case "diode_block_on": 
                    case "powered_repeater": {
                        return SpigotLegacyMaterials.getRepeaterWithData(1, data);
                    }
                    case "redstone": 
                    case "redstone_wire": {
                        return (IBlockData)Blocks.REDSTONE_WIRE.getBlockData().set((IBlockState)BlockRedstoneWire.POWER, (Comparable)Integer.valueOf(data));
                    }
                    case "redstone_comparator_off": 
                    case "comparator": {
                        return SpigotLegacyMaterials.getComparatorWithData(0, data);
                    }
                    case "redstone_comparator_on": {
                        return SpigotLegacyMaterials.getComparatorWithData(1, data);
                    }
                    case "bed_block": {
                        return SpigotLegacyMaterials.getBedBlockWithData(data);
                    }
                    case "trap_door": 
                    case "trapdoor": 
                    case "oak_trapdoor": {
                        return SpigotLegacyMaterials.getTrapDoorBlockWithData(0, data);
                    }
                    case "iron_trapdoor": {
                        return SpigotLegacyMaterials.getTrapDoorBlockWithData(1, data);
                    }
                    case "piston_base": 
                    case "piston": {
                        return SpigotLegacyMaterials.getPistonWithData(0, data);
                    }
                    case "piston_sticky_base": 
                    case "sticky_piston": {
                        return SpigotLegacyMaterials.getPistonWithData(1, data);
                    }
                    case "piston_extension": 
                    case "piston_head": {
                        return SpigotLegacyMaterials.getPistonHeadWithData(data);
                    }
                    case "huge_mushroom_1": 
                    case "brown_mushroom_block": {
                        return SpigotLegacyMaterials.getHugeMushroomWithData(0, data);
                    }
                    case "huge_mushroom_2": 
                    case "red_mushroom_block": {
                        return SpigotLegacyMaterials.getHugeMushroomWithData(1, data);
                    }
                    case "vine": {
                        return SpigotLegacyMaterials.getVineWithData(data);
                    }
                    case "fence_gate": 
                    case "oak_fence_gate": {
                        return SpigotLegacyMaterials.getFenceGateWithData(0, data);
                    }
                    case "spruce_fence_gate": {
                        return SpigotLegacyMaterials.getFenceGateWithData(1, data);
                    }
                    case "birch_fence_gate": {
                        return SpigotLegacyMaterials.getFenceGateWithData(2, data);
                    }
                    case "jungle_fence_gate": {
                        return SpigotLegacyMaterials.getFenceGateWithData(3, data);
                    }
                    case "dark_oak_fence_gate": {
                        return SpigotLegacyMaterials.getFenceGateWithData(4, data);
                    }
                    case "acacia_fence_gate": {
                        return SpigotLegacyMaterials.getFenceGateWithData(5, data);
                    }
                    case "cocoa": {
                        return SpigotLegacyMaterials.getCocoaWithData(data);
                    }
                    case "tripwire_hook": {
                        return SpigotLegacyMaterials.getTripWireHookWithData(data);
                    }
                    case "tripwire": {
                        return SpigotLegacyMaterials.getTripWireWithData(data);
                    }
                    case "purpur_pillar": {
                        return (IBlockData)Blocks.PURPUR_PILLAR.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)SpigotLegacyMaterials.getPillarAxisXYZ(data));
                    }
                    case "nether_wart": {
                        return (IBlockData)Blocks.NETHER_WART.getBlockData().set((IBlockState)BlockNetherWart.AGE, (Comparable)Integer.valueOf(data));
                    }
                    case "brewing_stand": {
                        return (IBlockData)((IBlockData)((IBlockData)Blocks.BREWING_STAND.getBlockData().set((IBlockState)BlockBrewingStand.HAS_BOTTLE[0], (Comparable)Boolean.valueOf(SpigotLegacyMaterials.getBit(data, 0) == 1))).set((IBlockState)BlockBrewingStand.HAS_BOTTLE[1], (Comparable)Boolean.valueOf(SpigotLegacyMaterials.getBit(data, 1) == 1))).set((IBlockState)BlockBrewingStand.HAS_BOTTLE[2], (Comparable)Boolean.valueOf(SpigotLegacyMaterials.getBit(data, 2) == 1));
                    }
                    case "cauldron": {
                        return (IBlockData)Blocks.CAULDRON.getBlockData().set((IBlockState)BlockCauldron.LEVEL, (Comparable)Integer.valueOf(data));
                    }
                    case "portal": {
                        return (IBlockData)Blocks.NETHER_PORTAL.getBlockData().set((IBlockState)BlockPortal.AXIS, (Comparable)SpigotLegacyMaterials.getAxisXZ(data));
                    }
                    case "end_portal_frame": 
                    case "ender_portal_frame": {
                        return SpigotLegacyMaterials.getEndPortalFrameWithData(data);
                    }
                    case "structure_block": {
                        return SpigotLegacyMaterials.getStructureBlockWithData(data);
                    }
                    case "black_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(0, data);
                    }
                    case "blue_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(1, data);
                    }
                    case "brown_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(2, data);
                    }
                    case "cyan_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(3, data);
                    }
                    case "gray_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(4, data);
                    }
                    case "green_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(5, data);
                    }
                    case "light_blue_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(6, data);
                    }
                    case "lime_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(7, data);
                    }
                    case "magenta_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(8, data);
                    }
                    case "orange_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(9, data);
                    }
                    case "pink_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(10, data);
                    }
                    case "purple_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(11, data);
                    }
                    case "red_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(12, data);
                    }
                    case "silver_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(13, data);
                    }
                    case "white_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(14, data);
                    }
                    case "yellow_glazed_terracotta": {
                        return SpigotLegacyMaterials.getGlazedTerracottaWithData(15, data);
                    }
                    case "snow": {
                        switch (data) {
                            case 0: {
                                return (IBlockData)Blocks.SNOW.getBlockData().set((IBlockState)BlockSnow.LAYERS, (Comparable)Integer.valueOf(1));
                            }
                        }
                        return (IBlockData)Blocks.SNOW.getBlockData().set((IBlockState)BlockSnow.LAYERS, (Comparable)Integer.valueOf(data));
                    }
                }
                return null;
            }
            catch (IllegalArgumentException ex) {
                if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) {
                    OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CONFIGS, "Could not parse block with data, illegal data: " + blockName + ":" + data + ". Exception: " + ex.getMessage());
                }
            }
            catch (NullPointerException ex) {
                if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) break block465;
                OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CONFIGS, "Encountered a null pointer trying to parse " + blockName + ":" + data + ". Exception: " + ex.getMessage());
            }
        }
        return null;
    }

    private static MinecraftKey getFlatKey(String name, int data) throws NullPointerException {
        String result = DataConverterFlatten.a((String)name, (int)data);
        if (result == null) {
            throw new NullPointerException();
        }
        return new MinecraftKey(result);
    }

    private static IBlockData getAnvilWithData(int material, int data) {
        EnumDirection orientation = SpigotLegacyMaterials.getBit(data, 0) == 0 ? EnumDirection.NORTH : EnumDirection.WEST;
        switch (material) {
            case 0: {
                if ((SpigotLegacyMaterials.getBit(data, 2) & SpigotLegacyMaterials.getBit(data, 3)) == 0) {
                    return (IBlockData)Blocks.ANVIL.getBlockData().set((IBlockState)BlockAnvil.FACING, (Comparable)orientation);
                }
                if (SpigotLegacyMaterials.getBit(data, 2) == 1) {
                    return (IBlockData)Blocks.CHIPPED_ANVIL.getBlockData().set((IBlockState)BlockAnvil.FACING, (Comparable)orientation);
                }
                if (SpigotLegacyMaterials.getBit(data, 3) == 1) {
                    return (IBlockData)Blocks.DAMAGED_ANVIL.getBlockData().set((IBlockState)BlockAnvil.FACING, (Comparable)orientation);
                }
            }
            case 1: {
                return (IBlockData)Blocks.CHIPPED_ANVIL.getBlockData().set((IBlockState)BlockAnvil.FACING, (Comparable)orientation);
            }
            case 2: {
                return (IBlockData)Blocks.DAMAGED_ANVIL.getBlockData().set((IBlockState)BlockAnvil.FACING, (Comparable)orientation);
            }
        }
        return null;
    }

    private static IBlockData getLogWithData(int data) {
        int material = SpigotLegacyMaterials.getBits(data, 0, 2);
        int orientation = SpigotLegacyMaterials.getBits(data, 2, 2);
        EnumDirection.EnumAxis axisDirection = orientation == 0 ? EnumDirection.EnumAxis.Y : (orientation == 1 ? EnumDirection.EnumAxis.X : (orientation == 2 ? EnumDirection.EnumAxis.Z : EnumDirection.EnumAxis.Y));
        boolean bark = orientation == 3;
        switch (material) {
            case 0: {
                if (bark) {
                    return (IBlockData)Blocks.OAK_WOOD.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)axisDirection);
                }
                return (IBlockData)Blocks.OAK_LOG.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)axisDirection);
            }
            case 1: {
                if (bark) {
                    return (IBlockData)Blocks.SPRUCE_WOOD.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)axisDirection);
                }
                return (IBlockData)Blocks.SPRUCE_LOG.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)axisDirection);
            }
            case 2: {
                if (bark) {
                    return (IBlockData)Blocks.BIRCH_WOOD.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)axisDirection);
                }
                return (IBlockData)Blocks.BIRCH_LOG.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)axisDirection);
            }
            case 3: {
                if (bark) {
                    return (IBlockData)Blocks.JUNGLE_WOOD.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)axisDirection);
                }
                return (IBlockData)Blocks.JUNGLE_LOG.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)axisDirection);
            }
        }
        return Blocks.OAK_LOG.getBlockData();
    }

    private static IBlockData getLog2WithData(int data) {
        int material = SpigotLegacyMaterials.getBits(data, 0, 2);
        int orientation = SpigotLegacyMaterials.getBits(data, 2, 2);
        EnumDirection.EnumAxis axisDirection = orientation == 0 ? EnumDirection.EnumAxis.Y : (orientation == 1 ? EnumDirection.EnumAxis.X : (orientation == 2 ? EnumDirection.EnumAxis.Z : EnumDirection.EnumAxis.Y));
        boolean bark = orientation == 3;
        switch (material) {
            case 0: {
                if (bark) {
                    return (IBlockData)Blocks.ACACIA_WOOD.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)axisDirection);
                }
                return (IBlockData)Blocks.ACACIA_LOG.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)axisDirection);
            }
            case 1: {
                if (bark) {
                    return (IBlockData)Blocks.DARK_OAK_WOOD.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)axisDirection);
                }
                return (IBlockData)Blocks.DARK_OAK_LOG.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)axisDirection);
            }
        }
        return Blocks.ACACIA_LOG.getBlockData();
    }

    private static IBlockData getQuartzBlockWithData(int data) {
        switch (data) {
            default: {
                return Blocks.QUARTZ_BLOCK.getBlockData();
            }
            case 1: {
                return Blocks.CHISELED_QUARTZ_BLOCK.getBlockData();
            }
            case 2: {
                return (IBlockData)Blocks.QUARTZ_PILLAR.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)EnumDirection.EnumAxis.Y);
            }
            case 3: {
                return (IBlockData)Blocks.QUARTZ_PILLAR.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)EnumDirection.EnumAxis.X);
            }
            case 4: 
        }
        return (IBlockData)Blocks.QUARTZ_PILLAR.getBlockData().set((IBlockState)BlockRotatable.AXIS, (Comparable)EnumDirection.EnumAxis.Z);
    }

    private static IBlockData getTorchWithData(int material, int data) {
        switch (material) {
            case 0: {
                switch (data) {
                    default: {
                        return Blocks.TORCH.getBlockData();
                    }
                    case 1: {
                        return (IBlockData)Blocks.WALL_TORCH.getBlockData().set((IBlockState)BlockTorchWall.a, (Comparable)EnumDirection.EAST);
                    }
                    case 2: {
                        return (IBlockData)Blocks.WALL_TORCH.getBlockData().set((IBlockState)BlockTorchWall.a, (Comparable)EnumDirection.WEST);
                    }
                    case 3: {
                        return (IBlockData)Blocks.WALL_TORCH.getBlockData().set((IBlockState)BlockTorchWall.a, (Comparable)EnumDirection.SOUTH);
                    }
                    case 4: 
                }
                return (IBlockData)Blocks.WALL_TORCH.getBlockData().set((IBlockState)BlockTorchWall.a, (Comparable)EnumDirection.NORTH);
            }
            case 1: {
                switch (data) {
                    default: {
                        return Blocks.REDSTONE_TORCH.getBlockData();
                    }
                    case 1: {
                        return (IBlockData)((IBlockData)Blocks.REDSTONE_WALL_TORCH.getBlockData().set((IBlockState)BlockRedstoneTorchWall.LIT, (Comparable)Boolean.valueOf(false))).set((IBlockState)BlockRedstoneTorchWall.b, (Comparable)EnumDirection.EAST);
                    }
                    case 2: {
                        return (IBlockData)((IBlockData)Blocks.REDSTONE_WALL_TORCH.getBlockData().set((IBlockState)BlockRedstoneTorchWall.LIT, (Comparable)Boolean.valueOf(false))).set((IBlockState)BlockRedstoneTorchWall.b, (Comparable)EnumDirection.WEST);
                    }
                    case 3: {
                        return (IBlockData)((IBlockData)Blocks.REDSTONE_WALL_TORCH.getBlockData().set((IBlockState)BlockRedstoneTorchWall.LIT, (Comparable)Boolean.valueOf(false))).set((IBlockState)BlockRedstoneTorchWall.b, (Comparable)EnumDirection.SOUTH);
                    }
                    case 4: 
                }
                return (IBlockData)((IBlockData)Blocks.REDSTONE_WALL_TORCH.getBlockData().set((IBlockState)BlockRedstoneTorchWall.LIT, (Comparable)Boolean.valueOf(false))).set((IBlockState)BlockRedstoneTorchWall.b, (Comparable)EnumDirection.NORTH);
            }
            case 2: {
                switch (data) {
                    default: {
                        return (IBlockData)Blocks.REDSTONE_TORCH.getBlockData().set((IBlockState)BlockRedstoneTorchWall.LIT, (Comparable)Boolean.valueOf(true));
                    }
                    case 1: {
                        return (IBlockData)((IBlockData)Blocks.REDSTONE_WALL_TORCH.getBlockData().set((IBlockState)BlockRedstoneTorchWall.LIT, (Comparable)Boolean.valueOf(true))).set((IBlockState)BlockRedstoneTorchWall.b, (Comparable)EnumDirection.EAST);
                    }
                    case 2: {
                        return (IBlockData)((IBlockData)Blocks.REDSTONE_WALL_TORCH.getBlockData().set((IBlockState)BlockRedstoneTorchWall.LIT, (Comparable)Boolean.valueOf(true))).set((IBlockState)BlockRedstoneTorchWall.b, (Comparable)EnumDirection.WEST);
                    }
                    case 3: {
                        return (IBlockData)((IBlockData)Blocks.REDSTONE_WALL_TORCH.getBlockData().set((IBlockState)BlockRedstoneTorchWall.LIT, (Comparable)Boolean.valueOf(true))).set((IBlockState)BlockRedstoneTorchWall.b, (Comparable)EnumDirection.SOUTH);
                    }
                    case 4: 
                }
                return (IBlockData)((IBlockData)Blocks.REDSTONE_WALL_TORCH.getBlockData().set((IBlockState)BlockRedstoneTorchWall.LIT, (Comparable)Boolean.valueOf(true))).set((IBlockState)BlockRedstoneTorchWall.b, (Comparable)EnumDirection.NORTH);
            }
        }
        return null;
    }

    private static IBlockData getRailsWithData(int material, int data) {
        int shape = SpigotLegacyMaterials.getBits(data, 0, 3);
        int active = SpigotLegacyMaterials.getBit(data, 3);
        switch (material) {
            case 0: {
                return (IBlockData)((IBlockData)Blocks.POWERED_RAIL.getBlockData().set((IBlockState)BlockPoweredRail.SHAPE, (Comparable)SpigotLegacyMaterials.getRailShape(shape))).set((IBlockState)BlockPoweredRail.POWERED, (Comparable)Boolean.valueOf(active == 1));
            }
            case 1: {
                return (IBlockData)((IBlockData)Blocks.DETECTOR_RAIL.getBlockData().set((IBlockState)BlockMinecartDetector.SHAPE, (Comparable)SpigotLegacyMaterials.getRailShape(shape))).set((IBlockState)BlockMinecartDetector.POWERED, (Comparable)Boolean.valueOf(active == 1));
            }
            case 2: {
                return (IBlockData)((IBlockData)Blocks.ACTIVATOR_RAIL.getBlockData().set((IBlockState)BlockPoweredRail.SHAPE, (Comparable)SpigotLegacyMaterials.getRailShape(shape))).set((IBlockState)BlockPoweredRail.POWERED, (Comparable)Boolean.valueOf(active == 1));
            }
        }
        return null;
    }

    private static IBlockData getStairsWithData(int material, int data) {
        IBlockData output;
        int facing = SpigotLegacyMaterials.getBits(data, 0, 2);
        int half = SpigotLegacyMaterials.getBit(data, 2);
        switch (material) {
            case 0: {
                output = Blocks.OAK_STAIRS.getBlockData();
                break;
            }
            case 1: {
                output = Blocks.BIRCH_STAIRS.getBlockData();
                break;
            }
            case 2: {
                output = Blocks.SPRUCE_STAIRS.getBlockData();
                break;
            }
            case 3: {
                output = Blocks.JUNGLE_STAIRS.getBlockData();
                break;
            }
            case 4: {
                output = Blocks.COBBLESTONE_STAIRS.getBlockData();
                break;
            }
            case 5: {
                output = Blocks.BRICK_STAIRS.getBlockData();
                break;
            }
            case 6: {
                output = Blocks.STONE_STAIRS.getBlockData();
                break;
            }
            case 7: {
                output = Blocks.NETHER_BRICK_STAIRS.getBlockData();
                break;
            }
            case 8: {
                output = Blocks.SANDSTONE_STAIRS.getBlockData();
                break;
            }
            case 9: {
                output = Blocks.QUARTZ_STAIRS.getBlockData();
                break;
            }
            case 10: {
                output = Blocks.ACACIA_STAIRS.getBlockData();
                break;
            }
            case 11: {
                output = Blocks.DARK_OAK_STAIRS.getBlockData();
                break;
            }
            case 12: {
                output = Blocks.RED_SANDSTONE_STAIRS.getBlockData();
                break;
            }
            case 13: {
                output = Blocks.PURPUR_STAIRS.getBlockData();
                break;
            }
            case 14: {
                output = Blocks.STONE_BRICK_STAIRS.getBlockData();
                break;
            }
            default: {
                return null;
            }
        }
        return (IBlockData)((IBlockData)output.set((IBlockState)BlockStairs.FACING, (Comparable)SpigotLegacyMaterials.getFacingEastWestSouthNorth(facing))).set((IBlockState)BlockStairs.HALF, (Comparable)(half == 0 ? BlockPropertyHalf.BOTTOM : BlockPropertyHalf.TOP));
    }

    private static IBlockData getLeverOrButtonWithData(int material, int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 3);
        int powered = SpigotLegacyMaterials.getBit(data, 3);
        BlockPropertyAttachPosition face = facing == 0 || facing == 7 ? BlockPropertyAttachPosition.CEILING : (facing == 1 || facing == 2 || facing == 3 || facing == 4 ? BlockPropertyAttachPosition.WALL : BlockPropertyAttachPosition.FLOOR);
        switch (material) {
            case 0: {
                return (IBlockData)((IBlockData)((IBlockData)Blocks.LEVER.getBlockData().set((IBlockState)BlockLever.FACE, (Comparable)face)).set((IBlockState)BlockLever.FACING, (Comparable)SpigotLegacyMaterials.getFacingLever(facing))).set((IBlockState)BlockLever.POWERED, (Comparable)Boolean.valueOf(powered == 1));
            }
            case 1: {
                return (IBlockData)((IBlockData)((IBlockData)Blocks.STONE_BUTTON.getBlockData().set((IBlockState)BlockStoneButton.FACE, (Comparable)face)).set((IBlockState)BlockStoneButton.FACING, (Comparable)SpigotLegacyMaterials.getFacingButton(facing))).set((IBlockState)BlockStoneButton.POWERED, (Comparable)Boolean.valueOf(powered == 1));
            }
            case 2: {
                return (IBlockData)((IBlockData)((IBlockData)Blocks.OAK_BUTTON.getBlockData().set((IBlockState)BlockWoodButton.FACE, (Comparable)face)).set((IBlockState)BlockWoodButton.FACING, (Comparable)SpigotLegacyMaterials.getFacingButton(facing))).set((IBlockState)BlockWoodButton.POWERED, (Comparable)Boolean.valueOf(powered == 1));
            }
        }
        return null;
    }

    private static IBlockData getDoorWithData(int material, int data) {
        IBlockData blockState;
        int half = SpigotLegacyMaterials.getBit(data, 3);
        int hinge = SpigotLegacyMaterials.getBit(data, 0);
        int powered = SpigotLegacyMaterials.getBit(data, 1);
        int facing = SpigotLegacyMaterials.getBits(data, 0, 2);
        int open = SpigotLegacyMaterials.getBit(data, 2);
        switch (material) {
            case 0: {
                blockState = Blocks.OAK_DOOR.getBlockData();
                break;
            }
            case 1: {
                blockState = Blocks.IRON_DOOR.getBlockData();
                break;
            }
            case 2: {
                blockState = Blocks.SPRUCE_DOOR.getBlockData();
                break;
            }
            case 3: {
                blockState = Blocks.BIRCH_DOOR.getBlockData();
                break;
            }
            case 4: {
                blockState = Blocks.JUNGLE_DOOR.getBlockData();
                break;
            }
            case 5: {
                blockState = Blocks.ACACIA_DOOR.getBlockData();
                break;
            }
            case 6: {
                blockState = Blocks.DARK_OAK_DOOR.getBlockData();
                break;
            }
            default: {
                return null;
            }
        }
        return half == 0 ? (IBlockData)((IBlockData)((IBlockData)blockState.set((IBlockState)BlockDoor.HALF, (Comparable)BlockPropertyDoubleBlockHalf.LOWER)).set((IBlockState)BlockDoor.FACING, (Comparable)SpigotLegacyMaterials.getFacingEastSouthWestNorth(facing))).set((IBlockState)BlockDoor.OPEN, (Comparable)Boolean.valueOf(open == 1)) : (IBlockData)((IBlockData)((IBlockData)blockState.set((IBlockState)BlockDoor.HALF, (Comparable)BlockPropertyDoubleBlockHalf.UPPER)).set((IBlockState)BlockDoor.HINGE, (Comparable)(hinge == 0 ? BlockPropertyDoorHinge.LEFT : BlockPropertyDoorHinge.RIGHT))).set((IBlockState)BlockDoor.POWERED, (Comparable)Boolean.valueOf(powered == 1));
    }

    private static IBlockData getSignPostWithData(int data) {
        int rotation = SpigotLegacyMaterials.getBits(data, 0, 4);
        return (IBlockData)Blocks.OAK_SIGN.getBlockData().set((IBlockState)BlockFloorSign.ROTATION, (Comparable)Integer.valueOf(rotation));
    }

    private static IBlockData getWallSignWithData(int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 3);
        return (IBlockData)Blocks.OAK_WALL_SIGN.getBlockData().set((IBlockState)BlockWallSign.FACING, (Comparable)SpigotLegacyMaterials.getFacingNorthSouthWestEast(facing));
    }

    private static IBlockData getCommandBlockWithData(int material, int data) {
        IBlockData blockState;
        switch (material) {
            case 0: {
                blockState = Blocks.COMMAND_BLOCK.getBlockData();
                break;
            }
            case 1: {
                blockState = Blocks.REPEATING_COMMAND_BLOCK.getBlockData();
                break;
            }
            case 2: {
                blockState = Blocks.CHAIN_COMMAND_BLOCK.getBlockData();
                break;
            }
            default: {
                return null;
            }
        }
        return blockState;
    }

    private static IBlockData getShulkerBoxWithData(int material, int data) {
        IBlockData blockState;
        switch (material) {
            case 0: {
                blockState = Blocks.WHITE_SHULKER_BOX.getBlockData();
                break;
            }
            case 1: {
                blockState = Blocks.ORANGE_SHULKER_BOX.getBlockData();
                break;
            }
            case 2: {
                blockState = Blocks.MAGENTA_SHULKER_BOX.getBlockData();
                break;
            }
            case 3: {
                blockState = Blocks.LIGHT_BLUE_SHULKER_BOX.getBlockData();
                break;
            }
            case 4: {
                blockState = Blocks.YELLOW_SHULKER_BOX.getBlockData();
                break;
            }
            case 5: {
                blockState = Blocks.LIME_SHULKER_BOX.getBlockData();
                break;
            }
            case 6: {
                blockState = Blocks.PINK_SHULKER_BOX.getBlockData();
                break;
            }
            case 7: {
                blockState = Blocks.GRAY_SHULKER_BOX.getBlockData();
                break;
            }
            case 8: {
                blockState = Blocks.LIGHT_GRAY_SHULKER_BOX.getBlockData();
                break;
            }
            case 9: {
                blockState = Blocks.CYAN_SHULKER_BOX.getBlockData();
                break;
            }
            case 10: {
                blockState = Blocks.PURPLE_SHULKER_BOX.getBlockData();
                break;
            }
            case 11: {
                blockState = Blocks.BLUE_SHULKER_BOX.getBlockData();
                break;
            }
            case 12: {
                blockState = Blocks.BROWN_SHULKER_BOX.getBlockData();
                break;
            }
            case 13: {
                blockState = Blocks.GREEN_SHULKER_BOX.getBlockData();
                break;
            }
            case 14: {
                blockState = Blocks.RED_SHULKER_BOX.getBlockData();
                break;
            }
            case 15: {
                blockState = Blocks.BLACK_SHULKER_BOX.getBlockData();
                break;
            }
            case 16: {
                blockState = Blocks.SHULKER_BOX.getBlockData();
                break;
            }
            default: {
                return null;
            }
        }
        return (IBlockData)blockState.set((IBlockState)BlockShulkerBox.a, (Comparable)SpigotLegacyMaterials.getFacingDownEastNorthSouthUpWest(data));
    }

    private static IBlockData getLadderChestOrFurnaceWithData(int material, int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 3);
        switch (material) {
            case 0: {
                return (IBlockData)Blocks.LADDER.getBlockData().set((IBlockState)BlockLadder.FACING, (Comparable)SpigotLegacyMaterials.getFacingNorthSouthWestEast(facing));
            }
            case 1: {
                return (IBlockData)Blocks.CHEST.getBlockData().set((IBlockState)BlockChest.FACING, (Comparable)SpigotLegacyMaterials.getFacingNorthSouthWestEast(facing));
            }
            case 2: {
                return (IBlockData)Blocks.ENDER_CHEST.getBlockData().set((IBlockState)BlockEnderChest.FACING, (Comparable)SpigotLegacyMaterials.getFacingNorthSouthWestEast(facing));
            }
            case 3: {
                return (IBlockData)Blocks.TRAPPED_CHEST.getBlockData().set((IBlockState)BlockChestTrapped.FACING, (Comparable)SpigotLegacyMaterials.getFacingNorthSouthWestEast(facing));
            }
            case 4: {
                return (IBlockData)((IBlockData)Blocks.FURNACE.getBlockData().set((IBlockState)BlockFurnace.FACING, (Comparable)SpigotLegacyMaterials.getFacingNorthSouthWestEast(facing))).set((IBlockState)BlockFurnace.LIT, (Comparable)Boolean.valueOf(false));
            }
            case 5: {
                return (IBlockData)((IBlockData)Blocks.FURNACE.getBlockData().set((IBlockState)BlockFurnace.FACING, (Comparable)SpigotLegacyMaterials.getFacingNorthSouthWestEast(facing))).set((IBlockState)BlockFurnace.LIT, (Comparable)Boolean.valueOf(true));
            }
        }
        return null;
    }

    private static IBlockData getDispenserHopperDropperWithData(int material, int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 3);
        int active = SpigotLegacyMaterials.getBit(data, 3);
        switch (material) {
            case 0: {
                return (IBlockData)((IBlockData)Blocks.DISPENSER.getBlockData().set((IBlockState)BlockDispenser.FACING, (Comparable)SpigotLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing))).set((IBlockState)BlockDispenser.TRIGGERED, (Comparable)Boolean.valueOf(active == 1));
            }
            case 1: {
                return (IBlockData)((IBlockData)Blocks.DROPPER.getBlockData().set((IBlockState)BlockDropper.FACING, (Comparable)SpigotLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing))).set((IBlockState)BlockDropper.TRIGGERED, (Comparable)Boolean.valueOf(active == 1));
            }
            case 2: {
                return (IBlockData)((IBlockData)Blocks.HOPPER.getBlockData().set((IBlockState)BlockHopper.FACING, (Comparable)SpigotLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing))).set((IBlockState)BlockHopper.ENABLED, (Comparable)Boolean.valueOf(active == 1));
            }
        }
        return null;
    }

    private static IBlockData getJackOLanternOrPumpkinWithData(int material, int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 2);
        switch (material) {
            case 0: {
                return (IBlockData)Blocks.CARVED_PUMPKIN.getBlockData().set((IBlockState)BlockPumpkinCarved.FACING, (Comparable)SpigotLegacyMaterials.getFacingSouthWestNorthEast(facing));
            }
            case 1: {
                return (IBlockData)Blocks.JACK_O_LANTERN.getBlockData().set((IBlockState)BlockPumpkinCarved.FACING, (Comparable)SpigotLegacyMaterials.getFacingSouthWestNorthEast(facing));
            }
        }
        return null;
    }

    private static IBlockData getObserverWithData(int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 3);
        int powered = SpigotLegacyMaterials.getBit(data, 3);
        return (IBlockData)((IBlockData)Blocks.OBSERVER.getBlockData().set((IBlockState)BlockObserver.FACING, (Comparable)SpigotLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing))).set((IBlockState)BlockObserver.b, (Comparable)Boolean.valueOf(powered == 1));
    }

    private static IBlockData getRepeaterWithData(int material, int data) {
        IBlockData blockState;
        int facing = SpigotLegacyMaterials.getBits(data, 0, 2);
        int delay = SpigotLegacyMaterials.getBits(data, 2, 2) + 1;
        switch (material) {
            case 0: {
                blockState = (IBlockData)Blocks.REPEATER.getBlockData().set((IBlockState)BlockRepeater.c, (Comparable)Boolean.valueOf(false));
                break;
            }
            case 1: {
                blockState = (IBlockData)Blocks.REPEATER.getBlockData().set((IBlockState)BlockRepeater.c, (Comparable)Boolean.valueOf(true));
                break;
            }
            default: {
                return null;
            }
        }
        return (IBlockData)((IBlockData)blockState.set((IBlockState)BlockRepeater.DELAY, (Comparable)Integer.valueOf(delay))).set((IBlockState)BlockRepeater.FACING, (Comparable)SpigotLegacyMaterials.getFacingSouthWestNorthEast(facing));
    }

    private static IBlockData getComparatorWithData(int material, int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 2);
        int mode = SpigotLegacyMaterials.getBit(data, 2);
        int powered = material == 1 ? 1 : SpigotLegacyMaterials.getBit(data, 3);
        return (IBlockData)((IBlockData)((IBlockData)Blocks.COMPARATOR.getBlockData().set((IBlockState)BlockRedstoneComparator.FACING, (Comparable)SpigotLegacyMaterials.getFacingSouthWestNorthEast(facing))).set((IBlockState)BlockRedstoneComparator.MODE, (Comparable)(mode == 0 ? BlockPropertyComparatorMode.COMPARE : BlockPropertyComparatorMode.SUBTRACT))).set((IBlockState)BlockRedstoneComparator.c, (Comparable)Boolean.valueOf(powered == 1));
    }

    private static IBlockData getBedBlockWithData(int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 2);
        int occupied = SpigotLegacyMaterials.getBit(data, 2);
        int part = SpigotLegacyMaterials.getBit(data, 3);
        return (IBlockData)((IBlockData)((IBlockData)Blocks.RED_BED.getBlockData().set((IBlockState)BlockBed.FACING, (Comparable)SpigotLegacyMaterials.getFacingSouthWestNorthEast(facing))).set((IBlockState)BlockBed.OCCUPIED, (Comparable)Boolean.valueOf(occupied == 1))).set((IBlockState)BlockBed.PART, (Comparable)(part == 0 ? BlockPropertyBedPart.FOOT : BlockPropertyBedPart.HEAD));
    }

    private static IBlockData getTrapDoorBlockWithData(int material, int data) {
        IBlockData blockState;
        int facing = SpigotLegacyMaterials.getBits(data, 0, 2);
        int open = SpigotLegacyMaterials.getBit(data, 2);
        int half = SpigotLegacyMaterials.getBit(data, 3);
        switch (material) {
            case 0: {
                blockState = Blocks.OAK_TRAPDOOR.getBlockData();
                break;
            }
            case 1: {
                blockState = Blocks.IRON_TRAPDOOR.getBlockData();
                break;
            }
            default: {
                return null;
            }
        }
        return (IBlockData)((IBlockData)((IBlockData)blockState.set((IBlockState)BlockTrapdoor.FACING, (Comparable)SpigotLegacyMaterials.getFacingSouthNorthEastWest(facing))).set((IBlockState)BlockTrapdoor.HALF, (Comparable)(half == 0 ? BlockPropertyHalf.BOTTOM : BlockPropertyHalf.TOP))).set((IBlockState)BlockTrapdoor.OPEN, (Comparable)Boolean.valueOf(open == 1));
    }

    private static IBlockData getPistonWithData(int material, int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 3);
        int extended = SpigotLegacyMaterials.getBit(data, 3);
        switch (material) {
            case 0: {
                return (IBlockData)((IBlockData)Blocks.PISTON.getBlockData().set((IBlockState)BlockPiston.EXTENDED, (Comparable)Boolean.valueOf(extended == 1))).set((IBlockState)BlockPiston.FACING, (Comparable)SpigotLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing));
            }
            case 1: {
                return (IBlockData)((IBlockData)Blocks.STICKY_PISTON.getBlockData().set((IBlockState)BlockPiston.EXTENDED, (Comparable)Boolean.valueOf(extended == 1))).set((IBlockState)BlockPiston.FACING, (Comparable)SpigotLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing));
            }
        }
        return null;
    }

    private static IBlockData getPistonHeadWithData(int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 3);
        int type = SpigotLegacyMaterials.getBit(data, 3);
        return (IBlockData)((IBlockData)Blocks.PISTON_HEAD.getBlockData().set((IBlockState)BlockPistonExtension.FACING, (Comparable)SpigotLegacyMaterials.getFacingDownUpNorthSouthWestEast(facing))).set((IBlockState)BlockPistonExtension.TYPE, (Comparable)(type == 0 ? BlockPropertyPistonType.DEFAULT : BlockPropertyPistonType.STICKY));
    }

    private static IBlockData getHugeMushroomWithData(int material, int data) {
        IBlockData blockState;
        boolean west;
        boolean down = data == 14 || data == 15;
        boolean up = data == 1 || data == 2 || data == 3 || data == 4 || data == 5 || data == 6 || data == 7 || data == 8 || data == 9 || data == 14 || data == 15;
        boolean north = data == 1 || data == 2 || data == 3 || data == 10 || data == 14 || data == 15;
        boolean east = data == 3 || data == 6 || data == 9 || data == 10 || data == 14 || data == 15;
        boolean south = data == 7 || data == 8 || data == 9 || data == 10 || data == 14 || data == 15;
        boolean bl = west = data == 1 || data == 4 || data == 7 || data == 10 || data == 14 || data == 15;
        if (data == 10 || data == 15) {
            blockState = Blocks.MUSHROOM_STEM.getBlockData();
        } else {
            switch (material) {
                case 0: {
                    blockState = Blocks.BROWN_MUSHROOM_BLOCK.getBlockData();
                    break;
                }
                case 1: {
                    blockState = Blocks.RED_MUSHROOM_BLOCK.getBlockData();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)blockState.set((IBlockState)BlockHugeMushroom.f, (Comparable)Boolean.valueOf(down))).set((IBlockState)BlockHugeMushroom.e, (Comparable)Boolean.valueOf(up))).set((IBlockState)BlockHugeMushroom.a, (Comparable)Boolean.valueOf(north))).set((IBlockState)BlockHugeMushroom.b, (Comparable)Boolean.valueOf(east))).set((IBlockState)BlockHugeMushroom.c, (Comparable)Boolean.valueOf(south))).set((IBlockState)BlockHugeMushroom.d, (Comparable)Boolean.valueOf(west));
    }

    private static IBlockData getVineWithData(int data) {
        int south = SpigotLegacyMaterials.getBit(data, 0);
        int west = SpigotLegacyMaterials.getBit(data, 1);
        int north = SpigotLegacyMaterials.getBit(data, 2);
        int east = SpigotLegacyMaterials.getBit(data, 3);
        boolean up = data == 0;
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)Blocks.VINE.getBlockData().set((IBlockState)BlockVine.EAST, (Comparable)Boolean.valueOf(east == 1))).set((IBlockState)BlockVine.NORTH, (Comparable)Boolean.valueOf(north == 1))).set((IBlockState)BlockVine.SOUTH, (Comparable)Boolean.valueOf(south == 1))).set((IBlockState)BlockVine.WEST, (Comparable)Boolean.valueOf(west == 1))).set((IBlockState)BlockVine.UP, (Comparable)Boolean.valueOf(up));
    }

    private static IBlockData getFenceGateWithData(int material, int data) {
        IBlockData blockState;
        int facing = SpigotLegacyMaterials.getBits(data, 0, 2);
        int open = SpigotLegacyMaterials.getBit(data, 2);
        switch (material) {
            case 0: {
                blockState = Blocks.BIRCH_FENCE_GATE.getBlockData();
                break;
            }
            case 1: {
                blockState = Blocks.OAK_FENCE_GATE.getBlockData();
                break;
            }
            case 2: {
                blockState = Blocks.SPRUCE_FENCE_GATE.getBlockData();
                break;
            }
            case 3: {
                blockState = Blocks.JUNGLE_FENCE_GATE.getBlockData();
                break;
            }
            case 4: {
                blockState = Blocks.DARK_OAK_FENCE_GATE.getBlockData();
                break;
            }
            case 5: {
                blockState = Blocks.ACACIA_FENCE_GATE.getBlockData();
                break;
            }
            default: {
                return null;
            }
        }
        return (IBlockData)((IBlockData)blockState.set((IBlockState)BlockFenceGate.FACING, (Comparable)SpigotLegacyMaterials.getFacingSouthWestNorthEast(facing))).set((IBlockState)BlockFenceGate.OPEN, (Comparable)Boolean.valueOf(open == 1));
    }

    private static IBlockData getCocoaWithData(int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 2);
        int age = SpigotLegacyMaterials.getBits(data, 2, 2);
        return (IBlockData)((IBlockData)Blocks.COCOA.getBlockData().set((IBlockState)BlockCocoa.FACING, (Comparable)SpigotLegacyMaterials.getFacingSouthWestNorthEast(facing))).set((IBlockState)BlockCocoa.AGE, (Comparable)Integer.valueOf(age));
    }

    private static IBlockData getTripWireHookWithData(int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 2);
        int attached = SpigotLegacyMaterials.getBit(data, 2);
        int powered = SpigotLegacyMaterials.getBit(data, 3);
        return (IBlockData)((IBlockData)((IBlockData)Blocks.TRIPWIRE_HOOK.getBlockData().set((IBlockState)BlockTripwireHook.ATTACHED, (Comparable)Boolean.valueOf(attached == 1))).set((IBlockState)BlockTripwireHook.FACING, (Comparable)SpigotLegacyMaterials.getFacingSouthWestNorthEast(facing))).set((IBlockState)BlockTripwireHook.POWERED, (Comparable)Boolean.valueOf(powered == 1));
    }

    private static IBlockData getEndPortalFrameWithData(int data) {
        int facing = SpigotLegacyMaterials.getBits(data, 0, 2);
        int eye = SpigotLegacyMaterials.getBit(data, 2);
        return (IBlockData)((IBlockData)Blocks.END_PORTAL_FRAME.getBlockData().set((IBlockState)BlockEnderPortalFrame.EYE, (Comparable)Boolean.valueOf(eye == 1))).set((IBlockState)BlockEnderPortalFrame.FACING, (Comparable)SpigotLegacyMaterials.getFacingSouthWestNorthEast(facing));
    }

    private static IBlockData getStructureBlockWithData(int data) {
        BlockPropertyStructureMode structureBlockMode = data == 0 ? BlockPropertyStructureMode.DATA : (data == 1 ? BlockPropertyStructureMode.SAVE : (data == 2 ? BlockPropertyStructureMode.LOAD : (data == 3 ? BlockPropertyStructureMode.LOAD : BlockPropertyStructureMode.DATA)));
        return (IBlockData)Blocks.STRUCTURE_BLOCK.getBlockData().set((IBlockState)BlockStructure.a, (Comparable)structureBlockMode);
    }

    private static IBlockData getGlazedTerracottaWithData(int material, int data) {
        IBlockData blockState;
        int facing = SpigotLegacyMaterials.getBits(data, 0, 2);
        switch (material) {
            case 0: {
                blockState = Blocks.BLACK_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 1: {
                blockState = Blocks.BLUE_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 2: {
                blockState = Blocks.BROWN_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 3: {
                blockState = Blocks.CYAN_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 4: {
                blockState = Blocks.GRAY_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 5: {
                blockState = Blocks.GREEN_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 6: {
                blockState = Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 7: {
                blockState = Blocks.LIME_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 8: {
                blockState = Blocks.MAGENTA_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 9: {
                blockState = Blocks.ORANGE_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 10: {
                blockState = Blocks.PINK_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 11: {
                blockState = Blocks.PURPLE_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 12: {
                blockState = Blocks.RED_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 13: {
                blockState = Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 14: {
                blockState = Blocks.WHITE_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            case 15: {
                blockState = Blocks.YELLOW_GLAZED_TERRACOTTA.getBlockData();
                break;
            }
            default: {
                return Blocks.BLACK_GLAZED_TERRACOTTA.getBlockData();
            }
        }
        return (IBlockData)blockState.set((IBlockState)BlockGlazedTerracotta.FACING, (Comparable)SpigotLegacyMaterials.getFacingSouthWestNorthEast(facing));
    }

    private static IBlockData getTripWireWithData(int data) {
        int active = SpigotLegacyMaterials.getBit(data, 0);
        int attached = SpigotLegacyMaterials.getBit(data, 2);
        int disarmed = SpigotLegacyMaterials.getBit(data, 3);
        return (IBlockData)((IBlockData)((IBlockData)Blocks.TRIPWIRE.getBlockData().set((IBlockState)BlockTripwire.POWERED, (Comparable)Boolean.valueOf(active == 1))).set((IBlockState)BlockTripwire.ATTACHED, (Comparable)Boolean.valueOf(attached == 1))).set((IBlockState)BlockTripwire.DISARMED, (Comparable)Boolean.valueOf(disarmed == 1));
    }

    private static EnumDirection.EnumAxis getAxisXYZ(int data) {
        switch (data) {
            case 0: {
                return EnumDirection.EnumAxis.X;
            }
            case 2: {
                return EnumDirection.EnumAxis.Z;
            }
        }
        return EnumDirection.EnumAxis.Y;
    }

    private static EnumDirection.EnumAxis getAxisXZ(int data) {
        switch (data) {
            case 2: {
                return EnumDirection.EnumAxis.Z;
            }
        }
        return EnumDirection.EnumAxis.X;
    }

    private static EnumDirection getFacingSouthWestNorthEast(int data) {
        switch (data) {
            case 1: {
                return EnumDirection.WEST;
            }
            case 2: {
                return EnumDirection.NORTH;
            }
            case 3: {
                return EnumDirection.EAST;
            }
        }
        return EnumDirection.SOUTH;
    }

    private static EnumDirection getFacingNorthSouthWestEast(int data) {
        switch (data) {
            case 3: {
                return EnumDirection.SOUTH;
            }
            case 4: {
                return EnumDirection.WEST;
            }
            case 5: {
                return EnumDirection.EAST;
            }
        }
        return EnumDirection.NORTH;
    }

    private static EnumDirection getFacingDownUpNorthSouthWestEast(int data) {
        switch (data) {
            case 1: {
                return EnumDirection.UP;
            }
            case 2: {
                return EnumDirection.NORTH;
            }
            case 3: {
                return EnumDirection.SOUTH;
            }
            case 4: {
                return EnumDirection.WEST;
            }
            case 5: {
                return EnumDirection.EAST;
            }
        }
        return EnumDirection.DOWN;
    }

    private static EnumDirection getFacingSouthNorthEastWest(int data) {
        switch (data) {
            case 1: {
                return EnumDirection.NORTH;
            }
            case 2: {
                return EnumDirection.EAST;
            }
            case 3: {
                return EnumDirection.WEST;
            }
        }
        return EnumDirection.SOUTH;
    }

    private static EnumDirection getFacingEastSouthWestNorth(int data) {
        switch (data) {
            case 1: {
                return EnumDirection.SOUTH;
            }
            case 2: {
                return EnumDirection.WEST;
            }
            case 3: {
                return EnumDirection.NORTH;
            }
        }
        return EnumDirection.EAST;
    }

    private static EnumDirection getFacingEastWestSouthNorth(int data) {
        switch (data) {
            case 1: {
                return EnumDirection.WEST;
            }
            case 2: {
                return EnumDirection.SOUTH;
            }
            case 3: {
                return EnumDirection.NORTH;
            }
        }
        return EnumDirection.EAST;
    }

    private static EnumDirection getFacingDownEastNorthSouthUpWest(int data) {
        switch (data) {
            case 0: {
                return EnumDirection.DOWN;
            }
            case 1: {
                return EnumDirection.EAST;
            }
            case 2: {
                return EnumDirection.NORTH;
            }
            case 3: {
                return EnumDirection.SOUTH;
            }
            case 5: {
                return EnumDirection.WEST;
            }
        }
        return EnumDirection.UP;
    }

    private static EnumDirection.EnumAxis getPillarAxisXYZ(int data) {
        switch (data) {
            case 0: {
                return EnumDirection.EnumAxis.Y;
            }
            case 4: {
                return EnumDirection.EnumAxis.X;
            }
            case 8: {
                return EnumDirection.EnumAxis.Z;
            }
        }
        return EnumDirection.EnumAxis.Y;
    }

    private static EnumDirection getFacingLever(int data) {
        switch (data) {
            case 2: {
                return EnumDirection.WEST;
            }
            case 3: 
            case 5: 
            case 7: {
                return EnumDirection.SOUTH;
            }
            case 4: {
                return EnumDirection.NORTH;
            }
        }
        return EnumDirection.EAST;
    }

    private static EnumDirection getFacingButton(int data) {
        switch (data) {
            case 2: {
                return EnumDirection.WEST;
            }
            case 3: {
                return EnumDirection.SOUTH;
            }
            case 4: {
                return EnumDirection.NORTH;
            }
        }
        return EnumDirection.EAST;
    }

    private static BlockPropertyTrackPosition getRailShape(int shape) {
        switch (shape) {
            case 1: {
                return BlockPropertyTrackPosition.EAST_WEST;
            }
            case 2: {
                return BlockPropertyTrackPosition.ASCENDING_EAST;
            }
            case 3: {
                return BlockPropertyTrackPosition.ASCENDING_WEST;
            }
            case 4: {
                return BlockPropertyTrackPosition.ASCENDING_NORTH;
            }
            case 5: {
                return BlockPropertyTrackPosition.ASCENDING_SOUTH;
            }
            case 6: {
                return BlockPropertyTrackPosition.SOUTH_EAST;
            }
            case 7: {
                return BlockPropertyTrackPosition.SOUTH_WEST;
            }
            case 8: {
                return BlockPropertyTrackPosition.NORTH_WEST;
            }
            case 9: {
                return BlockPropertyTrackPosition.NORTH_EAST;
            }
        }
        return BlockPropertyTrackPosition.NORTH_SOUTH;
    }

    private static int getBits(int source, int index, int length) {
        int bits = 0;
        for (int i = 0; i < length; ++i) {
            bits |= SpigotLegacyMaterials.getBit(source, index + i) << i;
        }
        return bits;
    }

    private static int getBit(int source, int index) {
        return (source & 1 << index) >> index;
    }
}

