/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.materials;

import com.pg85.otg.spigot.materials.SpigotMaterialTag;
import com.pg85.otg.util.OTGDirection;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterialTag;
import com.pg85.otg.util.materials.MaterialProperties;
import com.pg85.otg.util.materials.MaterialProperty;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockFalling;
import net.minecraft.server.v1_16_R3.BlockLeaves;
import net.minecraft.server.v1_16_R3.BlockProperties;
import net.minecraft.server.v1_16_R3.BlockRotatable;
import net.minecraft.server.v1_16_R3.BlockSnow;
import net.minecraft.server.v1_16_R3.BlockStateDirection;
import net.minecraft.server.v1_16_R3.BlockStateInteger;
import net.minecraft.server.v1_16_R3.BlockTall;
import net.minecraft.server.v1_16_R3.Blocks;
import net.minecraft.server.v1_16_R3.EnumBlockRotation;
import net.minecraft.server.v1_16_R3.EnumDirection;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IBlockState;
import net.minecraft.server.v1_16_R3.Material;
import net.minecraft.server.v1_16_R3.Tag;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;

public class SpigotMaterialData
extends LocalMaterialData {
    static final LocalMaterialData blank = new SpigotMaterialData(null, null, true);
    private static final ConcurrentHashMap<IBlockData, LocalMaterialData> stateToMaterialDataMap = new ConcurrentHashMap();
    private final IBlockData blockData;
    private String name = null;

    private SpigotMaterialData(IBlockData blockData, String raw) {
        this(blockData, raw, false);
    }

    private SpigotMaterialData(IBlockData blockData, String raw, boolean isBlank) {
        this.blockData = blockData;
        this.rawEntry = raw;
        this.isBlank = isBlank;
    }

    public static LocalMaterialData ofBlockData(IBlockData blockData) {
        return SpigotMaterialData.ofBlockData(blockData, null);
    }

    public static LocalMaterialData ofBlockData(IBlockData blockData, String raw) {
        LocalMaterialData existingData = stateToMaterialDataMap.get(blockData);
        if (existingData != null) {
            return existingData;
        }
        SpigotMaterialData newData = new SpigotMaterialData(blockData, raw);
        existingData = stateToMaterialDataMap.putIfAbsent(blockData, newData);
        if (existingData != null) {
            return existingData;
        }
        return newData;
    }

    public static LocalMaterialData ofSpigotMaterial(org.bukkit.Material type) {
        return SpigotMaterialData.ofBlockData(((CraftBlockData)type.createBlockData()).getState(), null);
    }

    public IBlockData internalBlock() {
        return this.blockData;
    }

    public BlockData toSpigotBlockData() {
        if (this.blockData == null) {
            return null;
        }
        return CraftBlockData.fromData((IBlockData)this.blockData);
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        this.name = this.isBlank ? "BLANK" : (this.blockData == null ? (this.rawEntry != null ? this.rawEntry : "Unknown") : (this.blockData != this.blockData.getBlock().getBlockData() && (!(this.blockData.getBlock() instanceof BlockLeaves) || this.blockData != this.blockData.getBlock().getBlockData().set((IBlockState)BlockLeaves.DISTANCE, (Comparable)Integer.valueOf(1))) ? this.blockData.toString().replace("Block{", "").replace("}", "") : this.getRegistryName()));
        return this.name;
    }

    @Override
    public String getRegistryName() {
        return this.blockData == null ? null : this.blockData.toString().substring(0, this.blockData.toString().indexOf("}")).replace("Block{", "");
    }

    @Override
    public boolean isLiquid() {
        return this.blockData != null && (this.blockData.getMaterial() == Material.WATER || this.blockData.getMaterial() == Material.LAVA);
    }

    @Override
    public boolean isSolid() {
        return this.blockData != null && this.blockData.getMaterial().isSolid();
    }

    @Override
    public boolean isEmptyOrAir() {
        return this.blockData == null || this.blockData.getMaterial() == Material.AIR;
    }

    @Override
    public boolean isNonCaveAir() {
        return this.blockData != null && this.blockData.getBlock() == Blocks.AIR;
    }

    @Override
    public boolean isAir() {
        return this.blockData != null && this.blockData.getMaterial() == Material.AIR;
    }

    @Override
    public boolean isEmpty() {
        return this.blockData == null;
    }

    @Override
    public boolean canFall() {
        return this.blockData != null && this.blockData.getBlock() instanceof BlockFalling;
    }

    @Override
    public boolean canSnowFallOn() {
        if (!(this.blockData == null || this.blockData.a(Blocks.ICE) || this.blockData.a(Blocks.PACKED_ICE) || this.blockData.a(Blocks.BARRIER))) {
            if (!this.blockData.a(Blocks.HONEY_BLOCK) && !this.blockData.a(Blocks.SOUL_SAND)) {
                return this.blockData.getMaterial().isSolid() || this.blockData.a(Blocks.SNOW) && (Integer)this.blockData.get((IBlockState)BlockSnow.LAYERS) == 8;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isMaterial(LocalMaterialData material) {
        return this.isBlank && ((SpigotMaterialData)material).isBlank || !this.isBlank && !((SpigotMaterialData)material).isBlank && Objects.equals(this.blockData.getBlock(), ((SpigotMaterialData)material).blockData.getBlock());
    }

    @Override
    public LocalMaterialData rotate(int rotateTimes) {
        if (this.isBlank) {
            return this;
        }
        if (this.rotated == null) {
            IBlockData state = this.blockData;
            Collection properties = state.r();
            for (IBlockState property : properties) {
                if (!(property instanceof BlockStateDirection)) continue;
                EnumDirection direction = (EnumDirection)state.get(property);
                switch (direction) {
                    case DOWN: 
                    case UP: {
                        break;
                    }
                    case NORTH: {
                        state = (IBlockData)state.set((IBlockState)((BlockStateDirection)property), (Comparable)EnumDirection.WEST);
                        break;
                    }
                    case SOUTH: {
                        state = (IBlockData)state.set((IBlockState)((BlockStateDirection)property), (Comparable)EnumDirection.EAST);
                        break;
                    }
                    case WEST: {
                        state = (IBlockData)state.set((IBlockState)((BlockStateDirection)property), (Comparable)EnumDirection.SOUTH);
                        break;
                    }
                    case EAST: {
                        state = (IBlockData)state.set((IBlockState)((BlockStateDirection)property), (Comparable)EnumDirection.NORTH);
                    }
                }
            }
            if (state.b((IBlockState)BlockRotatable.AXIS)) {
                state = ((BlockRotatable)state.getBlock()).a(this.blockData, EnumBlockRotation.COUNTERCLOCKWISE_90);
            }
            if (state.b((IBlockState)BlockTall.EAST)) {
                boolean hasEast = (Boolean)state.get((IBlockState)BlockTall.EAST);
                state = (IBlockData)state.set((IBlockState)BlockTall.EAST, state.get((IBlockState)BlockTall.SOUTH));
                state = (IBlockData)state.set((IBlockState)BlockTall.SOUTH, state.get((IBlockState)BlockTall.WEST));
                state = (IBlockData)state.set((IBlockState)BlockTall.WEST, state.get((IBlockState)BlockTall.NORTH));
                state = (IBlockData)state.set((IBlockState)BlockTall.NORTH, (Comparable)Boolean.valueOf(hasEast));
            }
            this.rotated = SpigotMaterialData.ofBlockData(state);
        }
        if (rotateTimes > 1) {
            return this.rotated.rotate(rotateTimes - 1);
        }
        return this.rotated;
    }

    @Override
    public <T extends Comparable<T>> LocalMaterialData withProperty(MaterialProperty<T> materialProperty, T value) {
        BlockStateInteger property = null;
        T finalVal = value;
        if (materialProperty == MaterialProperties.AGE_0_25) {
            property = BlockProperties.ak;
        } else if (materialProperty == MaterialProperties.PICKLES_1_4) {
            property = BlockProperties.ay;
        } else if (materialProperty == MaterialProperties.SNOWY) {
            property = BlockProperties.z;
        } else if (materialProperty == MaterialProperties.AGE_0_3) {
            property = BlockProperties.ag;
        } else {
            if (materialProperty == MaterialProperties.HORIZONTAL_DIRECTION) {
                property = BlockProperties.O;
                EnumDirection direction = EnumDirection.values()[((OTGDirection)((Object)value)).ordinal()];
                return SpigotMaterialData.ofBlockData((IBlockData)this.blockData.set((IBlockState)property, (Comparable)direction));
            }
            throw new IllegalArgumentException("Unknown property: " + materialProperty);
        }
        return SpigotMaterialData.ofBlockData((IBlockData)this.blockData.set((IBlockState)property, finalVal));
    }

    @Override
    public boolean isBlockTag(LocalMaterialTag tag) {
        if (this.blockData != null) {
            SpigotMaterialTag spigotTag = (SpigotMaterialTag)tag;
            if (spigotTag.isOTGTag(this.blockData.getBlock())) {
                return true;
            }
            Tag<Block> blockTag = spigotTag.getTag();
            if (blockTag != null) {
                return this.blockData.a(blockTag);
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SpigotMaterialData)) {
            return false;
        }
        SpigotMaterialData other = (SpigotMaterialData)obj;
        return this.isBlank && other.isBlank || !this.isBlank && !other.isBlank && Objects.equals(this.blockData.getBlock(), other.blockData.getBlock());
    }

    @Override
    public int hashCode() {
        return this.blockData == null ? -1 : this.blockData.hashCode();
    }

    @Override
    public LocalMaterialData legalOrPersistentLeaves(boolean leaveIllegalLeaves) {
        if (!this.isLeaves()) {
            return this;
        }
        int i = (Integer)this.blockData.get((IBlockState)BlockLeaves.DISTANCE);
        if (i > 6) {
            return SpigotMaterialData.ofBlockData((IBlockData)this.blockData.set((IBlockState)BlockLeaves.PERSISTENT, (Comparable)Boolean.valueOf(true)));
        }
        return SpigotMaterialData.ofBlockData((IBlockData)this.blockData.set((IBlockState)BlockLeaves.PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }
}

