/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.materials;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pg85.otg.OTG;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.spigot.materials.SpigotLegacyMaterials;
import com.pg85.otg.spigot.materials.SpigotMaterialData;
import com.pg85.otg.spigot.materials.SpigotMaterialTag;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterialTag;
import com.pg85.otg.util.minecraft.BlockNames;
import net.minecraft.server.v1_16_R3.ArgumentBlock;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockLeaves;
import net.minecraft.server.v1_16_R3.Blocks;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IBlockState;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.ResourceKeyInvalidException;

public class SpigotMaterialReader
implements IMaterialReader {
    private final FifoMap<String, LocalMaterialData> cachedMaterials = new FifoMap(4096);
    private final FifoMap<String, LocalMaterialTag> cachedTags = new FifoMap(4096);

    @Override
    public LocalMaterialData readMaterial(String material) throws InvalidConfigException {
        LocalMaterialData localMaterial;
        block5: {
            if (material == null) {
                return null;
            }
            localMaterial = (LocalMaterialData)this.cachedMaterials.get(material);
            if (localMaterial != null) {
                return localMaterial;
            }
            if (this.cachedMaterials.containsKey(material)) {
                throw new InvalidConfigException("Cannot read block: " + material);
            }
            try {
                localMaterial = this.materialFromString(material);
            }
            catch (InvalidConfigException ex) {
                if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) break block5;
                OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CONFIGS, "Invalid material " + material + ". Exception: " + ex.getMessage() + ". Replacing with blank.");
            }
        }
        this.cachedMaterials.put(material, localMaterial);
        return localMaterial;
    }

    @Override
    public LocalMaterialTag readTag(String tag) throws InvalidConfigException {
        if (tag == null) {
            return null;
        }
        LocalMaterialTag localTag = (LocalMaterialTag)this.cachedTags.get(tag);
        if (localTag != null) {
            return localTag;
        }
        localTag = SpigotMaterialTag.ofString(tag);
        this.cachedTags.put(tag, localTag);
        return localTag;
    }

    private LocalMaterialData materialFromString(String input) throws InvalidConfigException {
        IBlockData blockState;
        if (input == null || input.trim().isEmpty()) {
            return null;
        }
        if (input.matches("minecraft:[A-Za-z_]+:[0-9]+")) {
            input = input.split(":")[1] + ":" + input.split(":")[2];
        }
        if (input.equalsIgnoreCase("blank")) {
            return SpigotMaterialData.blank;
        }
        String blockNameCorrected = input.trim().toLowerCase();
        if (!blockNameCorrected.contains(":")) {
            blockState = SpigotLegacyMaterials.fromLegacyBlockName(blockNameCorrected);
            if (blockState != null) {
                return SpigotMaterialData.ofBlockData(blockState, input);
            }
            try {
                int blockId;
                String fromLegacyIdName;
                if (blockNameCorrected.endsWith(".0")) {
                    blockNameCorrected = blockNameCorrected.substring(0, blockNameCorrected.length() - 2);
                }
                if ((fromLegacyIdName = BlockNames.blockNameFromLegacyBlockId(blockId = Integer.parseInt(blockNameCorrected))) != null && (blockState = SpigotLegacyMaterials.fromLegacyBlockName(blockNameCorrected = fromLegacyIdName)) != null) {
                    return SpigotMaterialData.ofBlockData(blockState, input);
                }
            }
            catch (NumberFormatException blockId) {
                // empty catch block
            }
        }
        IBlockData blockdata = null;
        try {
            String newInput = blockNameCorrected.contains(":") ? blockNameCorrected : "minecraft:" + blockNameCorrected;
            blockdata = new ArgumentBlock(new StringReader(newInput), true).a(true).getBlockData();
        }
        catch (CommandSyntaxException newInput) {
            // empty catch block
        }
        if (blockdata != null) {
            if (blockdata.getBlock() instanceof BlockLeaves) {
                return SpigotMaterialData.ofBlockData((IBlockData)blockdata.set((IBlockState)BlockLeaves.DISTANCE, (Comparable)Integer.valueOf(1)), input);
            }
            return SpigotMaterialData.ofBlockData(blockdata, input);
        }
        if (blockNameCorrected.contains(":")) {
            String blockNameOrId = blockNameCorrected.substring(0, blockNameCorrected.indexOf(":"));
            try {
                int blockId = Integer.parseInt(blockNameOrId);
                blockNameOrId = BlockNames.blockNameFromLegacyBlockId(blockId);
            }
            catch (NumberFormatException blockId) {
                // empty catch block
            }
            try {
                int data = Integer.parseInt(blockNameCorrected.substring(blockNameCorrected.indexOf(":") + 1));
                blockState = SpigotLegacyMaterials.fromLegacyBlockNameOrIdWithData(blockNameOrId, data);
                if (blockState != null) {
                    return SpigotMaterialData.ofBlockData(blockState, input);
                }
                blockNameCorrected = blockNameCorrected.substring(0, blockNameCorrected.indexOf(":"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            Block block = (Block)IRegistry.BLOCK.get(new MinecraftKey(blockNameCorrected));
            if (block != Blocks.AIR || blockNameCorrected.toLowerCase().endsWith("air")) {
                if (block instanceof BlockLeaves) {
                    return SpigotMaterialData.ofBlockData((IBlockData)block.getBlockData().set((IBlockState)BlockLeaves.DISTANCE, (Comparable)Integer.valueOf(1)), input);
                }
                return SpigotMaterialData.ofBlockData(block.getBlockData(), input);
            }
        }
        catch (ResourceKeyInvalidException resourceKeyInvalidException) {
            // empty catch block
        }
        blockState = SpigotLegacyMaterials.fromLegacyBlockName(blockNameCorrected.replace("minecraft:", ""));
        if (blockState != null) {
            return SpigotMaterialData.ofBlockData(blockState, input);
        }
        if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CONFIGS)) {
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CONFIGS, "Could not parse block: " + input + " (" + blockNameCorrected + "), substituting NOTE_BLOCK.");
        }
        return SpigotMaterialData.ofBlockData(Blocks.NOTE_BLOCK.getBlockData(), input);
    }
}

