/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.materials;

import com.pg85.otg.spigot.materials.SpigotMaterials;
import com.pg85.otg.util.materials.LocalMaterialTag;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.TagsBlock;

public class SpigotMaterialTag
extends LocalMaterialTag {
    private final String name;
    private final Tag<Block> blockTag;
    private final Block[] otgBlockTag;

    public static LocalMaterialTag ofString(String name) {
        MinecraftKey resourceLocation;
        Block[] blockTag;
        if ((!name.contains(":") || name.startsWith("otg:")) && (blockTag = SpigotMaterials.OTG_BLOCK_TAGS.get(name.trim().toLowerCase().replace("otg:", ""))) != null) {
            return new SpigotMaterialTag(blockTag, "otg:" + name.trim().toLowerCase().replace("otg:", ""));
        }
        try {
            resourceLocation = new MinecraftKey(name.trim().toLowerCase());
        }
        catch (Exception ex) {
            return null;
        }
        Tag blockTag2 = TagsBlock.b().stream().filter(n -> n.a().equals((Object)resourceLocation)).findFirst().orElse(null);
        return blockTag2 == null ? null : new SpigotMaterialTag((Tag<Block>)blockTag2, resourceLocation.toString());
    }

    private SpigotMaterialTag(Tag<Block> blockTag, String name) {
        this.otgBlockTag = null;
        this.blockTag = blockTag;
        this.name = name;
    }

    private SpigotMaterialTag(Block[] otgBlockTag, String name) {
        this.otgBlockTag = otgBlockTag;
        this.blockTag = null;
        this.name = name;
    }

    public boolean isOTGTag(Block block) {
        if (this.otgBlockTag != null) {
            for (Block otgTagBlock : this.otgBlockTag) {
                if (otgTagBlock != block) continue;
                return true;
            }
        }
        return false;
    }

    public Tag<Block> getTag() {
        return this.blockTag;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

