/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.networking;

import com.pg85.otg.OTG;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.spigot.OTGPlugin;
import com.pg85.otg.spigot.gen.OTGNoiseChunkGenerator;
import com.pg85.otg.spigot.networking.BiomeSettingSyncWrapper;
import com.pg85.otg.spigot.networking.OTGClientSyncManager;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.server.v1_16_R3.PacketDataSerializer;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class NetworkingListener
implements Listener {
    private final OTGPlugin plugin;

    public NetworkingListener(OTGPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.sendDataPacket(event.getPlayer());
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        this.sendDataPacket(event.getPlayer());
    }

    private void sendDataPacket(Player player) {
        WorldServer world = ((CraftWorld)player.getWorld()).getHandle();
        if (!(world.getChunkProvider().getChunkGenerator() instanceof OTGNoiseChunkGenerator)) {
            return;
        }
        Preset preset = ((OTGNoiseChunkGenerator)world.getChunkProvider().getChunkGenerator()).getPreset();
        PacketDataSerializer buffer = new PacketDataSerializer(Unpooled.buffer((int)32766));
        String presetName = preset.getFolderName().toLowerCase();
        buffer.writeByte(1);
        buffer.writeInt(preset.getAllBiomeConfigs().size());
        buffer.a(presetName);
        for (IBiomeConfig biome : preset.getAllBiomeConfigs()) {
            String key = biome.getRegistryKey().toResourceLocationString();
            BiomeSettingSyncWrapper wrapper = OTGClientSyncManager.getSyncedData().get(key);
            if (wrapper == null) continue;
            buffer.a(key.replace("otg:" + presetName + ".", ""));
            wrapper.encode((ByteBuf)buffer);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.MAIN, "Sending sync data of size " + buffer.writerIndex() + " bytes to " + player.getName() + ".");
            player.sendPluginMessage((Plugin)this.plugin, "otg:spigot", buffer.array());
        }, 100L);
    }
}

