/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.presets;

import com.mojang.serialization.Lifecycle;
import com.pg85.otg.OTG;
import com.pg85.otg.config.biome.BiomeConfigFinder;
import com.pg85.otg.config.biome.BiomeGroup;
import com.pg85.otg.config.world.WorldConfig;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.gen.biome.BiomeData;
import com.pg85.otg.gen.biome.layers.BiomeLayerData;
import com.pg85.otg.gen.biome.layers.NewBiomeGroup;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IBiomeResourceLocation;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.presets.LocalPresetLoader;
import com.pg85.otg.presets.Preset;
import com.pg85.otg.spigot.biome.SpigotBiome;
import com.pg85.otg.spigot.materials.SpigotMaterialReader;
import com.pg85.otg.spigot.networking.BiomeSettingSyncWrapper;
import com.pg85.otg.spigot.networking.OTGClientSyncManager;
import com.pg85.otg.spigot.util.MobSpawnGroupHelper;
import com.pg85.otg.util.biome.OTGBiomeResourceLocation;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.minecraft.EntityCategory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.EnumCreatureType;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.IRegistryWritable;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.RegistryGeneration;
import net.minecraft.server.v1_16_R3.ResourceKey;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;

public class SpigotPresetLoader
extends LocalPresetLoader {
    private final Map<String, List<ResourceKey<BiomeBase>>> biomesByPresetFolderName = new LinkedHashMap<String, List<ResourceKey<BiomeBase>>>();
    private final HashMap<String, IBiome[]> globalIdMapping = new HashMap();
    private final Map<String, BiomeLayerData> presetGenerationData = new HashMap<String, BiomeLayerData>();
    private final Map<BiomeBase, IBiomeConfig> biomeConfigsByBiome = new HashMap<BiomeBase, IBiomeConfig>();
    private final ResourceKey<IRegistry<BiomeBase>> BIOME_KEY = IRegistry.ay;

    public SpigotPresetLoader(File otgRootFolder) {
        super(otgRootFolder.toPath());
    }

    @Override
    public IMaterialReader createMaterialReader() {
        return new SpigotMaterialReader();
    }

    @Override
    public void registerBiomes() {
        for (Preset preset : this.presets.values()) {
            this.registerBiomesForPreset(false, preset);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void registerBiomesForPreset(boolean refresh, Preset preset) {
        IRegistryWritable biomeRegistry = ((CraftServer)Bukkit.getServer()).getServer().customRegistry.b(this.BIOME_KEY);
        HashMap<Integer, Integer> biomeColorMap = new HashMap<Integer, Integer>();
        int currentId = 1;
        ArrayList<ResourceKey> presetBiomes = new ArrayList<ResourceKey>();
        this.biomesByPresetFolderName.put(preset.getFolderName(), presetBiomes);
        IWorldConfig worldConfig = preset.getWorldConfig();
        IBiomeConfig oceanBiomeConfig = null;
        int[] oceanTemperatures = new int[]{0, 0, 0, 0};
        ArrayList<IBiomeConfig> biomeConfigs = preset.getAllBiomeConfigs();
        HashMap<Integer, List<BiomeData>> isleBiomesAtDepth = new HashMap<Integer, List<BiomeData>>();
        HashMap<Integer, List<BiomeData>> borderBiomesAtDepth = new HashMap<Integer, List<BiomeData>>();
        HashMap<String, List<Integer>> worldBiomes = new HashMap<String, List<Integer>>();
        HashMap<String, IBiomeConfig> biomeConfigsByName = new HashMap<String, IBiomeConfig>();
        LinkedHashMap<OTGBiomeResourceLocation, IBiomeConfig> biomeConfigsByResourceLocation = new LinkedHashMap<OTGBiomeResourceLocation, IBiomeConfig>();
        for (IBiomeConfig iBiomeConfig : biomeConfigs) {
            if (iBiomeConfig.getIsTemplateForBiome()) continue;
            OTGBiomeResourceLocation oTGBiomeResourceLocation = new OTGBiomeResourceLocation(preset.getPresetFolder(), preset.getShortPresetName(), preset.getMajorVersion(), iBiomeConfig.getName());
            biomeConfigsByResourceLocation.put(oTGBiomeResourceLocation, iBiomeConfig);
            biomeConfigsByName.put(iBiomeConfig.getName(), iBiomeConfig);
        }
        IBiome[] presetIdMapping = new IBiome[biomeConfigsByResourceLocation.entrySet().size()];
        for (Map.Entry entry : biomeConfigsByResourceLocation.entrySet()) {
            List biomesAtDepth;
            boolean isOceanBiome = false;
            if (((IBiomeConfig)entry.getValue()).getName().equals(worldConfig.getDefaultOceanBiome())) {
                oceanBiomeConfig = (IBiomeConfig)entry.getValue();
                isOceanBiome = true;
            }
            int otgBiomeId = isOceanBiome ? 0 : currentId;
            MinecraftKey resourceLocation = new MinecraftKey(((IBiomeResourceLocation)entry.getKey()).toResourceLocationString());
            if (!(entry.getKey() instanceof OTGBiomeResourceLocation)) {
                if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) continue;
                OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.BIOME_REGISTRY, "Could not process template biomeconfig " + ((IBiomeConfig)entry.getValue()).getName() + ", did you set TemplateForBiome:true in the BiomeConfig?");
                continue;
            }
            ((IBiomeConfig)entry.getValue()).setRegistryKey((IBiomeResourceLocation)entry.getKey());
            ((IBiomeConfig)entry.getValue()).setOTGBiomeId(otgBiomeId);
            ResourceKey registryKey = ResourceKey.a(this.BIOME_KEY, (MinecraftKey)resourceLocation);
            presetBiomes.add(registryKey);
            BiomeBase biome = SpigotBiome.createOTGBiome(isOceanBiome, preset.getWorldConfig(), (IBiomeConfig)entry.getValue());
            if (!refresh) {
                biomeRegistry.a(registryKey, (Object)biome, Lifecycle.experimental());
            } else {
                biomeRegistry.a(OptionalInt.empty(), registryKey, (Object)biome, Lifecycle.experimental());
            }
            OTGClientSyncManager.getSyncedData().put(resourceLocation.toString(), new BiomeSettingSyncWrapper((IBiomeConfig)entry.getValue()));
            if (((IBiomeConfig)entry.getValue()).getName().equals(worldConfig.getDefaultWarmOceanBiome())) {
                oceanTemperatures[0] = otgBiomeId;
            }
            if (((IBiomeConfig)entry.getValue()).getName().equals(worldConfig.getDefaultLukewarmOceanBiome())) {
                oceanTemperatures[1] = otgBiomeId;
            }
            if (((IBiomeConfig)entry.getValue()).getName().equals(worldConfig.getDefaultColdOceanBiome())) {
                oceanTemperatures[2] = otgBiomeId;
            }
            if (((IBiomeConfig)entry.getValue()).getName().equals(worldConfig.getDefaultFrozenOceanBiome())) {
                oceanTemperatures[3] = otgBiomeId;
            }
            SpigotBiome otgBiome = new SpigotBiome(biome, (IBiomeConfig)entry.getValue());
            if (otgBiomeId >= presetIdMapping.length) {
                OTG.getEngine().getLogger().log(LogLevel.FATAL, LogCategory.CONFIGS, "Fatal error while registering OTG biome id's for preset " + preset.getFolderName() + ", most likely you've assigned a DefaultOceanBiome that doesn't exist.");
                throw new RuntimeException("Fatal error while registering OTG biome id's for preset " + preset.getFolderName() + ", most likely you've assigned a DefaultOceanBiome that doesn't exist.");
            }
            presetIdMapping[otgBiomeId] = otgBiome;
            ArrayList<Integer> idsForBiome = (ArrayList<Integer>)worldBiomes.get(((IBiomeConfig)entry.getValue()).getName());
            if (idsForBiome == null) {
                idsForBiome = new ArrayList<Integer>();
                worldBiomes.put(((IBiomeConfig)entry.getValue()).getName(), idsForBiome);
            }
            idsForBiome.add(otgBiomeId);
            if (((IBiomeConfig)entry.getValue()).isIsleBiome()) {
                biomesAtDepth = isleBiomesAtDepth.getOrDefault(worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeSize() : ((IBiomeConfig)entry.getValue()).getBiomeSizeWhenIsle(), new ArrayList());
                biomesAtDepth.add(new BiomeData(otgBiomeId, worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeRarity() : ((IBiomeConfig)entry.getValue()).getBiomeRarityWhenIsle(), worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeSize() : ((IBiomeConfig)entry.getValue()).getBiomeSizeWhenIsle(), ((IBiomeConfig)entry.getValue()).getBiomeTemperature(), ((IBiomeConfig)entry.getValue()).getIsleInBiomes(), ((IBiomeConfig)entry.getValue()).getBorderInBiomes(), ((IBiomeConfig)entry.getValue()).getOnlyBorderNearBiomes(), ((IBiomeConfig)entry.getValue()).getNotBorderNearBiomes()));
                isleBiomesAtDepth.put(worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeSize() : ((IBiomeConfig)entry.getValue()).getBiomeSizeWhenIsle(), biomesAtDepth);
            }
            if (((IBiomeConfig)entry.getValue()).isBorderBiome()) {
                biomesAtDepth = borderBiomesAtDepth.getOrDefault(worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeSize() : ((IBiomeConfig)entry.getValue()).getBiomeSizeWhenBorder(), new ArrayList());
                biomesAtDepth.add(new BiomeData(otgBiomeId, ((IBiomeConfig)entry.getValue()).getBiomeRarity(), worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeSize() : ((IBiomeConfig)entry.getValue()).getBiomeSizeWhenBorder(), ((IBiomeConfig)entry.getValue()).getBiomeTemperature(), ((IBiomeConfig)entry.getValue()).getIsleInBiomes(), ((IBiomeConfig)entry.getValue()).getBorderInBiomes(), ((IBiomeConfig)entry.getValue()).getOnlyBorderNearBiomes(), ((IBiomeConfig)entry.getValue()).getNotBorderNearBiomes()));
                borderBiomesAtDepth.put(worldConfig.getBiomeMode() == SettingsEnums.BiomeMode.NoGroups ? ((IBiomeConfig)entry.getValue()).getBiomeSize() : ((IBiomeConfig)entry.getValue()).getBiomeSizeWhenBorder(), biomesAtDepth);
            }
            biomeColorMap.put(((IBiomeConfig)entry.getValue()).getBiomeColor(), otgBiomeId);
            if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.BIOME_REGISTRY)) {
                OTG.getEngine().getLogger().log(LogLevel.INFO, LogCategory.BIOME_REGISTRY, "Registered biome " + resourceLocation.toString() + " | " + ((IBiomeConfig)entry.getValue()).getName() + " with OTG id " + otgBiomeId);
            }
            currentId += isOceanBiome ? 0 : 1;
        }
        if (oceanBiomeConfig == null) {
            System.arraycopy(presetIdMapping, 1, presetIdMapping, 0, presetIdMapping.length - 1);
        }
        this.globalIdMapping.put(preset.getFolderName(), presetIdMapping);
        BiomeLayerData biomeLayerData = new BiomeLayerData(preset.getPresetFolder(), worldConfig, oceanBiomeConfig, oceanTemperatures);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashMap<Integer, List<NewBiomeGroup>> groupDepths = new HashMap<Integer, List<NewBiomeGroup>>();
        int genDepth = worldConfig.getGenerationDepth();
        for (BiomeGroup group : ((WorldConfig)worldConfig).getBiomeGroupManager().getGroups()) {
            IBiomeConfig config;
            NewBiomeGroup bg = new NewBiomeGroup();
            bg.id = group.getGroupId();
            bg.rarity = group.getGroupRarity();
            bg.totalDepthRarity = new int[genDepth + 1];
            bg.maxRarityPerDepth = new int[genDepth + 1];
            float totalTemp = 0.0f;
            LinkedHashMap<String, IBiomeConfig> groupBiomes = new LinkedHashMap<String, IBiomeConfig>();
            for (String string : group.getBiomes()) {
                config = (IBiomeConfig)biomeConfigsByName.get(string);
                if (config == null) continue;
                groupBiomes.put(string, config);
            }
            for (Map.Entry entry : ((HashMap)groupBiomes).entrySet()) {
                if (entry.getValue() == null) continue;
                config = (IBiomeConfig)entry.getValue();
                BiomeData newBiomeData = new BiomeData(config.getOTGBiomeId(), config.getBiomeRarity(), config.getBiomeSize(), config.getBiomeTemperature(), config.getIsleInBiomes(), config.getBorderInBiomes(), config.getOnlyBorderNearBiomes(), config.getNotBorderNearBiomes());
                bg.biomes.add(newBiomeData);
                hashSet.add(config.getBiomeSize());
                totalTemp += config.getBiomeTemperature();
                bg.totalGroupRarity += config.getBiomeRarity();
                int n = config.getBiomeSize();
                bg.totalDepthRarity[n] = bg.totalDepthRarity[n] + config.getBiomeRarity();
            }
            for (int depth = 0; depth < bg.totalDepthRarity.length; ++depth) {
                void var27_43;
                int n = depth;
                while (var27_43 < bg.totalDepthRarity.length) {
                    int n2 = depth;
                    bg.maxRarityPerDepth[n2] = bg.maxRarityPerDepth[n2] + bg.totalDepthRarity[var27_43];
                    ++var27_43;
                }
            }
            bg.avgTemp = totalTemp / (float)group.getBiomes().size();
            int groupSize = group.getGenerationDepth();
            List list = groupDepths.getOrDefault(groupSize, new ArrayList());
            list.add(bg);
            groupDepths.put(groupSize, list);
            biomeLayerData.groupRegistry.put(bg.id, bg);
        }
        biomeLayerData.init(hashSet, groupDepths, isleBiomesAtDepth, borderBiomesAtDepth, worldBiomes, biomeColorMap, presetIdMapping);
        this.presetGenerationData.put(preset.getFolderName(), biomeLayerData);
    }

    public IBiomeConfig getBiomeConfig(BiomeBase biome) {
        return this.biomeConfigsByBiome.get(biome);
    }

    public List<ResourceKey<BiomeBase>> getBiomeRegistryKeys(String presetFolderName) {
        return this.biomesByPresetFolderName.get(presetFolderName);
    }

    public IBiome[] getGlobalIdMapping(String presetFolderName) {
        return this.globalIdMapping.get(presetFolderName);
    }

    public Map<String, BiomeLayerData> getPresetGenerationData() {
        HashMap<String, BiomeLayerData> clonedData = new HashMap<String, BiomeLayerData>();
        for (Map.Entry<String, BiomeLayerData> entry : this.presetGenerationData.entrySet()) {
            clonedData.put(entry.getKey(), new BiomeLayerData(entry.getValue()));
        }
        return clonedData;
    }

    @Override
    protected void mergeVanillaBiomeMobSpawnSettings(BiomeConfigFinder.BiomeConfigStub biomeConfigStub, String biomeResourceLocation) {
        String[] resourceLocationArr = biomeResourceLocation.split(":");
        String resourceDomain = resourceLocationArr.length > 1 ? resourceLocationArr[0] : null;
        String resourceLocation = resourceLocationArr.length > 1 ? resourceLocationArr[1] : resourceLocationArr[0];
        NamespacedKey location = null;
        try {
            location = new NamespacedKey(resourceDomain, resourceLocation);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (location != null) {
            Biome biome = (Biome)Registry.BIOME.get(location);
            BiomeBase biomeBase = null;
            if (biome != null) {
                biomeBase = (BiomeBase)RegistryGeneration.WORLDGEN_BIOME.get(new MinecraftKey(biome.getKey().toString()));
            }
            if (biomeBase != null) {
                biomeConfigStub.mergeMobs(MobSpawnGroupHelper.getListFromMinecraftBiome(biomeBase, EnumCreatureType.MONSTER), EntityCategory.MONSTER);
                biomeConfigStub.mergeMobs(MobSpawnGroupHelper.getListFromMinecraftBiome(biomeBase, EnumCreatureType.AMBIENT), EntityCategory.AMBIENT_CREATURE);
                biomeConfigStub.mergeMobs(MobSpawnGroupHelper.getListFromMinecraftBiome(biomeBase, EnumCreatureType.CREATURE), EntityCategory.CREATURE);
                biomeConfigStub.mergeMobs(MobSpawnGroupHelper.getListFromMinecraftBiome(biomeBase, EnumCreatureType.WATER_AMBIENT), EntityCategory.WATER_AMBIENT);
                biomeConfigStub.mergeMobs(MobSpawnGroupHelper.getListFromMinecraftBiome(biomeBase, EnumCreatureType.WATER_CREATURE), EntityCategory.WATER_CREATURE);
                biomeConfigStub.mergeMobs(MobSpawnGroupHelper.getListFromMinecraftBiome(biomeBase, EnumCreatureType.MISC), EntityCategory.MISC);
                return;
            }
        }
        if (OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.MOBS)) {
            OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.MOBS, "Could not inherit mobs for unrecognised biome \"" + biomeResourceLocation + "\" in " + biomeConfigStub.getBiomeName() + ".bc");
        }
    }
}

