/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Stack;
import java.util.regex.Pattern;
import net.minecraft.server.v1_16_R3.NBTBase;
import net.minecraft.server.v1_16_R3.NBTTagByte;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.NBTTagDouble;
import net.minecraft.server.v1_16_R3.NBTTagFloat;
import net.minecraft.server.v1_16_R3.NBTTagInt;
import net.minecraft.server.v1_16_R3.NBTTagIntArray;
import net.minecraft.server.v1_16_R3.NBTTagList;
import net.minecraft.server.v1_16_R3.NBTTagLong;
import net.minecraft.server.v1_16_R3.NBTTagShort;
import net.minecraft.server.v1_16_R3.NBTTagString;

public class JsonToNBT {
    private static final Pattern INT_ARRAY_MATCHER = Pattern.compile("\\[[-+\\d|,\\s]+\\]");

    public static NBTTagCompound getTagFromJson(String jsonString) {
        if (!(jsonString = jsonString.trim()).startsWith("{")) {
            return null;
        }
        if (JsonToNBT.topTagsCount(jsonString) != 1) {
            return null;
        }
        return (NBTTagCompound)JsonToNBT.nameValueToNBT("tag", jsonString).parse();
    }

    private static int topTagsCount(String str) {
        int i = 0;
        boolean flag = false;
        Stack<Character> stack = new Stack<Character>();
        for (int j = 0; j < str.length(); ++j) {
            char c0 = str.charAt(j);
            if (c0 == '\"') {
                if (JsonToNBT.isCharEscaped(str, j)) {
                    if (flag) continue;
                    return -1;
                }
                flag = !flag;
                continue;
            }
            if (flag) continue;
            if (c0 != '{' && c0 != '[') {
                if (c0 == '}' && (stack.isEmpty() || ((Character)stack.pop()).charValue() != '{')) {
                    return -1;
                }
                if (c0 != ']' || !stack.isEmpty() && ((Character)stack.pop()).charValue() == '[') continue;
                return -1;
            }
            if (stack.isEmpty()) {
                ++i;
            }
            stack.push(Character.valueOf(c0));
        }
        if (flag) {
            return -1;
        }
        if (!stack.isEmpty()) {
            return -1;
        }
        if (i == 0 && !str.isEmpty()) {
            i = 1;
        }
        return i;
    }

    private static String nextNameValuePair(String str, boolean isCompound) {
        int i = JsonToNBT.getNextCharIndex(str, ':');
        int j = JsonToNBT.getNextCharIndex(str, ',');
        if (isCompound) {
            if (i == -1) {
                return null;
            }
            if (j != -1 && j < i) {
                return null;
            }
        } else if (i == -1 || i > j) {
            i = -1;
        }
        return JsonToNBT.locateValueAt(str, i);
    }

    private static Any getTagFromNameValue(String str, boolean isArray) {
        String s = JsonToNBT.locateName(str, isArray);
        String s1 = JsonToNBT.locateValue(str, isArray);
        return JsonToNBT.joinStrToNBT(s, s1);
    }

    private static String locateValueAt(String str, int index) {
        int i;
        Stack<Character> stack = new Stack<Character>();
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        int j = 0;
        for (i = index + 1; i < str.length(); ++i) {
            char c0 = str.charAt(i);
            if (c0 == '\"') {
                if (JsonToNBT.isCharEscaped(str, i)) {
                    if (!flag) {
                        return null;
                    }
                } else {
                    boolean bl = flag = !flag;
                    if (flag && !flag2) {
                        flag1 = true;
                    }
                    if (!flag) {
                        j = i;
                    }
                }
            } else if (!flag) {
                if (c0 != '{' && c0 != '[') {
                    if (c0 == '}' && (stack.isEmpty() || ((Character)stack.pop()).charValue() != '{')) {
                        return null;
                    }
                    if (c0 == ']' && (stack.isEmpty() || ((Character)stack.pop()).charValue() != '[')) {
                        return null;
                    }
                    if (c0 == ',' && stack.isEmpty()) {
                        return str.substring(0, i);
                    }
                } else {
                    stack.push(Character.valueOf(c0));
                }
            }
            if (Character.isWhitespace(c0)) continue;
            if (!flag && flag1 && j != i) {
                return str.substring(0, j + 1);
            }
            flag2 = true;
        }
        return str.substring(0, i);
    }

    private static String locateName(String str, boolean isArray) {
        if (isArray && ((str = str.trim()).startsWith("{") || str.startsWith("["))) {
            return "";
        }
        int i = JsonToNBT.getNextCharIndex(str, ':');
        if (i == -1) {
            if (isArray) {
                return "";
            }
            return null;
        }
        return str.substring(0, i).trim();
    }

    private static String locateValue(String str, boolean isArray) {
        if (isArray && ((str = str.trim()).startsWith("{") || str.startsWith("["))) {
            return str;
        }
        int i = JsonToNBT.getNextCharIndex(str, ':');
        if (i == -1) {
            if (isArray) {
                return str;
            }
            return null;
        }
        return str.substring(i + 1).trim();
    }

    private static int getNextCharIndex(String str, char targetChar) {
        boolean flag = true;
        for (int i = 0; i < str.length(); ++i) {
            char c0 = str.charAt(i);
            if (c0 == '\"') {
                if (JsonToNBT.isCharEscaped(str, i)) continue;
                flag = !flag;
                continue;
            }
            if (!flag) continue;
            if (c0 == targetChar) {
                return i;
            }
            if (c0 != '{' && c0 != '[') continue;
            return -1;
        }
        return -1;
    }

    private static boolean isCharEscaped(String str, int index) {
        return index > 0 && str.charAt(index - 1) == '\\' && !JsonToNBT.isCharEscaped(str, index - 1);
    }

    private static Any joinStrToNBT(String ... args) {
        return JsonToNBT.nameValueToNBT(args[0], args[1]);
    }

    private static Any nameValueToNBT(String key, String value) {
        if ((value = value.trim()).startsWith("{")) {
            value = value.substring(1, value.length() - 1);
            Compound jsontonbt$compound = new Compound(key);
            while (value.length() > 0) {
                String s1 = JsonToNBT.nextNameValuePair(value, true);
                if (s1.length() > 0) {
                    jsontonbt$compound.tagList.add(JsonToNBT.getTagFromNameValue(s1, false));
                }
                if (value.length() < s1.length() + 1) break;
                char c1 = value.charAt(s1.length());
                if (c1 != ',' && c1 != '{' && c1 != '}' && c1 != '[' && c1 != ']') {
                    return null;
                }
                value = value.substring(s1.length() + 1);
            }
            return jsontonbt$compound;
        }
        if (value.startsWith("[") && !INT_ARRAY_MATCHER.matcher(value).matches()) {
            value = value.substring(1, value.length() - 1);
            List jsontonbt$list = new List(key);
            while (value.length() > 0) {
                String s = JsonToNBT.nextNameValuePair(value, false);
                if (s.length() > 0) {
                    jsontonbt$list.tagList.add(JsonToNBT.getTagFromNameValue(s, true));
                }
                if (value.length() < s.length() + 1) break;
                char c0 = value.charAt(s.length());
                if (c0 != ',' && c0 != '{' && c0 != '}' && c0 != '[' && c0 != ']') {
                    return null;
                }
                value = value.substring(s.length() + 1);
            }
            return jsontonbt$list;
        }
        return new Primitive(key, value);
    }

    static class Primitive
    extends Any {
        private static final Pattern DOUBLE = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+[d|D]");
        private static final Pattern FLOAT = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+[f|F]");
        private static final Pattern BYTE = Pattern.compile("[-+]?[0-9]+[b|B]");
        private static final Pattern LONG = Pattern.compile("[-+]?[0-9]+[l|L]");
        private static final Pattern SHORT = Pattern.compile("[-+]?[0-9]+[s|S]");
        private static final Pattern INTEGER = Pattern.compile("[-+]?[0-9]+");
        private static final Pattern DOUBLE_UNTYPED = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+");
        private static final Splitter SPLITTER = Splitter.on((char)',').omitEmptyStrings();
        private String jsonValue;

        private Primitive(String jsonIn, String valueIn) {
            this.json = jsonIn;
            this.jsonValue = valueIn;
        }

        @Override
        public NBTBase parse() {
            try {
                if (DOUBLE.matcher(this.jsonValue).matches()) {
                    return NBTTagDouble.a((double)Double.parseDouble(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (FLOAT.matcher(this.jsonValue).matches()) {
                    return NBTTagFloat.a((float)Float.parseFloat(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (BYTE.matcher(this.jsonValue).matches()) {
                    return NBTTagByte.a((byte)Byte.parseByte(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (LONG.matcher(this.jsonValue).matches()) {
                    return NBTTagLong.a((long)Long.parseLong(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (SHORT.matcher(this.jsonValue).matches()) {
                    return NBTTagShort.a((short)Short.parseShort(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (INTEGER.matcher(this.jsonValue).matches()) {
                    return NBTTagInt.a((int)Integer.parseInt(this.jsonValue));
                }
                if (DOUBLE_UNTYPED.matcher(this.jsonValue).matches()) {
                    return NBTTagDouble.a((double)Double.parseDouble(this.jsonValue));
                }
                if ("true".equalsIgnoreCase(this.jsonValue) || "false".equalsIgnoreCase(this.jsonValue)) {
                    return NBTTagByte.a((byte)((byte)(Boolean.parseBoolean(this.jsonValue) ? 1 : 0)));
                }
            }
            catch (NumberFormatException var6) {
                this.jsonValue = this.jsonValue.replaceAll("\\\\\"", "\"");
                return NBTTagString.a((String)this.jsonValue);
            }
            if (this.jsonValue.startsWith("[") && this.jsonValue.endsWith("]")) {
                String s = this.jsonValue.substring(1, this.jsonValue.length() - 1);
                String[] astring = (String[])Iterables.toArray((Iterable)SPLITTER.split((CharSequence)s), String.class);
                try {
                    int[] aint = new int[astring.length];
                    for (int j = 0; j < astring.length; ++j) {
                        aint[j] = Integer.parseInt(astring[j].trim());
                    }
                    return new NBTTagIntArray(aint);
                }
                catch (NumberFormatException var5) {
                    return NBTTagString.a((String)this.jsonValue);
                }
            }
            if (this.jsonValue.startsWith("\"") && this.jsonValue.endsWith("\"")) {
                this.jsonValue = this.jsonValue.substring(1, this.jsonValue.length() - 1);
            }
            this.jsonValue = this.jsonValue.replaceAll("\\\\\"", "\"");
            StringBuilder stringbuilder = new StringBuilder();
            for (int i = 0; i < this.jsonValue.length(); ++i) {
                if (i < this.jsonValue.length() - 1 && this.jsonValue.charAt(i) == '\\' && this.jsonValue.charAt(i + 1) == '\\') {
                    stringbuilder.append('\\');
                    ++i;
                    continue;
                }
                stringbuilder.append(this.jsonValue.charAt(i));
            }
            return NBTTagString.a((String)stringbuilder.toString());
        }
    }

    static class List
    extends Any {
        private java.util.List<Any> tagList = Lists.newArrayList();

        private List(String json) {
            this.json = json;
        }

        @Override
        public NBTBase parse() {
            NBTTagList nbttaglist = new NBTTagList();
            for (Any jsontonbt$any : this.tagList) {
                nbttaglist.add((Object)jsontonbt$any.parse());
            }
            return nbttaglist;
        }
    }

    static class Compound
    extends Any {
        private java.util.List<Any> tagList = Lists.newArrayList();

        private Compound(String jsonIn) {
            this.json = jsonIn;
        }

        @Override
        public NBTBase parse() {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            for (Any jsontonbt$any : this.tagList) {
                nbttagcompound.set(jsontonbt$any.json, jsontonbt$any.parse());
            }
            return nbttagcompound;
        }
    }

    static abstract class Any {
        String json;

        Any() {
        }

        public abstract NBTBase parse();
    }
}

