/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.spigot.util;

import com.pg85.otg.OTG;
import com.pg85.otg.spigot.gen.SpigotWorldGenRegion;
import com.pg85.otg.util.gen.LocalWorldGenRegion;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.nbt.LocalNBTHelper;
import com.pg85.otg.util.nbt.NamedBinaryTag;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Map;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.NBTBase;
import net.minecraft.server.v1_16_R3.NBTTagByte;
import net.minecraft.server.v1_16_R3.NBTTagByteArray;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.NBTTagDouble;
import net.minecraft.server.v1_16_R3.NBTTagFloat;
import net.minecraft.server.v1_16_R3.NBTTagInt;
import net.minecraft.server.v1_16_R3.NBTTagIntArray;
import net.minecraft.server.v1_16_R3.NBTTagList;
import net.minecraft.server.v1_16_R3.NBTTagLong;
import net.minecraft.server.v1_16_R3.NBTTagShort;
import net.minecraft.server.v1_16_R3.NBTTagString;
import net.minecraft.server.v1_16_R3.TileEntity;

public class SpigotNBTHelper
extends LocalNBTHelper {
    @Override
    public NamedBinaryTag getNBTFromLocation(LocalWorldGenRegion world, int x, int y, int z) {
        TileEntity tileEntity = ((SpigotWorldGenRegion)world).getTileEntity(new BlockPosition(x, y, z));
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound nmsTag = new NBTTagCompound();
        tileEntity.save(nmsTag);
        nmsTag.remove("x");
        nmsTag.remove("y");
        nmsTag.remove("z");
        return SpigotNBTHelper.getNBTFromNMSTagCompound(null, nmsTag);
    }

    public static NamedBinaryTag getNBTFromNMSTagCompound(String name, NBTTagCompound nmsTag) {
        Map nmsChildTags;
        NamedBinaryTag compoundTag;
        block9: {
            compoundTag = new NamedBinaryTag(NamedBinaryTag.Type.TAG_Compound, name, (Object)new NamedBinaryTag[]{new NamedBinaryTag(NamedBinaryTag.Type.TAG_End, null, (Object)null)});
            nmsChildTags = null;
            try {
                Field mapField = NBTTagCompound.class.getDeclaredField("map");
                mapField.setAccessible(true);
                nmsChildTags = (Map)mapField.get(nmsTag);
            }
            catch (Exception e2) {
                if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) break block9;
                OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, String.format("SpigotNBTHelper: ", e2.getStackTrace()));
            }
        }
        if (nmsChildTags == null) {
            return compoundTag;
        }
        for (Map.Entry entry : nmsChildTags.entrySet()) {
            NBTBase nmsChildTag = (NBTBase)entry.getValue();
            NamedBinaryTag.Type type = NamedBinaryTag.Type.values()[nmsChildTag.getTypeId()];
            switch (type) {
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    compoundTag.addTag(new NamedBinaryTag(type, (String)entry.getKey(), SpigotNBTHelper.getValueFromNms(nmsChildTag)));
                    break;
                }
                case TAG_List: {
                    NamedBinaryTag listChildTag = SpigotNBTHelper.getNBTFromNMSTagList((String)entry.getKey(), (NBTTagList)nmsChildTag);
                    if (listChildTag == null) break;
                    compoundTag.addTag(listChildTag);
                    break;
                }
                case TAG_Compound: {
                    compoundTag.addTag(SpigotNBTHelper.getNBTFromNMSTagCompound((String)entry.getKey(), (NBTTagCompound)nmsChildTag));
                    break;
                }
            }
        }
        return compoundTag;
    }

    private static NamedBinaryTag getNBTFromNMSTagList(String name, NBTTagList nmsListTag) {
        if (nmsListTag.size() == 0) {
            return null;
        }
        NamedBinaryTag.Type listType = NamedBinaryTag.Type.values()[nmsListTag.d_()];
        NamedBinaryTag listTag = new NamedBinaryTag(name, listType);
        block7: for (int i = 0; i < nmsListTag.size(); ++i) {
            switch (listType) {
                case TAG_Int_Array: {
                    listTag.addTag(new NamedBinaryTag(listType, null, nmsListTag.d(i)));
                    continue block7;
                }
                case TAG_Float: {
                    listTag.addTag(new NamedBinaryTag(listType, null, Float.valueOf(nmsListTag.i(i))));
                    continue block7;
                }
                case TAG_Double: {
                    listTag.addTag(new NamedBinaryTag(listType, null, nmsListTag.f(i)));
                    continue block7;
                }
                case TAG_String: {
                    listTag.addTag(new NamedBinaryTag(listType, null, nmsListTag.getString(i)));
                    continue block7;
                }
                case TAG_Compound: {
                    listTag.addTag(SpigotNBTHelper.getNBTFromNMSTagCompound(null, (NBTTagCompound)nmsListTag.get(i)));
                    continue block7;
                }
                default: {
                    if (!OTG.getEngine().getLogger().getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) continue block7;
                    OTG.getEngine().getLogger().log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, MessageFormat.format("Cannot convert list subtype {0} from it's NMS value", new Object[]{listType}));
                }
            }
        }
        return listTag;
    }

    private static Object getValueFromNms(NBTBase nmsTag) {
        NamedBinaryTag.Type type = NamedBinaryTag.Type.values()[nmsTag.getTypeId()];
        switch (type) {
            case TAG_Byte: {
                return ((NBTTagByte)nmsTag).asByte();
            }
            case TAG_Short: {
                return ((NBTTagShort)nmsTag).asShort();
            }
            case TAG_Int: {
                return ((NBTTagInt)nmsTag).asInt();
            }
            case TAG_Long: {
                return ((NBTTagLong)nmsTag).asLong();
            }
            case TAG_Float: {
                return Float.valueOf(((NBTTagFloat)nmsTag).asFloat());
            }
            case TAG_Double: {
                return ((NBTTagDouble)nmsTag).asDouble();
            }
            case TAG_Byte_Array: {
                return ((NBTTagByteArray)nmsTag).getBytes();
            }
            case TAG_String: {
                return nmsTag.asString();
            }
            case TAG_Int_Array: {
                return ((NBTTagIntArray)nmsTag).getInts();
            }
        }
        throw new IllegalArgumentException((Object)((Object)type) + "doesn't have a simple value!");
    }

    public static NBTTagCompound getNMSFromNBTTagCompound(NamedBinaryTag compoundTag) {
        NamedBinaryTag[] childTags;
        NBTTagCompound nmsTag = new NBTTagCompound();
        block5: for (NamedBinaryTag tag : childTags = (NamedBinaryTag[])compoundTag.getValue()) {
            switch (tag.getType()) {
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    nmsTag.set(tag.getName(), SpigotNBTHelper.createTagNms(tag.getType(), tag.getValue()));
                    continue block5;
                }
                case TAG_List: {
                    nmsTag.set(tag.getName(), (NBTBase)SpigotNBTHelper.getNMSFromNBTTagList(tag));
                    continue block5;
                }
                case TAG_Compound: {
                    nmsTag.set(tag.getName(), (NBTBase)SpigotNBTHelper.getNMSFromNBTTagCompound(tag));
                    continue block5;
                }
            }
        }
        return nmsTag;
    }

    private static NBTTagList getNMSFromNBTTagList(NamedBinaryTag listTag) {
        NamedBinaryTag[] childTags;
        NBTTagList nmsTag = new NBTTagList();
        block5: for (NamedBinaryTag tag : childTags = (NamedBinaryTag[])listTag.getValue()) {
            switch (tag.getType()) {
                case TAG_Byte: 
                case TAG_Short: 
                case TAG_Int: 
                case TAG_Long: 
                case TAG_Float: 
                case TAG_Double: 
                case TAG_Byte_Array: 
                case TAG_String: 
                case TAG_Int_Array: {
                    nmsTag.add((Object)SpigotNBTHelper.createTagNms(tag.getType(), tag.getValue()));
                    continue block5;
                }
                case TAG_List: {
                    nmsTag.add((Object)SpigotNBTHelper.getNMSFromNBTTagList(tag));
                    continue block5;
                }
                case TAG_Compound: {
                    nmsTag.add((Object)SpigotNBTHelper.getNMSFromNBTTagCompound(tag));
                    continue block5;
                }
            }
        }
        return nmsTag;
    }

    private static NBTBase createTagNms(NamedBinaryTag.Type type, Object value) {
        switch (type) {
            case TAG_Byte: {
                return NBTTagByte.a((byte)((Byte)value));
            }
            case TAG_Short: {
                return NBTTagShort.a((short)((Short)value));
            }
            case TAG_Int: {
                return NBTTagInt.a((int)((Integer)value));
            }
            case TAG_Long: {
                return NBTTagLong.a((long)((Long)value));
            }
            case TAG_Float: {
                return NBTTagFloat.a((float)((Float)value).floatValue());
            }
            case TAG_Double: {
                return NBTTagDouble.a((double)((Double)value));
            }
            case TAG_Byte_Array: {
                return new NBTTagByteArray((byte[])value);
            }
            case TAG_String: {
                return NBTTagString.a((String)((String)value));
            }
            case TAG_Int_Array: {
                return new NBTTagIntArray((int[])value);
            }
        }
        throw new IllegalArgumentException((Object)((Object)type) + "doesn't have a simple value!");
    }
}

