/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util;

public enum OTGDirection {
    DOWN(0, -1, 0),
    UP(0, 1, 0),
    NORTH(0, 0, -1),
    SOUTH(0, 0, 1),
    WEST(-1, 0, 0),
    EAST(1, 0, 0);

    private final int dx;
    private final int dy;
    private final int dz;

    private OTGDirection(int dx, int dy, int dz) {
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
    }

    public int getX() {
        return this.dx;
    }

    public int getY() {
        return this.dy;
    }

    public int getZ() {
        return this.dz;
    }

    public OTGDirection getClockWise() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
            case EAST: {
                return SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get CW direction of " + (Object)((Object)this));
    }

    public OTGDirection getCounterClockWise() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
            case EAST: {
                return NORTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW direction of " + (Object)((Object)this));
    }
}

