/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.biome;

import com.pg85.otg.interfaces.IBiomeResourceLocation;
import java.nio.file.Path;

public class OTGBiomeResourceLocation
implements IBiomeResourceLocation {
    private static final String BIOME_RESOURCE_LOCATION_SEPARATOR = ".";
    private final String presetFolder;
    private final String presetShortName;
    private final int presetMajorVersion;
    private final String presetRegistryName;
    private final String biomeName;
    private final String resourceName;

    public OTGBiomeResourceLocation(Path presetFolder, String presetShortName, int presetMajorVersion, String biomeName, String resourceName) {
        this.presetMajorVersion = presetMajorVersion;
        this.presetFolder = presetFolder.toFile().getName();
        this.presetShortName = presetShortName != null && presetShortName.trim().length() > 0 ? presetShortName : this.presetFolder;
        this.presetRegistryName = this.presetShortName.toLowerCase().trim().replaceAll("[^a-z0-9/_-]", "_");
        this.biomeName = biomeName.toLowerCase().trim().replaceAll("[^a-z0-9/_-]", "_");
        this.resourceName = resourceName;
    }

    public OTGBiomeResourceLocation(Path presetFolder, String presetShortName, int presetMajorVersion, String biomeName) {
        this(presetFolder, presetShortName, presetMajorVersion, biomeName, null);
    }

    public IBiomeResourceLocation withBiomeResource(String resourceName) {
        return new OTGBiomeResourceLocation(this.presetFolder, this.presetShortName, this.presetMajorVersion, this.presetRegistryName, this.biomeName, resourceName);
    }

    private OTGBiomeResourceLocation(String presetFolderName, String presetShortName, int presetMajorVersion, String presetRegistryName, String biomeName, String resourceName) {
        this.presetMajorVersion = presetMajorVersion;
        this.presetFolder = presetFolderName;
        this.presetShortName = presetShortName;
        this.presetRegistryName = presetRegistryName;
        this.biomeName = biomeName;
        this.resourceName = resourceName;
    }

    @Override
    public String getPresetFolderName() {
        return this.presetFolder;
    }

    @Override
    public String toResourceLocationString() {
        return String.format("%s%s%s", this.getResourceDomain(), ":", this.getResourcePath());
    }

    private String getResourceDomain() {
        return "otg";
    }

    private String getResourcePath() {
        if (this.resourceName != null) {
            return String.format("%s%s%s%s%s", this.presetRegistryName, BIOME_RESOURCE_LOCATION_SEPARATOR, this.biomeName, BIOME_RESOURCE_LOCATION_SEPARATOR, this.resourceName);
        }
        return String.format("%s%s%s", this.presetRegistryName, BIOME_RESOURCE_LOCATION_SEPARATOR, this.biomeName);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OTGBiomeResourceLocation)) {
            return false;
        }
        return ((OTGBiomeResourceLocation)other).toResourceLocationString().equals(this.toResourceLocationString());
    }

    public int hashCode() {
        return this.toResourceLocationString().hashCode();
    }
}

