/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.biome;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.materials.LocalMaterialBase;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterialTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ReplaceBlockMatrix {
    private static final String NO_REPLACE = "None";
    private final int maxHeight;
    private List<ReplacedBlocksInstruction> instructions;
    private final ReplaceBlockEntry[] targetsAtHeights;
    public boolean replacesCooledLava = false;
    public boolean replacesIce = false;
    public boolean replacesPackedIce = false;
    public boolean replacesSnow = false;
    public boolean replacesWater = false;
    public boolean replacesStone = false;
    public boolean replacesGround = false;
    public boolean replacesSurface = false;
    public boolean replacesUnderWaterSurface = false;
    public boolean replacesBedrock = false;
    public boolean replacesSandStone = false;
    public boolean replacesRedSandStone = false;

    public ReplaceBlockMatrix(String setting, int maxHeight, IMaterialReader reader) throws InvalidConfigException {
        String[] keys;
        this.maxHeight = maxHeight;
        this.targetsAtHeights = new ReplaceBlockEntry[256];
        if (setting.isEmpty() || setting.equalsIgnoreCase(NO_REPLACE)) {
            this.setInstructions(Collections.emptyList());
            return;
        }
        ArrayList<ReplacedBlocksInstruction> instructions = new ArrayList<ReplacedBlocksInstruction>();
        for (String key : keys = StringHelper.readCommaSeperatedString(setting)) {
            int start = key.indexOf(40);
            int end = key.lastIndexOf(41);
            if (start == -1 || end == -1) {
                throw new InvalidConfigException("One of the parts is missing braces around it.");
            }
            String keyWithoutBraces = key.substring(start + 1, end);
            instructions.add(new ReplacedBlocksInstruction(keyWithoutBraces, maxHeight, reader));
        }
        this.setInstructions(instructions);
    }

    public void init(LocalMaterialData biomeCooledLavaBlock, LocalMaterialData biomeIceBlock, LocalMaterialData biomePackedIceBlock, LocalMaterialData biomeSnowBlock, LocalMaterialData biomeWaterBlock, LocalMaterialData biomeStoneBlock, LocalMaterialData biomeGroundBlock, LocalMaterialData biomeSurfaceBlock, LocalMaterialData biomeUnderWaterSurfaceBlock, LocalMaterialData biomeBedrockBlock, LocalMaterialData biomeSandStoneBlock, LocalMaterialData biomeRedSandStoneBlock) {
        for (ReplacedBlocksInstruction instruction : this.instructions) {
            for (int y = instruction.minHeight; y <= instruction.maxHeight && y <= 255; ++y) {
                if (y < 0) continue;
                ReplaceBlockEntry targetsAtHeight = this.targetsAtHeights[y];
                if (targetsAtHeight == null) {
                    this.targetsAtHeights[y] = targetsAtHeight = new ReplaceBlockEntry();
                }
                for (ReplacedBlocksInstruction existing : targetsAtHeight.targets) {
                    LocalMaterialBase newFrom;
                    LocalMaterialData existingTo = existing.to;
                    if (!instruction.from.isTag()) {
                        newFrom = (LocalMaterialData)instruction.from;
                        if ((!((LocalMaterialData)newFrom).isDefaultState() || !((LocalMaterialData)newFrom).getRegistryName().equals(existingTo.getRegistryName())) && (((LocalMaterialData)newFrom).isDefaultState() || ((LocalMaterialData)newFrom).hashCode() != existingTo.hashCode())) continue;
                        existing.to = instruction.to;
                        continue;
                    }
                    newFrom = (LocalMaterialTag)instruction.from;
                    if (!instruction.from.isTag() || !existingTo.isBlockTag((LocalMaterialTag)newFrom)) continue;
                    existing.to = instruction.to;
                }
                targetsAtHeight.targets.add(instruction.clone());
            }
        }
        for (ReplacedBlocksInstruction instruction : this.instructions) {
            if (instruction.from.matches(biomeCooledLavaBlock)) {
                this.replacesCooledLava = true;
            }
            if (instruction.from.matches(biomeIceBlock)) {
                this.replacesIce = true;
            }
            if (instruction.from.matches(biomePackedIceBlock)) {
                this.replacesPackedIce = true;
            }
            if (instruction.from.matches(biomeSnowBlock)) {
                this.replacesSnow = true;
            }
            if (instruction.from.matches(biomeWaterBlock)) {
                this.replacesWater = true;
            }
            if (instruction.from.matches(biomeStoneBlock)) {
                this.replacesStone = true;
            }
            if (instruction.from.matches(biomeGroundBlock)) {
                this.replacesGround = true;
            }
            if (instruction.from.matches(biomeSurfaceBlock)) {
                this.replacesSurface = true;
            }
            if (instruction.from.matches(biomeUnderWaterSurfaceBlock)) {
                this.replacesUnderWaterSurface = true;
            }
            if (instruction.from.matches(biomeBedrockBlock)) {
                this.replacesBedrock = true;
            }
            if (instruction.from.matches(biomeSandStoneBlock)) {
                this.replacesSandStone = true;
            }
            if (!instruction.from.matches(biomeRedSandStoneBlock)) continue;
            this.replacesRedSandStone = true;
        }
    }

    public boolean replacesBlock(LocalMaterialData targetBlock) {
        for (ReplacedBlocksInstruction instruction : this.instructions) {
            if (!instruction.from.matches(targetBlock)) continue;
            return true;
        }
        return false;
    }

    public LocalMaterialData replaceBlock(int y, LocalMaterialData material) {
        ReplaceBlockEntry targetsAtHeight = this.targetsAtHeights[y = Math.max(Math.min(y, 255), 0)];
        if (targetsAtHeight != null) {
            for (ReplacedBlocksInstruction instruction : targetsAtHeight.targets) {
                if (!instruction.from.matches(material)) continue;
                return instruction.to;
            }
        }
        return material;
    }

    public boolean hasReplaceSettings() {
        return this.instructions != null && this.instructions.size() > 0;
    }

    public List<ReplacedBlocksInstruction> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(Collection<ReplacedBlocksInstruction> instructions) {
        this.instructions = Collections.unmodifiableList(new ArrayList<ReplacedBlocksInstruction>(instructions));
    }

    public String toString() {
        if (!this.hasReplaceSettings()) {
            return NO_REPLACE;
        }
        StringBuilder builder = new StringBuilder();
        for (ReplacedBlocksInstruction instruction : this.getInstructions()) {
            builder.append('(');
            builder.append(instruction.from);
            builder.append(',').append(instruction.to);
            if (instruction.getMinHeight() != 0 || instruction.getMaxHeight() != this.maxHeight) {
                builder.append(',').append(instruction.getMinHeight());
                builder.append(',').append(instruction.getMaxHeight());
            }
            builder.append(')').append(',');
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static ReplaceBlockMatrix createEmptyMatrix(int maxHeight, IMaterialReader materialReader) {
        try {
            return new ReplaceBlockMatrix(NO_REPLACE, maxHeight, materialReader);
        }
        catch (InvalidConfigException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static class ReplacedBlocksInstruction {
        private final LocalMaterialBase from;
        private LocalMaterialData to;
        private final int minHeight;
        private final int maxHeight;

        private ReplacedBlocksInstruction(String instruction, int maxAllowedY, IMaterialReader materialReader) throws InvalidConfigException {
            String[] values = instruction.split(",(?![^\\(\\[]*[\\]\\)])");
            if (values.length == 5) {
                values = new String[]{values[0], values[1] + ":" + values[2], values[3], "" + (Integer.parseInt(values[4]) - 1)};
            }
            if (values.length != 2 && values.length != 4) {
                throw new InvalidConfigException("Replace parts must be in the format (from,to) or (from,to,minHeight,maxHeight)");
            }
            LocalMaterialTag tag = materialReader.readTag(values[0]);
            this.from = tag != null ? tag : materialReader.readMaterial(values[0]);
            this.to = materialReader.readMaterial(values[1]);
            if (values.length == 4) {
                this.minHeight = StringHelper.readInt(values[2], 0, maxAllowedY);
                this.maxHeight = StringHelper.readInt(values[3], this.minHeight, maxAllowedY);
            } else {
                this.minHeight = 0;
                this.maxHeight = maxAllowedY;
            }
        }

        public ReplacedBlocksInstruction(LocalMaterialBase from, LocalMaterialData to, int minHeight, int maxHeight) {
            this.from = from;
            this.to = to;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        public ReplacedBlocksInstruction clone() {
            return new ReplacedBlocksInstruction(this.from, this.to, this.minHeight, this.maxHeight);
        }

        public LocalMaterialBase getFrom() {
            return this.from;
        }

        public LocalMaterialData getTo() {
            return this.to;
        }

        public int getMinHeight() {
            return this.minHeight;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }
    }

    private class ReplaceBlockEntry {
        public final List<ReplacedBlocksInstruction> targets = new ArrayList<ReplacedBlocksInstruction>();

        private ReplaceBlockEntry() {
        }
    }
}

