/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.gen;

import com.pg85.otg.util.ChunkCoordinate;

public class DecorationArea {
    public static final int DECORATION_OFFSET = 8;
    public static final int CARVER_OFFSET = 8;
    public static final int BO_CHUNK_CENTER_X = 8;
    public static final int BO_CHUNK_CENTER_Z = 7;
    private static final int WIDTH_IN_CHUNKS = 2;
    private static final int HEIGHT_IN_CHUNKS = 2;
    public static final int WIDTH = 32;
    public static final int HEIGHT = 32;
    private final int minX;
    private final int maxX;
    private final int minZ;
    private final int maxZ;
    private final int width;
    private final int height;
    private final ChunkCoordinate chunkBeingDecorated;

    public DecorationArea(ChunkCoordinate chunkBeingDecorated) {
        int top = 0;
        int right = 16;
        int bottom = 16;
        int left = 0;
        this.width = left + right + 16;
        this.height = top + bottom + 16;
        this.minX = chunkBeingDecorated.getBlockX() - left;
        this.maxX = chunkBeingDecorated.getBlockX() + 16 + right;
        this.minZ = chunkBeingDecorated.getBlockZ() - top;
        this.maxZ = chunkBeingDecorated.getBlockZ() + 16 + bottom;
        this.chunkBeingDecorated = chunkBeingDecorated;
    }

    public boolean isInAreaBeingDecorated(int blockX, int blockZ) {
        return blockX >= this.minX && blockX < this.maxX && blockZ >= this.minZ && blockZ < this.maxZ;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTop() {
        return this.minZ;
    }

    public int getBottom() {
        return this.minZ + this.height;
    }

    public int getLeft() {
        return this.minX;
    }

    public int getRight() {
        return this.minX + this.width;
    }

    public ChunkCoordinate getChunkBeingDecorated() {
        return this.chunkBeingDecorated;
    }

    public int getChunkBeingDecoratedCenterX() {
        return this.chunkBeingDecorated.getChunkX() * 16 + 8;
    }

    public int getChunkBeingDecoratedCenterZ() {
        return this.chunkBeingDecorated.getChunkZ() * 16 + 8;
    }
}

