/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.gen;

import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ICachedBiomeProvider;
import com.pg85.otg.util.ChunkCoordinate;

public class DecorationBiomeCache {
    private final int startX;
    private final int startZ;
    private final IBiome[] biomes;

    public DecorationBiomeCache(int startChunkX, int startChunkZ, ICachedBiomeProvider cachedBiomeProvider) {
        this.startX = startChunkX * 16;
        this.startZ = startChunkZ * 16;
        this.biomes = cachedBiomeProvider.getBiomesForChunks(ChunkCoordinate.fromBlockCoords(this.startX, this.startZ), 32);
    }

    public IBiome getBiome(int x, int z) {
        int internalX = x - this.startX;
        int internalZ = z - this.startZ;
        return this.biomes[internalX * 32 + internalZ];
    }

    public IBiomeConfig getBiomeConfig(int x, int z) {
        return this.getBiome(x, z).getBiomeConfig();
    }
}

