/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.gen;

import java.util.Random;

public final class GeneratingChunk {
    private static final int BEDROCK_LAYER_HEIGHT = 5;
    public final int heightCap;
    public final Random random;
    private final int[] waterLevel;
    private final double[] surfaceNoise;

    public GeneratingChunk(Random random, int[] waterLevel, double[] surfaceNoise, int heightCap) {
        this.random = random;
        this.waterLevel = waterLevel;
        this.surfaceNoise = surfaceNoise;
        this.heightCap = heightCap;
    }

    public double getNoise(int x, int z) {
        return this.surfaceNoise[x + z * 16];
    }

    public int getWaterLevel(int x, int z) {
        return this.waterLevel[z + x * 16];
    }

    public boolean mustCreateBedrockAt(boolean flatBedrock, boolean disableBedrock, boolean ceilingBedrock, int y) {
        if (flatBedrock) {
            if (!disableBedrock && y == 0) {
                return true;
            }
            return ceilingBedrock && y >= this.heightCap - 1;
        }
        if (!disableBedrock && y < 5) {
            return y <= this.random.nextInt(5);
        }
        if (ceilingBedrock) {
            int amountBelowHeightCap = this.heightCap - y - 1;
            if (amountBelowHeightCap < 0 || amountBelowHeightCap > 5) {
                return false;
            }
            return amountBelowHeightCap <= this.random.nextInt(5);
        }
        return false;
    }
}

