/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.helpers;

public class MathHelper {
    private static float[] A = new float[65536];

    private MathHelper() {
    }

    public static float sqrt(float paramFloat) {
        return (float)Math.sqrt(paramFloat);
    }

    public static float sin(float paramFloat) {
        return A[(int)(paramFloat * 10430.378f) & 0xFFFF];
    }

    public static float cos(float paramFloat) {
        return A[(int)(paramFloat * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static int floor(double d0) {
        int i = (int)d0;
        return d0 < (double)i ? i - 1 : i;
    }

    public static long lfloor(double d) {
        long l = (long)d;
        return d >= (double)l ? l : l - 1L;
    }

    public static int abs(int number) {
        if (number > 0) {
            return number;
        }
        return -number;
    }

    public static double smoothstep(double d) {
        return d * d * d * (d * (d * 6.0 - 15.0) + 10.0);
    }

    public static double lerp(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    private static double lerp2(double deltaX, double deltaY, double val00, double val10, double val01, double val11) {
        return MathHelper.lerp(deltaY, MathHelper.lerp(deltaX, val00, val10), MathHelper.lerp(deltaX, val01, val11));
    }

    public static double lerp3(double deltaX, double deltaY, double deltaZ, double val000, double val100, double val010, double val110, double val001, double val101, double val011, double val111) {
        return MathHelper.lerp(deltaZ, MathHelper.lerp2(deltaX, deltaY, val000, val100, val010, val110), MathHelper.lerp2(deltaX, deltaY, val001, val101, val011, val111));
    }

    public static int ceil(float floatNumber) {
        int truncated = (int)floatNumber;
        return floatNumber > (float)truncated ? truncated + 1 : truncated;
    }

    public static int clamp(int check, int min, int max) {
        return check > max ? max : (check < min ? min : check);
    }

    public static double clamp(double check, double min, double max) {
        return check > max ? max : (check < min ? min : check);
    }

    public static float clamp(float check, float min, float max) {
        return check > max ? max : (check < min ? min : check);
    }

    public static double clampedLerp(double start, double end, double delta) {
        if (delta < 0.0) {
            return start;
        }
        return delta > 1.0 ? end : MathHelper.lerp(delta, start, end);
    }

    public static int smallestEncompassingPowerOfTwo(int value) {
        int i = value - 1;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    public static long toLong(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    public static int getXFromLong(long val) {
        return (int)(val & 0xFFFFFFFFL);
    }

    public static int getZFromLong(long val) {
        return (int)(val >>> 32 & 0xFFFFFFFFL);
    }

    public static double fastInverseSqrt(double x) {
        double d = 0.5 * x;
        long l = Double.doubleToRawLongBits(x);
        l = 6910469410427058090L - (l >> 1);
        x = Double.longBitsToDouble(l);
        x *= 1.5 - d * x * x;
        return x;
    }

    public static long mixSeed(long seed, long salt) {
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        return seed += salt;
    }

    public static int mod(int x, int y) {
        int result = x % y;
        if (result < 0) {
            result += y;
        }
        return result;
    }

    public static boolean tryParseInt(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            MathHelper.A[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
    }
}

