/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.logging;

import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class Logger
implements ILogger {
    protected LogLevel minimumLevel = LogLevel.INFO;
    private boolean logCustomObjects;
    private boolean logStructurePlotting;
    private boolean logConfigs;
    private boolean logBiomeRegistry;
    private boolean logPerformance;
    private boolean logDecoration;
    private boolean logMobs;
    private String logPresets;

    @Override
    public void init(LogLevel level, boolean logCustomObjects, boolean logStructurePlotting, boolean logConfigs, boolean logBiomeRegistry, boolean logPerformance, boolean logDecoration, boolean logMobs, String logPresets) {
        this.minimumLevel = level;
        this.logCustomObjects = logCustomObjects;
        this.logStructurePlotting = logStructurePlotting;
        this.logConfigs = logConfigs;
        this.logBiomeRegistry = logBiomeRegistry;
        this.logPerformance = logPerformance;
        this.logDecoration = logDecoration;
        this.logMobs = logMobs;
        this.logPresets = logPresets;
    }

    @Override
    public boolean canLogForPreset(String presetFolderName) {
        return this.logPresets.equalsIgnoreCase(presetFolderName) || this.logPresets.equals("all");
    }

    @Override
    public boolean getLogCategoryEnabled(LogCategory category) {
        switch (category) {
            case MAIN: {
                return true;
            }
            case CUSTOM_OBJECTS: {
                return this.logCustomObjects;
            }
            case STRUCTURE_PLOTTING: {
                return this.logStructurePlotting;
            }
            case CONFIGS: {
                return this.logConfigs;
            }
            case BIOME_REGISTRY: {
                return this.logBiomeRegistry;
            }
            case PERFORMANCE: {
                return this.logPerformance;
            }
            case DECORATION: {
                return this.logDecoration;
            }
            case MOBS: {
                return this.logMobs;
            }
        }
        return false;
    }

    @Override
    public void printStackTrace(LogLevel level, LogCategory categoy, Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        this.log(level, categoy, stringWriter.toString());
    }
}

