/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.materials;

import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.materials.LocalMaterialBase;
import com.pg85.otg.util.materials.LocalMaterialTag;
import com.pg85.otg.util.materials.LocalMaterials;
import com.pg85.otg.util.materials.MaterialProperty;

public abstract class LocalMaterialData
extends LocalMaterialBase {
    protected String rawEntry;
    protected boolean isBlank = false;
    protected boolean parsedDefaultMaterial = false;
    protected LocalMaterialData[] rotations = new LocalMaterialData[]{this, null, null, null};
    protected LocalMaterialData rotated = null;
    private boolean isOreSet;
    private boolean isOre;
    private boolean isLeavesSet;
    private boolean isLeaves;
    private boolean isLogSet;
    private boolean isLog;

    public abstract <T extends Comparable<T>> LocalMaterialData withProperty(MaterialProperty<T> var1, T var2);

    public abstract String getName();

    public abstract String getRegistryName();

    public abstract boolean canSnowFallOn();

    public abstract boolean canFall();

    public boolean isBlank() {
        return this.isBlank;
    }

    public abstract boolean isMaterial(LocalMaterialData var1);

    public abstract boolean isBlockTag(LocalMaterialTag var1);

    public abstract boolean isLiquid();

    public abstract boolean isSolid();

    public abstract boolean isEmptyOrAir();

    public abstract boolean isNonCaveAir();

    public abstract boolean isAir();

    public abstract boolean isEmpty();

    public boolean isLogOrLeaves() {
        return this.isLog() || this.isLeaves();
    }

    public boolean isDefaultState() {
        return this.getName().equals(this.getRegistryName());
    }

    @Override
    public boolean matches(LocalMaterialData material) {
        return this.isDefaultState() || material.isDefaultState() ? material.getRegistryName().equals(this.getRegistryName()) : material.hashCode() == this.hashCode();
    }

    public boolean isSmoothAreaAnchor(boolean allowWood, boolean ignoreWater) {
        return (this.isSolid() && (!this.isLog() || allowWood) || !ignoreWater && this.isLiquid() || this.isMaterial(LocalMaterials.ICE) || this.isMaterial(LocalMaterials.PACKED_ICE) || this.isMaterial(LocalMaterials.FROSTED_ICE)) && !this.isLeaves() && !this.isMaterial(LocalMaterials.WATER_LILY);
    }

    public boolean isOre() {
        if (this.isOreSet) {
            return this.isOre;
        }
        this.isOre = this.isMaterial(LocalMaterials.COAL_ORE) || this.isMaterial(LocalMaterials.DIAMOND_ORE) || this.isMaterial(LocalMaterials.EMERALD_ORE) || this.isMaterial(LocalMaterials.GOLD_ORE) || this.isMaterial(LocalMaterials.IRON_ORE) || this.isMaterial(LocalMaterials.LAPIS_ORE) || this.isMaterial(LocalMaterials.QUARTZ_ORE) || this.isMaterial(LocalMaterials.REDSTONE_ORE);
        this.isOreSet = true;
        return this.isOre;
    }

    public boolean isLeaves() {
        if (this.isLeavesSet) {
            return this.isLeaves;
        }
        this.isLeaves = this.isMaterial(LocalMaterials.ACACIA_LEAVES) || this.isMaterial(LocalMaterials.BIRCH_LEAVES) || this.isMaterial(LocalMaterials.DARK_OAK_LEAVES) || this.isMaterial(LocalMaterials.JUNGLE_LEAVES) || this.isMaterial(LocalMaterials.OAK_LEAVES) || this.isMaterial(LocalMaterials.SPRUCE_LEAVES);
        this.isLeavesSet = true;
        return this.isLeaves;
    }

    public boolean isLog() {
        if (this.isLogSet) {
            return this.isLog;
        }
        this.isLog = this.isMaterial(LocalMaterials.ACACIA_LOG) || this.isMaterial(LocalMaterials.BIRCH_LOG) || this.isMaterial(LocalMaterials.DARK_OAK_LOG) || this.isMaterial(LocalMaterials.OAK_LOG) || this.isMaterial(LocalMaterials.SPRUCE_LOG) || this.isMaterial(LocalMaterials.ACACIA_WOOD) || this.isMaterial(LocalMaterials.BIRCH_WOOD) || this.isMaterial(LocalMaterials.DARK_OAK_WOOD) || this.isMaterial(LocalMaterials.OAK_WOOD) || this.isMaterial(LocalMaterials.SPRUCE_WOOD) || this.isMaterial(LocalMaterials.STRIPPED_ACACIA_LOG) || this.isMaterial(LocalMaterials.STRIPPED_BIRCH_LOG) || this.isMaterial(LocalMaterials.STRIPPED_DARK_OAK_LOG) || this.isMaterial(LocalMaterials.STRIPPED_JUNGLE_LOG) || this.isMaterial(LocalMaterials.STRIPPED_OAK_LOG) || this.isMaterial(LocalMaterials.STRIPPED_SPRUCE_LOG);
        this.isLogSet = true;
        return this.isLog;
    }

    public boolean isSapling() {
        return this.isMaterial(LocalMaterials.BAMBOO_SAPLING) || this.isMaterial(LocalMaterials.BIRCH_SAPLING) || this.isMaterial(LocalMaterials.DARK_OAK_SAPLING) || this.isMaterial(LocalMaterials.JUNGLE_SAPLING) || this.isMaterial(LocalMaterials.OAK_SAPLING) || this.isMaterial(LocalMaterials.SPRUCE_SAPLING);
    }

    public LocalMaterialData rotate() {
        return this.rotate(1);
    }

    public abstract LocalMaterialData rotate(int var1);

    public LocalMaterialData parseWithBiomeAndHeight(boolean biomeConfigsHaveReplacement, ReplaceBlockMatrix replaceBlocks, int y) {
        if (!biomeConfigsHaveReplacement) {
            return this;
        }
        return replaceBlocks.replaceBlock(y, this);
    }

    @Override
    public boolean isTag() {
        return false;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract LocalMaterialData legalOrPersistentLeaves(boolean var1);
}

