/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.materials;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterialTag;
import com.pg85.otg.util.materials.MaterialSetEntry;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class MaterialSet {
    private static final String ALL_MATERIALS = "All";
    public static final String SOLID_MATERIALS = "Solid";
    private static final String NON_SOLID_MATERIALS = "NonSolid";
    private boolean allMaterials = false;
    private boolean allSolidMaterials = false;
    private boolean allNonSolidMaterials = false;
    private int[] materialIntSet = new int[0];
    private Set<MaterialSetEntry> materials = new LinkedHashSet<MaterialSetEntry>();
    private Set<MaterialSetEntry> tags = new LinkedHashSet<MaterialSetEntry>();
    private boolean intSetUpToDate = true;

    public void parseAndAdd(String input, IMaterialReader materialReader) throws InvalidConfigException {
        if (input.equalsIgnoreCase(ALL_MATERIALS)) {
            this.allMaterials = true;
            return;
        }
        if (input.equalsIgnoreCase(SOLID_MATERIALS)) {
            this.allSolidMaterials = true;
            return;
        }
        if (input.equalsIgnoreCase(NON_SOLID_MATERIALS)) {
            this.allNonSolidMaterials = true;
            return;
        }
        LocalMaterialTag tag = materialReader.readTag(input);
        if (tag != null) {
            this.addTag(new MaterialSetEntry(tag));
        } else {
            LocalMaterialData material = materialReader.readMaterial(input);
            if (material == null) {
                throw new InvalidConfigException("Invalid block check, material \"" + input + "\" could not be found.");
            }
            this.addMaterial(new MaterialSetEntry(material));
        }
    }

    private void addMaterial(MaterialSetEntry entry) {
        this.intSetUpToDate = false;
        this.materials.add(entry);
    }

    private void addTag(MaterialSetEntry entry) {
        this.tags.add(entry);
    }

    private void updateIntSet() {
        if (this.intSetUpToDate) {
            return;
        }
        this.materialIntSet = new int[this.materials.size()];
        int i = 0;
        for (MaterialSetEntry entry : this.materials) {
            this.materialIntSet[i] = !((LocalMaterialData)entry.getMaterial()).isDefaultState() ? ((LocalMaterialData)entry.getMaterial()).getRegistryName().hashCode() : entry.hashCode();
            ++i;
        }
        Arrays.sort(this.materialIntSet);
        this.intSetUpToDate = true;
    }

    public boolean contains(LocalMaterialData material) {
        if (material == null || material.isEmpty()) {
            return false;
        }
        if (this.allMaterials) {
            return true;
        }
        if (this.allSolidMaterials && material.isSolid()) {
            return true;
        }
        if (this.allNonSolidMaterials && !material.isSolid()) {
            return true;
        }
        this.updateIntSet();
        if (Arrays.binarySearch(this.materialIntSet, material.hashCode()) >= 0) {
            return true;
        }
        if (Arrays.binarySearch(this.materialIntSet, material.getRegistryName().hashCode()) >= 0) {
            return true;
        }
        for (MaterialSetEntry entry : this.tags) {
            if (!material.isBlockTag((LocalMaterialTag)entry.getMaterial())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.allMaterials) {
            return ALL_MATERIALS;
        }
        StringBuilder builder = new StringBuilder();
        if (this.allSolidMaterials) {
            builder.append(SOLID_MATERIALS).append(',');
        }
        if (this.allNonSolidMaterials) {
            builder.append(NON_SOLID_MATERIALS).append(',');
        }
        for (MaterialSetEntry tag : this.tags) {
            builder.append(tag.toString()).append(',');
        }
        for (MaterialSetEntry material : this.materials) {
            builder.append(material.toString()).append(',');
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public MaterialSet rotate() {
        MaterialSet rotated = new MaterialSet();
        if (this.allMaterials) {
            rotated.allMaterials = true;
        }
        if (this.allSolidMaterials) {
            rotated.allSolidMaterials = true;
        }
        if (this.allNonSolidMaterials) {
            rotated.allNonSolidMaterials = true;
        }
        rotated.intSetUpToDate = false;
        for (MaterialSetEntry material : this.materials) {
            rotated.materials.add(material.rotate());
        }
        rotated.tags = this.tags;
        return rotated;
    }
}

