/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.minecraft;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class PlantType {
    private static final Map<String, PlantType> LOOKUP_MAP = new TreeMap<String, PlantType>(String.CASE_INSENSITIVE_ORDER);
    private static final Map<String, PlantType> ALIAS_LOOKUP_MAP = new TreeMap<String, PlantType>(String.CASE_INSENSITIVE_ORDER);
    public static final PlantType SeaGrass = PlantType.register(new PlantType("SeaGrass", LocalMaterials.SEAGRASS));
    public static final PlantType Allium = PlantType.register(new PlantType("Allium", LocalMaterials.ALLIUM));
    public static final PlantType AzureBluet = PlantType.register(new PlantType("AzureBluet", LocalMaterials.AZURE_BLUET));
    public static final PlantType BlueOrchid = PlantType.register(new PlantType("BlueOrchid", LocalMaterials.BLUE_ORCHID));
    public static final PlantType BrownMushroom = PlantType.register(new PlantType("BrownMushroom", LocalMaterials.BROWN_MUSHROOM));
    public static final PlantType Dandelion = PlantType.register(new PlantType("Dandelion", LocalMaterials.YELLOW_FLOWER));
    public static final PlantType DeadBush = PlantType.register(new PlantType("DeadBush", LocalMaterials.DEAD_BUSH));
    public static final PlantType DoubleTallSeaGrass = PlantType.register(new PlantType("DoubleTallSeaGrass", LocalMaterials.TALL_SEAGRASS_LOWER, LocalMaterials.TALL_SEAGRASS_UPPER));
    public static final PlantType DoubleTallGrass = PlantType.register(new PlantType("DoubleTallgrass", new String[]{"minecraft:double_plant:2", "double_plant:2"}, LocalMaterials.DOUBLE_TALL_GRASS_LOWER, LocalMaterials.DOUBLE_TALL_GRASS_UPPER));
    public static final PlantType Fern = PlantType.register(new PlantType("Fern", LocalMaterials.FERN));
    public static final PlantType LargeFern = PlantType.register(new PlantType("LargeFern", new String[]{"minecraft:double_plant:3", "double_plant:3"}, LocalMaterials.LARGE_FERN_LOWER, LocalMaterials.LARGE_FERN_UPPER));
    public static final PlantType Lilac = PlantType.register(new PlantType("Lilac", new String[]{"minecraft:double_plant:1", "double_plant:1"}, LocalMaterials.LILAC_LOWER, LocalMaterials.LILAC_UPPER));
    public static final PlantType OrangeTulip = PlantType.register(new PlantType("OrangeTulip", LocalMaterials.ORANGE_TULIP));
    public static final PlantType OxeyeDaisy = PlantType.register(new PlantType("OxeyeDaisy", LocalMaterials.OXEYE_DAISY));
    public static final PlantType Peony = PlantType.register(new PlantType("Peony", new String[]{"minecraft:double_plant:5", "double_plant:5"}, LocalMaterials.PEONY_LOWER, LocalMaterials.PEONY_UPPER));
    public static final PlantType PinkTulip = PlantType.register(new PlantType("PinkTulip", LocalMaterials.PINK_TULIP));
    public static final PlantType Poppy = PlantType.register(new PlantType("Poppy", LocalMaterials.POPPY));
    public static final PlantType RedMushroom = PlantType.register(new PlantType("RedMushroom", LocalMaterials.RED_MUSHROOM));
    public static final PlantType RedTulip = PlantType.register(new PlantType("RedTulip", LocalMaterials.RED_TULIP));
    public static final PlantType RoseBush = PlantType.register(new PlantType("RoseBush", new String[]{"minecraft:double_plant:4", "double_plant:4"}, LocalMaterials.ROSE_BUSH_LOWER, LocalMaterials.ROSE_BUSH_UPPER));
    public static final PlantType Sunflower = PlantType.register(new PlantType("Sunflower", new String[]{"minecraft:double_plant", "double_plant", "minecraft:double_plant:0", "double_plant:0"}, LocalMaterials.SUNFLOWER_LOWER, LocalMaterials.SUNFLOWER_UPPER));
    public static final PlantType Tallgrass = PlantType.register(new PlantType("Tallgrass", LocalMaterials.LONG_GRASS));
    public static final PlantType WhiteTulip = PlantType.register(new PlantType("WhiteTulip", LocalMaterials.WHITE_TULIP));
    public static final PlantType BerryBush = PlantType.register(new PlantType("BerryBush", LocalMaterials.BERRY_BUSH));
    private final String name;
    private final String[] aliases;
    private LocalMaterialData topBlock;
    private LocalMaterialData bottomBlock;

    public static PlantType getPlant(String name, IMaterialReader materialReader) throws InvalidConfigException {
        PlantType plantType = LOOKUP_MAP.get(name.toLowerCase());
        if (plantType == null && (plantType = ALIAS_LOOKUP_MAP.get(name.toLowerCase())) == null) {
            LocalMaterialData material = materialReader.readMaterial(name);
            plantType = new PlantType(material);
        }
        return plantType;
    }

    public static Collection<PlantType> values() {
        return LOOKUP_MAP.values();
    }

    private static PlantType register(PlantType plantType) {
        LOOKUP_MAP.put(plantType.toString().toLowerCase(), plantType);
        if (plantType.aliases != null) {
            for (String alias : plantType.aliases) {
                ALIAS_LOOKUP_MAP.put(alias.toLowerCase(), plantType);
            }
        }
        return plantType;
    }

    private PlantType(String name, String[] aliases, LocalMaterialData material) {
        this.name = name;
        this.aliases = aliases;
        this.topBlock = null;
        this.bottomBlock = material;
    }

    private PlantType(String name, LocalMaterialData material) {
        this(name, (String[])null, material);
    }

    private PlantType(LocalMaterialData material) {
        this.name = material.toString();
        this.aliases = null;
        this.topBlock = null;
        this.bottomBlock = material;
    }

    private PlantType(String name, String[] aliases, LocalMaterialData bottomMaterial, LocalMaterialData topMaterial) {
        this.name = name;
        this.aliases = aliases;
        this.bottomBlock = bottomMaterial;
        this.topBlock = topMaterial;
    }

    private PlantType(String name, LocalMaterialData bottomMaterial, LocalMaterialData topMaterial) {
        this(name, null, bottomMaterial, topMaterial);
    }

    public String getName() {
        return this.name;
    }

    public void spawn(IWorldGenRegion worldGenregion, int x, int y, int z) {
        worldGenregion.setBlock(x, y, z, this.bottomBlock);
        if (this.topBlock != null) {
            worldGenregion.setBlock(x, y + 1, z, this.topBlock);
        }
    }

    public LocalMaterialData getBottomMaterial() {
        return this.bottomBlock;
    }

    public LocalMaterialData getTopMaterial() {
        return this.topBlock;
    }

    public String toString() {
        return this.name;
    }
}

