//finds the unserviced town nearest to the location inputted
function find_nearby_town(location,serviced_towns) {
   AILog.Info("Finding unserviced town near " + location);

   //create a list of potential towns
	local towns = AITownList();

   //remove serviced towns
   towns.RemoveList(serviced_towns);

   //remove towns that are too small to make a profit
   towns.Valuate(AITown.GetPopulation);
   towns.KeepAboveValue(100);

   //keep the closest town to the inputted location on the list
   towns.Valuate(AITown.GetDistanceManhattanToTile, location);
   towns.KeepBottom(1);
   AILog.Info("Town found at " + AITown.GetLocation(towns.Begin()));
   return(towns.Begin());
}
