//this file contains road related functions

/*finds a path from one tile to the next using the road pathfinder library
Mostly copied from a pathfinding ai from the wiki */
function build_path(tile1, tile2) {

   AILog.Info("building path between " + tile1 + " and " + tile2);

	//create an instance of the pathfinder
	local pathfinder = RoadPathFinder();

   //tell openttd that we want to build roads
	AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);

	//tell the pathfinder where we want to start and end
   pathfinder.InitializePath([tile1], [tile2]);

	AILog.Info("Finding Path")
   //find a path between the tiles
	local path = false;
   local i = 1
   while (path == false && i < 151) {
		AILog.Info("Try number " + i);
   	path = pathfinder.FindPath(150);
      i ++;
   	this.Sleep(1);
		if(i == 150) {return(false);}
  }

  //build the path we found
  while (path != null) {
    local par = path.GetParent();
    if (par != null) {
      local last_node = path.GetTile();
      if (AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) == 1 ) {
        if (!AIRoad.BuildRoad(path.GetTile(), par.GetTile())) {
          /* An error occured while building a piece of road. TODO: handle it. 
           * Note that is can also be the case that the road was already build. */
        }
      } else {
        /* Build a bridge or tunnel. */
        if (!AIBridge.IsBridgeTile(path.GetTile()) && !AITunnel.IsTunnelTile(path.GetTile())) {
          /* If it was a road tile, demolish it first. Do this to work around expended roadbits. */
          if (AIRoad.IsRoadTile(path.GetTile())) AITile.DemolishTile(path.GetTile());
          if (AITunnel.GetOtherTunnelEnd(path.GetTile()) == par.GetTile()) {
            if (!AITunnel.BuildTunnel(AIVehicle.VT_ROAD, path.GetTile())) {
              /* An error occured while building a tunnel. TODO: handle it. */
            }
          } else {
            local bridge_list = AIBridgeList_Length(AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) + 1);
            bridge_list.Valuate(AIBridge.GetMaxSpeed);
            bridge_list.Sort(AIList.SORT_BY_VALUE, false);
            if (!AIBridge.BuildBridge(AIVehicle.VT_ROAD, bridge_list.Begin(), path.GetTile(), par.GetTile())) {
              /* An error occured while building a bridge. TODO: handle it. */
            }
          }
        }
      }
    }
    path = par;
   }
	AILog.Info("Path Built!")
   return(true);
}



//This function builds a bus station in the optimal location in a 14x14 area
function build_station(town_center) {

	//variables for building our stations
      local stations_built = 0;
      local station1_x = -1;
      local station1_y = -1;
      local station1_front = -1;
      local station1_tileindex = -1
      

      // Create a 14x14 grid around the town that will be used to find a location for a bus station.
      local station1_location = AITileList();
      station1_location.AddRectangle(town_center - AIMap.GetTileIndex(7, 7), town_center + AIMap.GetTileIndex(7, 7));

      //cut the list down to buildable tiles next to roads with reasonable passenger availability
      station1_location.Valuate(AITile.IsBuildable);
      station1_location.RemoveValue(0);
      station1_location.Valuate(AIRoad.GetNeighbourRoadCount);
      station1_location.RemoveValue(0);
      station1_location.Valuate(AITile.GetCargoAcceptance, 2, 1, 1, 6);
      //station1_location.RemoveBelowValue(10);
      //station1_location.Valuate(AIRoad.Get
      AILog.Info("number of potential tiles: " + station1_location.Count());

      //Create a while loop to find a spot to build a station.
      local station1 = station1_location.Begin();
      while(stations_built < 1) {

         station1_x = AIMap.GetTileX(station1);
         station1_y = AIMap.GetTileY(station1);

         //set the front of the station to a road tile adjacent to the station
         if(AIRoad.IsRoadTile(AIMap.GetTileIndex(station1_x, station1_y + 1))) {
            station1_front = AIMap.GetTileIndex(station1_x, station1_y + 1);
         } else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(station1_x, station1_y - 1))) {
            station1_front = AIMap.GetTileIndex(station1_x, station1_y - 1);
         }else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(station1_x + 1, station1_y))) {
            station1_front = AIMap.GetTileIndex(station1_x + 1, station1_y);
         }else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(station1_x - 1, station1_y))) {
            station1_front = AIMap.GetTileIndex(station1_x - 1, station1_y);
         }

         AILog.Info("Building Road between " + station1 + " and " + station1_front);
         if(AIRoad.BuildRoad(station1_front, station1)) {
            AILog.Info("Built Road between " + station1 + " and " + station1_front);
            if(AIRoad.BuildRoadStation(station1, station1_front, AIRoad.ROADVEHTYPE_BUS,AIStation.STATION_NEW)) {
               stations_built ++;
               AILog.Info("Built Station!");

               //Mark the location of the stations to order busses to them.
               if(stations_built == 1) {
                  station1_tileindex = AIMap.GetTileIndex(station1_x, station1_y);
						return(station1_tileindex);
               }
            }
            
            
            
         }else{
            station1_location.RemoveValue(station1);
         }

         
         this.Sleep(5);
         station1 = station1_location.Next();
      }
}



function create_network(town) {

   local bus_name = null;
   //local stations_built = 0;
   local station1_tileindex = -1;
   local station2_tileindex = -1;


   local town_center = AITown.GetLocation(town);
   AISign.BuildSign(town_center, "Building Bus Network");


   //set the road type to road
   AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);

   //TODO: TAKE OUT
   if(1 == 1) {

      //towns_serviced.AddValue(town_list.Begin);


      //variables for building our stations
      local stations_built = 0;
      local station1_x = -1;
      local station1_y = -1;
      local station1_front = -1;
      

      // Create a 14x14 grid around the town that will be used to find a location for a bus station.
      local station1_location = AITileList();
      station1_location.AddRectangle(town_center - AIMap.GetTileIndex(7, 7), town_center + AIMap.GetTileIndex(7, 7));

      //cut the list down to buildable tiles next to roads with reasonable passenger availability
      station1_location.Valuate(AITile.IsBuildable);
      station1_location.RemoveValue(0);
      station1_location.Valuate(AIRoad.GetNeighbourRoadCount);
      station1_location.RemoveValue(0);
      station1_location.Valuate(AITile.GetCargoAcceptance, 2, 1, 1, 6);
      station1_location.RemoveBelowValue(15);
      //station1_location.Valuate(AIRoad.Get
      AILog.Info("number of potential tiles: " + station1_location.Count());

      //Create a while loop to find a spot to build a station.
      local station1 = station1_location.Begin();
      while(stations_built < 2) {

         station1_x = AIMap.GetTileX(station1);
         station1_y = AIMap.GetTileY(station1);

         //set the front of the station to a road tile adjacent to the station
         if(AIRoad.IsRoadTile(AIMap.GetTileIndex(station1_x, station1_y + 1))) {
            station1_front = AIMap.GetTileIndex(station1_x, station1_y + 1);
         } else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(station1_x, station1_y - 1))) {
            station1_front = AIMap.GetTileIndex(station1_x, station1_y - 1);
         }else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(station1_x + 1, station1_y))) {
            station1_front = AIMap.GetTileIndex(station1_x + 1, station1_y);
         }else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(station1_x - 1, station1_y))) {
            station1_front = AIMap.GetTileIndex(station1_x - 1, station1_y);
         }

         AILog.Info("Building Road between " + station1 + " and " + station1_front);
         if(AIRoad.BuildRoad(station1_front, station1)) {
            AILog.Info("Built Road between " + station1 + " and " + station1_front);
            if(AIRoad.BuildRoadStation(station1, station1_front, AIRoad.
ROADVEHTYPE_BUS,AIStation.STATION_NEW)) {
               stations_built ++;
               AILog.Info("Built Station!");

               //Mark the location of the stations to order busses to them.
               if(stations_built == 1) {
                  station1_tileindex = AIMap.GetTileIndex(station1_x, station1_y);
               } else if(stations_built == 2) {
                  station2_tileindex = AIMap.GetTileIndex(station1_x, station1_y);
               }
            }
            
            
            
         }else{
            station1_location.RemoveValue(station1);
         }

         
         this.Sleep(5);
         station1 = station1_location.Next();
      }
   }

   //code for building our depot
   local depot_built = false;
   local depot_x = -1;
   local depot_y = -1;
   local depot_front = -1;

   // Create a 14x14 grid around the town that will be used to find a location for a bus depot.
   local depot_location = AITileList();
   depot_location.AddRectangle(town_center - AIMap.GetTileIndex(7, 7), town_center + AIMap.GetTileIndex(7, 7));

   //cut the list down to buildable tiles next to roads
   depot_location.Valuate(AITile.IsBuildable);
   depot_location.RemoveValue(0);
   depot_location.Valuate(AIRoad.GetNeighbourRoadCount);
   depot_location.RemoveValue(0);
   AILog.Info("number of potential tiles: " + depot_location.Count());

   //Create a while loop to find a spot to build a depot.
   local depot = depot_location.Begin();
   while(!depot_built) {

      depot = depot_location.Next();
      depot_x = AIMap.GetTileX(depot);
      depot_y = AIMap.GetTileY(depot);

      //set the front of the depot to a road tile adjacent to the depot
      if(AIRoad.IsRoadTile(AIMap.GetTileIndex(depot_x, depot_y + 1))) {
         depot_front = AIMap.GetTileIndex(depot_x, depot_y + 1);
      } else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(depot_x, depot_y - 1))) {
         depot_front = AIMap.GetTileIndex(depot_x, depot_y - 1);
      }else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(depot_x + 1, depot_y))) {
         depot_front = AIMap.GetTileIndex(depot_x + 1, depot_y);
      }else if(AIRoad.IsRoadTile(AIMap.GetTileIndex(depot_x - 1, depot_y))) {
         depot_front = AIMap.GetTileIndex(depot_x - 1, depot_y);
      }
      AILog.Info("Building Road between " + depot + " and " + depot_front);
      if(AIRoad.BuildRoad(depot_front, depot)) {
         AILog.Info("Built Road between " + depot + " and " + depot_front);
         if(AIRoad.BuildRoadDepot(depot, depot_front)) {
				//depots.AddTile(depot);
            depot_built = true;
            AILog.Info("Built Depot!");
				//return depot;
         }

          
      }else{
         depot_location.RemoveValue(depot);
      }
      this.Sleep(5);
   }
   
   //chose a road vehicle to go between our two bus stations.
   local engines = AIEngineList(AIVehicle.VT_ROAD);
   engines.Valuate(AIEngine.IsValidEngine);
   engines.RemoveValue(0); 
   engines.Valuate(AIEngine.GetCargoType);
   engines.RemoveValue(AICargo.CC_PASSENGERS);
   AILog.Info("Number of potential busses: " + engines.Count());
   while(engines.Count() > 1) {
      engines.RemoveTop(1);
      this.Sleep(5);
   }

   local bus = null;
   //build the vehicle
   local bus_type = engines.Begin();
   if(AIEngine.IsBuildable(bus_type)) {
      AILog.Info("Bus found: " + bus_type + "  Building at" + depot);
      bus = AIVehicle.BuildVehicle(depot, bus_type);
      AILog.Info("Built Bus!");
   }
   AILog.Info("Next... Ordering busses...");
   //give the vehicles its orders
   AILog.Info("ordering bus " + bus + " to go to: " + station1_tileindex);
   if(AIOrder.InsertOrder(bus, 0, station1_tileindex, AIOrder.OF_NONE)) {
      AILog.Info("Bus order 1 set");
   }
   if(AIOrder.InsertOrder(bus, 1, station2_tileindex, AIOrder.OF_NONE)) {
      AILog.Info("Bus order 2 set");
   }

   //Finally, start the bus.
   AILog.Info("Bus network complete, starting bus transport!");
   AIVehicle.StartStopVehicle(bus);

	return depot;
}
