require("road.nut");
require("random.nut");

import("pathfinder.road", "RoadPathFinder", 4);


class SmallTownAI extends AIController {


   function Start();
}

function SmallTownAI::Start() {

   local serviced_towns = AITownList();
   serviced_towns.RemoveList(serviced_towns);

   //set the name of our ai
   if (!AICompany.SetName("The Company")) {
      if (!AICompany.SetName("The 2nd Company")) {
			if(!AICompany.SetName("The 3rd Company")) {
         local i = 4;
         local named = false;
         while(named = false); {
            if(AICompany.SetName("The " + i + "th Company")) {
					named = true;
            }
            i ++;
				}      
         }
      }
   }

   local bus = null;
   //create a list of the unserviced towns between 250 and 1500 population.
   AILog.Info("Searching for a small town...");
   local town_list = AITownList();
   town_list.RemoveList(serviced_towns);
   town_list.Valuate(AITown.GetPopulation);
   town_list.KeepAboveValue(250);
   town_list.KeepBelowValue(1250);
   AILog.Info("Number of potential towns: " + town_list.Count());
   town_list.KeepTop(1);
   AILog.Info("Town Found! Building network...");
   local town = town_list.Begin();

   //build a road network in the desired town
   local depot = create_network(town);

   //add the serviced town to the serviced towns list
   serviced_towns.AddItem(town, 1);

   local first_town = 1
	

   //create a loop so that our ai doesn't end
   while (true) {

		if(AICompany.GetBankBalance(AICompany.COMPANY_SELF) > 20000 && serviced_towns.Count() < 12) {
			//find a nearby town
   		local second_town = find_nearby_town(AITown.GetLocation(serviced_towns.Begin()), serviced_towns);

   		//build a path from the current town to the next town and, if successful, build a station and order busses to go there
   		local new_station = null;
   		if(build_path(AITown.GetLocation(serviced_towns.Begin()), AITown.GetLocation(second_town))) {
				new_station = build_station(AITown.GetLocation(second_town));
	
	
	  			//chose a road vehicle to go between our two bus stations.
   			local engines = AIEngineList(AIVehicle.VT_ROAD);
			   engines.Valuate(AIEngine.IsBuildable);
			   engines.RemoveValue(0);
			   engines.Valuate(AIEngine.GetCargoType);
			  	engines.KeepValue(0);
				engines.Valuate(AIEngine.GetDesignDate);
				engines.KeepTop(1);
			   AILog.Info("Number of potential busses: " + engines.Count());
			   while(engines.Count() > 1) {
			      engines.RemoveBottom(1);
			      this.Sleep(5);
			   }

   	
		   	//build the vehicle
		   	local bus_type = engines.Begin();
		   	if(AIEngine.IsBuildable(bus_type)) {
		   	   AILog.Info("Bus found: " + bus_type + "  Building at" + depot);
		   	   bus = AIVehicle.BuildVehicle(depot, bus_type);
		   	   AILog.Info("Built Bus!");
		   	}
			}


			//order the bus to go between the most crowded station and the new station.
		   local stations = AIStationList(AIStation.STATION_BUS_STOP);
			stations.Valuate(AIStation.GetCargoWaiting, AICargo.CC_PASSENGERS);
			stations.KeepBottom(1);
			AILog.Info("Ordering bus to " + AIBaseStation.GetName(stations.Begin()));
		  	AIOrder.InsertOrder(bus, 0, AIBaseStation.GetLocation(stations.Begin()), AIOrder.OF_NONE);
			AILog.Info("Ordering bus to " + AIBaseStation.GetName(new_station));
			AIOrder.InsertOrder(bus, 1, new_station, AIOrder.OF_NONE);
	
			//start the bus
			AILog.Info("New route complete, starting bus transport!");
	   	AIVehicle.StartStopVehicle(bus);

	      serviced_towns.AddItem(second_town, -1);
		}

      //try to repay our loan
      AICompany.SetLoanAmount(AICompany.GetLoanAmount() - 10000);

      this.Sleep(500);
   }
}





