import("pathfinder.road", "RoadPathFinder", 4);

class Util {
    roadpathfinder=RoadPathFinder();
	unbuiltConnections = [];
	tileBlacklist = []
    function BuildRoute(sourcetiles, destinationtiles);
    function FindFreeTileNear(tileID);
    function FilterBuildableTiles();
    function GetDirectlyAdjacentTiles(tile);
	function IsAreaClear(tile);
	function IsClearableTile(tile);
    function IndustryTotalCargo(industryID);
	function StationWaitingCargo();
    function ArrayFind(arr, item);
	function FindRoadVehicle(cargoID);
	static function IsStraightRoadTile(tile);
	function IsCargoPickedUp(industryID, cargoID);
	function TryBuildRoad(loc1, loc2);
	function BuildUnbuiltRoads();
	function CapLength(str);
    constructor()
    {
        AIRoad.SetCurrentRoadType(AIRoad.ROADTYPE_ROAD);
        roadpathfinder.cost.max_cost=500;
		roadpathfinder.cost.tile=2;
		roadpathfinder.cost.turn=1;
		roadpathfinder.cost.no_existing_road=2;
		roadpathfinder.cost.slope=2;
		roadpathfinder.cost.bridge_per_tile=3;
		roadpathfinder.cost.coast=1;
		roadpathfinder.cost.tunnel_per_tile=3;
        
    }
}

function Util::BuildRoute(sourcetile, destinationtile){
	foreach(tile in tileBlacklist){
		if (tile[0]==sourcetile && tile[1]==destinationtile){
			AILog.Info("tile combination in blacklist");
		}
	}
	roadpathfinder.InitializePath([sourcetile],[destinationtile]);
	local path = false;
	AILog.Info("Pathfinding...")
	  while (path == false) {
		 path = roadpathfinder.FindPath(100);
		 AIController.Sleep(1);
	   }
	//building route
	local distance=0;
	if (path==null) {
        AILog.Info("No Path Found");
		tileBlacklist.push([sourcetile,destinationtile]);
		return false;
	}
    else {
		AILog.Info("Completed, building route");
    }
	while (path != null) {
		local par = path.GetParent();
		if (par != null) {
			local last_node = path.GetTile();
			if (AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) == 1 ) {
				if (AIRoad.AreRoadTilesConnected(path.GetTile(), par.GetTile())){
					//A road already exists
				}
				else if (!TryBuildRoad(path.GetTile(), par.GetTile())) {
                    AILog.Info("failed to build path: "+AIError.GetLastErrorString());
					/* An error occurred while building a piece of road. TODO: handle it. 
					* Note that this could mean the road was already built. */
				}
				distance+=1;
			}
			else {
			/* Build a bridge or tunnel. */
				if (!AIBridge.IsBridgeTile(path.GetTile()) && !AITunnel.IsTunnelTile(path.GetTile())) {
					/* If it was a road tile, demolish it first. Do this to work around expended roadbits. */
					if (AIRoad.IsRoadTile(path.GetTile())) AITile.DemolishTile(path.GetTile());
						if (AITunnel.GetOtherTunnelEnd(path.GetTile()) == par.GetTile()) {
							if (!AITunnel.BuildTunnel(AIVehicle.VT_ROAD, path.GetTile())) {
								AILog.Info("failed to build tunnel: "+AIError.GetLastErrorString());
							/* An error occured while building a tunnel. TODO: handle it. */
							}
						} else {
							local distance = AIMap.DistanceManhattan(path.GetTile(), par.GetTile()) + 1;
							local bridge_list = AIBridgeList_Length(distance);
							bridge_list.Valuate(AIBridge.GetPrice, distance);
							bridge_list.KeepBelowValue(AICompany.GetBankBalance(AICompany.COMPANY_SELF)/2);
							bridge_list.Valuate(AIBridge.GetMaxSpeed);
							bridge_list.Sort(AIList.SORT_BY_VALUE, false);
							if (bridge_list.IsEmpty()){
								AILog.Info("cannot afford bridge");
							}
							else if (!AIBridge.BuildBridge(AIVehicle.VT_ROAD, bridge_list.Begin(), path.GetTile(), par.GetTile())) {
								AILog.Info("failed to build bridge: "+AIError.GetLastErrorString());
								/* An error occured while building a bridge. TODO: handle it. */
							}
						}
				}
			}
		}
		path = par;
	}
    return true;
}

function Util::TryBuildRoad(tile1, tile2){
	if (AIRoad.BuildRoad(tile1, tile2)){
		return true;
	}
	else {
		local error = AIError.GetLastError();
		switch (error) {
			case AIError.ERR_VEHICLE_IN_THE_WAY:
			case AIError.ERR_NOT_ENOUGH_CASH:
			case AIError.ERR_LOCAL_AUTHORITY_REFUSES:
				unbuiltConnections.push([tile1, tile2, error]);
				return true;
				break;
			case AIError.ERR_AREA_NOT_CLEAR:
				if (AITile.DemolishTile(tile2)){
					return TryBuildRoad(tile1, tile2);
				}
				else {
					return false;
				}
				break;
			default:
				return false;
		}
	}
}

function Util::BuildUnbuiltRoads(){
	local unbuild = unbuiltConnections;
	unbuiltConnections = []
	foreach (connection in unbuild){
		AILog.Info("fixing unbuilt road ("+connection[2]+")");
		//AISign.BuildSign(connection[0], "unbuilt fix");
		if (!TryBuildRoad(connection[0], connection[1])){
			AILog.Info("Success");
		};
	}
}

function Util::IsStraightRoadTile(tile) {
	return AIRoad.IsRoadTile(tile) && AIRoad.GetNeighbourRoadCount(tile)==2 &&
			((AIRoad.AreRoadTilesConnected(tile, tile + AIMap.GetTileIndex(-1,0)) &&
			  AIRoad.AreRoadTilesConnected(tile, tile + AIMap.GetTileIndex(1, 0))) ||
			 (AIRoad.AreRoadTilesConnected(tile, tile + AIMap.GetTileIndex(0,-1)) &&
			  AIRoad.AreRoadTilesConnected(tile, tile + AIMap.GetTileIndex(0, 1))))
}

function Util::IsClearableTile(tile, allowRoad = false) {
	return AITile.IsBuildable(tile) || AITile.IsFarmTile(tile) || AITile.HasTreeOnTile(tile) ||
		   AITile.IsRockTile(tile) || AITile.IsRoughTile(tile) ||
	       (allowRoad && Util.IsStraightRoadTile(tile))
}

function Util::GetDirectlyAdjacentTiles(tile){
    return [tile + AIMap.GetTileIndex(-1,0),
            tile + AIMap.GetTileIndex(1 ,0),
            tile + AIMap.GetTileIndex(0,-1),
            tile + AIMap.GetTileIndex(0, 1)]
}

function Util::IsAreaClear(tile, ut, checkFlat) {
	//ut.GetDirectlyAdjacentTiles(tile);
	foreach (tile2 in ut.GetDirectlyAdjacentTiles(tile)) {
		if (!ut.IsClearableTile(tile2,true) && !AIRoad.IsRoadTile(tile2)){
			return false;
		}
		if (checkFlat && AITile.GetSlope(tile2)!=AITile.SLOPE_FLAT){
			return false;
		}
	}
	return true;
}


function Util::FilterBuildableTiles(tiles, allowRoad = false){
    tiles.Valuate(IsClearableTile, allowRoad);
    tiles.KeepValue(1);
    tiles.Valuate(AITile.GetSlope);
    tiles.KeepValue(AITile.SLOPE_FLAT);
	tiles.Valuate(IsAreaClear, this, true);
	tiles.KeepValue(1);
    return tiles
}

function Util::FindFreeTileNear(tileID)
{
    local tiles = AITileList();
    tiles.AddRectangle(tileID - AIMap.GetTileIndex(9, 9),
		tileID + AIMap.GetTileIndex(9, 9));
    tiles = FilterBuildableTiles(tiles);
    tiles.Valuate(AITile.GetDistanceManhattanToTile, tileID);
    tiles.Sort(AIList.SORT_BY_VALUE, true);
    local firstTile = tiles.Begin();
    return firstTile;
}

function Util::IndustryTotalCargo(industryID)
{
    local cargoList = AICargoList();
    local sum=0;
    foreach (cargo, prod in cargoList) {
        local diff = AIIndustry.GetLastMonthProduction(industryID, cargo);
		if (diff > 0){
			
			local elist = AIEngineList(AIVehicle.VT_ROAD);
			elist.Valuate(AIEngine.CanRefitCargo, cargo);
			elist.KeepValue(1);
			
			if (!elist.IsEmpty()){
				sum += (diff * AICargo.GetCargoIncome(cargo, 20, 20) * (80 + AIBase.RandRange(40))) / 100;
			}
		}
    }
    return sum;
}

function Util::StationWaitingCargo(stationID){
	local cargoList = AICargoList();
	local sum=0;
	foreach (cargo, prod in cargoList){
		sum+=AIStation.GetCargoWaiting(stationID, cargo);
	}
	return sum;

}

function Util::CarriesCargo(vehicle, cargoID){
	return AIVehicle.GetCapacity(vehicle, cargoID)>5;
}

function Util::FindRoadVehicle(CargoID){
		local engineList=AIEngineList(AIVehicle.VT_ROAD);
		engineList.Valuate(AIEngine.CanRefitCargo,CargoID);
		engineList.KeepValue(1);
		engineList.Valuate(AIEngine.GetCapacity);
		engineList.KeepAboveValue(10);
		engineList.Valuate(AIEngine.GetMaxSpeed);
		engineList.Sort(AIList.SORT_BY_VALUE, false);
			engineList.Valuate(AIEngine.GetRoadType);
		engineList.KeepValue(AIRoad.GetCurrentRoadType());
		return engineList.Begin();
}

function Util::IsCargoPickedUp(industryID, cargoID){
	if (AIIndustry.GetAmountOfStationsAround(industryID)==0){
		return true;
	}
	else if (AIIndustry.GetLastMonthTransported(industryID, cargoID)>5){
		return false;
	}
	else {
		local stationType = AICargo.HasCargoClass(cargoID, AICargo.CC_PASSENGERS)?AIStation.STATION_BUS_STOP:AIStation.STATION_TRUCK_STOP;
		local tiles = AITileList_IndustryProducing(industryID, AIStation.GetCoverageRadius(stationType));
		tiles.Valuate(AIStation.GetStationID);
		foreach(tile, stationID in tiles){
			if (AIStation.IsValidStation(stationID)){
				//AILog.Info("checking station "+AIBaseStation.GetName(stationID));
				if (AIStation.HasStationType(stationID, stationType)){
					local vehicles = AIVehicleList_Station(stationID);
					foreach(vehicle, itm2 in vehicles){
						//AILog.Info("Checking vehicle "+AIVehicle.GetName(vehicle));
						if (AIVehicle.GetCapacity(vehicle, cargoID)>1){
							return false;
						}
					}
				}
			}
		}
	}
	return true;
}
	
function Util::FindRoadVehicleCapacity(CargoID, ut){
	local vehicle = ut.FindRoadVehicle(CargoID);
}

function Util::ArrayFind(array, item)
{
    foreach (element in array) {
        if (element == item){
            return true;
        }
    }
    return false;
}

function Util::CapLength(string, length)
{
	if (string.len() > length){
		return string.slice(0, length);
	}
	else {
		return string;
	}
}