/* -*- Mode: C++; tab-width: 4 -*- */
/**
 *    This file is part of Awards
 *    (c) krinn@chez.com
 *
 *    It's free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    any later version.
 *
 *    You should have received a copy of the GNU General Public License
 *    with it.  If not, see <http://www.gnu.org/licenses/>.
 *
**/
class _awards extends GSInfo
	{
	function GetAuthor()		{ return "Krinn"; }
	function GetName()			{ return "Awards"; }
	function GetDescription() 	{ return "Get awards and rewards while playing openttd"; }
	function GetVersion()		{ return 7; }
	function GetDate()			{ return "2013-11-05"; }
	function CreateInstance()	{ return "_awards"; }
	function GetShortName()		{ return "AWDS"; }
	function GetAPIVersion()	{ return "1.4"; }
	function MinVersionToLoad()	{ return 1; }
	function GetUrl()			{ return "http://www.tt-forums.net/viewtopic.php?f=65&t=69369"; }

	function GetSettings()
	{
		AddSetting({name = "BigUI",
		description = "Disable special UI symbols for users with BigGUI newGRF",
		easy_value = 0,
		medium_value = 0,
		hard_value = 0,
		custom_value = 0,
		flags = CONFIG_BOOLEAN |CONFIG_INGAME
		});

		AddSetting({name = "scriptNews",
		description = "Display news when an award/medal is earn",
		easy_value = 1,
		medium_value = 1,
		hard_value = 1,
		custom_value = 1,
		flags = CONFIG_BOOLEAN |CONFIG_INGAME
		});

		AddSetting({name = "HiddenAward",
		description = "Hide awards until someone get it. (no effect on medals)",
		easy_value = 1,
		medium_value = 1,
		hard_value = 1,
		custom_value = 1,
		flags = CONFIG_BOOLEAN
		});

		AddSetting({name = "PeriodicReward",
		description = "Enable/disable PeriodicReward : periodic reward grant money to all companies every X month",
		easy_value = 0,
		medium_value = 0,
		hard_value = 0,
		custom_value = 0,
		flags = CONFIG_BOOLEAN
		});

		AddSetting({name = "PeriodicMonth",
		description = "Set month interval to check rewards",
		easy_value = 3,
		medium_value = 3,
		hard_value = 3,
		custom_value = 3,
		min_value = 1,
		max_value = 12,
		flags = CONFIG_NONE
		});

		AddSetting({name = "RewardPoints",
		description = "Enable/disable PointsReward when company reach X points : this reward remove money from companies",
		easy_value = 1,
		medium_value = 1,
		hard_value = 1,
		custom_value = 1,
		flags = CONFIG_BOOLEAN
		});

		AddSetting({name = "RewardPointsTrigger",
		description = "Set points interval to grant the PointsReward",
		easy_value = 3,
		medium_value = 3,
		hard_value = 3,
		custom_value = 3,
		min_value = 0,
		max_value = 5,
		flags = CONFIG_NONE
		});
		AddLabels("RewardPointsTrigger", {_0 = "10", _1 = "20", _2 = "50", _3 = "100", _4 = "150", _5 = "200"});

		AddSetting({name = "MoneyIndex",
		description = "Set number of loan inverval use as base money for rewards",
		easy_value = 1,
		medium_value = 1,
		hard_value = 1,
		custom_value = 1,
		min_value = 1,
		max_value = 10,
		flags = CONFIG_NONE
		});

		AddSetting({name = "ToyLibGiveMoney",
		description = "Allow ToyLib to grant money to eyes candy/toy AIs. Disable it to stop sending them money",
		easy_value = 1,
		medium_value = 1,
		hard_value = 1,
		custom_value = 1,
		flags = CONFIG_BOOLEAN | CONFIG_INGAME
		});

		AddSetting({name = "ToyLibStats",
		description = "Allow ToyLib to output money given stats every start of month",
		easy_value = 1,
		medium_value = 1,
		hard_value = 1,
		custom_value = 1,
		flags = CONFIG_BOOLEAN | CONFIG_INGAME
		});
	}

}

RegisterGS(_awards());
