/* -*- Mode: C++; tab-width: 4 -*- */
/**
 *    This file is part of Awards
 *    (c) krinn@chez.com
 *
 *    It's free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    any later version.
 *
 *    You should have received a copy of the GNU General Public License
 *    with it.  If not, see <http://www.gnu.org/licenses/>.
 *
**/

require("require.nut");
import("Library.SCPLib", "SCPLib", 45);
import("Library.GSToyLib", "GSToyLib", 1);

enum PointsType
{
	EASY = 10,
	MEDIUM = 20,
	HARD = 30,
	MEDAL = 50
}

enum CategoryType
{
	MEDAL,
	VEHICLE,
	ECONOMY,
	MISC
}

class _awards extends GSController
{
	loadedgame = null;
	constructor()
	{
		loadedgame = null;
	}
}

function _awards::Init(loaded)
{
	Awards.DiscoverAwards();
	for (local i = 0; i < 15; i++)	{ Cache.cargo_handle.AddItem(i, 0);	Cache.vehicle[i] = GSList(); }
	local caching = CompanyLayer(); // init companies vars
	caching = Cache("companyDate", 0);
	caching = Cache("supply_town", 0);
	caching = Cache("supply_industry", 0);
	caching = Cache("reward", 0);
	caching = Cache("reward_balance", 0);
	caching = Cache("gabriel", 0);
	Cache.FindCargoUsage();


	local loadlimit = (loaded != null);
	if (loadlimit)
		{
		for (local i = 0; i < loaded.cPage.len(); i++)	{ CompanyLayer.companyPage[i] = loaded.cPage[i]; }
		for (local i = 0; i < loaded.cRank.len(); i++)	{ CompanyLayer.GlobalElement[i] = loaded.cRank[i]; }
		for (local i = 0; i < loaded.element.len(); i++)	{ Awards.ElementID[i] = loaded.element[i]; }
		for (local i = 0; i < 15; i++)	{ CompanyLayer.NewCompany(i); }
		// Force discovery of companies before we loaded their new values but after we have load their rank & page element and awards elementid
		GSLog.Info("savegame type="+typeof(loaded.element)+" datasize="+loaded.element.len());
		//foreach (item, value in loaded.element) { print("item="+item+" value="+value); }
		for (local i = 0; i < loaded.bigdata.len(); i++)	{ Cache.bigarray[i] = loaded.bigdata[i]; } // keep it after finding companies that reset value
		local idx = 0;
		local buff = [];
		while (idx < loaded.award_data.len())
			{
			local awd = Awards.Get(loaded.award_data[idx]);
			idx++;
			if (loaded.award_data[idx] != "EOL")
				{
				awd.Own_By_Company.push(loaded.award_data[idx]);
				CompanyLayer.AddPoints(awd.Own_By_Company[0], awd.Points);
				Scheduler.RemoveTask(awd.ID);
				}
			idx++;
			buff.clear();
			while (loaded.award_data[idx] != "EOL")	{ buff.push(loaded.award_data[idx]); idx++; }
			idx++;
			for (local k = 0; k < buff.len(); k++)	{ awd.Datas[k] = buff[k]; }
			}
		}
	CompanyLayer.Init();
	GSLog.Info("Welcome use page #"+CompanyLayer.GetPageID(15,0));
	GSLog.Info("Rank use page #"+CompanyLayer.GetPageID(16,0));
	GSLog.Info("Medal use page #"+CompanyLayer.GetPageID(17,0));
	GSLog.Info("Reward use page #"+CompanyLayer.GetPageID(18,0));
	Cache.GetSnowTown();
	local delay = GSController.GetSetting("PeriodicMonth") * 30 * 74;
	local ntask = Scheduler(9999, delay); // add special tasks to scheduler
	delay = true;
	GSLog.Info("Waiting companies...");
	while (delay)
		for (local i = 0; i < 15; i++)
			{ // wait for at least one valid company to appears
			if (GSCompany.ResolveCompanyID(i) != GSCompany.COMPANY_INVALID)
				{
				StoryTeller.UpdateRank();
				delay = false;
				GSLog.Info("Company found.");
				break;
				}
			}
	GSStoryPage.Show(CompanyLayer.GetPageID(15, 0));
	local tl = GSToyLib(null);
	GSToyLib.SCPConfigChange(false, false, false);
}

function _awards::CheckConfig()
{
	local option = (GSController.GetSetting("ToyLibGiveMoney") == 1);
	GSToyLib.MoneyHandling(option);
	option = (GSController.GetSetting("ToyLibStats") == 1);
	if (option && GSDate.GetDayOfMonth(GSDate.GetCurrentDate()) == 1)	{ GSToyLib.LogStats(); }
}

function _awards::Start()
{
	this.Init(loadedgame);
	local looper = 0;
	while (true)
		{
		looper++;
		if ((looper % 10) == 0)	{ StoryTeller.UpdateRank(); }
		Scheduler.Advance();
		Events.HandleEvents();
        GSToyLib.Check();
        _awards.CheckConfig();
		this.Sleep(74);
		}
}

function _awards::Load(version, data)
{
	GSLog.Info("Loading savegame version "+version);
	loadedgame = data;
}

function _awards::Save()
{
	GSLog.Info("saving...");
	local table =
	{
		award_data = null,
		cPage = null,
		cRank = null,
		element = null,
		bigdata = null,
	}
	table.cPage = CompanyLayer.companyPage;
	table.cRank = CompanyLayer.GlobalElement;
	table.element = Awards.ElementID;
	table.bigdata = Cache.bigarray;

	local award = [];
	foreach (a in Awards.awards_db)
		{
		if (a.Category == CategoryType.MEDAL)
			{
			award.push(a.ID);
			if (a.Own_By_Company.len() == 0)	{ award.push("EOL"); }
										else	{ award.extend(a.Own_By_Company); }
			award.extend(a.Datas);
			award.push("EOL");
			}
		}
	table.award_data = award;
	return table;
}

