/* -*- Mode: C++; tab-width: 4 -*- */
/**
 *    This file is part of Awards
 *    (c) krinn@chez.com
 *
 *    It's free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    any later version.
 *
 *    You should have received a copy of the GNU General Public License
 *    with it.  If not, see <http://www.gnu.org/licenses/>.
 *
**/

class StoryTeller
{
	constructor()
		{
		}
}

/** @brief Update an element in a page, create the element if it doesn't exists
 *
 * @param pageid The PageID the put the element within
 * @param elementid The ElementID to update or an invalid one to create a new one
 * @param text The GSText to update the element with
 * @param GSStoryPage.SPET_TEXT etype = not use, fixed to SPET_TEXT
 * @param 0 ref = not use, reference for non SPET_TEXT display
 * @return return the elementID of the new/update element
 *
 */
function StoryTeller::StoryUpdate(pageid, elementid, text, etype = GSStoryPage.SPET_TEXT, ref = 0)
{
	if (!GSStoryPage.IsValidStoryPageElement(elementid))
			{
			elementid = GSStoryPage.NewElement(pageid, etype, 0, "EMPTY!");
			if (elementid == GSStoryPage.STORY_PAGE_ELEMENT_INVALID)	{ return -1; } // forcing return -1 (unused state)
			//GSController.Break("new element");
			}
	GSStoryPage.UpdateElement(elementid, ref, text);
	return elementid;
}

/** @brief Display an award and upate the content of all companies page with its new state
 *
 * @param AwardID The AwardID
 *
 */
function StoryTeller::DisplayAwards(AwardID)
{
	local awd = null;
	if (AwardID in Awards.awards_db)	{ awd = Awards.awards_db[AwardID]; }
								else	{ throw("invalid AwardID "+AwardID); }
	local page_id = [];
	local index = AwardID * 15;
	if (awd.Category == CategoryType.MEDAL)
				{
				if (awd.Own_By_Company.len() == 0)	{ return; } // never display medal not earn
				page_id.push(0); // store it as 0 index
				page_id.push(CompanyLayer.GetPageID(17, 0));

				}
		else	{
				for (local i = 0; i < 15; i++)
					{
					local j = -1;
					switch (awd.Category)
						{
						case CategoryType.VEHICLE:
								j = CompanyLayer.GetPageID(i, 0);
								break;
						case CategoryType.ECONOMY:
								j = CompanyLayer.GetPageID(i, 1);
								break;
						case CategoryType.MISC:
								j = CompanyLayer.GetPageID(i, 2);
								break;
						}
					if (j != -1)	{ page_id.push(i); page_id.push(j); }
					}
				}
	for (local z = 0; z < page_id.len(); z++)
		{
		local text = Awards.AwardFormat(AwardID, page_id[z]);
		local r = StoryTeller.StoryUpdate(page_id[z+1], Awards.ElementID[index + page_id[z]], text);
        Awards.ElementID[index + page_id[z]] = r;
        z++;
		}
}

/** @brief Recalc the rank of all companies and update the page that display it
 *
 *
 */
function StoryTeller::UpdateRank()
{
	local rank = GSList();
	for (local i = 0; i < 15; i++)
		{
		rank.AddItem(i, CompanyLayer.companyPoints[i]);
		}
	rank.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	local counter = 0;
	local draw = -1;
	local result = [];
	local points = -1;
	foreach (comp, top in rank)
		{
		if (GSCompany.ResolveCompanyID(comp) == GSCompany.COMPANY_INVALID)
					{
					points = -1;
					CompanyLayer.companyPoints[comp] = -1;
					}
			else	{
					if (top == -1)	{ // valid company but bad points
									points = 0;
									CompanyLayer.companyPoints[comp] = 0;
									CompanyLayer.NewCompany(comp);
									}
							else	{ points = top; }
					}
        if (points != draw && points != -1)	{ counter++; draw = points; }
        local res = null;
        switch (counter)
			{
			case	1 :
				res = GSText(GSText.STR_GREEN);
				break;
			case	2:
				res = GSText(GSText.STR_YELLOW);
				break;
			case	3:
				res = GSText(GSText.STR_ORANGE);
				break;
			default:
				res = GSText(GSText.STR_RED);
			}
		if (points == -1)
				{
				res = " ";
				}
		else	{
				res.AddParam(GSText(GSText.STR_RANK));
				res.AddParam(counter);
				res.AddParam(comp);
				res.AddParam(points);
				}
        result.push(res);
		}
	for (local i = 0; i < result.len(); i++)
		{
		GSStoryPage.UpdateElement(CompanyLayer.GlobalElement[i], 0, result[i]);
		}
}

/** @brief Update and display rewards for all companies in the RewardPage
 *
 *
 */
function StoryTeller::UpdateReward()
{
	local balance = GSList();
	for (local i = 0; i < 15; i++)
		{
		balance.AddItem(i, Cache.GetData("reward_balance", i));
		}
	balance.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	local result = [];
	foreach (comp, top in balance)
		{
		local res = null;
		if (GSCompany.ResolveCompanyID(comp) == GSCompany.COMPANY_INVALID)
					{ res = " "; }
			else	{
					res = GSText(GSText.STR_REWARD_BALANCE);
					res.AddParam(comp);
					if (top < 0)	{ res.AddParam(GSText(GSText.STR_REWARD_LOOSE)); }
							else	{ res.AddParam(GSText(GSText.STR_REWARD_GAIN)); }
					res.AddParam(top);
					}
        result.push(res);
		}
	GSStoryPage.UpdateElement(CompanyLayer.GlobalElement[30], 0, GSText(GSText.STR_REWARD_REPORT, GSDate.GetCurrentDate()));
	for (local i = 0; i < result.len(); i++)
		{
		GSStoryPage.UpdateElement(CompanyLayer.GlobalElement[i+15], 0, result[i]);
		}
}

/** @brief Wrapper that create a new StoryPage but disable date output
 *
 *
 */
function StoryTeller::NewStoryPage(company, text)
{
	local value = GSStoryPage.New(company, text);
	if (value != GSStoryPage.STORY_PAGE_INVALID)	{ GSStoryPage.SetDate(value, GSDate.DATE_INVALID); }
	return value;
}
