/* -*- Mode: C++; tab-width: 4 -*- */
/**
 *    This file is part of Awards
 *    (c) krinn@chez.com
 *
 *    It's free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    any later version.
 *
 *    You should have received a copy of the GNU General Public License
 *    with it.  If not, see <http://www.gnu.org/licenses/>.
 *
**/

function Scheduler::AwardEvaluate_9999()
/** @brief Special task use in scheduler to check rewards
 *
 * @return -2 always to prevent AdvanceTask from checking that award
 *
 */

{
	local company = Cache.Company_Helper();
	foreach (comp in company)	{ Awards.CheckPointsReward(comp); }
	Awards.Reward_Periodic();
	StoryTeller.UpdateReward();
	return -2;
}

function Scheduler::AwardEvaluate_0()
{
// bee queen
	local own = -1;
	local v_list = Cache.Vehicle_Helper();
	local c_list = Cache.Company_Helper();
	local count = 0;
	local c = Awards.GetDatas(0);
	foreach (comp in c_list)
		{
		local k = v_list[comp];
		if (k.Count() > count)
			{
			count = v_list[comp].Count();
			own = comp;
			}
		}
	if (own != -1 && c[2] < count)	{ Awards.Update(0, count); }
	return own;
}

function Scheduler::AwardEvaluate_1()
{
	local own = -1;
	local veh = Cache.Vehicle_Helper_Counter("truck");
	veh.RemoveValue(0);
	if (veh.IsEmpty())	{ return -1; }
	veh.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	own = veh.Begin();
	Awards.Update(1, veh.GetValue(own));
	return own;
}

function Scheduler::AwardEvaluate_2()
{
	local own = -1;
	local veh = Cache.Vehicle_Helper_Counter("bus");
	veh.RemoveValue(0);
	if (veh.IsEmpty())	{ return -1; }
	veh.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	own = veh.Begin();
	Awards.Update(2, veh.GetValue(own));
	return own;
}

function Scheduler::AwardEvaluate_3()
{
	local own = -1;
	local veh = Cache.Vehicle_Helper_Counter("boat");
	veh.RemoveValue(0);
	if (veh.IsEmpty())	{ return -1; }
	veh.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	own = veh.Begin();
	Awards.Update(3, veh.GetValue(own));
	return own;
}

function Scheduler::AwardEvaluate_4()
{
	local own = -1;
	local veh = Cache.Vehicle_Helper_Counter("train");
	veh.RemoveValue(0);
	if (veh.IsEmpty())	{ return -1; }
	veh.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	own = veh.Begin();
	Awards.Update(4, veh.GetValue(own));
	return own;
}

function Scheduler::AwardEvaluate_5()
{
	local own = -1;
	local veh = Cache.Vehicle_Helper_Counter("aircraft");
	veh.RemoveValue(0);
	if (veh.IsEmpty())	{ return -1; }
	veh.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	own = veh.Begin();
	Awards.Update(5, veh.GetValue(own));
	return own;
}

function Scheduler::AwardEvaluate_6()
{
	local own = -1;
	local veh = Cache.Vehicle_Helper_Counter("chopper");
	veh.RemoveValue(0);
	if (veh.IsEmpty())	{ return -1; }
	veh.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	own = veh.Begin();
	Awards.Update(6, veh.GetValue(own));
	return own;
}

function Scheduler::AwardEvaluate_7()
{
	local vlist = GSVehicleList();
	if (vlist.IsEmpty())	{ return -1; }
	local veh, eng, spd, own;
	vlist.Valuate(GSVehicle.GetCurrentSpeed);
	local c = Awards.GetDatas(7);
    veh = c[2];
	eng = c[3];
	spd = c[4];
	if (!GSVehicle.IsValidVehicle(veh))	{ own = -1; spd = 0; }
								else	{ own = GSVehicle.GetOwner(veh); }
	vlist.KeepAboveValue(spd);
	if (vlist.IsEmpty())	return own;
	vlist.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	spd = vlist.GetValue(vlist.Begin());
	vlist.KeepValue(spd);
	vlist.Valuate(GSVehicle.GetAge);
	vlist.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	veh= vlist.Begin();
	own = GSVehicle.GetOwner(veh);
	eng = GSVehicle.GetEngineType(veh);
	Awards.Update(7, veh, eng, spd);
	return own;
}

function Scheduler::AwardEvaluate_8()
{
	local vlist = GSVehicleList();
	if (vlist.IsEmpty())	{ return -1; }
	local own = -1;
	local veh, eng, pwd;
	local c = Awards.GetDatas(8);
	pwd = c[4];
	vlist.Valuate(GSVehicle.GetEngineType);
	foreach (v, e in vlist)
		{
		local p = GSEngine.GetPower(e);
		if (p > pwd)	{ pwd = p; veh = v; eng = e; }
		}
	if (c[4] == pwd)	{ return -2; }
	own = GSVehicle.GetOwner(veh);
	Awards.Update(8, veh, eng, pwd);
	return own;
}

function Scheduler::AwardEvaluate_9()
{
	local own = -1;
	local vlist = Cache.Vehicle_Helper();
	local company = Cache.Company_Helper();
	local t_list = GSList();
	t_list.AddItem(GSVehicle.VT_RAIL, GSGameSettings.GetValue("vehicle.max_trains"));
	t_list.AddItem(GSVehicle.VT_ROAD, GSGameSettings.GetValue("vehicle.max_roadveh"));
	t_list.AddItem(GSVehicle.VT_WATER, GSGameSettings.GetValue("vehicle.max_ships"));
	t_list.AddItem(GSVehicle.VT_AIR, GSGameSettings.GetValue("vehicle.max_aircraft"));
	foreach (comp in company)
		{
		if (own != -1)	{ break; }
		local clist = vlist[comp];
		clist.Valuate(GSVehicle.GetVehicleType);
		foreach (v_type, v_max in t_list)
			{
			local i = GSList();
			i.AddList(clist);
			i.KeepValue(v_type);
			if (i.Count()+3 > v_max)	{ own = comp; break; }
			}
		}
	return own;
}

function Scheduler::AwardEvaluate_10()
{
	local own = [];
	local company = Cache.Company_Helper();
	if (company.len() < 2)	{ return -1; }
	local v_list = Cache.Vehicle_Helper();
	local check = GSList();
	foreach (comp in company)
		{
		if (v_list[comp].Count() > 0)	{ check.AddItem(comp, v_list[comp].Count()); }
		}
	if (check.Count() < 2)	{ return -1; }
	check.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	local most = check.Begin();
	foreach (comp, c in check)
		{
		if (most * 0.05 >= c)	{ own.push(comp); }
		}
	return own;
}

function Scheduler::AwardEvaluate_11()
{
	local vlist = GSVehicleList();
	if (vlist.IsEmpty())	{ return -1; }
	local own = -1;
	local veh, age;
	vlist.Valuate(GSVehicle.GetAge);
	vlist.KeepAboveValue(1825); // min 10 years old
	if (!vlist.IsEmpty())
		{
		vlist.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
		veh = vlist.Begin(); // the oldest one
		age = vlist.GetValue(veh);
		if ((age * 1.2) > GSVehicle.GetMaxAge(veh))
			{
			own = GSVehicle.GetOwner(veh);
			Awards.Update(11, veh, age);
			}
		}
	return own;
}

function Scheduler::AwardEvaluate_12()
{
	local airport = GSStationList(GSStation.STATION_AIRPORT);
	if (airport.IsEmpty())	{ return -1; }
	airport.Valuate(GSAirport.GetAirportType);
	local cleaner = GSList();
	foreach (station, stype in airport)
		{
		if (stype == GSAirport.AT_SMALL || stype == GSAirport.AT_COMMUTER)	{ cleaner.AddItem(station, GSStation.GetOwner(station)); }
		}
	if (cleaner.IsEmpty())	{ return -1; }
	local filter = GSList();
	foreach (station, owner in cleaner)
		{
		if (filter.HasItem(owner))	{ continue; }
		local veh = GSVehicleList_Station(station);
		if (veh.IsEmpty())	{ continue; }
		foreach (vehicle, _ in veh)
			{
			if (GSEngine.GetPlaneType(GSVehicle.GetEngineType(vehicle)) == GSAirport.PT_BIG_PLANE)
				{
				filter.AddItem(owner, 0);
				break;
				}
			}
		}
	if (filter.IsEmpty())	{ return -1; }
	local own = [];
	foreach (owner, _ in filter)	{ own.push(owner); }
	return own;
}

function Scheduler::AwardEvaluate_13()
{
	local own = -1;
	local stats = Cache.Infrastructure_helper(GSInfrastructure.INFRASTRUCTURE_RAIL);
	stats.RemoveValue(0);
	if (stats.IsEmpty())	{ return -1; }
	stats.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	own = stats.Begin();
	Awards.Update(13, stats.GetValue(own));
	return own;
}

function Scheduler::AwardEvaluate_14()
{
	local own = -1;
	local stats = Cache.Infrastructure_helper(GSInfrastructure.INFRASTRUCTURE_ROAD);
	stats.RemoveValue(0);
	if (stats.IsEmpty())	{ return -1; }
	stats.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	own = stats.Begin();
	Awards.Update(14, stats.GetValue(own));
	return own;
}

function Scheduler::AwardEvaluate_15()
{
	local own = -1;
	local company = GSList();
	for (local j = 0; j < 15; j++)
		{
		local c_idx = GSCompany.ResolveCompanyID(j);
		if (c_idx != GSCompany.COMPANY_INVALID)	{ company.AddItem(c_idx, GSInfrastructure.GetRoadPieceCount(c_idx, GSRoad.ROADTYPE_ROAD)); }
		}
	company.RemoveValue(0);
	company.Sort(GSList.SORT_BY_VALUE, GSList.SORT_ASCENDING);
	if (company.IsEmpty())	{ return -1; }
	local lowest = company.Begin();
	local vehicle = Cache.Vehicle_Helper();
	if (vehicle[lowest].IsEmpty())	{ return -1; }
	local templist = GSList();
	templist.AddList(vehicle[lowest]);
	templist.Valuate(GSVehicle.GetVehicleType);
	templist.KeepValue(GSVehicle.VT_ROAD);
	if (templist.Count() >= (vehicle[15].Count() / 3))	{ own = lowest; }
	return own;
}

function Scheduler::AwardEvaluate_16()
{
	local company = Cache.Company_Helper();
	local now = GSDate.GetCurrentDate();
	local good_company = GSList();
	foreach (comp in company)
		{
		if (now - Cache.GetData("companyDate", comp) > 1825)
			{
			if (CompanyLayer.companyValue[comp] == null)	{ CompanyLayer.companyValue[comp] = Cache.CalcCompanyValue(comp); }
			good_company.AddItem(comp, CompanyLayer.companyValue[comp]);
			}
		}
	if (company.len() != good_company.Count())	{ return -2; }
	good_company.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	return good_company.Begin();
}

function Scheduler::AwardEvaluate_17()
{
	local company = Cache.Company_Helper();
	local candidat = GSList();
	foreach (companyID in company)
		{
		local cmode = GSCompanyMode(companyID);
		local cur_loan = GSCompany.GetLoanAmount();
		if (cur_loan == GSCompany.GetMaxLoanAmount())
			{
			local value = GSCompany.GetBankBalance(companyID);
			value -= cur_loan;
			candidat.AddItem(companyID, value);
			}
		}
	if (candidat.IsEmpty())	{ return -1; }
	candidat.Sort(GSList.SORT_BY_VALUE, GSList.SORT_ASCENDING);
	local own = candidat.Begin();
	Awards.Update(17, candidat.GetValue(own));
	return own;
}

function Scheduler::AwardEvaluate_18()
{
	local own = -2;
	local town_list = GSTownList();
	town_list.Valuate(GSTown.GetPopulation);
	town_list.KeepAboveValue(10000);
	if (town_list.IsEmpty())	{ return -2; }
	local station_list = GSStationList(GSStation.STATION_ANY);
	local work_list = GSList();
	local old_station = null;
	local big_town = null;
	foreach (town, _ in town_list)
		{
        foreach (station, dum in station_list)
			{
			if (GSStation.IsWithinTownInfluence(station, town))
				{
				local age = GSBaseStation.GetConstructionDate(station);
				if (old_station == null || age < old_station)
					{
					old_station = age;
					big_town = town;
					}
				}
			}
		}
	if (big_town == null)	{ return -2; }
	Awards.Update(18, big_town);
	own = GSStation.GetOwner(old_station);
	return own;
}

function Scheduler::AwardEvaluate_19()
{
	local own = -1;
	local mode = null;
	local company = Cache.Company_Helper();
	local count = 0;
	foreach (comp in company)
		{
		local mode = GSCompanyMode(comp);
		local town_list = GSTownList();
		town_list.Valuate(GSTown.HasStatue);
		town_list.KeepValue(1);
		if (count < town_list.Count())	{ count = town_list.Count(); own = comp; }
		}
	if (own > -1)	{ Awards.Update(19, count); }
	return own;
}

function Scheduler::AwardEvaluate_20()
{
	local powerplant = Cache.GetPowerPlant();
	if (powerplant.HasItem(0) && powerplant.GetValue(0) == -1)	{ return -2; }
	local coal = powerplant.GetValue(powerplant.Begin());
	local all_stations = GSStationList(GSStation.STATION_ANY);
	local all_companies = GSList();
	for (local i = 0; i < 15; i++)	{ all_companies.AddItem(i, 0); }
	local noone = true;
	local counter = 3;
	local comp = -1;
	foreach (station, _ in all_stations)
		{
		local s = GSCargoList_StationAccepting(station);
		if (s.HasItem(coal))	{
								local owner = GSStation.GetOwner(station);
								local c = all_companies.GetValue(owner) + 1;
								if (c > counter)	{ comp = owner; counter = c; }
								all_companies.SetValue(owner, c);
								noone = false;
								}
		}
	Awards.Update(20, counter);
	return comp;
}

function Scheduler::AwardEvaluate_21()
{
	local company = Cache.Company_Helper();
	local own = [];
	foreach (comp in company)
		{
		local z = GSBase.RandRange(1000);
		if (z == 100)	{ own.push(comp); }
		}
	return own;
}

function Scheduler::AwardEvaluate_22()
{
	local ind_list = GSIndustryList();
	ind_list.Valuate(GSIndustry.GetAmountOfStationsAround);
	ind_list.KeepAboveValue(3);
	if (ind_list.IsEmpty())	{ return -2; }
	local own = [];
	foreach (indID, _ in ind_list)
		{
		local stats = Cache.GetCompetitorStationAround(indID);
		local battle = GSList();
		foreach (station, owner in stats)
			{
			if (!battle.HasItem(owner))	{ battle.AddItem(owner, 1); }
								else	{ battle.SetValue(owner, battle.GetValue(owner)+1); }
			}
		foreach (owner, count in battle)
			{
			if (stats.Count() - count > 3 && Utils.INArray(owner, own) == -1) { own.push(owner); }
			}
		}
	return own;
}

function Scheduler::AwardEvaluate_23()
{
	local ind_list = GSIndustryList();
	ind_list.Valuate(GSIndustry.GetAmountOfStationsAround);
	ind_list.KeepAboveValue(3);
	if (ind_list.IsEmpty())	{ return -2; }
	local own = [];
	foreach (indID, _ in ind_list)
		{
		local battle = GSList();
		local stats = Cache.GetCompetitorStationAround(indID);
		foreach (station, owner in stats)
			{
			if (!battle.HasItem(owner))	{ battle.AddItem(owner, 1); }
								else	{ battle.SetValue(owner, battle.GetValue(owner)+1); }
			}
		foreach (owner, count in battle)
			{
			if (count > 1 && stats.Count() - count > 3 && Utils.INArray(owner, own) == -1)	{ own.push(owner); }
			}
		}
	return own;
}

function Scheduler::AwardEvaluate_24()
{
	local own = -1;
	local stats = Cache.Infrastructure_helper(GSInfrastructure.INFRASTRUCTURE_CANAL);
	stats.RemoveValue(0);
	if (stats.IsEmpty())	{ return -1; }
	stats.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	own = stats.Begin();
	Awards.Update(24, stats.GetValue(own));
	return own;
}

function Scheduler::AwardEvaluate_25()
{
	local company = Cache.Company_Helper();
	local own = [];
	foreach (comp in company)
		{
		local mode = GSCompanyMode(comp);
		local station = GSStationList(GSStation.STATION_ANY);
		mode = null;
		station.Valuate(GSBaseStation.GetConstructionDate);
		station.Sort(GSList.SORT_BY_VALUE, GSList.SORT_ASCENDING);
		local old = station.GetValue(station.Begin());
		if (Cache.GetData("companyDate", comp) - old > 30)	{ own.push(comp); }
		}
	return own;
}

function Scheduler::AwardEvaluate_26()
{
	local own = -2;
	local company = Cache.Company_Helper();
	local count = 0;
	local total_cargo = GSCargoList();
	foreach (comp in company)
		{
		local v = Cache.cargo_handle.GetValue(comp);
		if (v == 0)	{ continue; }
		local c = 0;
		while (v != 0)	{ c += (v&1); v = (v >> 1); }
		if (c == total_cargo.Count())	{ own = comp; break; }
		}
	return own;
}
function Scheduler::AwardEvaluate_27()
{
	local own = -2;
	local companies = Cache.Company_Helper();
	local million = 1000000;
	Cache.Monitoring(); // freshen cache values
	foreach (comp in companies)
		{
		local t = Cache.GetData("supply_town", comp);
		if (t >= 300000)	{ Cache.DeliveryAwardGeneric(35, comp); }
					else	{
							if (t >= 100000)	{ Cache.DeliveryAwardGeneric(34, comp); }
										else	{
												if (t >= 10000)	{ Cache.DeliveryAwardGeneric(33, comp); }
												}
							}
		local c = Cache.GetData("supply_industry", comp);
		if (c >= 300000)	{ Cache.DeliveryAwardGeneric(42, comp); }
					else	{
							if (c >= 100000)	{ Cache.DeliveryAwardGeneric(41, comp); }
										else	{
												if (c >= 10000)	{ Cache.DeliveryAwardGeneric(40, comp); }
												}
						}
		if (c > million || t > million || (c+t) > million)	{ own = comp; }
		}
	return own;
}

function Scheduler::AwardEvaluate_28()
{
	local company = Cache.Company_Helper();
	local stown = Cache.GetSnowTown();
	local town_heigh = GSList();
	foreach (town, _ in stown)
		{
		local h = GSTile.GetMaxHeight(GSTown.GetLocation(town));
		if (h >= 10)	{ town_heigh.AddItem(town, h); }
		}
	if (town_heigh.IsEmpty())	{ return -2; }
	local station = GSStationList(GSStation.STATION_ANY);
	local station_heigh = GSList();
	foreach (st, _ in station)
		{
		local h = GSTile.GetMaxHeight(GSStation.GetLocation(st));
		if (h >= 10)	{ station_heigh.AddItem(st, h); }
		}
	if (station_heigh.IsEmpty())	{ return -2; }
	local twork = GSList();
	foreach (st, _s in station_heigh)
		{
		foreach (to, _t in town_heigh)
			{
			if (GSStation.IsWithinTownInfluence(st, to))
				{
				if (!twork.HasItem(to))	{ twork.AddItem(to, st); }
								else	{ twork.SetValue(to, -1); }
				}
			}
		}
	twork.RemoveValue(-1);
	if (twork.IsEmpty())	{ return -2; }
	local small = GSList();
	small.AddList(twork);
	small.Valuate(GSTown.GetPopulation);
	small.Sort(GSList.SORT_BY_VALUE, GSList.SORT_ASCENDING);
	local good = twork.GetValue(small.Begin());
	Awards.Update(28, good);
	return GSStation.GetOwner(good);
}

function Scheduler::AwardEvaluate_29()
{
	local own = -2;
	local company = Cache.Company_Helper();
	local stown = Cache.GetSnowTown();
	foreach (town, dummy in stown)
		{
		foreach (comp, dum in company)
			{
			if (GSTown.GetRating(town, comp) == GSTown.TOWN_RATING_APPALLING)	{ Awards.Update(29, town); return comp; }
			}
		}
	return own;
}

function Scheduler::AwardEvaluate_30()
{
	local own = [];
    local company = Cache.Company_Helper();
    foreach(comp in company)
		{
		if (GSCompany.GetCompanyHQ(comp) != GSMap.TILE_INVALID)	{ own.push(comp); }
		}
	return own;
}


function Scheduler::AwardEvaluate_31()
{
	local own = -2;
	local company = Cache.Company_Helper();
	local list = GSList();
	foreach (comp in company) { list.AddItem(comp, GSCompany.GetCompanyHQ(comp)); }
	list.RemoveValue(GSMap.TILE_INVALID);
	foreach (comp, location in list)
		{
        local place = GSTileList();
        place.AddRectangle(location + GSMap.GetTileIndex(-2, -2), location + GSMap.GetTileIndex(4, 4));
        place.Valuate(GSTile.HasTreeOnTile);
        local s = place.Count();
        place.RemoveValue(0);
        if (place.Count() == (s-4))	{ own = comp; break; }
		}
	return own;
}

function Scheduler::AwardEvaluate_32()
{
	local own = -1;
	local company = Cache.Company_Helper();
	local count = 0;
	foreach (comp in company)
		{
		local v = Cache.cargo_handle.GetValue(comp);
		if (v == 0)	{ continue; }
		local c = 0;
		while (v != 0)	{ c += (v&1); v = (v >> 1); }
		if (c > count)	{ count = c; own = comp; }
		}
	if (own == -1)	{ return -1; }
    Awards.Update(32, count, Cache.cargo_handle.GetValue(own));
	return own;
}

// handling of 33, 34, 35 is done by 27

function Scheduler::AwardEvaluate_36()
{
	local own = -2;
	local companies = Cache.Company_Helper();
	Cache.Monitoring();
	foreach (comp in companies)
		{
		foreach (cargo_label in Cache.cargo_tracker)
			{
			local t = Cache.GetData(cargo_label, comp);
			if (t == -1)	{ continue; } // non handle cargo on that map
			local award_target = -1;
			switch (cargo_label)
				{
				case	"WOOD":
					award_target = 47;
				break;
				case	"OIL_":
					award_target = 43;
				break;
				case	"TOYS":
					award_target = 46;
				break;
				case	"WATR":
					award_target = 38;
				break;
				case	"GOOD":
					award_target = 36;
				break;
				case	"DIAM":
					award_target = 37;
				break;
				}
			if (t > 200000)	{ Cache.DeliveryAwardGeneric(award_target, comp); }
			}
		}
	return -2; // always return -2 to stop checks
}

// handling of 37, 38 are done by 36

function Scheduler::AwardEvaluate_39()
{
	local own = -2;
	local companies = Cache.Company_Helper();
	foreach (comp in companies)
		{
		if (Awards.HaveAward(36, comp) && Awards.HaveAward(37, comp) && Awards.HaveAward(38, comp))	{ own = comp; break; }
		}
	if (own != -2)	{ Awards.Update(39, GSText(GSText.STR_KEY_36), GSText(GSText.STR_KEY_37), GSText(GSText.STR_KEY_38)); }
	return own;
}

// handling of 40, 41, 42 are done by 27

// handling of 43 is done by 36

function Scheduler::AwardEvaluate_44()
{
	local vlist = GSVehicleList();
	if (vlist.IsEmpty())	{ return -1; }
	vlist.Valuate(GSVehicle.GetVehicleType);
	vlist.KeepValue(GSVehicle.VT_ROAD);
	vlist.Valuate(GSVehicle.GetCurrentSpeed);
	vlist.KeepAboveValue(141); // 141,62km/h -> 88mph
	if (vlist.IsEmpty())	{ return -1; }
	vlist.Valuate(GSVehicle.GetOwner);
	local own = [];
	foreach (owner in vlist)
		{
		if (Utils.INArray(owner, own) == -1)	{ own.push(owner); }
		}
	return own;
}

function Scheduler::AwardEvaluate_45(owner)
{
	local awd = Awards.Get(45);
	local list = [];
	list.extend(awd.Own_By_Company);
	if (Utils.INArray(owner, list) != -1)	{ return; }
	list.push(owner);
	Awards.GrantAward(45, list);
}

// Handling of 46, 47 are done by 36

function Scheduler::AwardEvaluate_48()
{
	local own = -2;
	local companies = Cache.Company_Helper();
	foreach (comp in companies)
		{
		if (Awards.HaveAward(44, comp) && Awards.HaveAward(20, comp))	{ own = comp; break; }
		}
	if (own != -2)	{ Awards.Update(48, GSText(GSText.STR_KEY_44), GSText(GSText.STR_KEY_20)); }
	return own;
}

function Scheduler::AwardEvaluate_49(owner, dead)
{
	local onemore = Cache.GetData("gabriel", owner);
	onemore += dead;
	Cache.SetData("gabriel", owner, onemore);
	local own = -1;
	local souls = 0;
	local current = 0;
	for (local i = 0; i < 15; i++)
		{
		current = Cache.GetData("gabriel", i);
		if (current > souls)	{ own = i; souls = current; }
		}
	Awards.Update(49, souls);
	Awards.GrantAward(49, [own]);
}

function Scheduler::AwardEvaluate_50(owner)
{
	local awd = Awards.Get(50);
	local list = [];
	list.extend(awd.Own_By_Company);
	if (Utils.INArray(owner, list) != -1)	{ return; }
	list.push(owner);
	Awards.GrantAward(50, list);
}

function Scheduler::AwardEvaluate_51()
{
	local own = -1;
	local veh = Cache.Vehicle_Helper_Counter("tram");
	veh.RemoveValue(0);
	if (veh.IsEmpty())	{ return -1; }
	veh.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);
	own = veh.Begin();
	Awards.Update(51, veh.GetValue(own));
	return own;
}

function Scheduler::AwardEvaluate_52()
{
	local vlist = GSVehicleList();
	if (vlist.IsEmpty())	{ return -1; }
	local own = -1;
	local veh, eng, cap, carg;
	local c = Awards.GetDatas(52);
	cap = c[5];
	vlist.Valuate(GSVehicle.GetEngineType);
	local cargo=null;
	foreach (v, e in vlist)
		{
		cargo = GSEngine.GetCargoType(e);
		local l_cap = GSEngine.GetCapacity(e);
		local wagnum = GSVehicle.GetNumWagons(v);
		if (wagnum > 1)
			{
			l_cap = 0;
			local wtype = 0;
			for (local z = 0; z < wagnum; z++) // browse train to find capacity
				{
				wtype = GSVehicle.GetWagonEngineType(v, z);
				local t_cap = GSEngine.GetCapacity(wtype);
				if (t_cap < 0)	t_cap = 0;
				l_cap += t_cap;
				cargo = GSEngine.GetCargoType(wtype);
				}
			}
		if (l_cap > cap)	{ cap = l_cap; veh = v; eng = e; carg = (1 << cargo); }
		}
	if (c[5] == cap)	{ return -2; }
	own = GSVehicle.GetOwner(veh);
	Awards.Update(52, veh, eng, carg, cap);
	return own;
}

function Scheduler::AwardEvaluate_53()
{
	local own = -2;
	local companies = Cache.Company_Helper();
	local checked = ["chopper", "tram", "boat", "train", "aircraft", "bus", "truck"];
	local vehicle = null;
	local comp_valid = GSList();
	foreach (comp in companies)	{ comp_valid.AddItem(comp, 0); }
	foreach (vehtype in checked)
		{
		vehicle = Cache.Vehicle_Helper_Counter(vehtype);
		vehicle.RemoveValue(0);
		if (vehicle.IsEmpty())	{ return -2; }
		foreach (comp in companies)
			{
			local point = comp_valid.GetValue(comp);
			if (vehicle.HasItem(comp))	{ comp_valid.SetValue(comp, point+1); }
			}
		}
	comp_valid.KeepValue(7);
	if (comp_valid.IsEmpty())	{ return -2; }
	own = comp_valid.Begin();
	return own;
}

function Scheduler::AwardEvaluate_54()
{
	local own = -1;
	local companies = Cache.Company_Helper();
	local veh = Cache.Vehicle_Helper();
	local multi = 0;
	foreach (comp in companies)
		{
		local templist = GSList();
		templist.AddList(veh[comp]);
		templist.Valuate(GSVehicle.GetEngineType);
		local list_nodup = GSList();
		foreach (vehicle, engine in templist)	{ if (!list_nodup.HasItem(engine))	{ list_nodup.AddItem(engine,0); } }
		if (list_nodup.Count() > multi)	{ multi = list_nodup.Count(); own = comp; }
		}
	if (own != -1)	{ Awards.Update(54, multi); }
	return own;
}

// handling of 55, 56 are done in 57
function Scheduler::AwardEvaluate_57()
{
	local devlist = ["orudge", "Ludde", "MYOB", "Vurlix", "Bjarni", "Tron", "Miham", "Darkvater", "blathijs", "Pasky", "Dominik", "TrueBrain", "Celestar", "hackykid", "peter1138", "egladil", "Belugas", "KUDr", "Rubidium", "glx", "Maedhros", "forsch", "SmatZ", "skidd13", "michi_cc", "Yexo", "Alberth", "Terkhen", "planetmaker", "Zuu", "fonsinchen"]; // http://wiki.openttd.org/Developers
	local ottdlist = ["Adams", "Allan", "Baker", "Bigwig", "Black", "Bloggs", "Brown", "Campbell", "Gordon", "Hamilton", "Hawthorn", "Higgins", "Green", "Gribble", "Jones", "McAlpine", "MacDonald", "McIntosh", "Muir", "Murphy", "Nelson", "O'Donnell", "Parker", "Phillips", "Pilkington", "Quigley", "Sharkey", "Thomson", "Watkins"];// /src/strings.cpp
	local companies = Cache.Company_Helper();
	local pname = null;
	local own = [];
	local gown = -1;
	foreach (comp in companies)
		{
		pname = GSCompany.GetPresidentName(comp);
		local match = Awards.GetDatas(56);
		if (match[0] == -1)
			foreach (key in devlist)	{ if (pname.find(key) != null)	{ Awards.GrantAward(56, [comp]); break; } }
		match = Awards.GetDatas(55);
		if (match[0] == -1 && pname.find("Sawyer") != null)	{ Awards.GrantAward(55, [comp]); }
		match = false;
		foreach (key in ottdlist)	{ if (pname.find(key) != null) { match = true; break; } }
		if (!match)	{ own.push(comp); }
		}
	return own;
}

function Scheduler::AwardEvaluate_58()
{
	local zlist = GSList();
	local clist = Cache.Vehicle_Helper();
	zlist.AddList(clist[15]);
	if (zlist.IsEmpty())	{ return -1; }
	local own = -1;
	local veh = -1
	local reliab = 0;
	zlist.Valuate(GSVehicle.GetReliability);
	zlist.KeepBelowValue(50);
	if (!zlist.IsEmpty())
		{
		zlist.Sort(GSList.SORT_BY_VALUE, GSList.SORT_ASCENDING);
		veh = zlist.Begin();
		if (!GSVehicle.IsValidVehicle(veh))	{ GSLog.Warning("Your OpenTTD verison have a bug with List handling ; you should update it"); return -2 } // try avoid bug.
		reliab = zlist.GetValue(veh);
		own = GSVehicle.GetOwner(veh);
		Awards.Update(58, veh, reliab);
		}
	return own;
}
