/* -*- Mode: C++; tab-width: 4 -*- */
/**
 *    This file is part of Awards
 *    (c) krinn@chez.com
 *
 *    It's free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    any later version.
 *
 *    You should have received a copy of the GNU General Public License
 *    with it.  If not, see <http://www.gnu.org/licenses/>.
 *
**/

class Events
{
	constructor()
	{
	}
}

function Events::HandleEvents()
{
while (GSEventController.IsEventWaiting())
	{
	local event = GSEventController.GetNextEvent();
	local eventType = event.GetEventType();
	//GSLog.Info("New event incoming: "+eventType);
	switch (eventType)
		{
		case	GSEvent.ET_INDUSTRY_OPEN:
		case	GSEvent.ET_INDUSTRY_CLOSE:
				Cache.GetPowerPlant(true);
				break;
		case	GSEvent.ET_COMPANY_BANKRUPT:
                local e = GSEventCompanyBankrupt.Convert(event);
                local c = e.GetCompanyID();
				CompanyLayer.RemoveCompany(c);
				break;
		case	GSEvent.ET_TOWN_FOUNDED:
				local e = GSEventTownFounded.Convert(event);
                local id = event.GetTownID();
                Cache.GetSnowTown(true);
				break;
		case	GSEvent.ET_COMPANY_MERGER:
				local e = GSEventCompanyMerger.Convert(event);
				local n = e.GetNewCompanyID();
				local o = e.GetOldCompanyID();
				Scheduler.AwardEvaluate_50(n);
				if (GSCompany.ResolveCompanyID(o) != GSCompany.COMPANY_INVALID)	{ CompanyLayer.RemoveCompany(o); }
				break;
		case	GSEvent.ET_VEHICLE_CRASHED:
                // We must quickly collect vehicle stats before it vanish
				local e = GSEventVehicleCrashed.Convert(event);
				local veh = e.GetVehicleID();
				local owner = -1;
				local passengers = 1;
				if (veh != null && GSVehicle.IsValidVehicle(veh))
					{
					owner = GSVehicle.GetOwner(veh);
					local plist = Cache.GetPassengerCargo();
					foreach (item, _ in plist)	{ passengers += GSVehicle.GetCapacity(veh, item); }
					}
                if (owner == -1)	{ break; }
                local reason = e.GetCrashReason();
                if (reason == GSEventVehicleCrashed.CRASH_RV_LEVEL_CROSSING)	{ Scheduler.AwardEvaluate_45(owner); }
                Scheduler.AwardEvaluate_49(owner, passengers);
				break;
		}

	} // while
} // function

