require ("version.nut")
/*
 * This file is part of CityBuilder, which is a GameScript for OpenTTD
 *
 * CityBuilder is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * CityBuilder is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CityBuilder; If not, see <http://www.gnu.org/licenses/> or
 * write to the Free Software Foundation, Inc., 51 Franklin Street, 
 * Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
 
  // Contributors: lukasz1985

class CityBuilder extends GSInfo {
	function GetAuthor()		{ return "Aphid"; }
	function GetName()			{ return "CityBuilder"; }
	function GetDescription() 	{ return "Luukland style Citybuilder"; }
	function GetVersion()		{ return SELF_VERSION; }
	function GetDate()			{ return "2014-08-02"; }
	function CreateInstance()	{ return "CityBuilder"; }
	function GetShortName()		{ return "CBGS"; }
	function GetAPIVersion()	{ return "1.4"; }
	function GetUrl()			{ return ""; }
	function GetSettings() {	
		AddSetting({name = "debug_level", description = "debug level", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 7});
		AddLabels("debug_level", {_0 = "Off", _1 = "Minimal", _2 = "Low", _3 = "Medium", _4 = "High", _5 = "Very High", _6 = "Verbose", _7 = "Everything" });
		AddSetting({name = "point_to_goal", description = "Point to goal GUI > 3 goals: ", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1});
		AddLabels("point_to_goal", {_0 = "No", _1 = "Yes"});
		AddSetting({name = "Town_Labels", description = "Show owner above town name", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1});
		AddLabels("Town_Labels", {_0 = "Off", _1 = "On"});
		AddSetting({name = "Industry_Density", description = "Amount of tiles per primary industry: ", easy_value = 512, medium_value = 512, hard_value = 512, custom_value = 512, flags = CONFIG_INGAME, min_value = 63, max_value = 65536, step_size = 1});
		AddLabels("Industry_Density", {_63 = "Don't spawn extra primary industry"});
		AddSetting({name = "Industry_S_Density", description = "Amount of tiles per secondary industry: ", easy_value = 4096, medium_value = 4096, hard_value = 4096, custom_value = 4096, flags = CONFIG_INGAME, min_value = 63, max_value = 65536, step_size = 1});
		AddLabels("Industry_S_Density", {_63 = "Don't spawn extra secondary industry"});
		AddSetting({name = "Industry_Water", description = "Build industries on water: ", easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1});
		AddLabels("Industry_Water", {_0 = "No", _1 = "Yes"});
		AddSetting({name = "Industry_Town", description = "Chance of building industry in a town at game start", 
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000, step_size = 1});
			AddLabels("Industry_Town", {_0 = "Nil", _1000 = "One of everything"});
		AddSetting({name = "gametime", description = "Game Length in years: "
			easy_value = 4, medium_value = 8, hard_value = 12, custom_value = 16, flags= CONFIG_INGAME, min_value = 0, max_value = 1000});
		AddLabels("gametime", {_0 = "Indefinite"});
		AddSetting({name = "gamegoal", description = "Goal Target: "
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags= CONFIG_INGAME, min_value = 0, max_value = 10000000, step_size = 500});
		AddLabels("gamegoal", {_0 = "Disabled"});			
		AddSetting({name = "gametype", description = "Game Type: "
			easy_value = 0, medium_value = 1, hard_value = 1, custom_value = 1, flags = CONFIG_INGAME, min_value = 0, max_value = 3});
		AddLabels("gametype", {_0 = "FreeBuilder", _1 = "CityBuilder", _2 = "CityBuilder Co-Op", _3 = "Metropolis"});
		AddSetting({name = "hqmaxdist", description = "Maximum HQ distance to claim town: "
			easy_value = 20, medium_value = 15, hard_value = 10, custom_value = 12, flags=0, min_value = 5, max_value = 32});
		AddSetting({name = "metro_mod", description = "Metropolis cargo multiplier: "
			easy_value = 20, medium_value = 9, hard_value = 1, custom_value = 12, flags = CONFIG_INGAME, min_value = 1, max_value = 500});
		AddSetting({name = "metro_gmod", description = "Metropolis growth multiplier:"
			easy_value = 3, medium_value = 2, hard_value = 1, custom_value = 1, flags = CONFIG_INGAME, min_value = 1, max_value = 500});			
		AddSetting({name = "metro_cgg", description = "Metropolis transport requirement (MTR): "
			easy_value = 50, medium_value = 65, hard_value = 80, custom_value = 70, flags = CONFIG_INGAME, min_value = 30, max_value = 98});			
		AddSetting({name = "paxTR", description = "Passenger transport requirement (PTR): "
			easy_value = 50, medium_value = 60, hard_value = 70, custom_value = 70, flags = CONFIG_INGAME, min_value = 0, max_value = 98});
		AddSetting({name = "mailTR", description = "Mail transport requirement (TTR): "
			easy_value = 50, medium_value = 60, hard_value = 70, custom_value = 70, flags = CONFIG_INGAME, min_value = 0, max_value = 98});	
		AddSetting({name = "local_to_req", description = "Subtract local transported passengers "
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME | CONFIG_BOOLEAN});
		AddSetting({name = "maxclaimsize", description = "Maximum population of a claimable town: ", 
			easy_value = 750, medium_value = 500, hard_value = 250, custom_value = 200, flags = CONFIG_INGAME, min_value = 0, max_value = 4000, step_size = 25});	
		AddLabels("maxclaimsize", {_0 = "Infinite"});
		AddSetting({name = "growascity", description = "Unclaimed towns behave as cities: ", 
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME | CONFIG_BOOLEAN});	
		AddSetting({name = "min_size_max_growth", description = "Below this population growth is linear: ", 
			easy_value = 1200, medium_value = 800, hard_value = 400, custom_value = 600, flags = CONFIG_INGAME, min_value = 50, max_value = 8000, step_size = 25});
		AddSetting({name = "min_size_tr", description = "Below this population all towns grow: ", 
			easy_value = 150, medium_value = 125, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 50, max_value = 40000, step_size = 25});			
		AddSetting({name = "cargo_sigma", description = "variation in cargo requirements (%): ", 
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 25});
		AddSetting({name = "slow_factor", description = "Town size at which town grows with one house per day in thousands: ", 
			easy_value = 60, medium_value = 60, hard_value = 60, custom_value = 60, flags = CONFIG_INGAME, min_value = 10, max_value = 1000});
		AddSetting({name = "stagpct", description = "Stagnation window promillage:", 
			easy_value = 50, medium_value = 50, hard_value = 0, custom_value = 50, flags = CONFIG_INGAME, min_value = 0, max_value = 500});	
		AddSetting({name = "mgrpct", description = "Max growth promillage:", 
			easy_value = 400, medium_value = 200, hard_value = 0, custom_value = 500, flags = CONFIG_INGAME, min_value = 0, max_value = 65535});				
		AddSetting({name = "assim_factor", description = "factor needed to assimilate: "
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 4, flags=0, min_value = 0, max_value = 1000});	
		AddLabels("assim_factor", {_0 = "infinite"});	
		AddSetting({name = "storefactor", description = "Town warehouse size (months): "
			easy_value = 8, medium_value = 6, hard_value = 4, custom_value = 0, flags=0, min_value = 0, max_value = 360});
		AddLabels("storefactor", {_0 = "infinite"});	
		AddSetting({name = "store_min", description = "Town warehouse size (minimum): "
			easy_value = 780, medium_value = 390, hard_value = 200, custom_value = 288, flags=0, min_value = 1, max_value = 2000});
		AddSetting({name = "town_regrow", description = "Regrow towns, (% of starting pop): "
			easy_value = 140, medium_value = 120, hard_value = 100, custom_value = 120, flags=0, min_value = 100, step_size = 10, max_value = 300});
		AddLabels("town_regrow", {_100 = "Do NOT regrow"});
		AddSetting({name = "cities_setting", description = "Behaviour of cities: ",
			easy_value = 0, medium_value = 1, hard_value = 0, custom_value = 6, flags = CONFIG_INGAME, min_value = 0, max_value = 6});
		AddLabels("cities_setting", {_0 = "cities grow normally", _1= "cities grow above MTR", _2 = "cities grow randomly above MTR",_3 = "cities grow per citybuilder rules", 
		_4 = "citybuilder rules, but no passengers required", _5 = "CB, no mail", _6 = "CB, no passengers nor mail"} );
		AddSetting({name = "city_cgg", description = "City growth Multiplier promillage: "
			easy_value = 2400, medium_value = 2200, hard_value = 2000, custom_value = 1400, flags = CONFIG_INGAME, min_value = 1, max_value = 65535});
		// CARGO SETTINGS
		AddSetting({name = "injection", description = "Enable Freeze:", easy_value = 0, medium_value = 0, hard_value = 1, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1});
		AddLabels("injection", {_0 = "Off", _1 = "On"});
		AddSetting({name = "paxcargo_istownind", description = "Industries that produce Passengers are Town Industries", 
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME | CONFIG_BOOLEAN});
		AddSetting({name = "metro_cargo", description = "The cargo ID representing passengers:",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 31});		
		AddSetting({name = "metro_need", description = "The cargo ID representing mail:",
			easy_value = 2, medium_value = 2, hard_value = 2, custom_value = 2, flags = CONFIG_INGAME, min_value = 0, max_value = 31});							
		AddSetting({name = "fodcargo", description = "The cargo ID representing food:",
			easy_value = 11, medium_value = 11, hard_value = 11, custom_value = 11, flags = CONFIG_INGAME, min_value = 0, max_value = 31});	
		AddSetting({name = "wtrcargo", description = "The cargo ID representing water:",
			easy_value = 9, medium_value = 9, hard_value = 9, custom_value = 9, flags = CONFIG_INGAME, min_value = 0, max_value = 31});				
		AddSetting({name = "swapfw", description = "Towns in the tropic require no water but more food: ", easy_value = 1, medium_value = 1, hard_value = 1, custom_value = 1, flags = CONFIG_INGAME, min_value = 0, max_value = 1});
		AddLabels("swapfw", {_0 = "No", _1 = "Yes"});
		AddSetting({name = "lowcargo", description = "Reduced shrink effect:",
			easy_value = 360, medium_value = 180, hard_value = 20, custom_value = 60, flags = CONFIG_INGAME, min_value = 0, max_value = 1000, step_size = 20});
		AddLabels("lowcargo", {_0 = "Disabled"});
		AddSetting({name = "introdelay", description = "Introduction Delay (yrs): ",
			easy_value = 3, medium_value = 2, hard_value = 1, custom_value = 1, flags = CONFIG_INGAME, min_value = 0, max_value = 60});	
		AddLabels("introdelay", {_0 = "Disabled"});
		AddSetting({name = "cargo0", description = "cargo #00 (Passengers) required monthly per 1,000 pop",
			easy_value = 45, medium_value = 95, hard_value = 250, custom_value = 300, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo1", description = "cargo #01 (Coal) required monthly per 1,000 pop",
			easy_value = 30, medium_value = 60, hard_value = 90, custom_value = 90, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo2", description = "cargo #02 (Mail) required monthly per 1,000 pop",
			easy_value = 9, medium_value = 19, hard_value = 40, custom_value = 55, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo3", description = "cargo #03 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo4", description = "cargo #04 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo5", description = "cargo #05 (Goods) required monthly per 1,000 pop",
			easy_value = 125, medium_value = 200, hard_value = 250, custom_value = 250, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo6", description = "cargo #06 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo7", description = "cargo #07 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		

		AddSetting({name = "cargo8", description = "cargo #08 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo9", description = "cargo #09 (Water / Steel) required monthly per 1,000 pop",
			easy_value = 25, medium_value = 40, hard_value = 111, custom_value = 111, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo10", description = "cargo #10 (Valuables) required monthly per 1,000 pop",
			easy_value = 20, medium_value = 30, hard_value = 58, custom_value = 52, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo11", description = "cargo #11 (Food) required monthly per 1,000 pop",
			easy_value = 42, medium_value = 80, hard_value = 125, custom_value = 125, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo12", description = "cargo #12 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo13", description = "cargo #13 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo14", description = "cargo #14 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo15", description = "cargo #15 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		

		AddSetting({name = "cargo16", description = "cargo #16 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo17", description = "cargo #17 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo18", description = "cargo #18 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo19", description = "cargo #19 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo20", description = "cargo #20 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo21", description = "cargo #21 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo22", description = "cargo #22 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo23", description = "cargo #23 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		

		AddSetting({name = "cargo24", description = "cargo #24 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo25", description = "cargo #25 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo26", description = "cargo #26 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo27", description = "cargo #27 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo28", description = "cargo #28 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo29", description = "cargo #29 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo30", description = "cargo #30 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});		
		AddSetting({name = "cargo31", description = "cargo #31 (uu) required monthly per 1,000 pop",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 2000});				

	// MINIMUM TOWN SIZE FOR CARGO TYPE REQUIRED SETTINGS
		AddSetting({name = "size0", description = "cargo #00 (Passengers) population below which req is waived",
			easy_value = 1000, medium_value = 750, hard_value = 500, custom_value = 800, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size1", description = "cargo #01 (Coal) population below which req is waived",
			easy_value = 500, medium_value = 375, hard_value = 250, custom_value = 500, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size2", description = "cargo #02 (Mail) population below which req is waived",
			easy_value = 2000, medium_value = 1500, hard_value = 1000, custom_value = 1300, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size3", description = "cargo #03 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size4", description = "cargo #04 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size5", description = "cargo #05 (Goods) population below which req is waived",
			easy_value = 3000, medium_value = 2250, hard_value = 1500, custom_value = 2100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size6", description = "cargo #06 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size7", description = "cargo #07 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		

		AddSetting({name = "size8", description = "cargo #08 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size9", description = "cargo #09 (Water / Steel) population below which req is waived",
			easy_value = 400, medium_value = 300, hard_value = 200, custom_value = 200, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size10", description = "cargo #10 (Valuables) population below which req is waived",
			easy_value = 5000, medium_value = 3750, hard_value = 2500, custom_value = 3400, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size11", description = "cargo #11 (Food) population below which req is waived",
			easy_value = 400, medium_value = 300, hard_value = 200, custom_value = 300, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size12", description = "cargo #12 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size13", description = "cargo #13 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size14", description = "cargo #14 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size15", description = "cargo #15 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		

		AddSetting({name = "size16", description = "cargo #16 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size17", description = "cargo #17 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size18", description = "cargo #18 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size19", description = "cargo #19 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size20", description = "cargo #20 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size21", description = "cargo #21 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size22", description = "cargo #22 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size23", description = "cargo #23 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		

		AddSetting({name = "size24", description = "cargo #24 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size25", description = "cargo #25 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size26", description = "cargo #26 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size27", description = "cargo #27 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size28", description = "cargo #28 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size29", description = "cargo #29 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size30", description = "cargo #30 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
		AddSetting({name = "size31", description = "cargo #31 (uu) population below which req is waived",
			easy_value = 100, medium_value = 100, hard_value = 100, custom_value = 100, flags = CONFIG_INGAME, min_value = 100, max_value = 200000, step_size = 25});		
			// DECAY RATES
			
		AddSetting({name = "decay0", description = "cargo #00 (Passengers) decay rate",
			easy_value = 1000, medium_value = 1000, hard_value = 1000, custom_value = 1000, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay1", description = "cargo #01 (Coal) decay rate",
			easy_value = 2, medium_value = 4, hard_value = 6, custom_value = 6, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay2", description = "cargo #02 (Mail) decay rate",
			easy_value = 1000, medium_value = 1000, hard_value = 1000, custom_value = 1000, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay3", description = "cargo #03 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay4", description = "cargo #04 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay5", description = "cargo #05 (Goods) decay rate",
			easy_value = 16, medium_value = 33, hard_value = 50, custom_value = 50, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay6", description = "cargo #06 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay7", description = "cargo #07 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		

		AddSetting({name = "decay8", description = "cargo #08 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay9", description = "cargo #09 (Water / Steel) decay rate",
			easy_value = 16, medium_value = 28, hard_value = 40, custom_value = 40, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay10", description = "cargo #10 (Valuables) decay rate",
			easy_value = 5, medium_value = 10, hard_value = 15, custom_value = 15, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay11", description = "cargo #11 (Food) decay rate",
			easy_value = 40, medium_value = 80, hard_value = 120, custom_value = 120, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay12", description = "cargo #12 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay13", description = "cargo #13 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay14", description = "cargo #14 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay15", description = "cargo #15 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		

		AddSetting({name = "decay16", description = "cargo #16 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay17", description = "cargo #17 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay18", description = "cargo #18 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay19", description = "cargo #19 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay20", description = "cargo #20 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay21", description = "cargo #21 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay22", description = "cargo #22 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay23", description = "cargo #23 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		

		AddSetting({name = "decay24", description = "cargo #24 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay25", description = "cargo #25 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay26", description = "cargo #26 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay27", description = "cargo #27 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay28", description = "cargo #28 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay29", description = "cargo #29 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay30", description = "cargo #30 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});		
		AddSetting({name = "decay31", description = "cargo #31 (uu) decay rate",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 1000});			
			// TRANSITIONS
			
		AddSetting({name = "trans0", description = "cargo #00 (Passengers) transition length",
			easy_value = 2000, medium_value = 750, hard_value = 0, custom_value = 1300, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans1", description = "cargo #01 (Coal) transition length",
			easy_value = 2, medium_value = 4, hard_value = 0, custom_value = 800, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans2", description = "cargo #02 (Mail) transition length",
			easy_value = 1000, medium_value = 1000, hard_value = 0, custom_value = 2100, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans3", description = "cargo #03 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans4", description = "cargo #04 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans5", description = "cargo #05 (Goods) transition length",
			easy_value = 16, medium_value = 33, hard_value = 0, custom_value = 3400, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans6", description = "cargo #06 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans7", description = "cargo #07 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		

		AddSetting({name = "trans8", description = "cargo #08 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans9", description = "cargo #09 (Water / Steel) transition length",
			easy_value = 16, medium_value = 28, hard_value = 0, custom_value = 300, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans10", description = "cargo #10 (Valuables) transition length",
			easy_value = 10000, medium_value = 3750, hard_value = 0, custom_value = 5500, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans11", description = "cargo #11 (Food) transition length",
			easy_value = 800, medium_value = 300, hard_value = 0, custom_value = 500, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans12", description = "cargo #12 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans13", description = "cargo #13 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans14", description = "cargo #14 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans15", description = "cargo #15 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		

		AddSetting({name = "trans16", description = "cargo #16 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans17", description = "cargo #17 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans18", description = "cargo #18 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans19", description = "cargo #19 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans20", description = "cargo #20 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans21", description = "cargo #21 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans22", description = "cargo #22 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans23", description = "cargo #23 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		

		AddSetting({name = "trans24", description = "cargo #24 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans25", description = "cargo #25 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans26", description = "cargo #26 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans27", description = "cargo #27 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans28", description = "cargo #28 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans29", description = "cargo #29 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans30", description = "cargo #30 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});		
		AddSetting({name = "trans31", description = "cargo #31 (uu) transition length",
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, flags = CONFIG_INGAME, min_value = 0, max_value = 200000, step_size = 25});						
			
		}
}
RegisterGS(CityBuilder());