class CompanyValue extends GSController
{
    companies = null;
    goal_mode = null;
    goal_reached = null;
    goal_company = {
        c_id = null,
        goal_value = null
    };
    rankings = null;

    best_value = 1;
    debug_messages = GSController.GetSetting("debug_messages");
    global_list = GSList();
    
    function Start();
    function Save();
    function Load(version, data);
}

function CompanyValue::Save()
{
    if (this.debug_messages >= 1) GSLog.Info("CompanyValue GS is saving...");
    if (this.debug_messages >= 2) {
        GSLog.Info("Saving this.companies = " + this.companies);
        if (this.companies != null) {
            for (local c_id = GSCompany.COMPANY_FIRST; c_id < GSCompany.COMPANY_LAST; c_id++) {
                if (this.debug_messages >= 3) GSLog.Info("Saving this.companies[" + c_id + "] = { goal_id = " + this.companies[c_id] + " }");
            }
        }
        GSLog.Info("Saving this.goal_mode = " + this.goal_mode);
        GSLog.Info("Saving this.goal_reached = " + this.goal_reached);
        GSLog.Info("Saving this.goal_company = " + this.goal_company);
        if (this.debug_messages >= 3) GSLog.Info("Saving this.goal_company = { c_id = " + this.goal_company.c_id + ", goal_value = " + this.goal_company.goal_value + " }");
        GSLog.Info("Saving this.rankings = " + this.rankings);
        if (this.rankings != null) {
            foreach (rank, _ in this.rankings) {
                if (this.debug_messages >= 3) GSLog.Info("Saving this.rankings[" + rank + "] = { goal_id = " + this.rankings[rank].goal_id + ", c_id = " + this.rankings[rank].c_id + ", c_value = " + this.rankings[rank].c_value + ", c_progress = " + this.rankings[rank].c_progress + " }");
            }
        }
    }

    return {
        companies = this.companies,
        goal_mode = this.goal_mode,
        goal_reached = this.goal_reached,
        goal_company = this.goal_company,
        rankings = this.rankings
    };
}

function CompanyValue::Load(version, data)
{
    if (this.debug_messages >= 1) GSLog.Info("CompanyValue GS is loading...");
    this.Initialize();

    this.companies = data.companies;
    this.goal_mode = data.goal_mode;
    this.goal_reached = data.goal_reached;
    this.goal_company = data.goal_company;
    this.rankings = data.rankings;

    if (this.debug_messages >= 2) {
        GSLog.Info("Loaded this.companies = " + this.companies);
        if (this.companies != null) {
            for (local c_id = GSCompany.COMPANY_FIRST; c_id < GSCompany.COMPANY_LAST; c_id++) {
                if (this.debug_messages >= 3) GSLog.Info("Loaded this.companies[" + c_id + "] = { goal_id = " + this.companies[c_id] + " }");
            }
        }
        GSLog.Info("Loaded this.goal_mode = " + this.goal_mode);
        GSLog.Info("Loaded this.goal_reached = " + this.goal_reached);
        GSLog.Info("Loaded this.goal_company = " + this.goal_company);
        if (this.debug_messages >= 3) GSLog.Info("Loaded this.goal_company = { c_id = " + this.goal_company.c_id + ", goal_value = " + this.goal_company.goal_value + " }");
        GSLog.Info("Loaded this.rankings = " + this.rankings);
        if (this.rankings != null) {
            foreach (rank, _ in this.rankings) {
                if (this.debug_messages >= 3) GSLog.Info("Loaded this.rankings[" + rank + "] = { goal_id = " + this.rankings[rank].goal_id + ", c_id = " + this.rankings[rank].c_id + ", c_value = " + this.rankings[rank].c_value + ", c_progress = " + this.rankings[rank].c_progress + " }");
            }
        }
    }
}

function CompanyValue::Initialize()
{
    if (this.debug_messages >= 1) GSLog.Info("CompanyValue GS is (re)initializing...");
    if (this.companies == null) {
        this.companies = {};
        if (this.debug_messages >= 2) GSLog.Info("Initialized this.companies = " + this.companies);
        for (local c_id = GSCompany.COMPANY_FIRST; c_id < GSCompany.COMPANY_LAST; c_id++) {
            this.companies[c_id] <- null;
            if (this.debug_messages >= 3) GSLog.Info("Initialized this.companies[" + c_id + "] = { goal_id = " + this.companies[c_id] + " }");
        }
    }

    if (this.goal_mode == null) {
        this.goal_mode = GSController.GetSetting("goal_mode") == 1 ? true : false;
        if (this.debug_messages >= 2) GSLog.Info("Initialized this.goal_mode = " + this.goal_mode);
    }

    if (this.goal_reached == true) {
        GSLog.Warning("Game still paused. Asking companies to continue...");
        this.goal_reached = GSGoal.Question(25, GSCompany.COMPANY_INVALID, GSText(GSText.STR_GOAL_REACHED, this.goal_company.c_id, this.goal_company.c_id, this.goal_company.goal_value), GSGoal.QT_INFORMATION, GSGoal.BUTTON_CONTINUE);
        if (this.debug_messages >= 2) {
            GSLog.Info("Initialized this.goal_reached = " + this.goal_reached + " with qid = 25, (text: c_id = " + this.goal_company.c_id + ", goal_value = " + this.goal_company.goal_value + ")");
            if (this.debug_messages >= 3) GSLog.Info("Initialized this.goal_company = { c_id = " + this.goal_company.c_id + ", goal_value = " + this.goal_company.goal_value + " }");
        }
    }

    if (this.rankings == null) {
        this.rankings = {};
        if (this.debug_messages >= 2) GSLog.Info("Initialized this.rankings = " + this.rankings);
        for (local rank = GSCompany.COMPANY_FIRST + 1; rank <= GSCompany.COMPANY_LAST; rank++) {
            this.rankings[rank] <- null;
            this.rankings[rank] = {
                goal_id = null,
                c_id = null,
                c_value = null,
                c_progress = null,
            };
            if (this.debug_messages >= 3) GSLog.Info("Initialized this.rankings[" + rank + "] = { goal_id = " + this.rankings[rank].goal_id + ", c_id = " + this.rankings[rank].c_id + ", c_value = " + this.rankings[rank].c_value + ", c_progress = " + this.rankings[rank].c_progress + " }");
        }
    }
}

function CompanyValue::Start()
{
    if (this.debug_messages >= 1) GSLog.Info("CompanyValue GS is starting...");
    this.Initialize();

    if (this.goal_mode != false) {
        GSLog.Warning("Company Value GS is in Goal mode.");
    } else {
        GSLog.Warning("Company Value GS is in Ranking mode.");
    }

    while (true) {
        this.Sleep(1);
        local goal_value = GSController.GetSetting("goal_value") * 1000;
        this.debug_messages = GSController.GetSetting("debug_messages");

        local update_method = false;

        while (GSEventController.IsEventWaiting()) {
            local e = GSEventController.GetNextEvent();

            if (e.GetEventType() == GSEvent.ET_GOAL_QUESTION_ANSWER) {
                local ec = GSEventGoalQuestionAnswer.Convert(e);
                local eq_id = ec.GetUniqueID();
                local ec_id = ec.GetCompany();
                if (this.goal_mode != false) {
                    if (this.goal_reached == true) {
                        if (eq_id == 25) {
                            if (ec.GetButton() == GSGoal.BUTTON_CONTINUE) {
                                if (this.debug_messages >= 1) GSLog.Info("Closing question " + eq_id);
                                GSGoal.CloseQuestion(eq_id);
                                for (local c_id = GSCompany.COMPANY_FIRST; c_id < GSCompany.COMPANY_LAST; c_id++) {
                                    if (this.companies[c_id] != null) {
                                        if (GSGoal.IsValidGoal(this.companies[c_id])) {
                                            if (this.debug_messages >= 2) GSLog.Info("Removing goal_id " + this.companies[c_id] + " from this.companies[" + c_id + "]");
                                            GSGoal.Remove(this.companies[c_id]);
                                        }
                                        this.companies[c_id] = null;
                                    }
                                    if (this.debug_messages >= 1) GSLog.Info("Closing question " + c_id);
                                    GSGoal.CloseQuestion(c_id);
                                }
                                this.goal_company.c_id = null;
                                this.goal_company.goal_value = null;
                                this.goal_reached = null;
                                update_method = null;
                                GSGame.Unpause();
                                local ec_num = ec_id + 1;
                                GSLog.Warning("Game unpaused by " + GSCompany.GetName(ec_id) + " (Company " + ec_num + ").")
                                this.goal_mode = false;
                                GSLog.Warning("Company Value GS has switched to Ranking mode.");
                            }
                        }
                    }
                }
            }

            if (e.GetEventType() == GSEvent.ET_COMPANY_NEW) {
                local ec = GSEventCompanyNew.Convert(e);
                local ec_id = ec.GetCompanyID();
                if (this.goal_mode != false) {
                    if (this.goal_reached == true) {
                        if (this.debug_messages >= 1) GSLog.Info("Opening question 25 to company " + ec_id + " (text: this.goal_company.c_id = " + this.goal_company.c_id + ", this.goal_company.goal_value = " + this.goal_company.goal_value + ")");
                        this.goal_reached = GSGoal.Question(25, ec_id, GSText(GSText.STR_GOAL_REACHED, this.goal_company.c_id, this.goal_company.c_id, this.goal_company.goal_value), GSGoal.QT_INFORMATION, GSGoal.BUTTON_CONTINUE);
                        local ec_num = ec_id + 1;
                        GSLog.Warning("Game still paused. Asking the newly created company " + ec_num + " to continue...");
                    } else {
                        assert(this.companies[ec_id] == null);
                        this.companies[ec_id] = GSGoal.New(ec_id, GSText(GSText.STR_COMPANY_GOAL, goal_value), GSGoal.GT_COMPANY, ec_id);
                        if (this.debug_messages >= 2) GSLog.Info("Company " + ec_id + " created. Added goal_id " + this.companies[ec_id] + " to this.companies[" + ec_id + "] (text: goal_value = " + goal_value + ")");
                        if (this.debug_messages >= 1) GSLog.Info("Opening question " + ec_id + " to company " + ec_id + " (text: goal_value = " + goal_value + ")");
                        GSGoal.Question(ec_id, ec_id, GSText(GSText.STR_COMPANY_GOAL, goal_value), GSGoal.QT_INFORMATION, GSGoal.BUTTON_OK);
                    }
                }
            }

            if (e.GetEventType() == GSEvent.ET_COMPANY_BANKRUPT) {
                local ec = GSEventCompanyBankrupt.Convert(e);
                local ec_id = ec.GetCompanyID();
                if (this.goal_mode != false) {
                    if (this.companies[ec_id] != null) {
                        if (this.debug_messages >= 2) GSLog.Info("company " + ec_id + " bankrupted. Removing goal_id " + this.companies[ec_id] + " from this.companies[" + ec_id + "]");
                        GSGoal.Remove(this.companies[ec_id]);
                        this.companies[ec_id] = null;
                    }
                    if (this.debug_messages >= 1) GSLog.Info("Closing question " + ec_id);
                    GSGoal.CloseQuestion(ec_id);
                }
            }

            if (e.GetEventType() == GSEvent.ET_COMPANY_MERGER) {
                local ec = GSEventCompanyMerger.Convert(e);
                local ec_id = ec.GetOldCompanyID();
                if (this.goal_mode != false) {
                    if (this.companies[ec_id] != null) {
                        if (this.debug_messages >= 2) GSLog.Info("Company " + ec_id + " merged. Removing goal_id " + this.companies[ec_id] + " from this.companies[" + ec_id + "]");
                        GSGoal.Remove(this.companies[ec_id]);
                        this.companies[ec_id] = null;
                    }
                    if (this.debug_messages >= 1) GSLog.Info("Closing question " + ec_id);
                    GSGoal.CloseQuestion(ec_id);
                }
            }
        }

        if (this.goal_reached == null) {
            if (update_method != null) {
                update_method = false;
            } else {
                this.goal_mode = null;
            }

            for (local c_id = GSCompany.COMPANY_FIRST; c_id < GSCompany.COMPANY_LAST; c_id++) {
                if (GSCompany.ResolveCompanyID(c_id) != GSCompany.COMPANY_INVALID) {
                    local c_value = GSCompany.GetQuarterlyCompanyValue(c_id, GSCompany.CURRENT_QUARTER);
                    if (this.global_list.HasItem(c_id)) {
                        if (this.global_list.GetValue(c_id) != c_value) {
                            this.global_list.SetValue(c_id, c_value);
                            if (this.debug_messages >= 2) GSLog.Info("Set a c_value of " + c_value + " to c_id " + c_id + " in this.global_list");
                            if (update_method != null) update_method = true;
                        }
                    } else {
                        this.global_list.AddItem(c_id, c_value);
                        if (this.debug_messages >= 2) GSLog.Info("Added c_id " + c_id + " to this.global_list with a c_value of " + c_value);
                        update_method = null;
                    }
                } else {
                    if (this.global_list.HasItem(c_id)) {
                        this.global_list.RemoveItem(c_id);
                        if (this.debug_messages >= 2) GSLog.Info("Removed c_id " + c_id + " from this.global_list");
                        if (update_method != null) update_method = true;
                    }
                }
            }

            if (this.goal_mode != false) {
                if (this.best_value != goal_value) {
                    if (this.debug_messages >= 2) GSLog.Info("Changing goal_value from " + this.best_value + " to " + goal_value);
                    this.best_value = goal_value;
                    if (update_method != null) update_method = true;
                }
            }

            if (update_method != false) {
                if (this.debug_messages >= 2) GSLog.Info("=====Starting goal computations=====")

                local rank = 0;
                if (this.debug_messages >= 2) GSLog.Info(this.global_list.Count() + " c_id(s) counted in this.global_list");
                if (this.global_list.Count() > 0) {
                    this.global_list.Sort(GSList.SORT_BY_VALUE, GSList.SORT_DESCENDING);

                    for (local c_id = this.global_list.Begin(); !this.global_list.IsEnd(); c_id = this.global_list.Next()) {
                        rank++;

                        local c_value = this.global_list.GetValue(c_id);
                        if (this.goal_mode != true) {
                            if (rank == 1) {
                                this.best_value = c_value;
                            }
                        }

                        if (this.rankings[rank].goal_id != null) {
                            if (update_method == null && this.goal_mode != false) {
                                if (this.debug_messages >= 2) GSLog.Info("Nullifying goal_id " + this.rankings[rank].goal_id + " from this.rankings[" + rank + "].goal_id");
                                GSGoal.Remove(this.rankings[rank].goal_id);
                                this.rankings[rank].goal_id = null;
                                if (this.debug_messages >= 2) GSLog.Info("Nullifying c_id " + this.rankings[rank].c_id + " from this.rankings[" + rank + "].c_id");
                                this.rankings[rank].c_id = null;
                                if (this.debug_messages >= 2) GSLog.Info("Nullifying c_value " + this.rankings[rank].c_value + " from this.rankings[" + rank + "].c_value");
                                this.rankings[rank].c_value = null;
                                if (this.debug_messages >= 2) GSLog.Info("Nullifying c_progress " + this.rankings[rank].c_progress + " from this.rankings[" + rank + "].c_progress");
                                this.rankings[rank].c_progress = null;

                                this.rankings[rank].goal_id = GSGoal.New(GSCompany.COMPANY_INVALID, GSText(GSText.STR_RANK_COMPANY_NUM, rank, c_id, c_id), GSGoal.GT_NONE, 0);
                                if (this.debug_messages >= 2) GSLog.Info("Re-added goal_id " + this.rankings[rank].goal_id + " to this.rankings[" + rank + "].goal_id (text: rank = " + rank + ", c_id = " + c_id + ")");
                                this.rankings[rank].c_id = c_id;
                                if (this.debug_messages >= 2) GSLog.Info("Re-added c_id " + this.rankings[rank].c_id + " to this.rankings[" + rank + "].c_id");
                                this.rankings[rank].c_value = c_value;
                                if (this.debug_messages >= 2) GSLog.Info("Re-added c_value " + this.rankings[rank].c_value + " to this.rankings[" + rank + "].c_value");
                            } else {
                                if (this.rankings[rank].c_id != c_id) {
                                    GSGoal.SetText(this.rankings[rank].goal_id, GSText(GSText.STR_RANK_COMPANY_NUM, rank, c_id, c_id));
                                    if (this.debug_messages >= 2) GSLog.Info("Updating goal_id " + this.rankings[rank].goal_id + " text for this.rankings[" + rank + "].goal_id (text: rank = " + rank + ", c_id = " + c_id + ")");
                                    if (this.rankings[rank].c_id != c_id) {
                                        if (this.debug_messages >= 2) GSLog.Info("Updating c_id from " + this.rankings[rank].c_id + " to " + c_id + " for this.rankings[" + rank + "].c_id");
                                        this.rankings[rank].c_id = c_id;
                                    }
                                }
                            }
                            if (this.goal_mode == null) {
                                this.goal_mode = false;
                            }
                        } else {
                            this.rankings[rank].goal_id = GSGoal.New(GSCompany.COMPANY_INVALID, GSText(GSText.STR_RANK_COMPANY_NUM, rank, c_id, c_id), GSGoal.GT_NONE, 0);
                            if (this.debug_messages >= 2) GSLog.Info("Added goal_id " + this.rankings[rank].goal_id + " to this.rankings[" + rank + "].goal_id (text: rank = " + rank + ", c_id = " + c_id + ")");
                            this.rankings[rank].c_id = c_id;
                            if (this.debug_messages >= 2) GSLog.Info("Added c_id " + this.rankings[rank].c_id + " to this.rankings[" + rank + "].c_id");
                            this.rankings[rank].c_value = c_value;
                            if (this.debug_messages >= 2) GSLog.Info("Added c_value " + this.rankings[rank].c_value + " to this.rankings[" + rank + "].c_value");
                        }

                        local c_progress = (c_value * 100) / this.best_value;
                        if (this.goal_mode != false) {
                            if (c_progress > 100) {
                                c_progress = 100;
                            }
                        }

                        if (this.rankings[rank].c_value != c_value || this.rankings[rank].c_progress != c_progress) {
                            GSGoal.SetProgress(this.rankings[rank].goal_id, GSText(GSText.STR_GOAL_PROGRESS, c_value, c_progress));
                            if (this.debug_messages >= 2) GSLog.Info("Setting progress to goal_id " + this.rankings[rank].goal_id + " in this.rankings[" + rank + "].goal_id (text: c_value = " + c_value + ", c_progress = " + c_progress + ")");
                            
                        }

                        if (this.goal_mode != false) {
                            if (this.companies[c_id] != null) {
                                if (GSGoal.IsValidGoal(this.companies[c_id])) {
                                    if (this.rankings[rank].c_value != c_value || this.rankings[rank].c_progress != c_progress) {
                                        GSGoal.SetProgress(this.companies[c_id], GSText(GSText.STR_GOAL_PROGRESS, c_value, c_progress));
                                        if (this.debug_messages >= 2) GSLog.Info("Setting progress to goal_id " + this.companies[c_id] + " in this.companies[" + c_id + "] (text: c_value = " + c_value + ", c_progress = " + c_progress + ")");
                                    }
                                }
                            }

                            if (c_value >= goal_value) {
                                local c_num = c_id + 1;
                                GSLog.Warning(GSCompany.GetName(c_id) + " (Company " + c_num + ") has reached the company value goal of " + goal_value);
                                this.goal_company.c_id = c_id;
                                this.goal_company.goal_value = goal_value;
                                this.goal_reached = true;
                            }
                        }

                        if (this.rankings[rank].c_value != c_value) {
                            if (this.debug_messages >= 2) GSLog.Info("Setting c_value from " + this.rankings[rank].c_value + " to " + c_value + " for this.rankings[" + rank + "].c_value");
                            this.rankings[rank].c_value = c_value;
                        }

                        if (this.rankings[rank].c_progress != c_progress) {
                            if (this.debug_messages >= 2) GSLog.Info("Setting c_progress from " + this.rankings[rank].c_progress + " to " + c_progress + " for this.rankings[" + rank + "].c_progress");
                            this.rankings[rank].c_progress = c_progress;
                        }
                    }
                }

                while (rank < GSCompany.COMPANY_LAST) {
                    rank++;
                    if (this.rankings[rank].goal_id != null) {
                        if (this.debug_messages >= 2) GSLog.Info("Removing goal_id " + this.rankings[rank].goal_id + " from this.rankings[" + rank + "].goal_id");
                        GSGoal.Remove(this.rankings[rank].goal_id);
                        this.rankings[rank].goal_id = null;
                        if (this.debug_messages >= 2) GSLog.Info("Removing c_id " + this.rankings[rank].c_id + " from this.rankings[" + rank + "].c_id");
                        this.rankings[rank].c_id = null;
                        if (this.debug_messages >= 2) GSLog.Info("Removing c_value " + this.rankings[rank].c_value + " from this.rankings[" + rank + "].c_value");
                        this.rankings[rank].c_value = null;
                        if (this.debug_messages >= 2) GSLog.Info("Removing c_progress " + this.rankings[rank].c_progress + " from this.rankings[" + rank + "].c_progress");
                        this.rankings[rank].c_progress = null;
                    }
                }

                if (this.debug_messages >= 3) {
                    for (local c_id = GSCompany.COMPANY_FIRST; c_id < GSCompany.COMPANY_LAST; c_id++) {
                        GSLog.Info("this.companies[" + c_id + "] = { goal_id = " + this.companies[c_id] + " }");
                    }

                    foreach (rank, _ in this.rankings) {
                        GSLog.Info("this.rankings[" + rank + "] = { goal_id = " + this.rankings[rank].goal_id + ", c_id = " + this.rankings[rank].c_id + ", c_value = " + this.rankings[rank].c_value + ", c_progress = " + this.rankings[rank].c_progress + " }");
                    }

                    foreach (c_id, c_value in this.global_list) {
                        GSLog.Info("this.global_list[" + c_id + "] = { c_id = " + c_id + ", c_value = " + c_value + " }");
                    }
                }

                if (this.goal_reached == true) {
                    GSGoal.Question(25, GSCompany.COMPANY_INVALID, GSText(GSText.STR_GOAL_REACHED, this.goal_company.c_id, this.goal_company.c_id, this.goal_company.goal_value), GSGoal.QT_INFORMATION, GSGoal.BUTTON_CONTINUE);
                    GSGame.Pause();
                    GSLog.Warning("Game paused. Asking companies to continue...");
                }

                if (this.debug_messages >= 2) GSLog.Info("=====Ended goal computations=====");
            }
        }
    }
}