/* -*- Mode: C++; tab-width: 6 -*- */
/*
 *
 * This file is part of GSToyHelper a gamescript implementing ToyLib
 * Copyright (C) 2014 Krinn <krinn@chez.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

class GSToyHelper extends GSInfo
	{
	function GetAuthor()		{ return "Krinn"; }
	function GetName()			{ return "GSToyHelper"; }
	function GetDescription() 	{ return "A simple GS that implement the GSToyLib to provide funds to eyes candy AIs"; }
	function GetVersion()		{ return 1; }
	function GetDate()			{ return "2014-07-11"; }
	function CreateInstance()	{ return "GSToyHelper"; }
	function GetShortName()		{ return "GSTH"; }
	function GetAPIVersion()	{ return "1.4"; }
	function MinVersionToLoad()	{ return 1; }
	function GetUrl()			{ return "http://www.tt-forums.net/viewtopic.php?f=65&t=71597"; }

	function GetSettings()
	{
		AddSetting({name = "GiveMoney",
		description = "Gives money to AI that ask it, disable it to stop that",
		easy_value = 1,
		medium_value = 1,
		hard_value = 1,
		custom_value = 1,
		flags = CONFIG_BOOLEAN |CONFIG_INGAME
		});

		AddSetting({name = "LibOutput",
		description = "Allow the lib to output amount given to a company when a company ask us money",
		easy_value = 1,
		medium_value = 1,
		hard_value = 1,
		custom_value = 1,
		flags = CONFIG_BOOLEAN |CONFIG_INGAME
		});

	}

}

RegisterGS(GSToyHelper());
