PROGRAM_NAME <- "Kraken";

class HighwayTollInfo extends GSInfo {
    function GetAuthor()        { return "Kraken"; }
    function GetName()          { return "HighwayToll"; }
    function GetDescription()   { return "The company has to pay road tax for cars driving on roads owned by other companies. Every day for each vehicle, the charge is deducted from the company account and credited to the account of the company owning the road."; }
    function GetVersion()       { return 1; }
    function GetDate()          { return "2018-02-24"; }
    function CreateInstance()   { return "HighwayTollClass"; }
    function GetShortName()     { return "TOLL"; }
    function GetAPIVersion()    { return "1.7"; }
    function GetUrl()           { return ""; }
    function MinVersionToLoad() { return 1; }
    function GetSettings();
}

function HighwayTollInfo::GetSettings()
{
    GSInfo.AddSetting({name="fee_per_day",
                       description="Fee per one vehicle per day",
                       min_value=0,
                       max_value=1000,
                       easy_value=5,
                       medium_value=10,
                       hard_value=20,
                       custom_value=5,
                       flags=GSInfo.CONFIG_NONE});
}

RegisterGS(HighwayTollInfo());
