require("AllVehicles.nut");

class HighwayTollClass extends GSController
{
    function Start();
	function CheckAllVehicles();
}

function HighwayTollClass::Start()
{
    this.Sleep(1); // Wait for the game to start.

    while (true)
	{
		this.CheckAllVehicles();
		
		// Run every 1 day.
        local delay_time = 1 * 74;
        this.Sleep(delay_time);
    }
}

function HighwayTollClass::CheckAllVehicles()
{
	local vehicleList = AllVehicles();
	if (!vehicleList.IsEmpty()) 
	{
		local vehicle = vehicleList.GetFirstVehicle();
		do 
		{
			if (vehicle.IsRoadVehicle() && vehicle.IsRunningVehicle())
			{
				local payment = vehicle.OnForeignRoad();
				if (payment != null)
				{
					local paymentAmount = GSController.GetSetting("fee_per_day");
					payment.Pay(paymentAmount);
				}
			}
		
			vehicle = vehicleList.GetNextVehicle();
		} while(!vehicleList.IsEnd());
	}
}