require("version.nut");

class MainClass extends GSInfo
	{
	function GetAuthor()		{ return "Moep"; }
	function GetName()		{ return "NewCityGrowth"; }
	function GetShortName() 	{ return "NCGS"; }
	function GetDescription()	{ return "NewCityGrowth Script FIRS 3.0.5"; }
	function GetVersion()		{ return SELF_VERSION; }
	function GetDate()		{ return "2014-12-31"; }
	function GetAPIVersion()	{ return "1.4"; }
	function MinVersionToLoad()	{ return 1; }
	function CreateInstance()	{ return "MainClass"; }
	function GetSettings() {

		AddSetting({ name = "industry_NewGRF",
				description = "Welches GueterSet wird genutzt??",
				easy_value = 1,
				medium_value = 1,
				hard_value = 1,
				custom_value = 1,
				flags = CONFIG_NONE, min_value = 1, max_value = 11 });
		AddLabels("industry_NewGRF", { _1 = "Basisset: Gemaessigt",
					_2 = "Basisset: Arktisch",
					_3 = "Basisset: Tropisch",
					_4 = "Basisset: CandyLand",
					_5 = "FIRS: Firs economy"
					_6 = "FIRS: Temperate basic",
					_7 = "FIRS: Arctic basic",
					_8 = "FIRS: Tropic Basic",
					_9 = "FIRS: Hearth of Darkness",
					_10 = "ECS: All Vectors",
					_11 = "YETI (v5350)"});

		AddSetting({ name = "goal_scale_factor",
				description = "Schwierigkeitsgrad (Einfach = 60, Normal = 100, Schwer = 140)",
				easy_value = 60,
				medium_value = 100,
				hard_value = 140,
				custom_value = 100,
				flags = CONFIG_INGAME, min_value = 1, max_value = 1000, step_size = 20 });
				
		AddSetting({
			name = "industry_signs", 
			description = "Option: Zeige Industry Schiler(Namen)", 
			easy_value = 0, medium_value = 0, hard_value = 0, custom_value = 0, 
			flags = CONFIG_INGAME | CONFIG_BOOLEAN});

		AddSetting({ name = "merge_cat_2_3",
				description = "Packe Kategorien 2 (Nahrung) und 3 (Gueter) in eine",
				easy_value = 0,
				medium_value = 0,
				hard_value = 0,
				custom_value = 0,
				flags = CONFIG_BOOLEAN });

		AddSetting({ name = "merge_cat_4_5",
				description = "Packe Kategorien 4 (Ind. Gueter Roh) and 5 (Ind. Gueter Trans.) in eine",
				easy_value = 0,
				medium_value = 0,
				hard_value = 0,
				custom_value = 0,
				flags = CONFIG_BOOLEAN });

		AddSetting({ name = "use_town_sign",
				description = "Zeige die Wachstumsrate unter den Stadtnamen",
				easy_value = 1,
				medium_value = 1,
				hard_value = 1,
				custom_value = 1,
				flags = CONFIG_BOOLEAN });

		AddSetting({ name = "log_level",
				description = "Debug: Log level (higher = print more)",
				easy_value = 1,
				medium_value = 1,
				hard_value = 1,
				custom_value = 1,
				flags = CONFIG_INGAME, min_value = 1, max_value = 3 });
		AddLabels("log_level", { _1 = "1: Info", _2 = "2: (ungenutzt)", _3 = "3: Debug" });

		AddSetting({ name = "town_growth_factor",
				description = "Erweiterte Einstellung: Stadtwachstumsfaktor",
				easy_value = 100,
				medium_value = 100,
				hard_value = 100,
				custom_value = 100,
				flags = CONFIG_INGAME, min_value = 20, max_value = 1000, step_size = 20 });

		AddSetting({ name = "supply_impacting_part",
				description = "Erweiterte Einstellung: Minimale Versorgung in % um die Wachstumsrate zu steigern",
				easy_value = 50,
				medium_value = 50,
				hard_value = 50,
				custom_value = 50,
				flags = CONFIG_INGAME, min_value = 0, max_value = 100, step_size = 5 });

		AddSetting({ name = "exponentiality_factor",
				description = "Erweiterte Einstellung: Wachstumsratem steigerungs Faktor(exponentiell)",
				easy_value = 3,
				medium_value = 3,
				hard_value = 3,
				custom_value = 3,
				flags = CONFIG_INGAME, min_value = 1, max_value = 5 });

		AddSetting({ name = "lowest_town_growth_rate",
				description = "Erweiterte Einstellung: Niedrigste Wachstumsrate, wenn Anforderungen nicht erfuellt sind",
				easy_value = 10000,
				medium_value = 10000,
				hard_value = 10000,
				custom_value = 10000,
				flags = CONFIG_INGAME, min_value = 1000, max_value = 30000, step_size = 1000 });
	}
}

RegisterGS(MainClass());
