class GSToyHelper extends GSInfo
{
	function GetAuthor()		{ return "James+McZapkie"; }
	function GetName()			{ return "Act locally, think globally"; }
	function GetDescription() 	{ return "This controls both town and industry growth by requiring other industries and towns to be served. See readme.txt for more info."; }
	function GetVersion()		{ return 4; }
	function GetDate()			{ return "2017-11-22"; }
	function CreateInstance()	{ return "GSToyHelper"; }
	function GetShortName()		{ return "ALTG"; }
	function GetAPIVersion()	{ return "1.4"; }
	function MinVersionToLoad()	{ return 1; }

	function GetSettings()
	{
		AddSetting({name = "passmail",
		description = "Passengers+mail transport percentange required",
		min_value = 0
		max_value = 100
		easy_value = 10,
		medium_value = 15,
		hard_value = 20,
		custom_value = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "goodfood",
		description = "Goods+food transport percentange required",
		min_value = 0
		max_value = 100
		easy_value = 20,
		medium_value = 30,
		hard_value = 60,
		custom_value = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "petrbdmt",
		description = "Fuel+building materials transport percentange required",
		min_value = 0
		max_value = 100
		easy_value = 10,
		medium_value = 20,
		hard_value = 40,
		custom_value = 20
		flags = CONFIG_INGAME
		});
	
		AddSetting({name = "minprct",
		description = "Percent of industries required to be served",
		min_value = 0
		max_value = 99
		easy_value = 35,
		medium_value = 55,
		hard_value = 75,
		custom_value = 50,
		step_size = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "mintrans",
		description = "Percent of cargo to transport from an industry",
		min_value = 0
		max_value = 99
		easy_value = 25,
		medium_value = 50,
		hard_value = 75,
		custom_value = 50,
		step_size = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "economypoints",
		description = "Points threshold needed to change global economy mood",
		min_value = 0
		max_value = 99
		easy_value = 25,
		medium_value = 50,
		hard_value = 75,
		custom_value = 50,
		step_size = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "goodeconomy",
		description = "Economy index threshold indicating global wealth",
		min_value = 5
		max_value = 50
		easy_value = 5,
		medium_value = 10,
		hard_value = 20,
		custom_value = 10,
		step_size = 5,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "keepind",
		description = "Industry: Try to keep the number of industries on map",
		easy_value = 0,
		medium_value = 0,
		hard_value = 0,
		custom_value = 0,
		flags = CONFIG_INGAME|CONFIG_BOOLEAN
		});
	}

}

RegisterGS(GSToyHelper());
